/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Locale;
import java.util.SortedMap;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.workbench.renderers.swt.HandledContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.swt.IFocusService;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPCloseableObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithReturn;
import org.jkiss.dbeaver.model.runtime.DBRValueProvider;
import org.jkiss.dbeaver.model.runtime.RunnableWithResult;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.DummyRunnableContext;
import org.jkiss.dbeaver.runtime.RunnableContextDelegate;
import org.jkiss.dbeaver.ui.AbstractUIJob;
import org.jkiss.dbeaver.ui.BaseThemeSettings;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.SharedFonts;
import org.jkiss.dbeaver.ui.SharedTextColors;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.contentassist.SmartTextContentAdapter;
import org.jkiss.dbeaver.ui.contentassist.StringContentProposalProvider;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.LineSeparator;
import org.jkiss.dbeaver.ui.dialogs.EditTextDialog;
import org.jkiss.dbeaver.ui.dialogs.MessageBoxBuilder;
import org.jkiss.dbeaver.ui.dialogs.Reply;
import org.jkiss.dbeaver.ui.internal.UIActivator;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.StringUtils;

public class UIUtils {
    private static final Log log = Log.getLog(UIUtils.class);
    private static final String INLINE_WIDGET_EDITOR_ID = "org.jkiss.dbeaver.ui.InlineWidgetEditor";
    private static final SharedTextColors SHARED_TEXT_COLORS = new SharedTextColors();
    private static final SharedFonts SHARED_FONTS = new SharedFonts();
    private static final String MAX_LONG_STRING = String.valueOf(Long.MAX_VALUE);

    public static VerifyListener getIntegerVerifyListener(Locale locale) {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        return e -> {
            int i = 0;
            while (i < e.text.length()) {
                char ch = e.text.charAt(i);
                if (!Character.isDigit(ch) && ch != symbols.getMinusSign() && ch != symbols.getGroupingSeparator()) {
                    e.doit = false;
                    return;
                }
                ++i;
            }
            e.doit = true;
        };
    }

    public static VerifyListener getNumberVerifyListener(Locale locale) {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(locale);
        char[] allowedChars = new char[]{symbols.getDecimalSeparator(), symbols.getGroupingSeparator(), symbols.getMinusSign(), symbols.getZeroDigit(), symbols.getMonetaryDecimalSeparator(), '+', '.', ','};
        String exponentSeparator = symbols.getExponentSeparator();
        return e -> {
            int i = 0;
            while (i < e.text.length()) {
                char ch = e.text.charAt(i);
                if (!Character.isDigit(ch) && !ArrayUtils.contains((char[])allowedChars, (char)ch) && exponentSeparator.indexOf(ch) == -1) {
                    e.doit = false;
                    return;
                }
                ++i;
            }
            e.doit = true;
        };
    }

    public static VerifyListener getUnsignedLongOrEmptyTextVerifyListener(Text text) {
        return e -> {
            if (e.text.isEmpty()) {
                e.doit = true;
                return;
            }
            int i = 0;
            while (i < e.text.length()) {
                if (!Character.isDigit(e.text.charAt(i))) {
                    e.doit = false;
                    return;
                }
                ++i;
            }
            String newText = text.getText().substring(0, e.start) + e.text + text.getText().substring(e.end);
            if (newText.length() < MAX_LONG_STRING.length()) {
                e.doit = true;
                return;
            }
            if (newText.length() > MAX_LONG_STRING.length()) {
                e.doit = false;
                return;
            }
            e.doit = newText.compareTo(MAX_LONG_STRING) <= 0;
        };
    }

    public static void createLabelSeparator(Composite toolBar, int style) {
        Label label = new Label(toolBar, 2 | style);
        label.setLayoutData((Object)new GridData(style == 256 ? 768 : 1040));
    }

    public static void createToolBarSeparator(ToolBar toolBar, int style) {
        Label label = new Label((Composite)toolBar, 0);
        label.setImage(DBeaverIcons.getImage((DBPImage)((style & 0x100) == 256 ? UIIcon.SEPARATOR_H : UIIcon.SEPARATOR_V)));
        new ToolItem(toolBar, 2).setControl((Control)label);
    }

    public static void createLineSeparator(Composite toolBar, int style) {
        new LineSeparator(toolBar, style);
    }

    public static TableColumn createTableColumn(Table table, int style, String text) {
        TableColumn column = new TableColumn(table, style);
        column.setText(text);
        return column;
    }

    public static TreeColumn createTreeColumn(Tree tree, int style, String text) {
        TreeColumn column = new TreeColumn(tree, style);
        column.setText(text);
        return column;
    }

    public static void executeOnResize(final Control control, final Runnable runnable) {
        control.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                control.removeControlListener((ControlListener)this);
                runnable.run();
            }
        });
    }

    public static void packColumns(Table table) {
        UIUtils.packColumns(table, false);
    }

    public static void packColumns(Table table, boolean fit) {
        table.setRedraw(false);
        try {
            int n;
            TableColumn[] tableColumnArray;
            TableColumn[] columns;
            int totalWidth = 0;
            TableColumn[] tableColumnArray2 = columns = table.getColumns();
            int n2 = columns.length;
            int n3 = 0;
            while (n3 < n2) {
                TableColumn column = tableColumnArray2[n3];
                column.pack();
                totalWidth += column.getWidth();
                ++n3;
            }
            Rectangle clientArea = table.getBounds();
            if (clientArea.width > 0 && totalWidth > clientArea.width) {
                TableColumn[] tableColumnArray3 = columns;
                int n4 = columns.length;
                n2 = 0;
                while (n2 < n4) {
                    TableColumn column = tableColumnArray3[n2];
                    int colWidth = column.getWidth();
                    if (colWidth > totalWidth / 3) {
                        column.setWidth(totalWidth / 3);
                        totalWidth -= colWidth;
                        totalWidth += column.getWidth();
                    }
                    ++n2;
                }
                if (totalWidth < clientArea.width) {
                    int extraSpace = totalWidth - clientArea.width;
                    GC gc = new GC((Drawable)table);
                    try {
                        tableColumnArray = columns;
                        n = columns.length;
                        int n5 = 0;
                        while (n5 < n) {
                            TableColumn tc = tableColumnArray[n5];
                            double ratio = (double)tc.getWidth() / (double)totalWidth;
                            int newWidth = (int)((double)tc.getWidth() - (double)extraSpace * ratio);
                            int minWidth = gc.stringExtent((String)tc.getText()).x;
                            if (newWidth < (minWidth += 5)) {
                                newWidth = minWidth;
                            }
                            tc.setWidth(newWidth);
                            ++n5;
                        }
                    }
                    finally {
                        gc.dispose();
                    }
                }
            }
            if (fit && totalWidth < clientArea.width) {
                int sbWidth = table.getBorderWidth() * 2;
                if (table.getVerticalBar() != null) {
                    sbWidth += table.getVerticalBar().getSize().x;
                }
                if (columns.length > 0) {
                    float extraSpace = (clientArea.width - totalWidth - sbWidth) / columns.length - 1;
                    tableColumnArray = columns;
                    n = columns.length;
                    int n6 = 0;
                    while (n6 < n) {
                        TableColumn tc = tableColumnArray[n6];
                        tc.setWidth((int)((float)tc.getWidth() + extraSpace));
                        ++n6;
                    }
                }
            }
        }
        finally {
            table.setRedraw(true);
        }
    }

    public static void packColumns(@NotNull Tree tree) {
        UIUtils.packColumns(tree, false, null);
    }

    public static void packColumns(@NotNull Tree tree, boolean fit, @Nullable float[] ratios) {
        block23: {
            tree.setRedraw(false);
            try {
                TreeColumn tc2;
                int n;
                TreeColumn[] columns;
                TreeItem[] treeItemArray = tree.getItems();
                int n2 = treeItemArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    TreeItem item = treeItemArray[n3];
                    if (item.isDisposed()) {
                        return;
                    }
                    ++n3;
                }
                TreeColumn[] treeColumnArray = columns = tree.getColumns();
                int n4 = columns.length;
                n2 = 0;
                while (n2 < n4) {
                    TreeColumn column = treeColumnArray[n2];
                    column.pack();
                    ++n2;
                }
                Rectangle clientArea = tree.getClientArea();
                if (clientArea.isEmpty()) {
                    return;
                }
                int totalWidth = 0;
                TreeColumn[] treeColumnArray2 = columns;
                int n5 = columns.length;
                int n6 = 0;
                while (n6 < n5) {
                    TreeColumn column = treeColumnArray2[n6];
                    int colWidth = column.getWidth();
                    if (colWidth > clientArea.width) {
                        colWidth = clientArea.width;
                        column.setWidth(colWidth);
                    }
                    totalWidth += colWidth;
                    ++n6;
                }
                if (!fit) break block23;
                int areaWidth = clientArea.width;
                if (totalWidth > areaWidth) {
                    GC gc = new GC((Drawable)tree);
                    try {
                        int extraSpace = totalWidth - areaWidth;
                        TreeColumn[] treeColumnArray3 = columns;
                        int n7 = columns.length;
                        n = 0;
                        while (n < n7) {
                            tc2 = treeColumnArray3[n];
                            double ratio = (double)tc2.getWidth() / (double)totalWidth;
                            int newWidth = (int)((double)tc2.getWidth() - (double)extraSpace * ratio);
                            int minWidth = gc.stringExtent((String)tc2.getText()).x;
                            if (newWidth < (minWidth += 5)) {
                                newWidth = minWidth;
                            }
                            tc2.setWidth(newWidth);
                            ++n;
                        }
                        break block23;
                    }
                    finally {
                        gc.dispose();
                    }
                }
                if (totalWidth < areaWidth) {
                    float extraSpace = areaWidth - totalWidth;
                    if (columns.length > 0) {
                        if (ratios == null || ratios.length < columns.length) {
                            extraSpace /= (float)columns.length;
                            extraSpace -= 1.0f;
                            TreeColumn[] treeColumnArray4 = columns;
                            n = columns.length;
                            int tc2 = 0;
                            while (tc2 < n) {
                                TreeColumn tc3 = treeColumnArray4[tc2];
                                tc3.setWidth((int)((float)tc3.getWidth() + extraSpace));
                                ++tc2;
                            }
                        } else {
                            int i = 0;
                            while (i < columns.length) {
                                tc2 = columns[i];
                                tc2.setWidth((int)((float)tc2.getWidth() + extraSpace * ratios[i]));
                                ++i;
                            }
                        }
                    }
                }
            }
            finally {
                tree.setRedraw(true);
            }
        }
    }

    public static void maxTableColumnsWidth(Table table) {
        table.setRedraw(false);
        try {
            int columnCount = table.getColumnCount();
            if (columnCount > 0) {
                TableColumn[] columns;
                int totalWidth = 0;
                TableColumn[] tableColumnArray = columns = table.getColumns();
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn tc = tableColumnArray[n2];
                    tc.pack();
                    totalWidth += tc.getWidth();
                    ++n2;
                }
                Rectangle clientArea = table.getClientArea();
                if (totalWidth < clientArea.width) {
                    int extraSpace = clientArea.width - totalWidth;
                    extraSpace /= columnCount;
                    TableColumn[] tableColumnArray2 = columns;
                    int n3 = columns.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TableColumn tc = tableColumnArray2[n4];
                        tc.setWidth(tc.getWidth() + extraSpace);
                        ++n4;
                    }
                }
            }
        }
        finally {
            table.setRedraw(true);
        }
    }

    public static int getColumnAtPos(TableItem item, int x, int y) {
        int columnCount = item.getParent().getColumnCount();
        int i = 0;
        while (i < columnCount) {
            Rectangle rect = item.getBounds(i);
            if (rect.contains(x, y)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getColumnAtPos(TreeItem item, int x, int y) {
        int columnCount = item.getParent().getColumnCount();
        int i = 0;
        while (i < columnCount) {
            Rectangle rect = item.getBounds(i);
            if (rect.contains(x, y)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static TableItem getNextTableItem(Table table, TableItem item) {
        TableItem[] items = table.getItems();
        int i = 0;
        while (i < items.length - 1) {
            if (items[i] == item) {
                return items[i + 1];
            }
            ++i;
        }
        return null;
    }

    public static TableItem getPreviousTableItem(Table table, TableItem item) {
        TableItem[] items = table.getItems();
        int i = 1;
        while (i < items.length) {
            if (items[i] == item) {
                return items[i - 1];
            }
            ++i;
        }
        return null;
    }

    public static TreeItem getNextTreeItem(Tree tree, TreeItem item) {
        TreeItem[] items = tree.getItems();
        int i = 0;
        while (i < items.length - 1) {
            if (items[i] == item) {
                return items[i + 1];
            }
            ++i;
        }
        return null;
    }

    public static void dispose(Widget widget) {
        if (widget != null && !widget.isDisposed()) {
            try {
                widget.dispose();
            }
            catch (Exception e) {
                log.debug((Object)"widget dispose error", (Throwable)e);
            }
        }
    }

    public static void dispose(Resource resource) {
        if (resource != null && !resource.isDisposed()) {
            try {
                resource.dispose();
            }
            catch (Exception e) {
                log.debug((Object)"Resource dispose error", (Throwable)e);
            }
        }
    }

    public static void showMessageBox(Shell shell, String title, String info, int messageType) {
        Runnable messageBoxRunnable;
        DBIcon icon = null;
        if (messageType == 1) {
            icon = DBIcon.STATUS_ERROR;
        } else if (messageType == 8) {
            icon = DBIcon.STATUS_WARNING;
        } else if (messageType == 4) {
            icon = DBIcon.STATUS_QUESTION;
        } else if (messageType == 2) {
            icon = DBIcon.STATUS_INFO;
        }
        if (icon != null) {
            DBIcon finalIcon = icon;
            messageBoxRunnable = () -> UIUtils.lambda$3(shell, title, info, (DBPImage)finalIcon);
        } else {
            messageBoxRunnable = () -> {
                Shell activeShell = shell != null ? shell : UIUtils.getActiveWorkbenchShell();
                MessageBox messageBox = new MessageBox(activeShell, messageType | 0x20);
                messageBox.setMessage(info);
                messageBox.setText(title);
                messageBox.open();
            };
        }
        UIUtils.syncExec(messageBoxRunnable);
    }

    public static boolean confirmAction(String title, String question) {
        return UIUtils.confirmAction(null, title, question);
    }

    public static boolean confirmAction(@Nullable Shell shell, String title, String question) {
        return UIUtils.confirmAction(shell, title, question, (DBPImage)DBIcon.STATUS_QUESTION);
    }

    public static boolean confirmAction(@Nullable Shell shell, String title, String message, @NotNull DBPImage image) {
        Reply[] reply = new Reply[1];
        UIUtils.syncExec(() -> {
            Reply reply = MessageBoxBuilder.builder(shell != null ? shell : UIUtils.getActiveWorkbenchShell()).setTitle(title).setMessage(message).setReplies(Reply.YES, Reply.NO).setDefaultReply(Reply.NO).setPrimaryImage(image).showMessageBox();
        });
        return reply[0] == Reply.YES;
    }

    public static boolean confirmAction(@Nullable Shell shell, String title, String message, @NotNull DBPImage image, String[] buttons) {
        Reply[] reply = new Reply[1];
        UIUtils.syncExec(() -> {
            Reply reply = MessageBoxBuilder.builder(shell != null ? shell : UIUtils.getActiveWorkbenchShell()).setTitle(title).setMessage(message).setLabels(buttons).setDefaultReply(Reply.NO).setPrimaryImage(image).setDefaultFocus(buttons.length - 1).showMessageBox();
        });
        return reply[0] == Reply.OK;
    }

    public static int getFontHeight(Control control) {
        return UIUtils.getFontHeight(control.getFont());
    }

    public static int getFontHeight(Font font) {
        FontData[] fontData = font.getFontData();
        if (fontData.length == 0) {
            return 20;
        }
        return fontData[0].getHeight();
    }

    public static int getTextHeight(@NotNull Control control) {
        return UIUtils.getTextSize((Control)control, (String)"X").y;
    }

    @NotNull
    public static Point getTextSize(@NotNull Control control, @NotNull String text) {
        GC gc = new GC((Drawable)control);
        try {
            Point point = gc.textExtent(text);
            return point;
        }
        finally {
            gc.dispose();
        }
    }

    public static Font makeBoldFont(Font normalFont) {
        return UIUtils.modifyFont(normalFont, 1);
    }

    @NotNull
    public static Font modifyFont(@NotNull Font normalFont, int style) {
        FontData[] data;
        FontData[] fontDataArray = data = normalFont.getFontData();
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setStyle(fd.getStyle() | style);
            ++n2;
        }
        return new Font(normalFont.getDevice(), data);
    }

    @NotNull
    public static Font modifyFontSize(@NotNull Font normalFont, int modifier) {
        FontData[] data;
        FontData[] fontDataArray = data = normalFont.getFontData();
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fd.setHeight(fd.getHeight() + modifier);
            ++n2;
        }
        return new Font(normalFont.getDevice(), data);
    }

    public static Group createControlGroup(Composite parent, String label, int columns, int layoutStyle, int widthHint) {
        Group group = new Group(parent, 0);
        group.setText(label);
        if (parent.getLayout() instanceof GridLayout) {
            GridData gd = new GridData(layoutStyle);
            if (widthHint > 0) {
                gd.widthHint = widthHint;
            }
            group.setLayoutData((Object)gd);
        }
        GridLayout gl = new GridLayout(columns, false);
        group.setLayout((Layout)gl);
        return group;
    }

    public static Label createControlLabel(Composite parent, String label) {
        return UIUtils.createControlLabel(parent, label, 1);
    }

    public static Label createControlLabel(Composite parent, String label, int hSpan) {
        Label textLabel = new Label(parent, 0);
        textLabel.setText(label + ": ");
        GridData gd = new GridData(4);
        gd.horizontalSpan = hSpan;
        textLabel.setLayoutData((Object)gd);
        return textLabel;
    }

    public static Label createLabel(Composite parent, String label) {
        Label textLabel = new Label(parent, 0);
        textLabel.setText(label);
        return textLabel;
    }

    public static Label createLabel(Composite parent, @NotNull DBPImage image) {
        Label imageLabel = new Label(parent, 0);
        imageLabel.setImage(DBeaverIcons.getImage(image));
        return imageLabel;
    }

    @NotNull
    public static Control createInfoLabel(@NotNull Composite parent, @NotNull String text) {
        return UIUtils.createInfoLabel(parent, text, null);
    }

    @NotNull
    public static Control createInfoLabel(@NotNull Composite parent, @NotNull String text, @Nullable Runnable listener) {
        return UIUtils.createInfoLabel(parent, text, 0, 1, listener);
    }

    @NotNull
    public static Control createInfoLabel(@NotNull Composite parent, @NotNull String text, int gridStyle, int hSpan) {
        return UIUtils.createInfoLabel(parent, text, gridStyle, hSpan, null);
    }

    @NotNull
    public static Control createWarningLabel(@NotNull Composite parent, @NotNull String text, int gridStyle, int hSpan) {
        return UIUtils.createInfoLabel(parent, text, gridStyle, hSpan, null, DBeaverIcons.getImage((DBPImage)DBIcon.SMALL_WARNING));
    }

    @NotNull
    public static Control createInfoLabel(@NotNull Composite parent, @NotNull String text, int gridStyle, int hSpan, @Nullable Runnable callback) {
        return UIUtils.createInfoLabel(parent, text, gridStyle, hSpan, callback, DBeaverIcons.getImage((DBPImage)DBIcon.SMALL_INFO));
    }

    @NotNull
    public static Control createInfoLabel(@NotNull Composite parent, @NotNull String text, int gridStyle, int hSpan, @Nullable Runnable callback, @NotNull Image image) {
        Composite control;
        if (callback == null) {
            CLabel label = new CLabel(parent, 0);
            label.setImage(image);
            label.setText(text);
            control = label;
        } else {
            control = UIUtils.createInfoLink(parent, UIUtils.createHrefText(text), callback).getParent();
        }
        if (gridStyle != 0 || hSpan > 1) {
            GridData gd = new GridData(gridStyle);
            gd.horizontalSpan = hSpan;
            control.setLayoutData((Object)gd);
        }
        return control;
    }

    @NotNull
    private static String createHrefText(@NotNull String text) {
        return "<a href=\"#\">" + text + "</a>";
    }

    @NotNull
    public static Link createInfoLink(@NotNull Composite parent, @NotNull String text, @NotNull Runnable callback) {
        return UIUtils.createInfoLink(parent, text, callback, 0, 1, -1);
    }

    @NotNull
    public static Link createInfoLink(@NotNull Composite parent, @NotNull String text, @NotNull Runnable callback, int style, int colsSpan, int widthHint) {
        Composite composite = new Composite(parent, style);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().span(colsSpan, 1).hint(widthHint, -1).grab(true, false).create());
        Label imageLabel = new Label(composite, 0);
        imageLabel.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.SMALL_INFO));
        imageLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        Link link = new Link(composite, 0);
        link.setText(text);
        link.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> callback.run()));
        link.setLayoutData((Object)new GridData(1, 0x1000000, true, true));
        return link;
    }

    public static void setInfoLinkText(@NotNull Control infoLink, @NotNull String text) {
        Composite comp;
        Link link;
        if (infoLink instanceof Composite && (link = UIUtils.getChildOfType(comp = (Composite)infoLink, Link.class)) != null) {
            link.setText(UIUtils.createHrefText(text));
        }
    }

    public static Text createLabelText(Composite parent, String label, String value) {
        return UIUtils.createLabelText(parent, label, value, 2048);
    }

    public static Text createLabelText(Composite parent, String label, String value, int style) {
        return UIUtils.createLabelText(parent, label, value, style, new GridData(768));
    }

    @NotNull
    public static Text createLabelText(@NotNull Composite parent, @NotNull String label, @Nullable String value, int style, @Nullable Object layoutData) {
        UIUtils.createControlLabel(parent, label);
        Text text = new Text(parent, style);
        UIUtils.fixReadonlyTextBackground(text);
        if (value != null) {
            text.setText(value);
        }
        if (layoutData != null) {
            text.setLayoutData(layoutData);
        }
        return text;
    }

    @NotNull
    public static Text createLabelTextAdvanced(final @NotNull Composite parent, final @NotNull String label, @Nullable String value, int style) {
        UIUtils.createControlLabel(parent, label);
        Composite panel = UIUtils.createComposite(parent, 2);
        panel.setLayoutData((Object)new GridData(768));
        final Text text = new Text(panel, style);
        text.setLayoutData((Object)new GridData(768));
        UIUtils.fixReadonlyTextBackground(text);
        if (value != null) {
            text.setText(value);
        }
        ToolBar editTB = new ToolBar(panel, 256);
        ToolItem editButton = new ToolItem(editTB, 1024);
        editButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.EDIT));
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newText = EditTextDialog.editText(parent.getShell(), label, text.getText());
                if (newText != null) {
                    text.setText(newText);
                }
            }
        });
        editTB.setLayoutData((Object)new GridData(32));
        return text;
    }

    @NotNull
    public static Spinner createLabelSpinner(@NotNull Composite parent, @NotNull String label, @Nullable String tooltip, int value, int minimum, int maximum) {
        Label l = UIUtils.createControlLabel(parent, label);
        if (tooltip != null) {
            l.setToolTipText(tooltip);
        }
        return UIUtils.createSpinner(parent, tooltip, value, minimum, maximum);
    }

    @NotNull
    public static Spinner createSpinner(Composite parent, String tooltip, int value, int minimum, int maximum) {
        Spinner spinner = new Spinner(parent, 2048);
        spinner.setMinimum(minimum);
        spinner.setMaximum(maximum);
        spinner.setSelection(value);
        if (tooltip != null) {
            spinner.setToolTipText(tooltip);
        }
        return spinner;
    }

    @NotNull
    public static Spinner createLabelSpinner(@NotNull Composite parent, @NotNull String label, int value, int minimum, int maximum) {
        return UIUtils.createLabelSpinner(parent, label, null, value, minimum, maximum);
    }

    @NotNull
    public static Button createLabelCheckbox(Composite parent, String label, boolean checked) {
        return UIUtils.createLabelCheckbox(parent, label, null, checked, 0);
    }

    @NotNull
    public static Button createLabelCheckbox(Composite parent, String label, String tooltip, boolean checked) {
        return UIUtils.createLabelCheckbox(parent, label, tooltip, checked, 0);
    }

    @NotNull
    public static Button createLabelCheckbox(@NotNull Composite parent, @NotNull String label, @Nullable String tooltip, boolean checked, int style) {
        Label labelControl = UIUtils.createControlLabel(parent, label);
        final Button button = new Button(parent, 0x20 | style);
        if (checked) {
            button.setSelection(true);
        }
        labelControl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (!button.isDisposed() && button.isVisible() && button.isEnabled()) {
                    button.setSelection(!button.getSelection());
                    button.notifyListeners(13, new Event());
                }
            }
        });
        if (tooltip != null) {
            labelControl.setToolTipText(tooltip);
            button.setToolTipText(tooltip);
        }
        return button;
    }

    public static Button createCheckbox(Composite parent, String label, String tooltip, boolean checked, int hSpan) {
        Button checkbox = UIUtils.createCheckbox(parent, label, checked);
        if (tooltip != null) {
            checkbox.setToolTipText(tooltip);
        }
        if (hSpan > 1) {
            GridData gd = new GridData(32);
            gd.horizontalSpan = hSpan;
            checkbox.setLayoutData((Object)gd);
        }
        return checkbox;
    }

    public static Button createCheckbox(Composite parent, String label, boolean checked) {
        Button button = new Button(parent, 32);
        button.setText(label);
        if (checked) {
            button.setSelection(true);
        }
        return button;
    }

    public static Button createCheckbox(Composite parent, boolean checked) {
        Button button = new Button(parent, 32);
        if (checked) {
            button.setSelection(true);
        }
        return button;
    }

    public static Combo createLabelCombo(Composite parent, String label, int style) {
        return UIUtils.createLabelCombo(parent, label, null, style);
    }

    public static Combo createLabelCombo(Composite parent, String label, String tooltip, int style) {
        Label labelControl = UIUtils.createControlLabel(parent, label);
        if (tooltip != null) {
            labelControl.setToolTipText(tooltip);
        }
        Combo combo = new Combo(parent, style);
        combo.setLayoutData((Object)new GridData(768));
        if (tooltip != null) {
            combo.setToolTipText(tooltip);
        }
        return combo;
    }

    public static Button createToolButton(Composite parent, String text, SelectionListener selectionListener) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setLayoutData((Object)new GridData(768));
        if (selectionListener != null) {
            button.addSelectionListener(selectionListener);
        }
        return button;
    }

    public static ToolItem createToolItem(ToolBar parent, String text, DBPImage icon, SelectionListener selectionListener) {
        return UIUtils.createToolItem(parent, text, icon != null ? DBeaverIcons.getImage(icon) : null, selectionListener);
    }

    public static ToolItem createToolItem(ToolBar parent, String title, String text, DBPImage icon, SelectionListener selectionListener) {
        ToolItem toolItem = UIUtils.createToolItem(parent, text, icon != null ? DBeaverIcons.getImage(icon) : null, selectionListener);
        if (title != null) {
            toolItem.setText(title);
        }
        return toolItem;
    }

    public static ToolItem createToolItem(ToolBar parent, String text, Image icon, SelectionListener selectionListener) {
        ToolItem button = new ToolItem(parent, 8);
        button.setToolTipText(text);
        if (icon != null) {
            button.setImage(icon);
        }
        if (selectionListener != null) {
            button.addSelectionListener(selectionListener);
        }
        return button;
    }

    public static void updateContributionItems(IContributionManager manager) {
        IContributionItem[] iContributionItemArray = manager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            item.update();
            ++n2;
        }
    }

    @Nullable
    public static Shell getActiveShell() {
        Shell[] shells;
        Display display = Display.getCurrent();
        Shell activeShell = display.getActiveShell();
        if (activeShell != null) {
            return activeShell;
        }
        Shell[] shellArray = shells = display.getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            if (shell.isVisible()) {
                return shell;
            }
            ++n2;
        }
        return shells.length > 0 ? shells[0] : null;
    }

    @Nullable
    public static Shell getShell(IShellProvider provider) {
        return provider == null ? null : provider.getShell();
    }

    @Nullable
    public static Shell getShell(IWorkbenchPart part) {
        return part == null ? null : UIUtils.getShell((IShellProvider)part.getSite());
    }

    @Nullable
    public static Integer getTextInteger(Text text) {
        String str = text.getText();
        if ((str = str.trim()).length() == 0) {
            return null;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            log.debug((Object)e);
            return null;
        }
    }

    @Nullable
    public static IHandlerActivation registerKeyBinding(IServiceLocator serviceLocator, IAction action) {
        IHandlerService handlerService = (IHandlerService)serviceLocator.getService(IHandlerService.class);
        if (handlerService != null) {
            return handlerService.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler(action));
        }
        return null;
    }

    public static Composite createPlaceholder(Composite parent, int columns) {
        return UIUtils.createPlaceholder(parent, columns, 0);
    }

    public static Composite createComposite(@NotNull Composite parent, int columns) {
        Composite ph = new Composite(parent, 0);
        GridLayout gl = new GridLayout(columns, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        ph.setLayout((Layout)gl);
        return ph;
    }

    @NotNull
    public static ScrolledComposite createScrolledComposite(@NotNull Composite parent, int style) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, style);
        scrolledComposite.setLayout((Layout)new GridLayout(1, false));
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        return scrolledComposite;
    }

    public static void configureScrolledComposite(final @NotNull ScrolledComposite scrolledComposite, final @NotNull Control content) {
        scrolledComposite.setContent(content);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = scrolledComposite.getClientArea();
                Point size = content.computeSize((scrolledComposite.getStyle() & 0x100) != 0 ? -1 : area.width, (scrolledComposite.getStyle() & 0x200) != 0 ? -1 : area.height);
                content.setSize(size);
                scrolledComposite.setMinSize(size);
            }
        });
    }

    public static Composite createPlaceholder(@NotNull Composite parent, int columns, int spacing) {
        Composite ph = new Composite(parent, 0);
        GridLayout gl = new GridLayout(columns, false);
        gl.verticalSpacing = spacing;
        gl.horizontalSpacing = spacing;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        ph.setLayout((Layout)gl);
        return ph;
    }

    public static Composite createFormPlaceholder(Composite parent, int columns, int hSpan) {
        Composite ph = new Composite(parent, 0);
        GridLayout gl = new GridLayout(columns, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        ph.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        gd.horizontalSpan = hSpan;
        ph.setLayoutData((Object)gd);
        return ph;
    }

    public static Label createHorizontalLine(Composite parent) {
        return UIUtils.createHorizontalLine(parent, 1, 0);
    }

    public static Label createHorizontalLine(Composite parent, int hSpan, int vIndent) {
        Label horizontalLine = new Label(parent, 258);
        GridData gd = new GridData(4, 4, true, false, 1, 1);
        gd.horizontalSpan = hSpan;
        gd.verticalIndent = vIndent;
        horizontalLine.setLayoutData((Object)gd);
        return horizontalLine;
    }

    @Nullable
    public static String getComboSelection(Combo combo) {
        int selectionIndex = combo.getSelectionIndex();
        if (selectionIndex < 0) {
            return null;
        }
        return combo.getItem(selectionIndex);
    }

    public static boolean setComboSelection(Combo combo, String value) {
        if (value == null) {
            return false;
        }
        int count = combo.getItemCount();
        int i = 0;
        while (i < count) {
            if (value.equals(combo.getItem(i))) {
                combo.select(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Combo createEncodingCombo(Composite parent, @Nullable String curCharset) {
        Combo encodingCombo = new Combo(parent, 4);
        encodingCombo.setVisibleItemCount(30);
        SortedMap<String, Charset> charsetMap = Charset.availableCharsets();
        int index = 0;
        int defIndex = -1;
        for (String csName : charsetMap.keySet()) {
            Charset charset = (Charset)charsetMap.get(csName);
            encodingCombo.add(charset.displayName());
            if (curCharset != null) {
                if (charset.displayName().equalsIgnoreCase(curCharset)) {
                    defIndex = index;
                }
                if (defIndex < 0) {
                    for (String alias : charset.aliases()) {
                        if (!alias.equalsIgnoreCase(curCharset)) continue;
                        defIndex = index;
                    }
                }
            }
            ++index;
        }
        if (defIndex >= 0) {
            encodingCombo.select(defIndex);
        } else if (curCharset != null) {
            log.warn((Object)("Charset '" + curCharset + "' is not recognized"));
        }
        return encodingCombo;
    }

    @NotNull
    public static CustomSashForm createPartDivider(IWorkbenchPart workbenchPart, Composite parent, int style) {
        return new CustomSashForm(parent, style);
    }

    public static int checkSashStyle(int style) {
        if (DPIUtil.getDeviceZoom() != 100) {
            return style & 0xFFFEFFFF;
        }
        return style;
    }

    @NotNull
    public static Button createPushButton(@NotNull Composite parent, @Nullable String label, @Nullable Image image) {
        return UIUtils.createPushButton(parent, label, image, null);
    }

    @NotNull
    public static Button createPushButton(@NotNull Composite parent, @Nullable String label, @Nullable Image image, @Nullable SelectionListener selectionListener) {
        Button button = new Button(parent, 8);
        if (label != null) {
            button.setText(label);
        }
        if (image != null) {
            button.setImage(image);
        }
        if (selectionListener != null) {
            button.addSelectionListener(selectionListener);
        }
        return button;
    }

    @NotNull
    public static Button createPushButton(@NotNull Composite parent, @Nullable String label, @Nullable String toolTip, @Nullable DBPImage image, @Nullable SelectionListener selectionListener) {
        Button button = new Button(parent, 0x800008);
        if (label != null) {
            button.setText(label);
        }
        if (toolTip != null) {
            button.setToolTipText(toolTip);
        }
        if (image != null) {
            button.setImage(DBeaverIcons.getImage(image));
        }
        if (selectionListener != null) {
            button.addSelectionListener(selectionListener);
        }
        return button;
    }

    @NotNull
    public static Button createDialogButton(@NotNull Composite parent, @Nullable String label, @Nullable SelectionListener selectionListener) {
        return UIUtils.createDialogButton(parent, label, null, null, selectionListener);
    }

    @NotNull
    public static Button createDialogButton(@NotNull Composite parent, @Nullable String label, @Nullable DBPImage icon, @Nullable String toolTip, @Nullable SelectionListener selectionListener) {
        return UIUtils.createDialogButton(parent, label, toolTip, icon, selectionListener);
    }

    @NotNull
    public static Button createDialogButton(@NotNull Composite parent, @Nullable String label, @Nullable String toolTip, @Nullable DBPImage icon, @Nullable SelectionListener selectionListener) {
        Button button = new Button(parent, 8);
        if (label != null) {
            button.setText(label);
        }
        button.setFont(JFaceResources.getDialogFont());
        if (icon != null) {
            button.setImage(DBeaverIcons.getImage(icon));
        }
        if (toolTip != null) {
            button.setToolTipText(toolTip);
        }
        button.setLayoutData(UIUtils.getDialogButtonLayoutData(parent, button));
        if (selectionListener != null) {
            button.addSelectionListener(selectionListener);
        }
        return button;
    }

    private static Object getDialogButtonLayoutData(@NotNull Composite parent, @NotNull Button button) {
        int buttonWidth = UIUtils.getDialogButtonWidth(button);
        if (parent.getLayout() instanceof GridLayout) {
            GridData gridData = new GridData(256);
            gridData.widthHint = buttonWidth;
            return gridData;
        }
        if (parent.getLayout() instanceof RowLayout) {
            return new RowData(buttonWidth, -1);
        }
        return null;
    }

    public static int getDialogButtonWidth(@NotNull Button button) {
        GC gc = new GC((Drawable)button);
        try {
            gc.setFont(JFaceResources.getDialogFont());
            int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)gc.getFontMetrics(), (int)61);
            Point minSize = button.computeSize(-1, -1, true);
            int n = Math.max(widthHint, minSize.x);
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    @NotNull
    public static Button createRadioButton(@NotNull Composite parent, @Nullable String label, @NotNull Object data, @Nullable SelectionListener selectionListener) {
        Button button = new Button(parent, 16);
        button.setText(label);
        if (selectionListener != null) {
            button.addSelectionListener(selectionListener);
        }
        button.setData(data);
        return button;
    }

    public static void setHelp(Control control, String pluginId, String helpContextID) {
        if (control != null && !control.isDisposed()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(control, pluginId + "." + helpContextID);
        }
    }

    public static void setHelp(Control control, String helpContextID) {
        UIUtils.setHelp(control, "org.jkiss.dbeaver.ui", helpContextID);
    }

    public static String makeAnchor(String text) {
        return "<a>" + text + "</a>";
    }

    @Nullable
    public static <T> T findView(IWorkbenchWindow workbenchWindow, Class<T> viewClass) {
        IViewReference[] references;
        IViewReference[] iViewReferenceArray = references = workbenchWindow.getActivePage().getViewReferences();
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            IViewPart view = ref.getView(false);
            if (view != null && viewClass.isAssignableFrom(view.getClass())) {
                return viewClass.cast(view);
            }
            ++n2;
        }
        return null;
    }

    @Nullable
    public static IViewPart findView(IWorkbenchWindow workbenchWindow, String viewId) {
        IViewReference[] references;
        IViewReference[] iViewReferenceArray = references = workbenchWindow.getActivePage().getViewReferences();
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            if (ref.getId().equals(viewId)) {
                return ref.getView(false);
            }
            ++n2;
        }
        return null;
    }

    public static void setClipboardContents(Display display, Transfer transfer, Object contents) {
        Clipboard clipboard = new Clipboard(display);
        clipboard.setContents(new Object[]{contents}, new Transfer[]{transfer});
        clipboard.dispose();
    }

    public static void showPreferencesFor(Shell shell, Object element, String ... defPageID) {
        PreferenceDialog propDialog = element == null ? PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)defPageID[0], (String[])defPageID, null, (int)0) : PreferencesUtil.createPropertyDialogOn((Shell)shell, (Object)element, (String)defPageID[0], null, null, (int)0);
        if (propDialog != null) {
            propDialog.open();
        }
    }

    @NotNull
    public static Link createPreferenceLink(@NotNull Composite parent, @NotNull String message, @NotNull String pageId, @Nullable IWorkbenchPreferenceContainer pageContainer, @Nullable Object pageData) {
        IPreferenceNode node = UIUtils.findPreferenceNode(pageId);
        Link link = new Link(parent, 0);
        if (node == null) {
            link.setText(NLS.bind((String)WorkbenchMessages.PreferenceNode_NotFound, (Object)pageId));
        } else {
            boolean canOpenHere = UIUtils.findPreferenceNode(pageContainer, pageId) != null;
            String label = canOpenHere ? node.getLabelText() : NLS.bind((String)UIMessages.link_external_label, (Object)node.getLabelText());
            link.setText(NLS.bind((String)message, (Object)label));
            link.setToolTipText(canOpenHere ? null : UIMessages.link_external_tip);
            link.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                if (pageContainer != null && canOpenHere) {
                    pageContainer.openPage(pageId, pageData);
                } else {
                    PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)pageId, (String[])new String[]{pageId}, (Object)pageData, (int)0).open();
                }
            }));
        }
        return link;
    }

    @Nullable
    private static IPreferenceNode findPreferenceNode(@NotNull String pageId) {
        return UIUtils.findPreferenceNode(PlatformUI.getWorkbench().getPreferenceManager(), pageId);
    }

    @Nullable
    private static IPreferenceNode findPreferenceNode(@Nullable IWorkbenchPreferenceContainer container, @NotNull String pageId) {
        if (container instanceof PreferenceDialog) {
            PreferenceDialog dialog = (PreferenceDialog)container;
            return UIUtils.findPreferenceNode(dialog.getPreferenceManager(), pageId);
        }
        return null;
    }

    @Nullable
    private static IPreferenceNode findPreferenceNode(@NotNull PreferenceManager preferenceManager, @NotNull String pageId) {
        return preferenceManager.getElements(1).stream().filter(next -> next.getId().equals(pageId)).findFirst().orElse(null);
    }

    public static void addFocusTracker(IServiceLocator serviceLocator, String controlID, Control control) {
        IFocusService focusService = (IFocusService)serviceLocator.getService(IFocusService.class);
        if (focusService == null) {
            focusService = (IFocusService)UIUtils.getActiveWorkbenchWindow().getService(IFocusService.class);
        }
        if (focusService != null) {
            IFocusService finalFocusService = focusService;
            finalFocusService.addFocusTracker(control, controlID);
            control.addDisposeListener(e -> finalFocusService.removeFocusTracker(control));
        } else {
            log.debug((Object)("Focus service not found in " + String.valueOf(serviceLocator)));
        }
    }

    public static void addDefaultEditActionsSupport(IServiceLocator site, Control control) {
        UIUtils.addFocusTracker(site, INLINE_WIDGET_EDITOR_ID, control);
    }

    @NotNull
    public static IDialogSettings getDialogSettings(@NotNull String dialogId) {
        IDialogSettings workbenchSettings = UIActivator.getDefault().getDialogSettings();
        return UIUtils.getSettingsSection(workbenchSettings, dialogId);
    }

    @NotNull
    public static IDialogSettings getSettingsSection(@NotNull IDialogSettings parent, @NotNull String sectionId) {
        IDialogSettings section = parent.getSection(sectionId);
        if (section == null) {
            section = parent.addNewSection(sectionId);
        }
        return section;
    }

    public static void putSectionValueWithType(IDialogSettings dialogSettings, @NotNull String key, Object value) {
        if (value == null) {
            dialogSettings.put(key, null);
            return;
        }
        if (value instanceof Double) {
            dialogSettings.put(key, ((Double)value).doubleValue());
        } else if (value instanceof Float) {
            dialogSettings.put(key, ((Float)value).floatValue());
        } else if (value instanceof Integer) {
            dialogSettings.put(key, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            dialogSettings.put(key, ((Long)value).longValue());
        } else if (value instanceof String) {
            dialogSettings.put(key, (String)value);
        } else if (value instanceof Boolean) {
            dialogSettings.put(key, ((Boolean)value).booleanValue());
        }
        dialogSettings.put(key + "_type", value.getClass().getSimpleName());
    }

    public static Object getSectionValueWithType(IDialogSettings dialogSettings, @NotNull String key) {
        block22: {
            String type = dialogSettings.get(key + "_type");
            if (type == null) break block22;
            switch (type) {
                case "Double": {
                    return dialogSettings.getDouble(key);
                }
                case "Float": {
                    return Float.valueOf(dialogSettings.getFloat(key));
                }
                case "Integer": {
                    return dialogSettings.getInt(key);
                }
                case "Long": {
                    return dialogSettings.getLong(key);
                }
                case "String": {
                    return dialogSettings.get(key);
                }
                case "Boolean": {
                    return dialogSettings.getBoolean(key);
                }
            }
        }
        return dialogSettings.get(key);
    }

    @Nullable
    public static IWorkbenchPartSite getWorkbenchPartSite(IServiceLocator serviceLocator) {
        IWorkbenchPartSite partSite = (IWorkbenchPartSite)serviceLocator.getService(IWorkbenchPartSite.class);
        if (partSite == null) {
            IWorkbenchPart activePart = (IWorkbenchPart)serviceLocator.getService(IWorkbenchPart.class);
            if (activePart == null) {
                IWorkbenchPage activePage;
                IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)serviceLocator.getService(IWorkbenchWindow.class);
                if (workbenchWindow == null) {
                    workbenchWindow = UIUtils.getActiveWorkbenchWindow();
                }
                if (workbenchWindow != null && (activePage = workbenchWindow.getActivePage()) != null) {
                    activePart = activePage.getActivePart();
                }
            }
            if (activePart != null) {
                partSite = activePart.getSite();
            }
        }
        return partSite;
    }

    @Nullable
    public static ISelectionProvider getSelectionProvider(IServiceLocator serviceLocator) {
        ISelectionProvider selectionProvider = (ISelectionProvider)serviceLocator.getService(ISelectionProvider.class);
        if (selectionProvider != null) {
            return selectionProvider;
        }
        IWorkbenchPartSite partSite = UIUtils.getWorkbenchPartSite(serviceLocator);
        if (partSite == null) {
            IWorkbenchPart activePart = (IWorkbenchPart)serviceLocator.getService(IWorkbenchPart.class);
            if (activePart == null) {
                IWorkbenchWindow activeWindow = UIUtils.getActiveWorkbenchWindow();
                activePart = activeWindow.getActivePage().getActivePart();
            }
            if (activePart != null) {
                partSite = activePart.getSite();
            }
        }
        if (partSite != null) {
            return partSite.getSelectionProvider();
        }
        return null;
    }

    public static void enableWithChildren(Control control, boolean enable) {
        if (control == null || control.isDisposed()) {
            return;
        }
        control.setEnabled(enable);
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof Composite) {
                    UIUtils.enableWithChildren(child, enable);
                } else if (!child.isDisposed()) {
                    child.setEnabled(enable);
                }
                ++n2;
            }
        }
    }

    public static boolean isUIThread() {
        return Display.getCurrent() != null;
    }

    public static boolean hasFocus(Control control) {
        if (control == null || control.isDisposed()) {
            return false;
        }
        Control focusControl = control.getDisplay().getFocusControl();
        if (focusControl == null) {
            return false;
        }
        Control fc = focusControl;
        while (fc != null) {
            if (fc == control) {
                return true;
            }
            fc = fc.getParent();
        }
        return false;
    }

    public static CTabItem getTabItem(CTabFolder tabFolder, Object data) {
        CTabItem[] cTabItemArray = tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (item.getData() == data) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public static void disposeControlOnItemDispose(CTabItem tabItem) {
        tabItem.addDisposeListener(e -> {
            Control control = tabItem.getControl();
            if (!control.isDisposed()) {
                control.dispose();
            }
        });
    }

    public static TreeItem getTreeItem(Tree tree, Object data) {
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() == data) {
                return item;
            }
            TreeItem child = UIUtils.getTreeItem(item, data);
            if (child != null) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    private static TreeItem getTreeItem(TreeItem parent, Object data) {
        TreeItem[] treeItemArray = parent.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() == data) {
                return item;
            }
            TreeItem child = UIUtils.getTreeItem(item, data);
            if (child != null) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    public static int blend(int v1, int v2, int ratio) {
        return (ratio * v1 + (100 - ratio) * v2) / 100;
    }

    public static RGB blend(RGB c1, RGB c2, int ratio) {
        int r = UIUtils.blend(c1.red, c2.red, ratio);
        int g = UIUtils.blend(c1.green, c2.green, ratio);
        int b = UIUtils.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    public static boolean isParent(@NotNull Control parent, @Nullable Control child) {
        Control c = child;
        while (c != null) {
            if (c == parent) {
                return true;
            }
            c = c.getParent();
        }
        return false;
    }

    public static boolean isInDialog() {
        try {
            Shell activeShell = Display.getCurrent().getActiveShell();
            return activeShell != null && UIUtils.isInDialog((Control)activeShell);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isInDialog(Control control) {
        return control.getShell().getData() instanceof Dialog;
    }

    public static boolean isInWizard(Control control) {
        return control.getShell().getData() instanceof IWizardContainer;
    }

    public static Link createLink(Composite parent, String text, SelectionListener listener) {
        Link link = new Link(parent, 0);
        link.setText(text);
        link.addSelectionListener(listener);
        return link;
    }

    public static Point drawMessageOverControl(Control control, PaintEvent e, String message, int offset) {
        return UIUtils.drawMessageOverControl(control, e.gc, message, offset);
    }

    public static Point drawMessageOverControl(Control control, GC gc, String message, int offset) {
        Rectangle bounds = UIUtils.getControlPaintBounds(control);
        Point textSize = gc.textExtent(message);
        if (textSize.x > bounds.width) {
            double charsPerLine = (double)bounds.width / gc.getFontMetrics().getAverageCharacterWidth();
            message = StringUtils.wrap((String)message, (int)((int)charsPerLine));
            textSize = gc.textExtent(message);
        }
        int height = textSize.y;
        String[] stringArray = message.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            line = line.trim();
            Point ext = gc.textExtent(line);
            gc.drawText(line, (bounds.width - ext.x) / 2, (bounds.height - height) / 2 + offset);
            offset += ext.y;
            ++n2;
        }
        return textSize;
    }

    @NotNull
    private static Rectangle getControlPaintBounds(@NotNull Control control) {
        Rectangle bounds;
        if (control instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)control;
            bounds = scrollable.getClientArea();
        } else {
            bounds = control.getBounds();
        }
        if (control instanceof Tree) {
            Tree tree = (Tree)control;
            int height = tree.getHeaderHeight();
            bounds.y += height;
            bounds.height -= height;
        } else if (control instanceof Table) {
            Table table = (Table)control;
            int height = table.getHeaderHeight();
            bounds.y += height;
            bounds.height -= height;
        }
        return bounds;
    }

    public static SharedTextColors getSharedTextColors() {
        return SHARED_TEXT_COLORS;
    }

    public static SharedFonts getSharedFonts() {
        return SHARED_FONTS;
    }

    public static void run(IRunnableContext runnableContext, boolean fork, boolean cancelable, DBRRunnableWithProgress runnableWithProgress) throws InvocationTargetException, InterruptedException {
        runnableContext.run(fork, cancelable, monitor -> runnableWithProgress.run(RuntimeUtils.makeMonitor((IProgressMonitor)monitor)));
    }

    public static AbstractUIJob runUIJob(String jobName, DBRRunnableWithProgress runnableWithProgress) {
        return UIUtils.runUIJob(jobName, 0, runnableWithProgress);
    }

    public static AbstractUIJob runUIJob(String jobName, int timeout, final DBRRunnableWithProgress runnableWithProgress) {
        AbstractUIJob job = new AbstractUIJob(jobName){

            @Override
            public IStatus runInUIThread(DBRProgressMonitor monitor) {
                try {
                    runnableWithProgress.run(monitor);
                }
                catch (InvocationTargetException e) {
                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule(timeout);
        return job;
    }

    @Nullable
    public static IWorkbenchWindow findActiveWorkbenchWindow() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null) {
            return window;
        }
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        if (windows.length > 0) {
            return windows[0];
        }
        return null;
    }

    @NotNull
    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbenchWindow workbenchWindow = UIUtils.findActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            throw new IllegalStateException("No workbench window");
        }
        return workbenchWindow;
    }

    @Nullable
    public static Shell getActiveWorkbenchShell() {
        Shell shell;
        IWorkbench workbench;
        IWorkbenchWindow window;
        if (PlatformUI.isWorkbenchRunning() && (window = (workbench = PlatformUI.getWorkbench()).getActiveWorkbenchWindow()) != null && (shell = window.getShell()) != null && shell.isVisible()) {
            return shell;
        }
        return UIUtils.getActiveShell();
    }

    public static DBRRunnableContext getDefaultRunnableContext() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && workbench.getActiveWorkbenchWindow() != null) {
            return new RunnableContextDelegate((IRunnableContext)workbench.getActiveWorkbenchWindow());
        }
        return (fork, cancelable, runnable) -> runnable.run((DBRProgressMonitor)new VoidProgressMonitor());
    }

    public static DBRRunnableContext getDialogRunnableContext() {
        return (fork, cancelable, runnable) -> UIUtils.runInProgressDialog(runnable);
    }

    public static void runInProgressService(DBRRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        UIUtils.getDefaultRunnableContext().run(true, true, runnable);
    }

    public static <T> T runWithMonitor(DBRRunnableWithReturn<T> runnable) throws DBException {
        Object[] result = new Object[1];
        try {
            UIUtils.getDefaultRunnableContext().run(true, true, monitor -> {
                try {
                    objectArray[0] = runnable.runTask(monitor);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException();
            if (throwable instanceof DBException) {
                DBException dbe = (DBException)throwable;
                throw dbe;
            }
            throw new DBException("Internal error", e.getTargetException());
        }
        catch (Throwable e) {
            log.error((Object)e);
        }
        return (T)result[0];
    }

    public static <T> T runWithDialog(DBRRunnableWithReturn<T> runnable) throws DBException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        if (workbenchWindow != null) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(workbench.getActiveWorkbenchWindow().getShell());
            Object[] result = new Object[1];
            try {
                dialog.run(true, true, monitor -> {
                    try {
                        objectArray[0] = runnable.runTask(RuntimeUtils.makeMonitor((IProgressMonitor)monitor));
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (InvocationTargetException e) {
                Throwable throwable = e.getTargetException();
                if (throwable instanceof DBException) {
                    DBException dbe = (DBException)throwable;
                    throw dbe;
                }
                throw new DBException("Internal error", e.getTargetException());
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
            return (T)result[0];
        }
        return UIUtils.runWithMonitor(runnable);
    }

    public static void runInProgressDialog(DBRRunnableWithProgress runnable) throws InvocationTargetException {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
            Object runnableContext = workbenchWindow != null ? new ProgressMonitorDialog(workbench.getActiveWorkbenchWindow().getShell()) : workbench.getProgressService();
            runnableContext.run(true, true, monitor -> runnable.run(RuntimeUtils.makeMonitor((IProgressMonitor)monitor)));
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void runInUI(IRunnableContext context, DBRRunnableWithProgress runnable) {
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI(context, monitor -> runnable.run(RuntimeUtils.makeMonitor((IProgressMonitor)monitor)), (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError(null, null, e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void runInUI(DBRRunnableWithProgress runnable) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchWindow context = window != null ? window : DummyRunnableContext.INSTANCE;
        UIUtils.runInUI((IRunnableContext)context, runnable);
    }

    public static Display getDisplay() {
        try {
            return PlatformUI.getWorkbench().getDisplay();
        }
        catch (Exception exception) {
            return Display.getDefault();
        }
    }

    public static void timerExec(int milliseconds, @NotNull Runnable runnable) {
        try {
            Display display = UIUtils.getDisplay();
            if (!display.isDisposed()) {
                display.timerExec(milliseconds, runnable);
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }

    public static void asyncExec(Runnable runnable) {
        try {
            Display display = UIUtils.getDisplay();
            if (!display.isDisposed()) {
                display.asyncExec(runnable);
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }

    public static void syncExec(Runnable runnable) {
        try {
            Display display = UIUtils.getDisplay();
            if (!display.isDisposed()) {
                display.syncExec(runnable);
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
    }

    public static <T> T syncExec(RunnableWithResult<T> runnable) {
        try {
            UIUtils.getDisplay().syncExec(runnable);
            return (T)runnable.getResult();
        }
        catch (Exception e) {
            log.debug((Object)e);
            return null;
        }
    }

    @Nullable
    public static Color getSharedColor(@Nullable String rgbString) {
        if (CommonUtils.isEmpty((String)rgbString)) {
            return null;
        }
        return SHARED_TEXT_COLORS.getColor(rgbString);
    }

    @Nullable
    public static Color getSharedColor(@Nullable RGB rgb) {
        if (rgb == null) {
            return null;
        }
        return SHARED_TEXT_COLORS.getColor(rgb);
    }

    public static Color getConnectionColor(DBPConnectionConfiguration connectionInfo) {
        String rgbString = connectionInfo.getConnectionColor();
        if (CommonUtils.isEmpty((String)rgbString)) {
            rgbString = connectionInfo.getConnectionType().getColor();
        }
        if (CommonUtils.isEmpty((String)rgbString)) {
            return null;
        }
        return UIUtils.getConnectionColorByRGB(rgbString);
    }

    public static Color getConnectionTypeColor(DBPConnectionType connectionType) {
        String rgbString = connectionType.getColor();
        if (CommonUtils.isEmpty((String)rgbString)) {
            return null;
        }
        return UIUtils.getConnectionColorByRGB(rgbString);
    }

    public static Color getConnectionColorByRGB(String rgbStringOrId) {
        if (rgbStringOrId.isEmpty()) {
            return null;
        }
        if (Character.isAlphabetic(rgbStringOrId.charAt(0))) {
            RGB rgb = UIUtils.getActiveWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().getRGB(rgbStringOrId);
            return SHARED_TEXT_COLORS.getColor(rgb);
        }
        Color connectionColor = SHARED_TEXT_COLORS.getColor(rgbStringOrId);
        if (connectionColor.getBlue() == 255 && connectionColor.getRed() == 255 && connectionColor.getGreen() == 255) {
            return null;
        }
        return connectionColor;
    }

    public static Shell createCenteredShell(Shell parent) {
        Rectangle bounds = parent.getBounds();
        int x = bounds.x + bounds.width / 2 - 120;
        int y = bounds.y + bounds.height / 2 - 170;
        Shell shell = new Shell(parent);
        shell.setLocation(x, y);
        return shell;
    }

    public static void centerShell(Shell parent, Shell shell) {
        if (parent == null || shell == null) {
            return;
        }
        Point size = shell.computeSize(-1, -1);
        Rectangle parentBounds = parent.getBounds();
        int x = parentBounds.x + (parentBounds.width - size.x) / 2;
        int y = parentBounds.y + (parentBounds.height - size.y) / 2;
        shell.setLocation(x, y);
    }

    public static Image getShardImage(String id) {
        return PlatformUI.getWorkbench().getSharedImages().getImage(id);
    }

    public static ImageDescriptor getShardImageDescriptor(String id) {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(id);
    }

    public static void addVariablesToControl(@NotNull Control controlForTip, @NotNull String[] variables, String toolTipPattern) {
        StringContentProposalProvider proposalProvider = new StringContentProposalProvider((String[])Arrays.stream(variables).map(GeneralUtils::variablePattern).toArray(String[]::new));
        UIUtils.setContentProposalToolTip(controlForTip, toolTipPattern, variables);
        ContentAssistUtils.installContentProposal(controlForTip, (IControlContentAdapter)new SmartTextContentAdapter(), proposalProvider);
    }

    public static void setContentProposalToolTip(Control control, String toolTip, String ... variables) {
        control.setToolTipText(UIUtils.getSupportedVariablesTip(toolTip, variables));
    }

    @NotNull
    public static String getSupportedVariablesTip(String toolTip, String ... variables) {
        StringBuilder varsTip = new StringBuilder();
        varsTip.append(toolTip).append(". ").append(UIMessages.pref_page_connections_tool_tip_text_allowed_variables).append(":\n");
        int i = 0;
        while (i < variables.length) {
            String var = variables[i];
            if (i > 0) {
                varsTip.append(",\n");
            }
            varsTip.append("  ").append(GeneralUtils.variablePattern((String)var));
            ++i;
        }
        varsTip.append(".");
        return varsTip.toString();
    }

    public static void resizeShell(@NotNull Shell shell) {
        Point compSize = shell.computeSize(-1, -1, true);
        UIUtils.resizeShell(shell, compSize);
    }

    public static void resizeShell(@NotNull Shell shell, Point compSize) {
        Rectangle displayArea = shell.getDisplay().getClientArea();
        Point shellLocation = shell.getLocation();
        Point shellSize = shell.getSize();
        boolean needsLayout = false;
        if (shellSize.x < compSize.x || shellSize.y < compSize.y) {
            shellSize.x = Math.max(shellSize.x, compSize.x);
            shellSize.y = Math.max(shellSize.y, compSize.y);
            shell.setSize(shellSize);
        }
        if (shellLocation.x + shellSize.x > displayArea.width || shellLocation.y + shellSize.y > displayArea.height) {
            shellLocation.x = CommonUtils.clamp((int)(displayArea.width - shellSize.x), (int)0, (int)shellLocation.x);
            shellLocation.y = CommonUtils.clamp((int)(displayArea.height - shellSize.y), (int)0, (int)shellLocation.y);
            shell.setLocation(shellLocation.x, shellLocation.y);
            needsLayout = true;
        }
        if (needsLayout) {
            shell.layout(true);
        }
    }

    public static void waitJobCompletion(AbstractJob job) {
        UIUtils.waitJobCompletion(job, null);
    }

    public static void waitJobCompletion(@NotNull AbstractJob job, @Nullable IProgressMonitor monitor) {
        Display display = Display.getCurrent();
        while (!job.isFinished() && !DBWorkbench.getPlatform().isShuttingDown()) {
            if (monitor != null && monitor.isCanceled()) {
                job.cancel();
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.update();
    }

    public static void fixReadonlyTextBackground(Text textField) {
    }

    public static ColorRegistry getColorRegistry() {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
    }

    public static Control createEmptyLabel(Composite parent, int horizontalSpan, int verticalSpan) {
        Label emptyLabel = new Label(parent, 0);
        GridData gd = new GridData(128);
        gd.horizontalSpan = horizontalSpan;
        gd.verticalSpan = verticalSpan;
        gd.widthHint = 0;
        emptyLabel.setLayoutData((Object)gd);
        return emptyLabel;
    }

    public static void disposeChildControls(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
    }

    public static double greyLevel(RGB rgb) {
        if (rgb.red == rgb.green && rgb.green == rgb.blue) {
            return rgb.red;
        }
        return 0.299 * (double)rgb.red + 0.587 * (double)rgb.green + 0.114 * (double)rgb.blue + 0.5;
    }

    public static boolean isDark(RGB rgb) {
        return UIUtils.greyLevel(rgb) < 128.0;
    }

    public static void openWebBrowser(String url) {
        if (!(((String)(url = ((String)url).trim())).startsWith("http://") || ((String)url).startsWith("https://") || ((String)url).startsWith("ftp://"))) {
            url = "http://" + (String)url;
        }
        ShellUtils.launchProgram((String)url);
    }

    public static <T extends Control> void addEmptyTextHint(T control, DBRValueProvider<String, T> tipProvider) {
        control.addPaintListener(e -> {
            String tip = (String)tipProvider.getValue((Object)control);
            if (tip != null && UIUtils.isEmptyTextControl(control) && !control.isFocusControl()) {
                GC gc = e.gc;
                Point textSize = gc.textExtent(tip);
                Point controlSize = control.getSize();
                int baseline = (controlSize.y - control.getBorderWidth() * 2 - textSize.y) / 2;
                gc.setForeground(UIUtils.getDisplay().getSystemColor(18));
                gc.setFont(control.getFont());
                gc.drawText(tip, baseline, baseline, true);
                gc.setFont(null);
            }
        });
    }

    private static boolean isEmptyTextControl(Control control) {
        return control instanceof Text && ((Text)control).getCharCount() == 0 || control instanceof StyledText && ((StyledText)control).getCharCount() == 0 || control instanceof Combo && ((Combo)control).getText().isEmpty();
    }

    public static void expandAll(AbstractTreeViewer treeViewer) {
        Control control = treeViewer.getControl();
        control.setRedraw(false);
        try {
            treeViewer.expandAll();
        }
        finally {
            control.setRedraw(true);
        }
    }

    public static Font getMonospaceFont() {
        return BaseThemeSettings.instance.monospaceFont;
    }

    public static <T extends Control> T getParentOfType(@NotNull Control control, @NotNull Class<T> parentType) {
        while (control != null) {
            if (parentType.isInstance(control)) {
                return (T)((Control)parentType.cast(control));
            }
            control = control.getParent();
        }
        return null;
    }

    public static <T extends Control> T getChildOfType(@NotNull Composite parent, @NotNull Class<T> childType) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (childType.isInstance(child)) {
                return (T)((Control)childType.cast(child));
            }
            ++n2;
        }
        return null;
    }

    public static Object normalizePropertyValue(Object text) {
        if (text instanceof String) {
            return CommonUtils.toString((Object)text).trim();
        }
        return text;
    }

    public static void setControlVisible(Control control, boolean visible) {
        control.setVisible(visible);
        Object object = control.getLayoutData();
        if (object instanceof GridData) {
            GridData gd = (GridData)object;
            gd.exclude = !visible;
        }
    }

    public static void drawTextWithBackground(@NotNull GC gc, @NotNull String text, int x, int y) {
        Point size = gc.textExtent(text);
        int centerX = x - size.x / 2;
        int centerY = y - size.y;
        gc.setForeground(UIStyles.getDefaultTextForeground());
        gc.setBackground(UIStyles.getDefaultTextBackground());
        gc.fillRectangle(centerX - 2, centerY - 2, size.x + 4, size.y + 4);
        gc.drawText(text, centerX, centerY, true);
        gc.drawRoundRectangle(centerX - 3, centerY - 3, size.x + 5, size.y + 5, 5, 5);
    }

    public static void installMacOSFocusLostSubstitution(@NotNull Widget widget, final @NotNull Runnable onFocusLost) {
        if (!RuntimeUtils.isMacOS()) {
            return;
        }
        if (widget instanceof Combo || widget instanceof CCombo) {
            widget.addListener(13, (Listener)new TypedListener((EventListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    onFocusLost.run();
                }
            }));
        } else {
            widget.addDisposeListener(e -> onFocusLost.run());
        }
    }

    @Nullable
    public static Text recreateTextControl(@Nullable Text original, int style) {
        if (original == null || original.getStyle() == style) {
            return original;
        }
        Composite parent = original.getParent();
        Control[] tabList = parent.getTabList();
        Text text = new Text(parent, style);
        text.setText(original.getText());
        text.setLayoutData(original.getLayoutData());
        text.moveAbove((Control)original);
        UIUtils.copyListeners((Widget)original, (Widget)text, 14);
        UIUtils.copyListeners((Widget)original, (Widget)text, 24);
        UIUtils.copyListeners((Widget)original, (Widget)text, 25);
        original.dispose();
        int i = 0;
        while (i < tabList.length) {
            if (tabList[i] == original) {
                tabList[i] = text;
            }
            ++i;
        }
        parent.setTabList(tabList);
        parent.layout(true, true);
        return text;
    }

    private static void copyListeners(@NotNull Widget source, @NotNull Widget target, int eventType) {
        Listener[] listenerArray = source.getListeners(eventType);
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            target.addListener(eventType, listener);
            ++n2;
        }
    }

    public static void installAndUpdateMainFont(@NotNull Control control) {
        BaseThemeSettings.instance.addPropertyListener("org.jkiss.dbeaver.dbeaver.ui.fonts.main", s -> UIUtils.applyMainFont(control), control);
    }

    public static void applyMainFont(@Nullable Control control) {
        UIUtils.applyFont(control, BaseThemeSettings.instance.baseFont);
    }

    public static void applyMonospaceFont(@Nullable Control control) {
        UIUtils.applyFont(control, BaseThemeSettings.instance.monospaceFont);
    }

    public static void applyFont(@Nullable Control control, @NotNull Font font) {
        if (control == null || control.isDisposed() || UIUtils.mainFontIsDefault()) {
            return;
        }
        if (control instanceof Composite) {
            Composite comp = (Composite)control;
            comp.layout();
        }
        control.setFont(font);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                UIUtils.applyFont(element, font);
                ++n2;
            }
        }
    }

    private static boolean mainFontIsDefault() {
        Object[] mainFontData = JFaceResources.getFontRegistry().getFontData("org.jkiss.dbeaver.dbeaver.ui.fonts.main");
        Object[] defaultFontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jface.defaultfont");
        return Arrays.equals(mainFontData, defaultFontData);
    }

    @Nullable
    public static ToolItem findToolItemByCommandId(@NotNull ToolBarManager toolbarManager, @NotNull String commandId) {
        ToolBar toolBar = toolbarManager.getControl();
        if (toolBar == null || toolBar.isDisposed()) {
            return null;
        }
        ToolItem[] toolItemArray = toolBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterizedCommand cmd;
            HandledContributionItem hci;
            MHandledItem model;
            CommandContributionItem cci;
            ParameterizedCommand cmd2;
            ToolItem item = toolItemArray[n2];
            Object data = item.getData();
            if (data instanceof CommandContributionItem ? (cmd2 = (cci = (CommandContributionItem)data).getCommand()) != null && commandId.equals(cmd2.getId()) : data instanceof HandledContributionItem && (model = (hci = (HandledContributionItem)data).getModel()) != null && (cmd = model.getWbCommand()) != null && commandId.equals(cmd.getId())) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public static void populateToolItemCommandIds(ToolBarManager toolbarManager) {
        ToolBar toolBar = toolbarManager.getControl();
        if (toolBar == null || toolBar.isDisposed()) {
            return;
        }
        ToolItem[] toolItemArray = toolBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterizedCommand cmd;
            HandledContributionItem hci;
            MHandledItem model;
            ToolItem item = toolItemArray[n2];
            Object data = item.getData();
            if (data instanceof CommandContributionItem) {
                CommandContributionItem cci = (CommandContributionItem)data;
                ParameterizedCommand cmd2 = cci.getCommand();
                if (cmd2 != null) {
                    item.setData("commandId", (Object)cmd2.getId());
                }
            } else if (data instanceof HandledContributionItem && (model = (hci = (HandledContributionItem)data).getModel()) != null && (cmd = model.getWbCommand()) != null) {
                item.setData("commandId", (Object)cmd.getId());
            }
            ++n2;
        }
    }

    public static void enableDoubleBuffering(@NotNull Control control) {
        if ((control.getStyle() & 0x20000000) != 0) {
            return;
        }
        try {
            Field styleField = Widget.class.getDeclaredField("style");
            if (!styleField.canAccess(control)) {
                styleField.setAccessible(true);
            }
            styleField.set(control, styleField.getInt(control) | 0x20000000);
        }
        catch (Exception e) {
            log.error((Object)"Unable to enable double buffering", e.getCause());
        }
    }

    public static String getCatalogSchemaTerms(@Nullable DBPDataSourceContainer dataSourceContainer, boolean checkChangePossibility) {
        DBPDataSource dataSource;
        DBPDataSource dBPDataSource = dataSource = dataSourceContainer == null ? null : dataSourceContainer.getDataSource();
        if (dataSource != null) {
            String schemaTerm;
            DBCExecutionContextDefaults contextDefaults;
            DBCExecutionContext defaultContext;
            DBPDataSourceInfo dataSourceInfo = dataSource.getInfo();
            boolean showCatalog = true;
            boolean showSchema = true;
            if (checkChangePossibility && (defaultContext = DBUtils.getDefaultContext((DBSObject)dataSource, (boolean)false)) != null && (contextDefaults = defaultContext.getContextDefaults()) != null) {
                showCatalog = contextDefaults.getDefaultCatalog() != null || contextDefaults.supportsCatalogChange();
                showSchema = contextDefaults.getDefaultSchema() != null || contextDefaults.supportsSchemaChange();
            }
            String catalogTerm = showCatalog ? dataSourceInfo.getCatalogTerm() : null;
            String string = schemaTerm = showSchema ? dataSourceInfo.getSchemaTerm() : null;
            if (CommonUtils.isEmpty((String)catalogTerm)) {
                if (!CommonUtils.isEmpty((String)schemaTerm)) {
                    return schemaTerm;
                }
            } else {
                if (CommonUtils.isEmpty((String)schemaTerm)) {
                    return catalogTerm;
                }
                return catalogTerm + "/" + schemaTerm;
            }
        }
        return UIMessages.label_catalog_schema;
    }

    @NotNull
    public static DBPCloseableObject disableRedraw(@NotNull Control control) {
        control.setRedraw(false);
        return () -> control.setRedraw(true);
    }

    public static boolean isWindowVisible(@NotNull Display display, @NotNull Class<? extends Window> clazz) {
        return Arrays.stream(display.getShells()).map(Widget::getData).anyMatch(data -> data != null && clazz.isAssignableFrom(data.getClass()));
    }

    @NotNull
    public static ExpandableComposite createExpandableCompositeWithSeparator(@NotNull Composite parent, int style, int expansionStyle) {
        return new ExpandableComposite(parent, style, expansionStyle){
            {
                this.addPaintListener(e -> {
                    Rectangle bounds = this.getBounds();
                    Rectangle label = this.textLabel.getBounds();
                    e.gc.setForeground(Display.getDefault().getSystemColor(18));
                    e.gc.drawLine(label.x + label.width + 6, label.y + label.height / 2, bounds.width, label.y + label.height / 2);
                });
            }
        };
    }

    public static void setWidgetWidthHint(@NotNull Control widget, int widthHint) {
        if (widget.isDisposed()) {
            return;
        }
        Composite parent = widget.getParent();
        if (parent == null || !(parent.getLayout() instanceof GridLayout)) {
            return;
        }
        Object layoutData = widget.getLayoutData();
        if (layoutData instanceof GridData) {
            GridData gridData;
            gd = gridData = (GridData)layoutData;
        } else {
            gd = new GridData(768);
            widget.setLayoutData((Object)gd);
        }
        gd.widthHint = widthHint;
    }

    public static void setDefaultTextControlWidthHint(@NotNull Control widget) {
        UIUtils.setWidgetWidthHint(widget, 150);
    }

    public static void mimicControlBackground(@NotNull Composite control, @NotNull Control otherControl) {
        control.addPaintListener(e -> {
            e.gc.setBackground(otherControl.getBackground());
            e.gc.fillRectangle(control.getClientArea());
        });
    }

    private static /* synthetic */ void lambda$3(Shell shell, String string, String string2, DBPImage dBPImage) {
        Reply reply = MessageBoxBuilder.builder(shell != null ? shell : UIUtils.getActiveWorkbenchShell()).setTitle(string).setMessage(string2).setReplies(Reply.OK).setDefaultReply(Reply.OK).setPrimaryImage(dBPImage).showMessageBox();
    }
}

