/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.athena.model;

import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.athena.model.AthenaMetaModel;
import org.jkiss.dbeaver.ext.athena.model.AthenaSQLDialect;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.utils.CommonUtils;

public class AthenaDataSource
extends GenericDataSource {
    public AthenaDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, AthenaMetaModel metaModel) throws DBException {
        super(monitor, container, (GenericMetaModel)metaModel, (SQLDialect)new AthenaSQLDialect());
    }

    protected Map<String, String> getInternalConnectionProperties(@NotNull DBRProgressMonitor monitor, @NotNull DBPDriver driver, @NotNull JDBCExecutionContext context, @NotNull String purpose, @NotNull DBPConnectionConfiguration connectionInfo) throws DBCException {
        HashMap<String, String> props = new HashMap<String, String>();
        if (CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
            connectionInfo.setDatabaseName(connectionInfo.getProviderProperty("S3OutputLocation"));
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
            props.put("S3OutputLocation", connectionInfo.getDatabaseName());
        }
        props.put("AwsCredentialsProviderClass", "com.amazonaws.auth.DefaultAWSCredentialsProviderChain");
        boolean useCatalogs = CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("show-aws-catalogs"));
        if (useCatalogs) {
            props.put("MetadataRetrievalMethod", "ProxyAPI");
        }
        return props;
    }

    public boolean isOmitCatalog() {
        return !CommonUtils.toBoolean((Object)this.getContainer().getConnectionConfiguration().getProviderProperty("show-aws-catalogs"));
    }

    protected boolean isPopulateClientAppName() {
        return false;
    }
}

