/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.tasks;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueValidator;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteSettings;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class OracleToolTableGatherStatisticsSettings
extends SQLToolExecuteSettings<DBSObject> {
    private int samplePercent;

    @Property(viewable=true, editable=true, updatable=true, valueValidator=OracleStatisticPercentLimiter.class)
    public int getSamplePercent() {
        return this.samplePercent;
    }

    public void setSamplePercent(int samplePercent) {
        this.samplePercent = samplePercent;
    }

    public void loadConfiguration(@NotNull DBRRunnableContext runnableContext, @NotNull Map<String, Object> config, @NotNull DBPProject project) {
        super.loadConfiguration(runnableContext, config, project);
        this.samplePercent = JSONUtils.getInteger(config, (String)"sample_percent");
    }

    public void saveConfiguration(Map<String, Object> config) {
        super.saveConfiguration(config);
        config.put("sample_percent", this.samplePercent);
    }

    public static class OracleStatisticPercentLimiter
    implements IPropertyValueValidator<OracleToolTableGatherStatisticsSettings, Object> {
        public boolean isValidValue(OracleToolTableGatherStatisticsSettings object, Object value) throws IllegalArgumentException {
            int valueInt = CommonUtils.toInt((Object)value);
            return valueInt >= 0 && valueInt <= 100;
        }
    }
}

