/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpResponse;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.engine.TooManyRequestsException;
import org.jkiss.dbeaver.model.ai.utils.AIHttpTransportException;

public final class AIHttpUtils {
    private AIHttpUtils() {
    }

    public static URI resolve(String base, String ... paths) throws DBException {
        try {
            URI uri = new URI(base);
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                uri = uri.resolve(path);
                ++n2;
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new DBException("Incorrect URI", (Throwable)e);
        }
    }

    @NotNull
    public static DBException mapHttpError(@NotNull HttpResponse<String> response) {
        return switch (response.statusCode()) {
            case 400 -> new DBException("Invalid request: " + response.body());
            case 401 -> new DBException("Authentication error: " + response.body());
            case 403 -> new DBException("Permission error: " + response.body());
            case 404 -> new DBException("Not found: " + response.body());
            case 413 -> new DBException("Request too large: " + response.body());
            case 429 -> new TooManyRequestsException("Too many requests: " + response.body());
            case 500 -> new DBException("Internal server error: " + response.body());
            case 529 -> new DBException("Service overloaded: " + response.body());
            default -> new AIHttpTransportException(response.statusCode(), response.body());
        };
    }
}

