/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.cli.ApplicationCommandLine;
import org.jkiss.dbeaver.model.cli.ApplicationInstanceController;
import org.jkiss.dbeaver.model.cli.CLIProcessResult;
import org.jkiss.dbeaver.model.cli.registry.CommandLineParameterDescriptor;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverApplication;
import org.jkiss.dbeaver.ui.app.standalone.rpc.DBeaverInstanceServer;
import org.jkiss.dbeaver.ui.app.standalone.rpc.IInstanceController;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DBeaverCommandLine
extends ApplicationCommandLine<IInstanceController> {
    private static final Log log = Log.getLog(DBeaverCommandLine.class);
    public static final String PARAM_FILE = "f";
    public static final String PARAM_CONFIG = "vars";
    public static final String PARAM_STOP = "stop";
    public static final String PARAM_CONNECT = "con";
    public static final String PARAM_CLOSE_TABS = "closeTabs";
    public static final String PARAM_DISCONNECT_ALL = "disconnectAll";
    public static final String PARAM_REUSE_WORKSPACE = "reuseWorkspace";
    public static final String PARAM_NEW_INSTANCE = "newInstance";
    public static final String PARAM_BRING_TO_FRONT = "bringToFront";
    public static final String PARAM_QUIET = "q";
    private static DBeaverCommandLine INSTANCE = null;

    static {
        ALL_OPTIONS.addOption(PARAM_CONFIG, "variablesFile", true, "Uses a specified configuration file for variable resolving").addOption(PARAM_FILE, "file", true, "Open a file").addOption(PARAM_STOP, "quit", false, "Stop DBeaver running instance").addOption(PARAM_CONNECT, "connect", true, "Connects to a specified database").addOption("p", "project", true, "Specify used project").addOption(PARAM_DISCONNECT_ALL, PARAM_DISCONNECT_ALL, false, "Disconnect from all databases").addOption(PARAM_CLOSE_TABS, PARAM_CLOSE_TABS, false, "Close all open editors").addOption(PARAM_REUSE_WORKSPACE, PARAM_REUSE_WORKSPACE, false, "Force workspace reuse (do not show warnings)").addOption(PARAM_NEW_INSTANCE, PARAM_NEW_INSTANCE, false, "Force creating new application instance (do not try to activate already running)").addOption(PARAM_BRING_TO_FRONT, PARAM_BRING_TO_FRONT, false, "Bring DBeaver window on top of other applications").addOption(PARAM_QUIET, PARAM_QUIET, false, "Run quietly (do not print logs)").addOption("product", true, "Product id").addOption("nl", true, "National locale").addOption("data", true, "Data directory").addOption("nosplash", false, "No splash screen").addOption("showlocation", false, "Show location").addOption("registryMultiLanguage", false, "Multi-language mode");
    }

    private DBeaverCommandLine() {
    }

    public static synchronized DBeaverCommandLine getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DBeaverCommandLine();
        }
        return INSTANCE;
    }

    public CLIProcessResult executeCommandLineCommands(@Nullable CommandLine commandLine, @Nullable IInstanceController controller, boolean uiActivated) throws Exception {
        Object[] connectParams;
        String file;
        CLIProcessResult result = super.executeCommandLineCommands(commandLine, (ApplicationInstanceController)controller, uiActivated, true);
        if (result.getPostAction() != CLIProcessResult.PostAction.UNKNOWN_COMMAND) {
            return result;
        }
        Objects.requireNonNull(commandLine);
        if (commandLine.hasOption(PARAM_NEW_INSTANCE)) {
            return new CLIProcessResult(CLIProcessResult.PostAction.START_INSTANCE);
        }
        if (commandLine.hasOption(PARAM_REUSE_WORKSPACE) && DBeaverApplication.instance != null) {
            DBeaverApplication.instance.setReuseWorkspace(true);
        }
        if (!CommonUtils.isEmpty((String)(file = commandLine.getOptionValue(PARAM_CONFIG)))) {
            try {
                Throwable throwable = null;
                Object var7_10 = null;
                try (FileInputStream stream = new FileInputStream(file);){
                    Properties properties = new Properties();
                    properties.load(stream);
                    SystemVariablesResolver.setConfiguration((Properties)properties);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error parsing command line ", (Throwable)e);
                return new CLIProcessResult(CLIProcessResult.PostAction.START_INSTANCE);
            }
        }
        if (controller == null) {
            log.debug((Object)"Can't process commands because no running instance is present");
            return new CLIProcessResult(CLIProcessResult.PostAction.START_INSTANCE);
        }
        boolean exitAfterExecute = false;
        if (!uiActivated && commandLine.hasOption(PARAM_STOP)) {
            controller.quit();
            return new CLIProcessResult(CLIProcessResult.PostAction.SHUTDOWN);
        }
        Object[] files = commandLine.getOptionValues(PARAM_FILE);
        Object[] fileArgs = commandLine.getArgs();
        if (!ArrayUtils.isEmpty((Object[])files) || !ArrayUtils.isEmpty((Object[])fileArgs)) {
            ArrayList fileNames = new ArrayList();
            if (!ArrayUtils.isEmpty((Object[])files)) {
                Collections.addAll(fileNames, files);
            }
            if (!ArrayUtils.isEmpty((Object[])fileArgs)) {
                Collections.addAll(fileNames, fileArgs);
            }
            controller.openExternalFiles(fileNames.toArray(new String[0]));
            exitAfterExecute = true;
        }
        if (!ArrayUtils.isEmpty((Object[])(connectParams = commandLine.getOptionValues(PARAM_CONNECT)))) {
            Object[] objectArray = connectParams;
            int n = connectParams.length;
            int n2 = 0;
            while (n2 < n) {
                Object cp = objectArray[n2];
                controller.openDatabaseConnection((String)cp);
                ++n2;
            }
            exitAfterExecute = true;
        }
        if (commandLine.hasOption(PARAM_CLOSE_TABS)) {
            controller.closeAllEditors();
            exitAfterExecute = true;
        }
        if (commandLine.hasOption(PARAM_DISCONNECT_ALL)) {
            controller.executeWorkbenchCommand("org.jkiss.dbeaver.core.disconnectAll");
            exitAfterExecute = true;
        }
        if (commandLine.hasOption(PARAM_BRING_TO_FRONT)) {
            controller.bringToFront();
            exitAfterExecute = true;
        }
        CLIProcessResult.PostAction postAction = exitAfterExecute ? CLIProcessResult.PostAction.SHUTDOWN : CLIProcessResult.PostAction.START_INSTANCE;
        return new CLIProcessResult(postAction);
    }

    public CLIProcessResult handleCommandLineAsClient(CommandLine commandLine, String instanceLoc) {
        if (commandLine == null || ArrayUtils.isEmpty((Object[])commandLine.getArgs()) && ArrayUtils.isEmpty((Object[])commandLine.getOptions())) {
            return new CLIProcessResult(CLIProcessResult.PostAction.START_INSTANCE);
        }
        for (CommandLineParameterDescriptor param : customParameters.values()) {
            if (!param.isExclusiveMode() || !commandLine.hasOption(param.getName()) && !commandLine.hasOption(param.getLongName())) continue;
            if (DBeaverApplication.instance == null) break;
            DBeaverApplication.instance.setExclusiveMode(true);
            break;
        }
        try {
            IInstanceController client = DBeaverInstanceServer.createClient(instanceLoc);
            return this.executeCommandLineCommands(commandLine, client, false);
        }
        catch (Throwable e) {
            log.error((Object)"Error while calling remote server", e);
            return new CLIProcessResult(CLIProcessResult.PostAction.START_INSTANCE);
        }
    }
}

