// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package memorydb

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opBatchUpdateCluster = "BatchUpdateCluster"

// BatchUpdateClusterRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateCluster for more information on using the BatchUpdateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchUpdateClusterRequest method.
//	req, resp := client.BatchUpdateClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/BatchUpdateCluster
func (c *MemoryDB) BatchUpdateClusterRequest(input *BatchUpdateClusterInput) (req *request.Request, output *BatchUpdateClusterOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchUpdateClusterInput{}
	}

	output = &BatchUpdateClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdateCluster API operation for Amazon MemoryDB.
//
// Apply the service update to a list of clusters supplied. For more information
// on service updates and applying them, see Applying the service updates (https://docs.aws.amazon.com/MemoryDB/latest/devguide/managing-updates.html#applying-updates).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation BatchUpdateCluster for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUpdateNotFoundFault
//
//   - InvalidParameterValueException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/BatchUpdateCluster
func (c *MemoryDB) BatchUpdateCluster(input *BatchUpdateClusterInput) (*BatchUpdateClusterOutput, error) {
	req, out := c.BatchUpdateClusterRequest(input)
	return out, req.Send()
}

// BatchUpdateClusterWithContext is the same as BatchUpdateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) BatchUpdateClusterWithContext(ctx aws.Context, input *BatchUpdateClusterInput, opts ...request.Option) (*BatchUpdateClusterOutput, error) {
	req, out := c.BatchUpdateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopySnapshot = "CopySnapshot"

// CopySnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CopySnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopySnapshot for more information on using the CopySnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CopySnapshotRequest method.
//	req, resp := client.CopySnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CopySnapshot
func (c *MemoryDB) CopySnapshotRequest(input *CopySnapshotInput) (req *request.Request, output *CopySnapshotOutput) {
	op := &request.Operation{
		Name:       opCopySnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopySnapshotInput{}
	}

	output = &CopySnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopySnapshot API operation for Amazon MemoryDB.
//
// Makes a copy of an existing snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation CopySnapshot for usage and error information.
//
// Returned Error Types:
//
//   - SnapshotAlreadyExistsFault
//
//   - SnapshotNotFoundFault
//
//   - SnapshotQuotaExceededFault
//
//   - InvalidSnapshotStateFault
//
//   - ServiceLinkedRoleNotFoundFault
//
//   - InvalidParameterValueException
//
//   - InvalidParameterCombinationException
//
//   - TagQuotaPerResourceExceeded
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CopySnapshot
func (c *MemoryDB) CopySnapshot(input *CopySnapshotInput) (*CopySnapshotOutput, error) {
	req, out := c.CopySnapshotRequest(input)
	return out, req.Send()
}

// CopySnapshotWithContext is the same as CopySnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CopySnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) CopySnapshotWithContext(ctx aws.Context, input *CopySnapshotInput, opts ...request.Option) (*CopySnapshotOutput, error) {
	req, out := c.CopySnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateACL = "CreateACL"

// CreateACLRequest generates a "aws/request.Request" representing the
// client's request for the CreateACL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateACL for more information on using the CreateACL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateACLRequest method.
//	req, resp := client.CreateACLRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateACL
func (c *MemoryDB) CreateACLRequest(input *CreateACLInput) (req *request.Request, output *CreateACLOutput) {
	op := &request.Operation{
		Name:       opCreateACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateACLInput{}
	}

	output = &CreateACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateACL API operation for Amazon MemoryDB.
//
// Creates an Access Control List. For more information, see Authenticating
// users with Access Contol Lists (ACLs) (https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation CreateACL for usage and error information.
//
// Returned Error Types:
//
//   - UserNotFoundFault
//
//   - DuplicateUserNameFault
//
//   - ACLAlreadyExistsFault
//
//   - DefaultUserRequired
//
//   - ACLQuotaExceededFault
//
//   - InvalidParameterValueException
//
//   - TagQuotaPerResourceExceeded
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateACL
func (c *MemoryDB) CreateACL(input *CreateACLInput) (*CreateACLOutput, error) {
	req, out := c.CreateACLRequest(input)
	return out, req.Send()
}

// CreateACLWithContext is the same as CreateACL with the addition of
// the ability to pass a context and additional request options.
//
// See CreateACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) CreateACLWithContext(ctx aws.Context, input *CreateACLInput, opts ...request.Option) (*CreateACLOutput, error) {
	req, out := c.CreateACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCluster = "CreateCluster"

// CreateClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCluster for more information on using the CreateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateClusterRequest method.
//	req, resp := client.CreateClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateCluster
func (c *MemoryDB) CreateClusterRequest(input *CreateClusterInput) (req *request.Request, output *CreateClusterOutput) {
	op := &request.Operation{
		Name:       opCreateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterInput{}
	}

	output = &CreateClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCluster API operation for Amazon MemoryDB.
//
// Creates a cluster. All nodes in the cluster run the same protocol-compliant
// engine software.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation CreateCluster for usage and error information.
//
// Returned Error Types:
//
//   - ClusterAlreadyExistsFault
//
//   - SubnetGroupNotFoundFault
//
//   - ClusterQuotaForCustomerExceededFault
//
//   - NodeQuotaForClusterExceededFault
//
//   - NodeQuotaForCustomerExceededFault
//
//   - ParameterGroupNotFoundFault
//
//   - InsufficientClusterCapacityFault
//
//   - InvalidVPCNetworkStateFault
//
//   - ServiceLinkedRoleNotFoundFault
//
//   - ShardsPerClusterQuotaExceededFault
//
//   - InvalidParameterValueException
//
//   - InvalidParameterCombinationException
//
//   - InvalidCredentialsException
//
//   - TagQuotaPerResourceExceeded
//
//   - ACLNotFoundFault
//
//   - InvalidACLStateFault
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateCluster
func (c *MemoryDB) CreateCluster(input *CreateClusterInput) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	return out, req.Send()
}

// CreateClusterWithContext is the same as CreateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) CreateClusterWithContext(ctx aws.Context, input *CreateClusterInput, opts ...request.Option) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateParameterGroup = "CreateParameterGroup"

// CreateParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateParameterGroup for more information on using the CreateParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateParameterGroupRequest method.
//	req, resp := client.CreateParameterGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateParameterGroup
func (c *MemoryDB) CreateParameterGroupRequest(input *CreateParameterGroupInput) (req *request.Request, output *CreateParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCreateParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateParameterGroupInput{}
	}

	output = &CreateParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateParameterGroup API operation for Amazon MemoryDB.
//
// Creates a new MemoryDB parameter group. A parameter group is a collection
// of parameters and their values that are applied to all of the nodes in any
// cluster. For more information, see Configuring engine parameters using parameter
// groups (https://docs.aws.amazon.com/MemoryDB/latest/devguide/parametergroups.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation CreateParameterGroup for usage and error information.
//
// Returned Error Types:
//
//   - ParameterGroupQuotaExceededFault
//
//   - ParameterGroupAlreadyExistsFault
//
//   - InvalidParameterGroupStateFault
//
//   - ServiceLinkedRoleNotFoundFault
//
//   - TagQuotaPerResourceExceeded
//
//   - InvalidParameterValueException
//
//   - InvalidParameterCombinationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateParameterGroup
func (c *MemoryDB) CreateParameterGroup(input *CreateParameterGroupInput) (*CreateParameterGroupOutput, error) {
	req, out := c.CreateParameterGroupRequest(input)
	return out, req.Send()
}

// CreateParameterGroupWithContext is the same as CreateParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) CreateParameterGroupWithContext(ctx aws.Context, input *CreateParameterGroupInput, opts ...request.Option) (*CreateParameterGroupOutput, error) {
	req, out := c.CreateParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSnapshot = "CreateSnapshot"

// CreateSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSnapshot for more information on using the CreateSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSnapshotRequest method.
//	req, resp := client.CreateSnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateSnapshot
func (c *MemoryDB) CreateSnapshotRequest(input *CreateSnapshotInput) (req *request.Request, output *CreateSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotInput{}
	}

	output = &CreateSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSnapshot API operation for Amazon MemoryDB.
//
// Creates a copy of an entire cluster at a specific moment in time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation CreateSnapshot for usage and error information.
//
// Returned Error Types:
//
//   - SnapshotAlreadyExistsFault
//
//   - ClusterNotFoundFault
//
//   - InvalidClusterStateFault
//
//   - SnapshotQuotaExceededFault
//
//   - ServiceLinkedRoleNotFoundFault
//
//   - InvalidParameterCombinationException
//
//   - InvalidParameterValueException
//
//   - TagQuotaPerResourceExceeded
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateSnapshot
func (c *MemoryDB) CreateSnapshot(input *CreateSnapshotInput) (*CreateSnapshotOutput, error) {
	req, out := c.CreateSnapshotRequest(input)
	return out, req.Send()
}

// CreateSnapshotWithContext is the same as CreateSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) CreateSnapshotWithContext(ctx aws.Context, input *CreateSnapshotInput, opts ...request.Option) (*CreateSnapshotOutput, error) {
	req, out := c.CreateSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSubnetGroup = "CreateSubnetGroup"

// CreateSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSubnetGroup for more information on using the CreateSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSubnetGroupRequest method.
//	req, resp := client.CreateSubnetGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateSubnetGroup
func (c *MemoryDB) CreateSubnetGroupRequest(input *CreateSubnetGroupInput) (req *request.Request, output *CreateSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opCreateSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSubnetGroupInput{}
	}

	output = &CreateSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSubnetGroup API operation for Amazon MemoryDB.
//
// Creates a subnet group. A subnet group is a collection of subnets (typically
// private) that you can designate for your clusters running in an Amazon Virtual
// Private Cloud (VPC) environment. When you create a cluster in an Amazon VPC,
// you must specify a subnet group. MemoryDB uses that subnet group to choose
// a subnet and IP addresses within that subnet to associate with your nodes.
// For more information, see Subnets and subnet groups (https://docs.aws.amazon.com/MemoryDB/latest/devguide/subnetgroups.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation CreateSubnetGroup for usage and error information.
//
// Returned Error Types:
//
//   - SubnetGroupAlreadyExistsFault
//
//   - SubnetGroupQuotaExceededFault
//
//   - SubnetQuotaExceededFault
//
//   - InvalidSubnet
//
//   - ServiceLinkedRoleNotFoundFault
//
//   - SubnetNotAllowedFault
//
//   - TagQuotaPerResourceExceeded
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateSubnetGroup
func (c *MemoryDB) CreateSubnetGroup(input *CreateSubnetGroupInput) (*CreateSubnetGroupOutput, error) {
	req, out := c.CreateSubnetGroupRequest(input)
	return out, req.Send()
}

// CreateSubnetGroupWithContext is the same as CreateSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) CreateSubnetGroupWithContext(ctx aws.Context, input *CreateSubnetGroupInput, opts ...request.Option) (*CreateSubnetGroupOutput, error) {
	req, out := c.CreateSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUser = "CreateUser"

// CreateUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUser for more information on using the CreateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateUserRequest method.
//	req, resp := client.CreateUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateUser
func (c *MemoryDB) CreateUserRequest(input *CreateUserInput) (req *request.Request, output *CreateUserOutput) {
	op := &request.Operation{
		Name:       opCreateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserInput{}
	}

	output = &CreateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUser API operation for Amazon MemoryDB.
//
// Creates a MemoryDB user. For more information, see Authenticating users with
// Access Contol Lists (ACLs) (https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation CreateUser for usage and error information.
//
// Returned Error Types:
//
//   - UserAlreadyExistsFault
//
//   - UserQuotaExceededFault
//
//   - DuplicateUserNameFault
//
//   - InvalidParameterValueException
//
//   - InvalidParameterCombinationException
//
//   - TagQuotaPerResourceExceeded
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/CreateUser
func (c *MemoryDB) CreateUser(input *CreateUserInput) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	return out, req.Send()
}

// CreateUserWithContext is the same as CreateUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) CreateUserWithContext(ctx aws.Context, input *CreateUserInput, opts ...request.Option) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteACL = "DeleteACL"

// DeleteACLRequest generates a "aws/request.Request" representing the
// client's request for the DeleteACL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteACL for more information on using the DeleteACL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteACLRequest method.
//	req, resp := client.DeleteACLRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteACL
func (c *MemoryDB) DeleteACLRequest(input *DeleteACLInput) (req *request.Request, output *DeleteACLOutput) {
	op := &request.Operation{
		Name:       opDeleteACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteACLInput{}
	}

	output = &DeleteACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteACL API operation for Amazon MemoryDB.
//
// Deletes an Access Control List. The ACL must first be disassociated from
// the cluster before it can be deleted. For more information, see Authenticating
// users with Access Contol Lists (ACLs) (https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation DeleteACL for usage and error information.
//
// Returned Error Types:
//
//   - ACLNotFoundFault
//
//   - InvalidACLStateFault
//
//   - InvalidParameterValueException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteACL
func (c *MemoryDB) DeleteACL(input *DeleteACLInput) (*DeleteACLOutput, error) {
	req, out := c.DeleteACLRequest(input)
	return out, req.Send()
}

// DeleteACLWithContext is the same as DeleteACL with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) DeleteACLWithContext(ctx aws.Context, input *DeleteACLInput, opts ...request.Option) (*DeleteACLOutput, error) {
	req, out := c.DeleteACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCluster = "DeleteCluster"

// DeleteClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCluster for more information on using the DeleteCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteClusterRequest method.
//	req, resp := client.DeleteClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteCluster
func (c *MemoryDB) DeleteClusterRequest(input *DeleteClusterInput) (req *request.Request, output *DeleteClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterInput{}
	}

	output = &DeleteClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCluster API operation for Amazon MemoryDB.
//
// Deletes a cluster. It also deletes all associated nodes and node endpoints
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation DeleteCluster for usage and error information.
//
// Returned Error Types:
//
//   - ClusterNotFoundFault
//
//   - InvalidClusterStateFault
//
//   - SnapshotAlreadyExistsFault
//
//   - ServiceLinkedRoleNotFoundFault
//
//   - InvalidParameterValueException
//
//   - InvalidParameterCombinationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteCluster
func (c *MemoryDB) DeleteCluster(input *DeleteClusterInput) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	return out, req.Send()
}

// DeleteClusterWithContext is the same as DeleteCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) DeleteClusterWithContext(ctx aws.Context, input *DeleteClusterInput, opts ...request.Option) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteParameterGroup = "DeleteParameterGroup"

// DeleteParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteParameterGroup for more information on using the DeleteParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteParameterGroupRequest method.
//	req, resp := client.DeleteParameterGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteParameterGroup
func (c *MemoryDB) DeleteParameterGroupRequest(input *DeleteParameterGroupInput) (req *request.Request, output *DeleteParameterGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteParameterGroupInput{}
	}

	output = &DeleteParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteParameterGroup API operation for Amazon MemoryDB.
//
// Deletes the specified parameter group. You cannot delete a parameter group
// if it is associated with any clusters. You cannot delete the default parameter
// groups in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation DeleteParameterGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterGroupStateFault
//
//   - ParameterGroupNotFoundFault
//
//   - ServiceLinkedRoleNotFoundFault
//
//   - InvalidParameterValueException
//
//   - InvalidParameterCombinationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteParameterGroup
func (c *MemoryDB) DeleteParameterGroup(input *DeleteParameterGroupInput) (*DeleteParameterGroupOutput, error) {
	req, out := c.DeleteParameterGroupRequest(input)
	return out, req.Send()
}

// DeleteParameterGroupWithContext is the same as DeleteParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) DeleteParameterGroupWithContext(ctx aws.Context, input *DeleteParameterGroupInput, opts ...request.Option) (*DeleteParameterGroupOutput, error) {
	req, out := c.DeleteParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSnapshot = "DeleteSnapshot"

// DeleteSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSnapshot for more information on using the DeleteSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSnapshotRequest method.
//	req, resp := client.DeleteSnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteSnapshot
func (c *MemoryDB) DeleteSnapshotRequest(input *DeleteSnapshotInput) (req *request.Request, output *DeleteSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotInput{}
	}

	output = &DeleteSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSnapshot API operation for Amazon MemoryDB.
//
// Deletes an existing snapshot. When you receive a successful response from
// this operation, MemoryDB immediately begins deleting the snapshot; you cannot
// cancel or revert this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation DeleteSnapshot for usage and error information.
//
// Returned Error Types:
//
//   - SnapshotNotFoundFault
//
//   - InvalidSnapshotStateFault
//
//   - ServiceLinkedRoleNotFoundFault
//
//   - InvalidParameterValueException
//
//   - InvalidParameterCombinationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteSnapshot
func (c *MemoryDB) DeleteSnapshot(input *DeleteSnapshotInput) (*DeleteSnapshotOutput, error) {
	req, out := c.DeleteSnapshotRequest(input)
	return out, req.Send()
}

// DeleteSnapshotWithContext is the same as DeleteSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) DeleteSnapshotWithContext(ctx aws.Context, input *DeleteSnapshotInput, opts ...request.Option) (*DeleteSnapshotOutput, error) {
	req, out := c.DeleteSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSubnetGroup = "DeleteSubnetGroup"

// DeleteSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSubnetGroup for more information on using the DeleteSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSubnetGroupRequest method.
//	req, resp := client.DeleteSubnetGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteSubnetGroup
func (c *MemoryDB) DeleteSubnetGroupRequest(input *DeleteSubnetGroupInput) (req *request.Request, output *DeleteSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSubnetGroupInput{}
	}

	output = &DeleteSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSubnetGroup API operation for Amazon MemoryDB.
//
// Deletes a subnet group. You cannot delete a default subnet group or one that
// is associated with any clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation DeleteSubnetGroup for usage and error information.
//
// Returned Error Types:
//
//   - SubnetGroupInUseFault
//
//   - SubnetGroupNotFoundFault
//
//   - ServiceLinkedRoleNotFoundFault
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteSubnetGroup
func (c *MemoryDB) DeleteSubnetGroup(input *DeleteSubnetGroupInput) (*DeleteSubnetGroupOutput, error) {
	req, out := c.DeleteSubnetGroupRequest(input)
	return out, req.Send()
}

// DeleteSubnetGroupWithContext is the same as DeleteSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) DeleteSubnetGroupWithContext(ctx aws.Context, input *DeleteSubnetGroupInput, opts ...request.Option) (*DeleteSubnetGroupOutput, error) {
	req, out := c.DeleteSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteUserRequest method.
//	req, resp := client.DeleteUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteUser
func (c *MemoryDB) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteUser API operation for Amazon MemoryDB.
//
// Deletes a user. The user will be removed from all ACLs and in turn removed
// from all clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation DeleteUser for usage and error information.
//
// Returned Error Types:
//
//   - InvalidUserStateFault
//
//   - UserNotFoundFault
//
//   - InvalidParameterValueException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DeleteUser
func (c *MemoryDB) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeACLs = "DescribeACLs"

// DescribeACLsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeACLs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeACLs for more information on using the DescribeACLs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeACLsRequest method.
//	req, resp := client.DescribeACLsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeACLs
func (c *MemoryDB) DescribeACLsRequest(input *DescribeACLsInput) (req *request.Request, output *DescribeACLsOutput) {
	op := &request.Operation{
		Name:       opDescribeACLs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeACLsInput{}
	}

	output = &DescribeACLsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeACLs API operation for Amazon MemoryDB.
//
// # Returns a list of ACLs
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation DescribeACLs for usage and error information.
//
// Returned Error Types:
//
//   - ACLNotFoundFault
//
//   - InvalidParameterCombinationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeACLs
func (c *MemoryDB) DescribeACLs(input *DescribeACLsInput) (*DescribeACLsOutput, error) {
	req, out := c.DescribeACLsRequest(input)
	return out, req.Send()
}

// DescribeACLsWithContext is the same as DescribeACLs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeACLs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) DescribeACLsWithContext(ctx aws.Context, input *DescribeACLsInput, opts ...request.Option) (*DescribeACLsOutput, error) {
	req, out := c.DescribeACLsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeClusters = "DescribeClusters"

// DescribeClustersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClusters for more information on using the DescribeClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeClustersRequest method.
//	req, resp := client.DescribeClustersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeClusters
func (c *MemoryDB) DescribeClustersRequest(input *DescribeClustersInput) (req *request.Request, output *DescribeClustersOutput) {
	op := &request.Operation{
		Name:       opDescribeClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeClustersInput{}
	}

	output = &DescribeClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusters API operation for Amazon MemoryDB.
//
// Returns information about all provisioned clusters if no cluster identifier
// is specified, or about a specific cluster if a cluster name is supplied.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation DescribeClusters for usage and error information.
//
// Returned Error Types:
//
//   - ClusterNotFoundFault
//
//   - ServiceLinkedRoleNotFoundFault
//
//   - InvalidParameterValueException
//
//   - InvalidParameterCombinationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeClusters
func (c *MemoryDB) DescribeClusters(input *DescribeClustersInput) (*DescribeClustersOutput, error) {
	req, out := c.DescribeClustersRequest(input)
	return out, req.Send()
}

// DescribeClustersWithContext is the same as DescribeClusters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) DescribeClustersWithContext(ctx aws.Context, input *DescribeClustersInput, opts ...request.Option) (*DescribeClustersOutput, error) {
	req, out := c.DescribeClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEngineVersions = "DescribeEngineVersions"

// DescribeEngineVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEngineVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEngineVersions for more information on using the DescribeEngineVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEngineVersionsRequest method.
//	req, resp := client.DescribeEngineVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeEngineVersions
func (c *MemoryDB) DescribeEngineVersionsRequest(input *DescribeEngineVersionsInput) (req *request.Request, output *DescribeEngineVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeEngineVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEngineVersionsInput{}
	}

	output = &DescribeEngineVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEngineVersions API operation for Amazon MemoryDB.
//
// Returns a list of the available Redis engine versions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation DescribeEngineVersions for usage and error information.
//
// Returned Error Types:
//
//   - ServiceLinkedRoleNotFoundFault
//
//   - InvalidParameterValueException
//
//   - InvalidParameterCombinationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeEngineVersions
func (c *MemoryDB) DescribeEngineVersions(input *DescribeEngineVersionsInput) (*DescribeEngineVersionsOutput, error) {
	req, out := c.DescribeEngineVersionsRequest(input)
	return out, req.Send()
}

// DescribeEngineVersionsWithContext is the same as DescribeEngineVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEngineVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) DescribeEngineVersionsWithContext(ctx aws.Context, input *DescribeEngineVersionsInput, opts ...request.Option) (*DescribeEngineVersionsOutput, error) {
	req, out := c.DescribeEngineVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEvents = "DescribeEvents"

// DescribeEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEvents for more information on using the DescribeEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEventsRequest method.
//	req, resp := client.DescribeEventsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeEvents
func (c *MemoryDB) DescribeEventsRequest(input *DescribeEventsInput) (req *request.Request, output *DescribeEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventsInput{}
	}

	output = &DescribeEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEvents API operation for Amazon MemoryDB.
//
// Returns events related to clusters, security groups, and parameter groups.
// You can obtain events specific to a particular cluster, security group, or
// parameter group by providing the name as a parameter. By default, only the
// events occurring within the last hour are returned; however, you can retrieve
// up to 14 days' worth of events if necessary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation DescribeEvents for usage and error information.
//
// Returned Error Types:
//
//   - ServiceLinkedRoleNotFoundFault
//
//   - InvalidParameterValueException
//
//   - InvalidParameterCombinationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeEvents
func (c *MemoryDB) DescribeEvents(input *DescribeEventsInput) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	return out, req.Send()
}

// DescribeEventsWithContext is the same as DescribeEvents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) DescribeEventsWithContext(ctx aws.Context, input *DescribeEventsInput, opts ...request.Option) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeParameterGroups = "DescribeParameterGroups"

// DescribeParameterGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeParameterGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeParameterGroups for more information on using the DescribeParameterGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeParameterGroupsRequest method.
//	req, resp := client.DescribeParameterGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeParameterGroups
func (c *MemoryDB) DescribeParameterGroupsRequest(input *DescribeParameterGroupsInput) (req *request.Request, output *DescribeParameterGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeParameterGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeParameterGroupsInput{}
	}

	output = &DescribeParameterGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeParameterGroups API operation for Amazon MemoryDB.
//
// Returns a list of parameter group descriptions. If a parameter group name
// is specified, the list contains only the descriptions for that group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation DescribeParameterGroups for usage and error information.
//
// Returned Error Types:
//
//   - ParameterGroupNotFoundFault
//
//   - ServiceLinkedRoleNotFoundFault
//
//   - InvalidParameterValueException
//
//   - InvalidParameterCombinationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeParameterGroups
func (c *MemoryDB) DescribeParameterGroups(input *DescribeParameterGroupsInput) (*DescribeParameterGroupsOutput, error) {
	req, out := c.DescribeParameterGroupsRequest(input)
	return out, req.Send()
}

// DescribeParameterGroupsWithContext is the same as DescribeParameterGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeParameterGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) DescribeParameterGroupsWithContext(ctx aws.Context, input *DescribeParameterGroupsInput, opts ...request.Option) (*DescribeParameterGroupsOutput, error) {
	req, out := c.DescribeParameterGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeParameters = "DescribeParameters"

// DescribeParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeParameters for more information on using the DescribeParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeParametersRequest method.
//	req, resp := client.DescribeParametersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeParameters
func (c *MemoryDB) DescribeParametersRequest(input *DescribeParametersInput) (req *request.Request, output *DescribeParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeParametersInput{}
	}

	output = &DescribeParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeParameters API operation for Amazon MemoryDB.
//
// Returns the detailed parameter list for a particular parameter group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation DescribeParameters for usage and error information.
//
// Returned Error Types:
//
//   - ParameterGroupNotFoundFault
//
//   - ServiceLinkedRoleNotFoundFault
//
//   - InvalidParameterValueException
//
//   - InvalidParameterCombinationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeParameters
func (c *MemoryDB) DescribeParameters(input *DescribeParametersInput) (*DescribeParametersOutput, error) {
	req, out := c.DescribeParametersRequest(input)
	return out, req.Send()
}

// DescribeParametersWithContext is the same as DescribeParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) DescribeParametersWithContext(ctx aws.Context, input *DescribeParametersInput, opts ...request.Option) (*DescribeParametersOutput, error) {
	req, out := c.DescribeParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeServiceUpdates = "DescribeServiceUpdates"

// DescribeServiceUpdatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeServiceUpdates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeServiceUpdates for more information on using the DescribeServiceUpdates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeServiceUpdatesRequest method.
//	req, resp := client.DescribeServiceUpdatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeServiceUpdates
func (c *MemoryDB) DescribeServiceUpdatesRequest(input *DescribeServiceUpdatesInput) (req *request.Request, output *DescribeServiceUpdatesOutput) {
	op := &request.Operation{
		Name:       opDescribeServiceUpdates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeServiceUpdatesInput{}
	}

	output = &DescribeServiceUpdatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeServiceUpdates API operation for Amazon MemoryDB.
//
// # Returns details of the service updates
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation DescribeServiceUpdates for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//
//   - InvalidParameterCombinationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeServiceUpdates
func (c *MemoryDB) DescribeServiceUpdates(input *DescribeServiceUpdatesInput) (*DescribeServiceUpdatesOutput, error) {
	req, out := c.DescribeServiceUpdatesRequest(input)
	return out, req.Send()
}

// DescribeServiceUpdatesWithContext is the same as DescribeServiceUpdates with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeServiceUpdates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) DescribeServiceUpdatesWithContext(ctx aws.Context, input *DescribeServiceUpdatesInput, opts ...request.Option) (*DescribeServiceUpdatesOutput, error) {
	req, out := c.DescribeServiceUpdatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSnapshots = "DescribeSnapshots"

// DescribeSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSnapshots for more information on using the DescribeSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSnapshotsRequest method.
//	req, resp := client.DescribeSnapshotsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeSnapshots
func (c *MemoryDB) DescribeSnapshotsRequest(input *DescribeSnapshotsInput) (req *request.Request, output *DescribeSnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSnapshotsInput{}
	}

	output = &DescribeSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSnapshots API operation for Amazon MemoryDB.
//
// Returns information about cluster snapshots. By default, DescribeSnapshots
// lists all of your snapshots; it can optionally describe a single snapshot,
// or just the snapshots associated with a particular cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation DescribeSnapshots for usage and error information.
//
// Returned Error Types:
//
//   - SnapshotNotFoundFault
//
//   - ServiceLinkedRoleNotFoundFault
//
//   - InvalidParameterValueException
//
//   - InvalidParameterCombinationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeSnapshots
func (c *MemoryDB) DescribeSnapshots(input *DescribeSnapshotsInput) (*DescribeSnapshotsOutput, error) {
	req, out := c.DescribeSnapshotsRequest(input)
	return out, req.Send()
}

// DescribeSnapshotsWithContext is the same as DescribeSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) DescribeSnapshotsWithContext(ctx aws.Context, input *DescribeSnapshotsInput, opts ...request.Option) (*DescribeSnapshotsOutput, error) {
	req, out := c.DescribeSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSubnetGroups = "DescribeSubnetGroups"

// DescribeSubnetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSubnetGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSubnetGroups for more information on using the DescribeSubnetGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSubnetGroupsRequest method.
//	req, resp := client.DescribeSubnetGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeSubnetGroups
func (c *MemoryDB) DescribeSubnetGroupsRequest(input *DescribeSubnetGroupsInput) (req *request.Request, output *DescribeSubnetGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeSubnetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSubnetGroupsInput{}
	}

	output = &DescribeSubnetGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSubnetGroups API operation for Amazon MemoryDB.
//
// Returns a list of subnet group descriptions. If a subnet group name is specified,
// the list contains only the description of that group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation DescribeSubnetGroups for usage and error information.
//
// Returned Error Types:
//
//   - SubnetGroupNotFoundFault
//
//   - ServiceLinkedRoleNotFoundFault
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeSubnetGroups
func (c *MemoryDB) DescribeSubnetGroups(input *DescribeSubnetGroupsInput) (*DescribeSubnetGroupsOutput, error) {
	req, out := c.DescribeSubnetGroupsRequest(input)
	return out, req.Send()
}

// DescribeSubnetGroupsWithContext is the same as DescribeSubnetGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSubnetGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) DescribeSubnetGroupsWithContext(ctx aws.Context, input *DescribeSubnetGroupsInput, opts ...request.Option) (*DescribeSubnetGroupsOutput, error) {
	req, out := c.DescribeSubnetGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUsers = "DescribeUsers"

// DescribeUsersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUsers for more information on using the DescribeUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeUsersRequest method.
//	req, resp := client.DescribeUsersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeUsers
func (c *MemoryDB) DescribeUsersRequest(input *DescribeUsersInput) (req *request.Request, output *DescribeUsersOutput) {
	op := &request.Operation{
		Name:       opDescribeUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUsersInput{}
	}

	output = &DescribeUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUsers API operation for Amazon MemoryDB.
//
// Returns a list of users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation DescribeUsers for usage and error information.
//
// Returned Error Types:
//
//   - UserNotFoundFault
//
//   - InvalidParameterCombinationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/DescribeUsers
func (c *MemoryDB) DescribeUsers(input *DescribeUsersInput) (*DescribeUsersOutput, error) {
	req, out := c.DescribeUsersRequest(input)
	return out, req.Send()
}

// DescribeUsersWithContext is the same as DescribeUsers with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) DescribeUsersWithContext(ctx aws.Context, input *DescribeUsersInput, opts ...request.Option) (*DescribeUsersOutput, error) {
	req, out := c.DescribeUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opFailoverShard = "FailoverShard"

// FailoverShardRequest generates a "aws/request.Request" representing the
// client's request for the FailoverShard operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See FailoverShard for more information on using the FailoverShard
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the FailoverShardRequest method.
//	req, resp := client.FailoverShardRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/FailoverShard
func (c *MemoryDB) FailoverShardRequest(input *FailoverShardInput) (req *request.Request, output *FailoverShardOutput) {
	op := &request.Operation{
		Name:       opFailoverShard,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &FailoverShardInput{}
	}

	output = &FailoverShardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// FailoverShard API operation for Amazon MemoryDB.
//
// # Used to failover a shard
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation FailoverShard for usage and error information.
//
// Returned Error Types:
//
//   - APICallRateForCustomerExceededFault
//
//   - InvalidClusterStateFault
//
//   - ShardNotFoundFault
//
//   - ClusterNotFoundFault
//
//   - TestFailoverNotAvailableFault
//
//   - InvalidKMSKeyFault
//
//   - InvalidParameterValueException
//
//   - InvalidParameterCombinationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/FailoverShard
func (c *MemoryDB) FailoverShard(input *FailoverShardInput) (*FailoverShardOutput, error) {
	req, out := c.FailoverShardRequest(input)
	return out, req.Send()
}

// FailoverShardWithContext is the same as FailoverShard with the addition of
// the ability to pass a context and additional request options.
//
// See FailoverShard for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) FailoverShardWithContext(ctx aws.Context, input *FailoverShardInput, opts ...request.Option) (*FailoverShardOutput, error) {
	req, out := c.FailoverShardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAllowedNodeTypeUpdates = "ListAllowedNodeTypeUpdates"

// ListAllowedNodeTypeUpdatesRequest generates a "aws/request.Request" representing the
// client's request for the ListAllowedNodeTypeUpdates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAllowedNodeTypeUpdates for more information on using the ListAllowedNodeTypeUpdates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAllowedNodeTypeUpdatesRequest method.
//	req, resp := client.ListAllowedNodeTypeUpdatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/ListAllowedNodeTypeUpdates
func (c *MemoryDB) ListAllowedNodeTypeUpdatesRequest(input *ListAllowedNodeTypeUpdatesInput) (req *request.Request, output *ListAllowedNodeTypeUpdatesOutput) {
	op := &request.Operation{
		Name:       opListAllowedNodeTypeUpdates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAllowedNodeTypeUpdatesInput{}
	}

	output = &ListAllowedNodeTypeUpdatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAllowedNodeTypeUpdates API operation for Amazon MemoryDB.
//
// Lists all available node types that you can scale to from your cluster's
// current node type. When you use the UpdateCluster operation to scale your
// cluster, the value of the NodeType parameter must be one of the node types
// returned by this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation ListAllowedNodeTypeUpdates for usage and error information.
//
// Returned Error Types:
//
//   - ClusterNotFoundFault
//
//   - ServiceLinkedRoleNotFoundFault
//
//   - InvalidParameterCombinationException
//
//   - InvalidParameterValueException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/ListAllowedNodeTypeUpdates
func (c *MemoryDB) ListAllowedNodeTypeUpdates(input *ListAllowedNodeTypeUpdatesInput) (*ListAllowedNodeTypeUpdatesOutput, error) {
	req, out := c.ListAllowedNodeTypeUpdatesRequest(input)
	return out, req.Send()
}

// ListAllowedNodeTypeUpdatesWithContext is the same as ListAllowedNodeTypeUpdates with the addition of
// the ability to pass a context and additional request options.
//
// See ListAllowedNodeTypeUpdates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) ListAllowedNodeTypeUpdatesWithContext(ctx aws.Context, input *ListAllowedNodeTypeUpdatesInput, opts ...request.Option) (*ListAllowedNodeTypeUpdatesOutput, error) {
	req, out := c.ListAllowedNodeTypeUpdatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsRequest method.
//	req, resp := client.ListTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/ListTags
func (c *MemoryDB) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for Amazon MemoryDB.
//
// Lists all tags currently on a named resource. A tag is a key-value pair where
// the key and value are case-sensitive. You can use tags to categorize and
// track your MemoryDB resources. For more information, see Tagging your MemoryDB
// resources (https://docs.aws.amazon.com/MemoryDB/latest/devguide/Tagging-Resources.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation ListTags for usage and error information.
//
// Returned Error Types:
//
//   - ClusterNotFoundFault
//
//   - InvalidClusterStateFault
//
//   - ParameterGroupNotFoundFault
//
//   - SubnetGroupNotFoundFault
//
//   - SnapshotNotFoundFault
//
//   - InvalidARNFault
//
//   - ServiceLinkedRoleNotFoundFault
//
//   - UserNotFoundFault
//
//   - ACLNotFoundFault
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/ListTags
func (c *MemoryDB) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetParameterGroup = "ResetParameterGroup"

// ResetParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the ResetParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetParameterGroup for more information on using the ResetParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ResetParameterGroupRequest method.
//	req, resp := client.ResetParameterGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/ResetParameterGroup
func (c *MemoryDB) ResetParameterGroupRequest(input *ResetParameterGroupInput) (req *request.Request, output *ResetParameterGroupOutput) {
	op := &request.Operation{
		Name:       opResetParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetParameterGroupInput{}
	}

	output = &ResetParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResetParameterGroup API operation for Amazon MemoryDB.
//
// Modifies the parameters of a parameter group to the engine or system default
// value. You can reset specific parameters by submitting a list of parameter
// names. To reset the entire parameter group, specify the AllParameters and
// ParameterGroupName parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation ResetParameterGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterGroupStateFault
//
//   - ParameterGroupNotFoundFault
//
//   - ServiceLinkedRoleNotFoundFault
//
//   - InvalidParameterValueException
//
//   - InvalidParameterCombinationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/ResetParameterGroup
func (c *MemoryDB) ResetParameterGroup(input *ResetParameterGroupInput) (*ResetParameterGroupOutput, error) {
	req, out := c.ResetParameterGroupRequest(input)
	return out, req.Send()
}

// ResetParameterGroupWithContext is the same as ResetParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ResetParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) ResetParameterGroupWithContext(ctx aws.Context, input *ResetParameterGroupInput, opts ...request.Option) (*ResetParameterGroupOutput, error) {
	req, out := c.ResetParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/TagResource
func (c *MemoryDB) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TagResource API operation for Amazon MemoryDB.
//
// A tag is a key-value pair where the key and value are case-sensitive. You
// can use tags to categorize and track all your MemoryDB resources. When you
// add or remove tags on clusters, those actions will be replicated to all nodes
// in the cluster. For more information, see Resource-level permissions (https://docs.aws.amazon.com/MemoryDB/latest/devguide/iam.resourcelevelpermissions.html).
//
// For example, you can use cost-allocation tags to your MemoryDB resources,
// Amazon generates a cost allocation report as a comma-separated value (CSV)
// file with your usage and costs aggregated by your tags. You can apply tags
// that represent business categories (such as cost centers, application names,
// or owners) to organize your costs across multiple services. For more information,
// see Using Cost Allocation Tags (https://docs.aws.amazon.com/MemoryDB/latest/devguide/tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ClusterNotFoundFault
//
//   - ParameterGroupNotFoundFault
//
//   - SubnetGroupNotFoundFault
//
//   - InvalidClusterStateFault
//
//   - SnapshotNotFoundFault
//
//   - UserNotFoundFault
//
//   - ACLNotFoundFault
//
//   - TagQuotaPerResourceExceeded
//
//   - InvalidARNFault
//
//   - ServiceLinkedRoleNotFoundFault
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/TagResource
func (c *MemoryDB) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UntagResource
func (c *MemoryDB) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UntagResource API operation for Amazon MemoryDB.
//
// # Use this operation to remove tags on a resource
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ClusterNotFoundFault
//
//   - InvalidClusterStateFault
//
//   - ParameterGroupNotFoundFault
//
//   - SubnetGroupNotFoundFault
//
//   - SnapshotNotFoundFault
//
//   - InvalidARNFault
//
//   - TagNotFoundFault
//
//   - ServiceLinkedRoleNotFoundFault
//
//   - UserNotFoundFault
//
//   - ACLNotFoundFault
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UntagResource
func (c *MemoryDB) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateACL = "UpdateACL"

// UpdateACLRequest generates a "aws/request.Request" representing the
// client's request for the UpdateACL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateACL for more information on using the UpdateACL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateACLRequest method.
//	req, resp := client.UpdateACLRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateACL
func (c *MemoryDB) UpdateACLRequest(input *UpdateACLInput) (req *request.Request, output *UpdateACLOutput) {
	op := &request.Operation{
		Name:       opUpdateACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateACLInput{}
	}

	output = &UpdateACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateACL API operation for Amazon MemoryDB.
//
// Changes the list of users that belong to the Access Control List.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation UpdateACL for usage and error information.
//
// Returned Error Types:
//
//   - ACLNotFoundFault
//
//   - UserNotFoundFault
//
//   - DuplicateUserNameFault
//
//   - DefaultUserRequired
//
//   - InvalidACLStateFault
//
//   - InvalidParameterValueException
//
//   - InvalidParameterCombinationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateACL
func (c *MemoryDB) UpdateACL(input *UpdateACLInput) (*UpdateACLOutput, error) {
	req, out := c.UpdateACLRequest(input)
	return out, req.Send()
}

// UpdateACLWithContext is the same as UpdateACL with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) UpdateACLWithContext(ctx aws.Context, input *UpdateACLInput, opts ...request.Option) (*UpdateACLOutput, error) {
	req, out := c.UpdateACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCluster = "UpdateCluster"

// UpdateClusterRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCluster for more information on using the UpdateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateClusterRequest method.
//	req, resp := client.UpdateClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateCluster
func (c *MemoryDB) UpdateClusterRequest(input *UpdateClusterInput) (req *request.Request, output *UpdateClusterOutput) {
	op := &request.Operation{
		Name:       opUpdateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateClusterInput{}
	}

	output = &UpdateClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCluster API operation for Amazon MemoryDB.
//
// Modifies the settings for a cluster. You can use this operation to change
// one or more cluster configuration settings by specifying the settings and
// the new values.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation UpdateCluster for usage and error information.
//
// Returned Error Types:
//
//   - ClusterNotFoundFault
//
//   - InvalidClusterStateFault
//
//   - InvalidNodeStateFault
//
//   - ParameterGroupNotFoundFault
//
//   - InvalidVPCNetworkStateFault
//
//   - ServiceLinkedRoleNotFoundFault
//
//   - InvalidKMSKeyFault
//
//   - NodeQuotaForClusterExceededFault
//
//   - ClusterQuotaForCustomerExceededFault
//
//   - ShardsPerClusterQuotaExceededFault
//
//   - NodeQuotaForCustomerExceededFault
//
//   - NoOperationFault
//
//   - InvalidACLStateFault
//
//   - ACLNotFoundFault
//
//   - InvalidParameterValueException
//
//   - InvalidParameterCombinationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateCluster
func (c *MemoryDB) UpdateCluster(input *UpdateClusterInput) (*UpdateClusterOutput, error) {
	req, out := c.UpdateClusterRequest(input)
	return out, req.Send()
}

// UpdateClusterWithContext is the same as UpdateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) UpdateClusterWithContext(ctx aws.Context, input *UpdateClusterInput, opts ...request.Option) (*UpdateClusterOutput, error) {
	req, out := c.UpdateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateParameterGroup = "UpdateParameterGroup"

// UpdateParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateParameterGroup for more information on using the UpdateParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateParameterGroupRequest method.
//	req, resp := client.UpdateParameterGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateParameterGroup
func (c *MemoryDB) UpdateParameterGroupRequest(input *UpdateParameterGroupInput) (req *request.Request, output *UpdateParameterGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateParameterGroupInput{}
	}

	output = &UpdateParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateParameterGroup API operation for Amazon MemoryDB.
//
// Updates the parameters of a parameter group. You can modify up to 20 parameters
// in a single request by submitting a list parameter name and value pairs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation UpdateParameterGroup for usage and error information.
//
// Returned Error Types:
//
//   - ParameterGroupNotFoundFault
//
//   - InvalidParameterGroupStateFault
//
//   - ServiceLinkedRoleNotFoundFault
//
//   - InvalidParameterValueException
//
//   - InvalidParameterCombinationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateParameterGroup
func (c *MemoryDB) UpdateParameterGroup(input *UpdateParameterGroupInput) (*UpdateParameterGroupOutput, error) {
	req, out := c.UpdateParameterGroupRequest(input)
	return out, req.Send()
}

// UpdateParameterGroupWithContext is the same as UpdateParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) UpdateParameterGroupWithContext(ctx aws.Context, input *UpdateParameterGroupInput, opts ...request.Option) (*UpdateParameterGroupOutput, error) {
	req, out := c.UpdateParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSubnetGroup = "UpdateSubnetGroup"

// UpdateSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSubnetGroup for more information on using the UpdateSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSubnetGroupRequest method.
//	req, resp := client.UpdateSubnetGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateSubnetGroup
func (c *MemoryDB) UpdateSubnetGroupRequest(input *UpdateSubnetGroupInput) (req *request.Request, output *UpdateSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSubnetGroupInput{}
	}

	output = &UpdateSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSubnetGroup API operation for Amazon MemoryDB.
//
// Updates a subnet group. For more information, see Updating a subnet group
// (https://docs.aws.amazon.com/MemoryDB/latest/devguide/ubnetGroups.Modifying.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation UpdateSubnetGroup for usage and error information.
//
// Returned Error Types:
//
//   - SubnetGroupNotFoundFault
//
//   - SubnetQuotaExceededFault
//
//   - SubnetInUse
//
//   - InvalidSubnet
//
//   - ServiceLinkedRoleNotFoundFault
//
//   - SubnetNotAllowedFault
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateSubnetGroup
func (c *MemoryDB) UpdateSubnetGroup(input *UpdateSubnetGroupInput) (*UpdateSubnetGroupOutput, error) {
	req, out := c.UpdateSubnetGroupRequest(input)
	return out, req.Send()
}

// UpdateSubnetGroupWithContext is the same as UpdateSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) UpdateSubnetGroupWithContext(ctx aws.Context, input *UpdateSubnetGroupInput, opts ...request.Option) (*UpdateSubnetGroupOutput, error) {
	req, out := c.UpdateSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUser = "UpdateUser"

// UpdateUserRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUser for more information on using the UpdateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateUserRequest method.
//	req, resp := client.UpdateUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateUser
func (c *MemoryDB) UpdateUserRequest(input *UpdateUserInput) (req *request.Request, output *UpdateUserOutput) {
	op := &request.Operation{
		Name:       opUpdateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserInput{}
	}

	output = &UpdateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUser API operation for Amazon MemoryDB.
//
// Changes user password(s) and/or access string.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon MemoryDB's
// API operation UpdateUser for usage and error information.
//
// Returned Error Types:
//
//   - UserNotFoundFault
//
//   - InvalidUserStateFault
//
//   - InvalidParameterValueException
//
//   - InvalidParameterCombinationException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/UpdateUser
func (c *MemoryDB) UpdateUser(input *UpdateUserInput) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	return out, req.Send()
}

// UpdateUserWithContext is the same as UpdateUser with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MemoryDB) UpdateUserWithContext(ctx aws.Context, input *UpdateUserInput, opts ...request.Option) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An Access Control List. You can authenticate users with Access Contol Lists.
// ACLs enable you to control cluster access by grouping users. These Access
// control lists are designed as a way to organize access to clusters.
type ACL struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the ACL
	ARN *string `type:"string"`

	// A list of clusters associated with the ACL.
	Clusters []*string `type:"list"`

	// The minimum engine version supported for the ACL
	MinimumEngineVersion *string `type:"string"`

	// The name of the Access Control List
	Name *string `type:"string"`

	// A list of updates being applied to the ACL.
	PendingChanges *ACLPendingChanges `type:"structure"`

	// Indicates ACL status. Can be "creating", "active", "modifying", "deleting".
	Status *string `type:"string"`

	// The list of user names that belong to the ACL.
	UserNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ACL) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ACL) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *ACL) SetARN(v string) *ACL {
	s.ARN = &v
	return s
}

// SetClusters sets the Clusters field's value.
func (s *ACL) SetClusters(v []*string) *ACL {
	s.Clusters = v
	return s
}

// SetMinimumEngineVersion sets the MinimumEngineVersion field's value.
func (s *ACL) SetMinimumEngineVersion(v string) *ACL {
	s.MinimumEngineVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *ACL) SetName(v string) *ACL {
	s.Name = &v
	return s
}

// SetPendingChanges sets the PendingChanges field's value.
func (s *ACL) SetPendingChanges(v *ACLPendingChanges) *ACL {
	s.PendingChanges = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ACL) SetStatus(v string) *ACL {
	s.Status = &v
	return s
}

// SetUserNames sets the UserNames field's value.
func (s *ACL) SetUserNames(v []*string) *ACL {
	s.UserNames = v
	return s
}

type ACLAlreadyExistsFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ACLAlreadyExistsFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ACLAlreadyExistsFault) GoString() string {
	return s.String()
}

func newErrorACLAlreadyExistsFault(v protocol.ResponseMetadata) error {
	return &ACLAlreadyExistsFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ACLAlreadyExistsFault) Code() string {
	return "ACLAlreadyExistsFault"
}

// Message returns the exception's message.
func (s *ACLAlreadyExistsFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ACLAlreadyExistsFault) OrigErr() error {
	return nil
}

func (s *ACLAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ACLAlreadyExistsFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ACLAlreadyExistsFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type ACLNotFoundFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ACLNotFoundFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ACLNotFoundFault) GoString() string {
	return s.String()
}

func newErrorACLNotFoundFault(v protocol.ResponseMetadata) error {
	return &ACLNotFoundFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ACLNotFoundFault) Code() string {
	return "ACLNotFoundFault"
}

// Message returns the exception's message.
func (s *ACLNotFoundFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ACLNotFoundFault) OrigErr() error {
	return nil
}

func (s *ACLNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ACLNotFoundFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ACLNotFoundFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returns the updates being applied to the ACL.
type ACLPendingChanges struct {
	_ struct{} `type:"structure"`

	// A list of users being added to the ACL
	UserNamesToAdd []*string `type:"list"`

	// A list of user names being removed from the ACL
	UserNamesToRemove []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ACLPendingChanges) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ACLPendingChanges) GoString() string {
	return s.String()
}

// SetUserNamesToAdd sets the UserNamesToAdd field's value.
func (s *ACLPendingChanges) SetUserNamesToAdd(v []*string) *ACLPendingChanges {
	s.UserNamesToAdd = v
	return s
}

// SetUserNamesToRemove sets the UserNamesToRemove field's value.
func (s *ACLPendingChanges) SetUserNamesToRemove(v []*string) *ACLPendingChanges {
	s.UserNamesToRemove = v
	return s
}

type ACLQuotaExceededFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ACLQuotaExceededFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ACLQuotaExceededFault) GoString() string {
	return s.String()
}

func newErrorACLQuotaExceededFault(v protocol.ResponseMetadata) error {
	return &ACLQuotaExceededFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ACLQuotaExceededFault) Code() string {
	return "ACLQuotaExceededFault"
}

// Message returns the exception's message.
func (s *ACLQuotaExceededFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ACLQuotaExceededFault) OrigErr() error {
	return nil
}

func (s *ACLQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ACLQuotaExceededFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ACLQuotaExceededFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// The status of the ACL update
type ACLsUpdateStatus struct {
	_ struct{} `type:"structure"`

	// A list of ACLs pending to be applied.
	ACLToApply *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ACLsUpdateStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ACLsUpdateStatus) GoString() string {
	return s.String()
}

// SetACLToApply sets the ACLToApply field's value.
func (s *ACLsUpdateStatus) SetACLToApply(v string) *ACLsUpdateStatus {
	s.ACLToApply = &v
	return s
}

type APICallRateForCustomerExceededFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s APICallRateForCustomerExceededFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s APICallRateForCustomerExceededFault) GoString() string {
	return s.String()
}

func newErrorAPICallRateForCustomerExceededFault(v protocol.ResponseMetadata) error {
	return &APICallRateForCustomerExceededFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *APICallRateForCustomerExceededFault) Code() string {
	return "APICallRateForCustomerExceededFault"
}

// Message returns the exception's message.
func (s *APICallRateForCustomerExceededFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *APICallRateForCustomerExceededFault) OrigErr() error {
	return nil
}

func (s *APICallRateForCustomerExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *APICallRateForCustomerExceededFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *APICallRateForCustomerExceededFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// Denotes the user's authentication properties, such as whether it requires
// a password to authenticate. Used in output responses.
type Authentication struct {
	_ struct{} `type:"structure"`

	// The number of passwords belonging to the user. The maximum is two.
	PasswordCount *int64 `type:"integer"`

	// Indicates whether the user requires a password to authenticate.
	Type *string `type:"string" enum:"AuthenticationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Authentication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Authentication) GoString() string {
	return s.String()
}

// SetPasswordCount sets the PasswordCount field's value.
func (s *Authentication) SetPasswordCount(v int64) *Authentication {
	s.PasswordCount = &v
	return s
}

// SetType sets the Type field's value.
func (s *Authentication) SetType(v string) *Authentication {
	s.Type = &v
	return s
}

// Denotes the user's authentication properties, such as whether it requires
// a password to authenticate. Used in output responses.
type AuthenticationMode struct {
	_ struct{} `type:"structure"`

	// The password(s) used for authentication
	Passwords []*string `min:"1" type:"list"`

	// Indicates whether the user requires a password to authenticate. All newly-created
	// users require a password.
	Type *string `type:"string" enum:"InputAuthenticationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthenticationMode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthenticationMode) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthenticationMode) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthenticationMode"}
	if s.Passwords != nil && len(s.Passwords) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Passwords", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPasswords sets the Passwords field's value.
func (s *AuthenticationMode) SetPasswords(v []*string) *AuthenticationMode {
	s.Passwords = v
	return s
}

// SetType sets the Type field's value.
func (s *AuthenticationMode) SetType(v string) *AuthenticationMode {
	s.Type = &v
	return s
}

// Indicates if the cluster has a Multi-AZ configuration (multiaz) or not (singleaz).
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the Availability Zone.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AvailabilityZone) SetName(v string) *AvailabilityZone {
	s.Name = &v
	return s
}

type BatchUpdateClusterInput struct {
	_ struct{} `type:"structure"`

	// The cluster names to apply the updates.
	//
	// ClusterNames is a required field
	ClusterNames []*string `type:"list" required:"true"`

	// The unique ID of the service update
	ServiceUpdate *ServiceUpdateRequest `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdateClusterInput"}
	if s.ClusterNames == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterNames sets the ClusterNames field's value.
func (s *BatchUpdateClusterInput) SetClusterNames(v []*string) *BatchUpdateClusterInput {
	s.ClusterNames = v
	return s
}

// SetServiceUpdate sets the ServiceUpdate field's value.
func (s *BatchUpdateClusterInput) SetServiceUpdate(v *ServiceUpdateRequest) *BatchUpdateClusterInput {
	s.ServiceUpdate = v
	return s
}

type BatchUpdateClusterOutput struct {
	_ struct{} `type:"structure"`

	// The list of clusters that have been updated.
	ProcessedClusters []*Cluster `type:"list"`

	// The list of clusters where updates have not been applied.
	UnprocessedClusters []*UnprocessedCluster `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchUpdateClusterOutput) GoString() string {
	return s.String()
}

// SetProcessedClusters sets the ProcessedClusters field's value.
func (s *BatchUpdateClusterOutput) SetProcessedClusters(v []*Cluster) *BatchUpdateClusterOutput {
	s.ProcessedClusters = v
	return s
}

// SetUnprocessedClusters sets the UnprocessedClusters field's value.
func (s *BatchUpdateClusterOutput) SetUnprocessedClusters(v []*UnprocessedCluster) *BatchUpdateClusterOutput {
	s.UnprocessedClusters = v
	return s
}

// Contains all of the attributes of a specific cluster.
type Cluster struct {
	_ struct{} `type:"structure"`

	// The name of the Access Control List associated with this cluster.
	ACLName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the cluster.
	ARN *string `type:"string"`

	// When set to true, the cluster will automatically receive minor engine version
	// upgrades after launch.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// Indicates if the cluster has a Multi-AZ configuration (multiaz) or not (singleaz).
	AvailabilityMode *string `type:"string" enum:"AZStatus"`

	// The cluster's configuration endpoint
	ClusterEndpoint *Endpoint `type:"structure"`

	// A description of the cluster
	Description *string `type:"string"`

	// The Redis engine patch version used by the cluster
	EnginePatchVersion *string `type:"string"`

	// The Redis engine version used by the cluster
	EngineVersion *string `type:"string"`

	// The ID of the KMS key used to encrypt the cluster
	KmsKeyId *string `type:"string"`

	// Specifies the weekly time range during which maintenance on the cluster is
	// performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi
	// (24H Clock UTC). The minimum maintenance window is a 60 minute period.
	MaintenanceWindow *string `type:"string"`

	// The user-supplied name of the cluster. This identifier is a unique key that
	// identifies a cluster.
	Name *string `type:"string"`

	// The cluster's node type
	NodeType *string `type:"string"`

	// The number of shards in the cluster
	NumberOfShards *int64 `type:"integer"`

	// The name of the parameter group used by the cluster
	ParameterGroupName *string `type:"string"`

	// The status of the parameter group used by the cluster, for example 'active'
	// or 'applying'.
	ParameterGroupStatus *string `type:"string"`

	// A group of settings that are currently being applied.
	PendingUpdates *ClusterPendingUpdates `type:"structure"`

	// A list of security groups used by the cluster
	SecurityGroups []*SecurityGroupMembership `type:"list"`

	// A list of shards that are members of the cluster.
	Shards []*Shard `type:"list"`

	// The number of days for which MemoryDB retains automatic snapshots before
	// deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot
	// that was taken today is retained for 5 days before being deleted.
	SnapshotRetentionLimit *int64 `type:"integer"`

	// The daily time range (in UTC) during which MemoryDB begins taking a daily
	// snapshot of your shard. Example: 05:00-09:00 If you do not specify this parameter,
	// MemoryDB automatically chooses an appropriate time range.
	SnapshotWindow *string `type:"string"`

	// The Amazon Resource Name (ARN) of the SNS notification topic
	SnsTopicArn *string `type:"string"`

	// The SNS topic must be in Active status to receive notifications
	SnsTopicStatus *string `type:"string"`

	// The status of the cluster. For example, Available, Updating, Creating.
	Status *string `type:"string"`

	// The name of the subnet group used by the cluster
	SubnetGroupName *string `type:"string"`

	// A flag to indicate if In-transit encryption is enabled
	TLSEnabled *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cluster) GoString() string {
	return s.String()
}

// SetACLName sets the ACLName field's value.
func (s *Cluster) SetACLName(v string) *Cluster {
	s.ACLName = &v
	return s
}

// SetARN sets the ARN field's value.
func (s *Cluster) SetARN(v string) *Cluster {
	s.ARN = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *Cluster) SetAutoMinorVersionUpgrade(v bool) *Cluster {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAvailabilityMode sets the AvailabilityMode field's value.
func (s *Cluster) SetAvailabilityMode(v string) *Cluster {
	s.AvailabilityMode = &v
	return s
}

// SetClusterEndpoint sets the ClusterEndpoint field's value.
func (s *Cluster) SetClusterEndpoint(v *Endpoint) *Cluster {
	s.ClusterEndpoint = v
	return s
}

// SetDescription sets the Description field's value.
func (s *Cluster) SetDescription(v string) *Cluster {
	s.Description = &v
	return s
}

// SetEnginePatchVersion sets the EnginePatchVersion field's value.
func (s *Cluster) SetEnginePatchVersion(v string) *Cluster {
	s.EnginePatchVersion = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *Cluster) SetEngineVersion(v string) *Cluster {
	s.EngineVersion = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *Cluster) SetKmsKeyId(v string) *Cluster {
	s.KmsKeyId = &v
	return s
}

// SetMaintenanceWindow sets the MaintenanceWindow field's value.
func (s *Cluster) SetMaintenanceWindow(v string) *Cluster {
	s.MaintenanceWindow = &v
	return s
}

// SetName sets the Name field's value.
func (s *Cluster) SetName(v string) *Cluster {
	s.Name = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *Cluster) SetNodeType(v string) *Cluster {
	s.NodeType = &v
	return s
}

// SetNumberOfShards sets the NumberOfShards field's value.
func (s *Cluster) SetNumberOfShards(v int64) *Cluster {
	s.NumberOfShards = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *Cluster) SetParameterGroupName(v string) *Cluster {
	s.ParameterGroupName = &v
	return s
}

// SetParameterGroupStatus sets the ParameterGroupStatus field's value.
func (s *Cluster) SetParameterGroupStatus(v string) *Cluster {
	s.ParameterGroupStatus = &v
	return s
}

// SetPendingUpdates sets the PendingUpdates field's value.
func (s *Cluster) SetPendingUpdates(v *ClusterPendingUpdates) *Cluster {
	s.PendingUpdates = v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *Cluster) SetSecurityGroups(v []*SecurityGroupMembership) *Cluster {
	s.SecurityGroups = v
	return s
}

// SetShards sets the Shards field's value.
func (s *Cluster) SetShards(v []*Shard) *Cluster {
	s.Shards = v
	return s
}

// SetSnapshotRetentionLimit sets the SnapshotRetentionLimit field's value.
func (s *Cluster) SetSnapshotRetentionLimit(v int64) *Cluster {
	s.SnapshotRetentionLimit = &v
	return s
}

// SetSnapshotWindow sets the SnapshotWindow field's value.
func (s *Cluster) SetSnapshotWindow(v string) *Cluster {
	s.SnapshotWindow = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *Cluster) SetSnsTopicArn(v string) *Cluster {
	s.SnsTopicArn = &v
	return s
}

// SetSnsTopicStatus sets the SnsTopicStatus field's value.
func (s *Cluster) SetSnsTopicStatus(v string) *Cluster {
	s.SnsTopicStatus = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Cluster) SetStatus(v string) *Cluster {
	s.Status = &v
	return s
}

// SetSubnetGroupName sets the SubnetGroupName field's value.
func (s *Cluster) SetSubnetGroupName(v string) *Cluster {
	s.SubnetGroupName = &v
	return s
}

// SetTLSEnabled sets the TLSEnabled field's value.
func (s *Cluster) SetTLSEnabled(v bool) *Cluster {
	s.TLSEnabled = &v
	return s
}

type ClusterAlreadyExistsFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterAlreadyExistsFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterAlreadyExistsFault) GoString() string {
	return s.String()
}

func newErrorClusterAlreadyExistsFault(v protocol.ResponseMetadata) error {
	return &ClusterAlreadyExistsFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ClusterAlreadyExistsFault) Code() string {
	return "ClusterAlreadyExistsFault"
}

// Message returns the exception's message.
func (s *ClusterAlreadyExistsFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ClusterAlreadyExistsFault) OrigErr() error {
	return nil
}

func (s *ClusterAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ClusterAlreadyExistsFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ClusterAlreadyExistsFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// A list of cluster configuration options.
type ClusterConfiguration struct {
	_ struct{} `type:"structure"`

	// The description of the cluster configuration
	Description *string `type:"string"`

	// The Redis engine version used by the cluster
	EngineVersion *string `type:"string"`

	// The specified maintenance window for the cluster
	MaintenanceWindow *string `type:"string"`

	// The name of the cluster
	Name *string `type:"string"`

	// The node type used for the cluster
	NodeType *string `type:"string"`

	// The number of shards in the cluster
	NumShards *int64 `type:"integer"`

	// The name of parameter group used by the cluster
	ParameterGroupName *string `type:"string"`

	// The port used by the cluster
	Port *int64 `type:"integer"`

	// The list of shards in the cluster
	Shards []*ShardDetail `type:"list"`

	// The snapshot retention limit set by the cluster
	SnapshotRetentionLimit *int64 `type:"integer"`

	// The snapshot window set by the cluster
	SnapshotWindow *string `type:"string"`

	// The name of the subnet group used by the cluster
	SubnetGroupName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the SNS notification topic for the cluster
	TopicArn *string `type:"string"`

	// The ID of the VPC the cluster belongs to
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterConfiguration) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ClusterConfiguration) SetDescription(v string) *ClusterConfiguration {
	s.Description = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *ClusterConfiguration) SetEngineVersion(v string) *ClusterConfiguration {
	s.EngineVersion = &v
	return s
}

// SetMaintenanceWindow sets the MaintenanceWindow field's value.
func (s *ClusterConfiguration) SetMaintenanceWindow(v string) *ClusterConfiguration {
	s.MaintenanceWindow = &v
	return s
}

// SetName sets the Name field's value.
func (s *ClusterConfiguration) SetName(v string) *ClusterConfiguration {
	s.Name = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *ClusterConfiguration) SetNodeType(v string) *ClusterConfiguration {
	s.NodeType = &v
	return s
}

// SetNumShards sets the NumShards field's value.
func (s *ClusterConfiguration) SetNumShards(v int64) *ClusterConfiguration {
	s.NumShards = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *ClusterConfiguration) SetParameterGroupName(v string) *ClusterConfiguration {
	s.ParameterGroupName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *ClusterConfiguration) SetPort(v int64) *ClusterConfiguration {
	s.Port = &v
	return s
}

// SetShards sets the Shards field's value.
func (s *ClusterConfiguration) SetShards(v []*ShardDetail) *ClusterConfiguration {
	s.Shards = v
	return s
}

// SetSnapshotRetentionLimit sets the SnapshotRetentionLimit field's value.
func (s *ClusterConfiguration) SetSnapshotRetentionLimit(v int64) *ClusterConfiguration {
	s.SnapshotRetentionLimit = &v
	return s
}

// SetSnapshotWindow sets the SnapshotWindow field's value.
func (s *ClusterConfiguration) SetSnapshotWindow(v string) *ClusterConfiguration {
	s.SnapshotWindow = &v
	return s
}

// SetSubnetGroupName sets the SubnetGroupName field's value.
func (s *ClusterConfiguration) SetSubnetGroupName(v string) *ClusterConfiguration {
	s.SubnetGroupName = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *ClusterConfiguration) SetTopicArn(v string) *ClusterConfiguration {
	s.TopicArn = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *ClusterConfiguration) SetVpcId(v string) *ClusterConfiguration {
	s.VpcId = &v
	return s
}

type ClusterNotFoundFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterNotFoundFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterNotFoundFault) GoString() string {
	return s.String()
}

func newErrorClusterNotFoundFault(v protocol.ResponseMetadata) error {
	return &ClusterNotFoundFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ClusterNotFoundFault) Code() string {
	return "ClusterNotFoundFault"
}

// Message returns the exception's message.
func (s *ClusterNotFoundFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ClusterNotFoundFault) OrigErr() error {
	return nil
}

func (s *ClusterNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ClusterNotFoundFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ClusterNotFoundFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// A list of updates being applied to the cluster
type ClusterPendingUpdates struct {
	_ struct{} `type:"structure"`

	// A list of ACLs associated with the cluster that are being updated
	ACLs *ACLsUpdateStatus `type:"structure"`

	// The status of an online resharding operation.
	Resharding *ReshardingStatus `type:"structure"`

	// A list of service updates being applied to the cluster
	ServiceUpdates []*PendingModifiedServiceUpdate `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterPendingUpdates) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterPendingUpdates) GoString() string {
	return s.String()
}

// SetACLs sets the ACLs field's value.
func (s *ClusterPendingUpdates) SetACLs(v *ACLsUpdateStatus) *ClusterPendingUpdates {
	s.ACLs = v
	return s
}

// SetResharding sets the Resharding field's value.
func (s *ClusterPendingUpdates) SetResharding(v *ReshardingStatus) *ClusterPendingUpdates {
	s.Resharding = v
	return s
}

// SetServiceUpdates sets the ServiceUpdates field's value.
func (s *ClusterPendingUpdates) SetServiceUpdates(v []*PendingModifiedServiceUpdate) *ClusterPendingUpdates {
	s.ServiceUpdates = v
	return s
}

type ClusterQuotaForCustomerExceededFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterQuotaForCustomerExceededFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterQuotaForCustomerExceededFault) GoString() string {
	return s.String()
}

func newErrorClusterQuotaForCustomerExceededFault(v protocol.ResponseMetadata) error {
	return &ClusterQuotaForCustomerExceededFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ClusterQuotaForCustomerExceededFault) Code() string {
	return "ClusterQuotaForCustomerExceededFault"
}

// Message returns the exception's message.
func (s *ClusterQuotaForCustomerExceededFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ClusterQuotaForCustomerExceededFault) OrigErr() error {
	return nil
}

func (s *ClusterQuotaForCustomerExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ClusterQuotaForCustomerExceededFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ClusterQuotaForCustomerExceededFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type CopySnapshotInput struct {
	_ struct{} `type:"structure"`

	// The ID of the KMS key used to encrypt the target snapshot.
	KmsKeyId *string `type:"string"`

	// The name of an existing snapshot from which to make a copy.
	//
	// SourceSnapshotName is a required field
	SourceSnapshotName *string `type:"string" required:"true"`

	// A list of tags to be added to this resource. A tag is a key-value pair. A
	// tag key must be accompanied by a tag value, although null is accepted.
	Tags []*Tag `type:"list"`

	// The Amazon S3 bucket to which the snapshot is exported. This parameter is
	// used only when exporting a snapshot for external access. When using this
	// parameter to export a snapshot, be sure MemoryDB has the needed permissions
	// to this S3 bucket. For more information, see Step 2: Grant MemoryDB Access
	// to Your Amazon S3 Bucket (https://docs.aws.amazon.com/MemoryDB/latest/devguide/snapshots-exporting.html).
	TargetBucket *string `type:"string"`

	// A name for the snapshot copy. MemoryDB does not permit overwriting a snapshot,
	// therefore this name must be unique within its context - MemoryDB or an Amazon
	// S3 bucket if exporting.
	//
	// TargetSnapshotName is a required field
	TargetSnapshotName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopySnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopySnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopySnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopySnapshotInput"}
	if s.SourceSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceSnapshotName"))
	}
	if s.TargetSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CopySnapshotInput) SetKmsKeyId(v string) *CopySnapshotInput {
	s.KmsKeyId = &v
	return s
}

// SetSourceSnapshotName sets the SourceSnapshotName field's value.
func (s *CopySnapshotInput) SetSourceSnapshotName(v string) *CopySnapshotInput {
	s.SourceSnapshotName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CopySnapshotInput) SetTags(v []*Tag) *CopySnapshotInput {
	s.Tags = v
	return s
}

// SetTargetBucket sets the TargetBucket field's value.
func (s *CopySnapshotInput) SetTargetBucket(v string) *CopySnapshotInput {
	s.TargetBucket = &v
	return s
}

// SetTargetSnapshotName sets the TargetSnapshotName field's value.
func (s *CopySnapshotInput) SetTargetSnapshotName(v string) *CopySnapshotInput {
	s.TargetSnapshotName = &v
	return s
}

type CopySnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Represents a copy of an entire cluster as of the time when the snapshot was
	// taken.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopySnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopySnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *CopySnapshotOutput) SetSnapshot(v *Snapshot) *CopySnapshotOutput {
	s.Snapshot = v
	return s
}

type CreateACLInput struct {
	_ struct{} `type:"structure"`

	// The name of the Access Control List.
	//
	// ACLName is a required field
	ACLName *string `type:"string" required:"true"`

	// A list of tags to be added to this resource. A tag is a key-value pair. A
	// tag key must be accompanied by a tag value, although null is accepted.
	Tags []*Tag `type:"list"`

	// The list of users that belong to the Access Control List.
	UserNames []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateACLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateACLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateACLInput"}
	if s.ACLName == nil {
		invalidParams.Add(request.NewErrParamRequired("ACLName"))
	}
	if s.UserNames != nil && len(s.UserNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserNames", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACLName sets the ACLName field's value.
func (s *CreateACLInput) SetACLName(v string) *CreateACLInput {
	s.ACLName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateACLInput) SetTags(v []*Tag) *CreateACLInput {
	s.Tags = v
	return s
}

// SetUserNames sets the UserNames field's value.
func (s *CreateACLInput) SetUserNames(v []*string) *CreateACLInput {
	s.UserNames = v
	return s
}

type CreateACLOutput struct {
	_ struct{} `type:"structure"`

	// The newly-created Access Control List.
	ACL *ACL `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateACLOutput) GoString() string {
	return s.String()
}

// SetACL sets the ACL field's value.
func (s *CreateACLOutput) SetACL(v *ACL) *CreateACLOutput {
	s.ACL = v
	return s
}

type CreateClusterInput struct {
	_ struct{} `type:"structure"`

	// The name of the Access Control List to associate with the cluster.
	//
	// ACLName is a required field
	ACLName *string `min:"1" type:"string" required:"true"`

	// When set to true, the cluster will automatically receive minor engine version
	// upgrades after launch.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The name of the cluster. This value must be unique as it also serves as the
	// cluster identifier.
	//
	// ClusterName is a required field
	ClusterName *string `type:"string" required:"true"`

	// An optional description of the cluster.
	Description *string `type:"string"`

	// The version number of the Redis engine to be used for the cluster.
	EngineVersion *string `type:"string"`

	// The ID of the KMS key used to encrypt the cluster.
	KmsKeyId *string `type:"string"`

	// Specifies the weekly time range during which maintenance on the cluster is
	// performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi
	// (24H Clock UTC). The minimum maintenance window is a 60 minute period.
	MaintenanceWindow *string `type:"string"`

	// The compute and memory capacity of the nodes in the cluster.
	//
	// NodeType is a required field
	NodeType *string `type:"string" required:"true"`

	// The number of replicas to apply to each shard. The default value is 1. The
	// maximum is 5.
	NumReplicasPerShard *int64 `type:"integer"`

	// The number of shards the cluster will contain. The default value is 1.
	NumShards *int64 `type:"integer"`

	// The name of the parameter group associated with the cluster.
	ParameterGroupName *string `type:"string"`

	// The port number on which each of the nodes accepts connections.
	Port *int64 `type:"integer"`

	// A list of security group names to associate with this cluster.
	SecurityGroupIds []*string `type:"list"`

	// A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot
	// files stored in Amazon S3. The snapshot files are used to populate the new
	// cluster. The Amazon S3 object name in the ARN cannot contain any commas.
	SnapshotArns []*string `type:"list"`

	// The name of a snapshot from which to restore data into the new cluster. The
	// snapshot status changes to restoring while the new cluster is being created.
	SnapshotName *string `type:"string"`

	// The number of days for which MemoryDB retains automatic snapshots before
	// deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot
	// that was taken today is retained for 5 days before being deleted.
	SnapshotRetentionLimit *int64 `type:"integer"`

	// The daily time range (in UTC) during which MemoryDB begins taking a daily
	// snapshot of your shard.
	//
	// Example: 05:00-09:00
	//
	// If you do not specify this parameter, MemoryDB automatically chooses an appropriate
	// time range.
	SnapshotWindow *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
	// (SNS) topic to which notifications are sent.
	SnsTopicArn *string `type:"string"`

	// The name of the subnet group to be used for the cluster.
	SubnetGroupName *string `type:"string"`

	// A flag to enable in-transit encryption on the cluster.
	TLSEnabled *bool `type:"boolean"`

	// A list of tags to be added to this resource. Tags are comma-separated key,value
	// pairs (e.g. Key=myKey, Value=myKeyValue. You can include multiple tags as
	// shown following: Key=myKey, Value=myKeyValue Key=mySecondKey, Value=mySecondKeyValue.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterInput"}
	if s.ACLName == nil {
		invalidParams.Add(request.NewErrParamRequired("ACLName"))
	}
	if s.ACLName != nil && len(*s.ACLName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ACLName", 1))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.NodeType == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACLName sets the ACLName field's value.
func (s *CreateClusterInput) SetACLName(v string) *CreateClusterInput {
	s.ACLName = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *CreateClusterInput) SetAutoMinorVersionUpgrade(v bool) *CreateClusterInput {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateClusterInput) SetClusterName(v string) *CreateClusterInput {
	s.ClusterName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateClusterInput) SetDescription(v string) *CreateClusterInput {
	s.Description = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CreateClusterInput) SetEngineVersion(v string) *CreateClusterInput {
	s.EngineVersion = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateClusterInput) SetKmsKeyId(v string) *CreateClusterInput {
	s.KmsKeyId = &v
	return s
}

// SetMaintenanceWindow sets the MaintenanceWindow field's value.
func (s *CreateClusterInput) SetMaintenanceWindow(v string) *CreateClusterInput {
	s.MaintenanceWindow = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *CreateClusterInput) SetNodeType(v string) *CreateClusterInput {
	s.NodeType = &v
	return s
}

// SetNumReplicasPerShard sets the NumReplicasPerShard field's value.
func (s *CreateClusterInput) SetNumReplicasPerShard(v int64) *CreateClusterInput {
	s.NumReplicasPerShard = &v
	return s
}

// SetNumShards sets the NumShards field's value.
func (s *CreateClusterInput) SetNumShards(v int64) *CreateClusterInput {
	s.NumShards = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *CreateClusterInput) SetParameterGroupName(v string) *CreateClusterInput {
	s.ParameterGroupName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CreateClusterInput) SetPort(v int64) *CreateClusterInput {
	s.Port = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateClusterInput) SetSecurityGroupIds(v []*string) *CreateClusterInput {
	s.SecurityGroupIds = v
	return s
}

// SetSnapshotArns sets the SnapshotArns field's value.
func (s *CreateClusterInput) SetSnapshotArns(v []*string) *CreateClusterInput {
	s.SnapshotArns = v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *CreateClusterInput) SetSnapshotName(v string) *CreateClusterInput {
	s.SnapshotName = &v
	return s
}

// SetSnapshotRetentionLimit sets the SnapshotRetentionLimit field's value.
func (s *CreateClusterInput) SetSnapshotRetentionLimit(v int64) *CreateClusterInput {
	s.SnapshotRetentionLimit = &v
	return s
}

// SetSnapshotWindow sets the SnapshotWindow field's value.
func (s *CreateClusterInput) SetSnapshotWindow(v string) *CreateClusterInput {
	s.SnapshotWindow = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *CreateClusterInput) SetSnsTopicArn(v string) *CreateClusterInput {
	s.SnsTopicArn = &v
	return s
}

// SetSubnetGroupName sets the SubnetGroupName field's value.
func (s *CreateClusterInput) SetSubnetGroupName(v string) *CreateClusterInput {
	s.SubnetGroupName = &v
	return s
}

// SetTLSEnabled sets the TLSEnabled field's value.
func (s *CreateClusterInput) SetTLSEnabled(v bool) *CreateClusterInput {
	s.TLSEnabled = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterInput) SetTags(v []*Tag) *CreateClusterInput {
	s.Tags = v
	return s
}

type CreateClusterOutput struct {
	_ struct{} `type:"structure"`

	// The newly-created cluster.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *CreateClusterOutput) SetCluster(v *Cluster) *CreateClusterOutput {
	s.Cluster = v
	return s
}

type CreateParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// An optional description of the parameter group.
	Description *string `type:"string"`

	// The name of the parameter group family that the parameter group can be used
	// with.
	//
	// Family is a required field
	Family *string `type:"string" required:"true"`

	// The name of the parameter group.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`

	// A list of tags to be added to this resource. A tag is a key-value pair. A
	// tag key must be accompanied by a tag value, although null is accepted.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateParameterGroupInput"}
	if s.Family == nil {
		invalidParams.Add(request.NewErrParamRequired("Family"))
	}
	if s.ParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateParameterGroupInput) SetDescription(v string) *CreateParameterGroupInput {
	s.Description = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *CreateParameterGroupInput) SetFamily(v string) *CreateParameterGroupInput {
	s.Family = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *CreateParameterGroupInput) SetParameterGroupName(v string) *CreateParameterGroupInput {
	s.ParameterGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateParameterGroupInput) SetTags(v []*Tag) *CreateParameterGroupInput {
	s.Tags = v
	return s
}

type CreateParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// The newly-created parameter group.
	ParameterGroup *ParameterGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParameterGroupOutput) GoString() string {
	return s.String()
}

// SetParameterGroup sets the ParameterGroup field's value.
func (s *CreateParameterGroupOutput) SetParameterGroup(v *ParameterGroup) *CreateParameterGroupOutput {
	s.ParameterGroup = v
	return s
}

type CreateSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The snapshot is created from this cluster.
	//
	// ClusterName is a required field
	ClusterName *string `type:"string" required:"true"`

	// The ID of the KMS key used to encrypt the snapshot.
	KmsKeyId *string `type:"string"`

	// A name for the snapshot being created.
	//
	// SnapshotName is a required field
	SnapshotName *string `type:"string" required:"true"`

	// A list of tags to be added to this resource. A tag is a key-value pair. A
	// tag key must be accompanied by a tag value, although null is accepted.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSnapshotInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.SnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateSnapshotInput) SetClusterName(v string) *CreateSnapshotInput {
	s.ClusterName = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateSnapshotInput) SetKmsKeyId(v string) *CreateSnapshotInput {
	s.KmsKeyId = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *CreateSnapshotInput) SetSnapshotName(v string) *CreateSnapshotInput {
	s.SnapshotName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSnapshotInput) SetTags(v []*Tag) *CreateSnapshotInput {
	s.Tags = v
	return s
}

type CreateSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The newly-created snapshot.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *CreateSnapshotOutput) SetSnapshot(v *Snapshot) *CreateSnapshotOutput {
	s.Snapshot = v
	return s
}

type CreateSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// A description for the subnet group.
	Description *string `type:"string"`

	// The name of the subnet group.
	//
	// SubnetGroupName is a required field
	SubnetGroupName *string `type:"string" required:"true"`

	// A list of VPC subnet IDs for the subnet group.
	//
	// SubnetIds is a required field
	SubnetIds []*string `type:"list" required:"true"`

	// A list of tags to be added to this resource. A tag is a key-value pair. A
	// tag key must be accompanied by a tag value, although null is accepted.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSubnetGroupInput"}
	if s.SubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetGroupName"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateSubnetGroupInput) SetDescription(v string) *CreateSubnetGroupInput {
	s.Description = &v
	return s
}

// SetSubnetGroupName sets the SubnetGroupName field's value.
func (s *CreateSubnetGroupInput) SetSubnetGroupName(v string) *CreateSubnetGroupInput {
	s.SubnetGroupName = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateSubnetGroupInput) SetSubnetIds(v []*string) *CreateSubnetGroupInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSubnetGroupInput) SetTags(v []*Tag) *CreateSubnetGroupInput {
	s.Tags = v
	return s
}

type CreateSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The newly-created subnet group
	SubnetGroup *SubnetGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetSubnetGroup sets the SubnetGroup field's value.
func (s *CreateSubnetGroupOutput) SetSubnetGroup(v *SubnetGroup) *CreateSubnetGroupOutput {
	s.SubnetGroup = v
	return s
}

type CreateUserInput struct {
	_ struct{} `type:"structure"`

	// Access permissions string used for this user.
	//
	// AccessString is a required field
	AccessString *string `type:"string" required:"true"`

	// Denotes the user's authentication properties, such as whether it requires
	// a password to authenticate.
	//
	// AuthenticationMode is a required field
	AuthenticationMode *AuthenticationMode `type:"structure" required:"true"`

	// A list of tags to be added to this resource. A tag is a key-value pair. A
	// tag key must be accompanied by a tag value, although null is accepted.
	Tags []*Tag `type:"list"`

	// The name of the user. This value must be unique as it also serves as the
	// user identifier.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserInput"}
	if s.AccessString == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessString"))
	}
	if s.AuthenticationMode == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationMode"))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}
	if s.AuthenticationMode != nil {
		if err := s.AuthenticationMode.Validate(); err != nil {
			invalidParams.AddNested("AuthenticationMode", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessString sets the AccessString field's value.
func (s *CreateUserInput) SetAccessString(v string) *CreateUserInput {
	s.AccessString = &v
	return s
}

// SetAuthenticationMode sets the AuthenticationMode field's value.
func (s *CreateUserInput) SetAuthenticationMode(v *AuthenticationMode) *CreateUserInput {
	s.AuthenticationMode = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateUserInput) SetTags(v []*Tag) *CreateUserInput {
	s.Tags = v
	return s
}

// SetUserName sets the UserName field's value.
func (s *CreateUserInput) SetUserName(v string) *CreateUserInput {
	s.UserName = &v
	return s
}

type CreateUserOutput struct {
	_ struct{} `type:"structure"`

	// The newly-created user.
	User *User `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserOutput) GoString() string {
	return s.String()
}

// SetUser sets the User field's value.
func (s *CreateUserOutput) SetUser(v *User) *CreateUserOutput {
	s.User = v
	return s
}

type DefaultUserRequired struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultUserRequired) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultUserRequired) GoString() string {
	return s.String()
}

func newErrorDefaultUserRequired(v protocol.ResponseMetadata) error {
	return &DefaultUserRequired{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DefaultUserRequired) Code() string {
	return "DefaultUserRequired"
}

// Message returns the exception's message.
func (s *DefaultUserRequired) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DefaultUserRequired) OrigErr() error {
	return nil
}

func (s *DefaultUserRequired) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DefaultUserRequired) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DefaultUserRequired) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeleteACLInput struct {
	_ struct{} `type:"structure"`

	// The name of the Access Control List to delete
	//
	// ACLName is a required field
	ACLName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteACLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteACLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteACLInput"}
	if s.ACLName == nil {
		invalidParams.Add(request.NewErrParamRequired("ACLName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACLName sets the ACLName field's value.
func (s *DeleteACLInput) SetACLName(v string) *DeleteACLInput {
	s.ACLName = &v
	return s
}

type DeleteACLOutput struct {
	_ struct{} `type:"structure"`

	// The Access Control List object that has been deleted.
	ACL *ACL `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteACLOutput) GoString() string {
	return s.String()
}

// SetACL sets the ACL field's value.
func (s *DeleteACLOutput) SetACL(v *ACL) *DeleteACLOutput {
	s.ACL = v
	return s
}

type DeleteClusterInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster to be deleted
	//
	// ClusterName is a required field
	ClusterName *string `type:"string" required:"true"`

	// The user-supplied name of a final cluster snapshot. This is the unique name
	// that identifies the snapshot. MemoryDB creates the snapshot, and then deletes
	// the cluster immediately afterward.
	FinalSnapshotName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *DeleteClusterInput) SetClusterName(v string) *DeleteClusterInput {
	s.ClusterName = &v
	return s
}

// SetFinalSnapshotName sets the FinalSnapshotName field's value.
func (s *DeleteClusterInput) SetFinalSnapshotName(v string) *DeleteClusterInput {
	s.FinalSnapshotName = &v
	return s
}

type DeleteClusterOutput struct {
	_ struct{} `type:"structure"`

	// The cluster object that has been deleted
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *DeleteClusterOutput) SetCluster(v *Cluster) *DeleteClusterOutput {
	s.Cluster = v
	return s
}

type DeleteParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the parameter group to delete.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteParameterGroupInput"}
	if s.ParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *DeleteParameterGroupInput) SetParameterGroupName(v string) *DeleteParameterGroupInput {
	s.ParameterGroupName = &v
	return s
}

type DeleteParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// The parameter group that has been deleted.
	ParameterGroup *ParameterGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteParameterGroupOutput) GoString() string {
	return s.String()
}

// SetParameterGroup sets the ParameterGroup field's value.
func (s *DeleteParameterGroupOutput) SetParameterGroup(v *ParameterGroup) *DeleteParameterGroupOutput {
	s.ParameterGroup = v
	return s
}

type DeleteSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the snapshot to delete
	//
	// SnapshotName is a required field
	SnapshotName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSnapshotInput"}
	if s.SnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *DeleteSnapshotInput) SetSnapshotName(v string) *DeleteSnapshotInput {
	s.SnapshotName = &v
	return s
}

type DeleteSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The snapshot object that has been deleted.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *DeleteSnapshotOutput) SetSnapshot(v *Snapshot) *DeleteSnapshotOutput {
	s.Snapshot = v
	return s
}

type DeleteSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the subnet group to delete
	//
	// SubnetGroupName is a required field
	SubnetGroupName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSubnetGroupInput"}
	if s.SubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubnetGroupName sets the SubnetGroupName field's value.
func (s *DeleteSubnetGroupInput) SetSubnetGroupName(v string) *DeleteSubnetGroupInput {
	s.SubnetGroupName = &v
	return s
}

type DeleteSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The subnet group object that has been deleted.
	SubnetGroup *SubnetGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetSubnetGroup sets the SubnetGroup field's value.
func (s *DeleteSubnetGroupOutput) SetSubnetGroup(v *SubnetGroup) *DeleteSubnetGroupOutput {
	s.SubnetGroup = v
	return s
}

type DeleteUserInput struct {
	_ struct{} `type:"structure"`

	// The name of the user to delete
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserInput"}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserName sets the UserName field's value.
func (s *DeleteUserInput) SetUserName(v string) *DeleteUserInput {
	s.UserName = &v
	return s
}

type DeleteUserOutput struct {
	_ struct{} `type:"structure"`

	// The user object that has been deleted.
	User *User `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

// SetUser sets the User field's value.
func (s *DeleteUserOutput) SetUser(v *User) *DeleteUserOutput {
	s.User = v
	return s
}

type DescribeACLsInput struct {
	_ struct{} `type:"structure"`

	// The name of the ACL
	ACLName *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `type:"integer"`

	// An optional argument to pass in case the total number of records exceeds
	// the value of MaxResults. If nextToken is returned, there are more results
	// available. The value of nextToken is a unique pagination token for each page.
	// Make the call again using the returned token to retrieve the next page. Keep
	// all other arguments unchanged.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeACLsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeACLsInput) GoString() string {
	return s.String()
}

// SetACLName sets the ACLName field's value.
func (s *DescribeACLsInput) SetACLName(v string) *DescribeACLsInput {
	s.ACLName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeACLsInput) SetMaxResults(v int64) *DescribeACLsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeACLsInput) SetNextToken(v string) *DescribeACLsInput {
	s.NextToken = &v
	return s
}

type DescribeACLsOutput struct {
	_ struct{} `type:"structure"`

	// The list of ACLs
	ACLs []*ACL `type:"list"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeACLsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeACLsOutput) GoString() string {
	return s.String()
}

// SetACLs sets the ACLs field's value.
func (s *DescribeACLsOutput) SetACLs(v []*ACL) *DescribeACLsOutput {
	s.ACLs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeACLsOutput) SetNextToken(v string) *DescribeACLsOutput {
	s.NextToken = &v
	return s
}

type DescribeClustersInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster
	ClusterName *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `type:"integer"`

	// An optional argument to pass in case the total number of records exceeds
	// the value of MaxResults. If nextToken is returned, there are more results
	// available. The value of nextToken is a unique pagination token for each page.
	// Make the call again using the returned token to retrieve the next page. Keep
	// all other arguments unchanged.
	NextToken *string `type:"string"`

	// An optional flag that can be included in the request to retrieve information
	// about the individual shard(s).
	ShowShardDetails *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClustersInput) GoString() string {
	return s.String()
}

// SetClusterName sets the ClusterName field's value.
func (s *DescribeClustersInput) SetClusterName(v string) *DescribeClustersInput {
	s.ClusterName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeClustersInput) SetMaxResults(v int64) *DescribeClustersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeClustersInput) SetNextToken(v string) *DescribeClustersInput {
	s.NextToken = &v
	return s
}

// SetShowShardDetails sets the ShowShardDetails field's value.
func (s *DescribeClustersInput) SetShowShardDetails(v bool) *DescribeClustersInput {
	s.ShowShardDetails = &v
	return s
}

type DescribeClustersOutput struct {
	_ struct{} `type:"structure"`

	// A list of clusters
	Clusters []*Cluster `type:"list"`

	// An optional argument to pass in case the total number of records exceeds
	// the value of MaxResults. If nextToken is returned, there are more results
	// available. The value of nextToken is a unique pagination token for each page.
	// Make the call again using the returned token to retrieve the next page. Keep
	// all other arguments unchanged.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClustersOutput) GoString() string {
	return s.String()
}

// SetClusters sets the Clusters field's value.
func (s *DescribeClustersOutput) SetClusters(v []*Cluster) *DescribeClustersOutput {
	s.Clusters = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeClustersOutput) SetNextToken(v string) *DescribeClustersOutput {
	s.NextToken = &v
	return s
}

type DescribeEngineVersionsInput struct {
	_ struct{} `type:"structure"`

	// If true, specifies that only the default version of the specified engine
	// or engine and major version combination is to be returned.
	DefaultOnly *bool `type:"boolean"`

	// The Redis engine version
	EngineVersion *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `type:"integer"`

	// An optional argument to pass in case the total number of records exceeds
	// the value of MaxResults. If nextToken is returned, there are more results
	// available. The value of nextToken is a unique pagination token for each page.
	// Make the call again using the returned token to retrieve the next page. Keep
	// all other arguments unchanged.
	NextToken *string `type:"string"`

	// The name of a specific parameter group family to return details for.
	ParameterGroupFamily *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEngineVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEngineVersionsInput) GoString() string {
	return s.String()
}

// SetDefaultOnly sets the DefaultOnly field's value.
func (s *DescribeEngineVersionsInput) SetDefaultOnly(v bool) *DescribeEngineVersionsInput {
	s.DefaultOnly = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *DescribeEngineVersionsInput) SetEngineVersion(v string) *DescribeEngineVersionsInput {
	s.EngineVersion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeEngineVersionsInput) SetMaxResults(v int64) *DescribeEngineVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEngineVersionsInput) SetNextToken(v string) *DescribeEngineVersionsInput {
	s.NextToken = &v
	return s
}

// SetParameterGroupFamily sets the ParameterGroupFamily field's value.
func (s *DescribeEngineVersionsInput) SetParameterGroupFamily(v string) *DescribeEngineVersionsInput {
	s.ParameterGroupFamily = &v
	return s
}

type DescribeEngineVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of engine version details. Each element in the list contains detailed
	// information about one engine version.
	EngineVersions []*EngineVersionInfo `type:"list"`

	// An optional argument to pass in case the total number of records exceeds
	// the value of MaxResults. If nextToken is returned, there are more results
	// available. The value of nextToken is a unique pagination token for each page.
	// Make the call again using the returned token to retrieve the next page. Keep
	// all other arguments unchanged.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEngineVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEngineVersionsOutput) GoString() string {
	return s.String()
}

// SetEngineVersions sets the EngineVersions field's value.
func (s *DescribeEngineVersionsOutput) SetEngineVersions(v []*EngineVersionInfo) *DescribeEngineVersionsOutput {
	s.EngineVersions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEngineVersionsOutput) SetNextToken(v string) *DescribeEngineVersionsOutput {
	s.NextToken = &v
	return s
}

type DescribeEventsInput struct {
	_ struct{} `type:"structure"`

	// The number of minutes worth of events to retrieve.
	Duration *int64 `type:"integer"`

	// The end of the time interval for which to retrieve events, specified in ISO
	// 8601 format. Example: 2017-03-30T07:03:49.555Z
	EndTime *time.Time `type:"timestamp"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `type:"integer"`

	// An optional argument to pass in case the total number of records exceeds
	// the value of MaxResults. If nextToken is returned, there are more results
	// available. The value of nextToken is a unique pagination token for each page.
	// Make the call again using the returned token to retrieve the next page. Keep
	// all other arguments unchanged.
	NextToken *string `type:"string"`

	// The identifier of the event source for which events are returned. If not
	// specified, all sources are included in the response.
	SourceName *string `type:"string"`

	// The event source to retrieve events for. If no value is specified, all events
	// are returned.
	SourceType *string `type:"string" enum:"SourceType"`

	// The beginning of the time interval to retrieve events for, specified in ISO
	// 8601 format. Example: 2017-03-30T07:03:49.555Z
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventsInput) GoString() string {
	return s.String()
}

// SetDuration sets the Duration field's value.
func (s *DescribeEventsInput) SetDuration(v int64) *DescribeEventsInput {
	s.Duration = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeEventsInput) SetEndTime(v time.Time) *DescribeEventsInput {
	s.EndTime = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeEventsInput) SetMaxResults(v int64) *DescribeEventsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEventsInput) SetNextToken(v string) *DescribeEventsInput {
	s.NextToken = &v
	return s
}

// SetSourceName sets the SourceName field's value.
func (s *DescribeEventsInput) SetSourceName(v string) *DescribeEventsInput {
	s.SourceName = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *DescribeEventsInput) SetSourceType(v string) *DescribeEventsInput {
	s.SourceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeEventsInput) SetStartTime(v time.Time) *DescribeEventsInput {
	s.StartTime = &v
	return s
}

type DescribeEventsOutput struct {
	_ struct{} `type:"structure"`

	// A list of events. Each element in the list contains detailed information
	// about one event.
	Events []*Event `type:"list"`

	// An optional argument to pass in case the total number of records exceeds
	// the value of MaxResults. If nextToken is returned, there are more results
	// available. The value of nextToken is a unique pagination token for each page.
	// Make the call again using the returned token to retrieve the next page. Keep
	// all other arguments unchanged.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *DescribeEventsOutput) SetEvents(v []*Event) *DescribeEventsOutput {
	s.Events = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEventsOutput) SetNextToken(v string) *DescribeEventsOutput {
	s.NextToken = &v
	return s
}

type DescribeParameterGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `type:"integer"`

	// An optional argument to pass in case the total number of records exceeds
	// the value of MaxResults. If nextToken is returned, there are more results
	// available. The value of nextToken is a unique pagination token for each page.
	// Make the call again using the returned token to retrieve the next page. Keep
	// all other arguments unchanged.
	NextToken *string `type:"string"`

	// The name of a specific parameter group to return details for.
	ParameterGroupName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeParameterGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeParameterGroupsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeParameterGroupsInput) SetMaxResults(v int64) *DescribeParameterGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeParameterGroupsInput) SetNextToken(v string) *DescribeParameterGroupsInput {
	s.NextToken = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *DescribeParameterGroupsInput) SetParameterGroupName(v string) *DescribeParameterGroupsInput {
	s.ParameterGroupName = &v
	return s
}

type DescribeParameterGroupsOutput struct {
	_ struct{} `type:"structure"`

	// An optional argument to pass in case the total number of records exceeds
	// the value of MaxResults. If nextToken is returned, there are more results
	// available. The value of nextToken is a unique pagination token for each page.
	// Make the call again using the returned token to retrieve the next page. Keep
	// all other arguments unchanged.
	NextToken *string `type:"string"`

	// A list of parameter groups. Each element in the list contains detailed information
	// about one parameter group.
	ParameterGroups []*ParameterGroup `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeParameterGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeParameterGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeParameterGroupsOutput) SetNextToken(v string) *DescribeParameterGroupsOutput {
	s.NextToken = &v
	return s
}

// SetParameterGroups sets the ParameterGroups field's value.
func (s *DescribeParameterGroupsOutput) SetParameterGroups(v []*ParameterGroup) *DescribeParameterGroupsOutput {
	s.ParameterGroups = v
	return s
}

type DescribeParametersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `type:"integer"`

	// An optional argument to pass in case the total number of records exceeds
	// the value of MaxResults. If nextToken is returned, there are more results
	// available. The value of nextToken is a unique pagination token for each page.
	// Make the call again using the returned token to retrieve the next page. Keep
	// all other arguments unchanged.
	NextToken *string `type:"string"`

	// he name of a specific parameter group to return details for.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeParametersInput"}
	if s.ParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeParametersInput) SetMaxResults(v int64) *DescribeParametersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeParametersInput) SetNextToken(v string) *DescribeParametersInput {
	s.NextToken = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *DescribeParametersInput) SetParameterGroupName(v string) *DescribeParametersInput {
	s.ParameterGroupName = &v
	return s
}

type DescribeParametersOutput struct {
	_ struct{} `type:"structure"`

	// An optional argument to pass in case the total number of records exceeds
	// the value of MaxResults. If nextToken is returned, there are more results
	// available. The value of nextToken is a unique pagination token for each page.
	// Make the call again using the returned token to retrieve the next page. Keep
	// all other arguments unchanged.
	NextToken *string `type:"string"`

	// A list of parameters specific to a particular parameter group. Each element
	// in the list contains detailed information about one parameter.
	Parameters []*Parameter `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeParametersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeParametersOutput) SetNextToken(v string) *DescribeParametersOutput {
	s.NextToken = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DescribeParametersOutput) SetParameters(v []*Parameter) *DescribeParametersOutput {
	s.Parameters = v
	return s
}

type DescribeServiceUpdatesInput struct {
	_ struct{} `type:"structure"`

	// The list of cluster names to identify service updates to apply
	ClusterNames []*string `type:"list"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `type:"integer"`

	// An optional argument to pass in case the total number of records exceeds
	// the value of MaxResults. If nextToken is returned, there are more results
	// available. The value of nextToken is a unique pagination token for each page.
	// Make the call again using the returned token to retrieve the next page. Keep
	// all other arguments unchanged.
	NextToken *string `type:"string"`

	// The unique ID of the service update to describe.
	ServiceUpdateName *string `type:"string"`

	// The status(es) of the service updates to filter on
	Status []*string `type:"list" enum:"ServiceUpdateStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeServiceUpdatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeServiceUpdatesInput) GoString() string {
	return s.String()
}

// SetClusterNames sets the ClusterNames field's value.
func (s *DescribeServiceUpdatesInput) SetClusterNames(v []*string) *DescribeServiceUpdatesInput {
	s.ClusterNames = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeServiceUpdatesInput) SetMaxResults(v int64) *DescribeServiceUpdatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeServiceUpdatesInput) SetNextToken(v string) *DescribeServiceUpdatesInput {
	s.NextToken = &v
	return s
}

// SetServiceUpdateName sets the ServiceUpdateName field's value.
func (s *DescribeServiceUpdatesInput) SetServiceUpdateName(v string) *DescribeServiceUpdatesInput {
	s.ServiceUpdateName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeServiceUpdatesInput) SetStatus(v []*string) *DescribeServiceUpdatesInput {
	s.Status = v
	return s
}

type DescribeServiceUpdatesOutput struct {
	_ struct{} `type:"structure"`

	// An optional argument to pass in case the total number of records exceeds
	// the value of MaxResults. If nextToken is returned, there are more results
	// available. The value of nextToken is a unique pagination token for each page.
	// Make the call again using the returned token to retrieve the next page. Keep
	// all other arguments unchanged.
	NextToken *string `type:"string"`

	// A list of service updates
	ServiceUpdates []*ServiceUpdate `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeServiceUpdatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeServiceUpdatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeServiceUpdatesOutput) SetNextToken(v string) *DescribeServiceUpdatesOutput {
	s.NextToken = &v
	return s
}

// SetServiceUpdates sets the ServiceUpdates field's value.
func (s *DescribeServiceUpdatesOutput) SetServiceUpdates(v []*ServiceUpdate) *DescribeServiceUpdatesOutput {
	s.ServiceUpdates = v
	return s
}

type DescribeSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// A user-supplied cluster identifier. If this parameter is specified, only
	// snapshots associated with that specific cluster are described.
	ClusterName *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `type:"integer"`

	// An optional argument to pass in case the total number of records exceeds
	// the value of MaxResults. If nextToken is returned, there are more results
	// available. The value of nextToken is a unique pagination token for each page.
	// Make the call again using the returned token to retrieve the next page. Keep
	// all other arguments unchanged.
	NextToken *string `type:"string"`

	// A Boolean value which if true, the shard configuration is included in the
	// snapshot description.
	ShowDetail *bool `type:"boolean"`

	// A user-supplied name of the snapshot. If this parameter is specified, only
	// this named snapshot is described.
	SnapshotName *string `type:"string"`

	// If set to system, the output shows snapshots that were automatically created
	// by MemoryDB. If set to user the output shows snapshots that were manually
	// created. If omitted, the output shows both automatically and manually created
	// snapshots.
	Source *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSnapshotsInput) GoString() string {
	return s.String()
}

// SetClusterName sets the ClusterName field's value.
func (s *DescribeSnapshotsInput) SetClusterName(v string) *DescribeSnapshotsInput {
	s.ClusterName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeSnapshotsInput) SetMaxResults(v int64) *DescribeSnapshotsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSnapshotsInput) SetNextToken(v string) *DescribeSnapshotsInput {
	s.NextToken = &v
	return s
}

// SetShowDetail sets the ShowDetail field's value.
func (s *DescribeSnapshotsInput) SetShowDetail(v bool) *DescribeSnapshotsInput {
	s.ShowDetail = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *DescribeSnapshotsInput) SetSnapshotName(v string) *DescribeSnapshotsInput {
	s.SnapshotName = &v
	return s
}

// SetSource sets the Source field's value.
func (s *DescribeSnapshotsInput) SetSource(v string) *DescribeSnapshotsInput {
	s.Source = &v
	return s
}

type DescribeSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// An optional argument to pass in case the total number of records exceeds
	// the value of MaxResults. If nextToken is returned, there are more results
	// available. The value of nextToken is a unique pagination token for each page.
	// Make the call again using the returned token to retrieve the next page. Keep
	// all other arguments unchanged.
	NextToken *string `type:"string"`

	// A list of snapshots. Each item in the list contains detailed information
	// about one snapshot.
	Snapshots []*Snapshot `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSnapshotsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSnapshotsOutput) SetNextToken(v string) *DescribeSnapshotsOutput {
	s.NextToken = &v
	return s
}

// SetSnapshots sets the Snapshots field's value.
func (s *DescribeSnapshotsOutput) SetSnapshots(v []*Snapshot) *DescribeSnapshotsOutput {
	s.Snapshots = v
	return s
}

type DescribeSubnetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `type:"integer"`

	// An optional argument to pass in case the total number of records exceeds
	// the value of MaxResults. If nextToken is returned, there are more results
	// available. The value of nextToken is a unique pagination token for each page.
	// Make the call again using the returned token to retrieve the next page. Keep
	// all other arguments unchanged.
	NextToken *string `type:"string"`

	// The name of the subnet group to return details for.
	SubnetGroupName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSubnetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSubnetGroupsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeSubnetGroupsInput) SetMaxResults(v int64) *DescribeSubnetGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSubnetGroupsInput) SetNextToken(v string) *DescribeSubnetGroupsInput {
	s.NextToken = &v
	return s
}

// SetSubnetGroupName sets the SubnetGroupName field's value.
func (s *DescribeSubnetGroupsInput) SetSubnetGroupName(v string) *DescribeSubnetGroupsInput {
	s.SubnetGroupName = &v
	return s
}

type DescribeSubnetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// An optional argument to pass in case the total number of records exceeds
	// the value of MaxResults. If nextToken is returned, there are more results
	// available. The value of nextToken is a unique pagination token for each page.
	// Make the call again using the returned token to retrieve the next page. Keep
	// all other arguments unchanged.
	NextToken *string `type:"string"`

	// A list of subnet groups. Each element in the list contains detailed information
	// about one group.
	SubnetGroups []*SubnetGroup `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSubnetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSubnetGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSubnetGroupsOutput) SetNextToken(v string) *DescribeSubnetGroupsOutput {
	s.NextToken = &v
	return s
}

// SetSubnetGroups sets the SubnetGroups field's value.
func (s *DescribeSubnetGroupsOutput) SetSubnetGroups(v []*SubnetGroup) *DescribeSubnetGroupsOutput {
	s.SubnetGroups = v
	return s
}

type DescribeUsersInput struct {
	_ struct{} `type:"structure"`

	// Filter to determine the list of users to return.
	Filters []*Filter `type:"list"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `type:"integer"`

	// An optional argument to pass in case the total number of records exceeds
	// the value of MaxResults. If nextToken is returned, there are more results
	// available. The value of nextToken is a unique pagination token for each page.
	// Make the call again using the returned token to retrieve the next page. Keep
	// all other arguments unchanged.
	NextToken *string `type:"string"`

	// The name of the user
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUsersInput"}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeUsersInput) SetFilters(v []*Filter) *DescribeUsersInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeUsersInput) SetMaxResults(v int64) *DescribeUsersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeUsersInput) SetNextToken(v string) *DescribeUsersInput {
	s.NextToken = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DescribeUsersInput) SetUserName(v string) *DescribeUsersInput {
	s.UserName = &v
	return s
}

type DescribeUsersOutput struct {
	_ struct{} `type:"structure"`

	// An optional argument to pass in case the total number of records exceeds
	// the value of MaxResults. If nextToken is returned, there are more results
	// available. The value of nextToken is a unique pagination token for each page.
	// Make the call again using the returned token to retrieve the next page. Keep
	// all other arguments unchanged.
	NextToken *string `type:"string"`

	// A list of users.
	Users []*User `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUsersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeUsersOutput) SetNextToken(v string) *DescribeUsersOutput {
	s.NextToken = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *DescribeUsersOutput) SetUsers(v []*User) *DescribeUsersOutput {
	s.Users = v
	return s
}

type DuplicateUserNameFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DuplicateUserNameFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DuplicateUserNameFault) GoString() string {
	return s.String()
}

func newErrorDuplicateUserNameFault(v protocol.ResponseMetadata) error {
	return &DuplicateUserNameFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DuplicateUserNameFault) Code() string {
	return "DuplicateUserNameFault"
}

// Message returns the exception's message.
func (s *DuplicateUserNameFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DuplicateUserNameFault) OrigErr() error {
	return nil
}

func (s *DuplicateUserNameFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DuplicateUserNameFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DuplicateUserNameFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the information required for client programs to connect to the
// cluster and its nodes.
type Endpoint struct {
	_ struct{} `type:"structure"`

	// The DNS hostname of the node.
	Address *string `type:"string"`

	// The port number that the engine is listening on.
	Port *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *Endpoint) SetAddress(v string) *Endpoint {
	s.Address = &v
	return s
}

// SetPort sets the Port field's value.
func (s *Endpoint) SetPort(v int64) *Endpoint {
	s.Port = &v
	return s
}

// Provides details of the Redis engine version
type EngineVersionInfo struct {
	_ struct{} `type:"structure"`

	// The patched engine version
	EnginePatchVersion *string `type:"string"`

	// The engine version
	EngineVersion *string `type:"string"`

	// Specifies the name of the parameter group family to which the engine default
	// parameters apply.
	ParameterGroupFamily *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EngineVersionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EngineVersionInfo) GoString() string {
	return s.String()
}

// SetEnginePatchVersion sets the EnginePatchVersion field's value.
func (s *EngineVersionInfo) SetEnginePatchVersion(v string) *EngineVersionInfo {
	s.EnginePatchVersion = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *EngineVersionInfo) SetEngineVersion(v string) *EngineVersionInfo {
	s.EngineVersion = &v
	return s
}

// SetParameterGroupFamily sets the ParameterGroupFamily field's value.
func (s *EngineVersionInfo) SetParameterGroupFamily(v string) *EngineVersionInfo {
	s.ParameterGroupFamily = &v
	return s
}

// Represents a single occurrence of something interesting within the system.
// Some examples of events are creating a cluster or adding or removing a node.
type Event struct {
	_ struct{} `type:"structure"`

	// The date and time when the event occurred.
	Date *time.Time `type:"timestamp"`

	// The text of the event.
	Message *string `type:"string"`

	// The name for the source of the event. For example, if the event occurred
	// at the cluster level, the identifier would be the name of the cluster.
	SourceName *string `type:"string"`

	// Specifies the origin of this event - a cluster, a parameter group, a security
	// group, etc.
	SourceType *string `type:"string" enum:"SourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Event) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *Event) SetDate(v time.Time) *Event {
	s.Date = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *Event) SetMessage(v string) *Event {
	s.Message = &v
	return s
}

// SetSourceName sets the SourceName field's value.
func (s *Event) SetSourceName(v string) *Event {
	s.SourceName = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *Event) SetSourceType(v string) *Event {
	s.SourceType = &v
	return s
}

type FailoverShardInput struct {
	_ struct{} `type:"structure"`

	// The cluster being failed over
	//
	// ClusterName is a required field
	ClusterName *string `type:"string" required:"true"`

	// The name of the shard
	//
	// ShardName is a required field
	ShardName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailoverShardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailoverShardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FailoverShardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FailoverShardInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ShardName == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *FailoverShardInput) SetClusterName(v string) *FailoverShardInput {
	s.ClusterName = &v
	return s
}

// SetShardName sets the ShardName field's value.
func (s *FailoverShardInput) SetShardName(v string) *FailoverShardInput {
	s.ShardName = &v
	return s
}

type FailoverShardOutput struct {
	_ struct{} `type:"structure"`

	// The cluster being failed over
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailoverShardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailoverShardOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *FailoverShardOutput) SetCluster(v *Cluster) *FailoverShardOutput {
	s.Cluster = v
	return s
}

// Used to streamline results of a search based on the property being filtered.
type Filter struct {
	_ struct{} `type:"structure"`

	// The property being filtered. For example, UserName.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The property values to filter on. For example, "user-123".
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

type InsufficientClusterCapacityFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientClusterCapacityFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientClusterCapacityFault) GoString() string {
	return s.String()
}

func newErrorInsufficientClusterCapacityFault(v protocol.ResponseMetadata) error {
	return &InsufficientClusterCapacityFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InsufficientClusterCapacityFault) Code() string {
	return "InsufficientClusterCapacityFault"
}

// Message returns the exception's message.
func (s *InsufficientClusterCapacityFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InsufficientClusterCapacityFault) OrigErr() error {
	return nil
}

func (s *InsufficientClusterCapacityFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InsufficientClusterCapacityFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InsufficientClusterCapacityFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvalidACLStateFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidACLStateFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidACLStateFault) GoString() string {
	return s.String()
}

func newErrorInvalidACLStateFault(v protocol.ResponseMetadata) error {
	return &InvalidACLStateFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidACLStateFault) Code() string {
	return "InvalidACLStateFault"
}

// Message returns the exception's message.
func (s *InvalidACLStateFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidACLStateFault) OrigErr() error {
	return nil
}

func (s *InvalidACLStateFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidACLStateFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidACLStateFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvalidARNFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidARNFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidARNFault) GoString() string {
	return s.String()
}

func newErrorInvalidARNFault(v protocol.ResponseMetadata) error {
	return &InvalidARNFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidARNFault) Code() string {
	return "InvalidARNFault"
}

// Message returns the exception's message.
func (s *InvalidARNFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidARNFault) OrigErr() error {
	return nil
}

func (s *InvalidARNFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidARNFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidARNFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvalidClusterStateFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidClusterStateFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidClusterStateFault) GoString() string {
	return s.String()
}

func newErrorInvalidClusterStateFault(v protocol.ResponseMetadata) error {
	return &InvalidClusterStateFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidClusterStateFault) Code() string {
	return "InvalidClusterStateFault"
}

// Message returns the exception's message.
func (s *InvalidClusterStateFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidClusterStateFault) OrigErr() error {
	return nil
}

func (s *InvalidClusterStateFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidClusterStateFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidClusterStateFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvalidCredentialsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidCredentialsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidCredentialsException) GoString() string {
	return s.String()
}

func newErrorInvalidCredentialsException(v protocol.ResponseMetadata) error {
	return &InvalidCredentialsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidCredentialsException) Code() string {
	return "InvalidCredentialsException"
}

// Message returns the exception's message.
func (s *InvalidCredentialsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidCredentialsException) OrigErr() error {
	return nil
}

func (s *InvalidCredentialsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidCredentialsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidCredentialsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvalidKMSKeyFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidKMSKeyFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidKMSKeyFault) GoString() string {
	return s.String()
}

func newErrorInvalidKMSKeyFault(v protocol.ResponseMetadata) error {
	return &InvalidKMSKeyFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidKMSKeyFault) Code() string {
	return "InvalidKMSKeyFault"
}

// Message returns the exception's message.
func (s *InvalidKMSKeyFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidKMSKeyFault) OrigErr() error {
	return nil
}

func (s *InvalidKMSKeyFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidKMSKeyFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidKMSKeyFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvalidNodeStateFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNodeStateFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNodeStateFault) GoString() string {
	return s.String()
}

func newErrorInvalidNodeStateFault(v protocol.ResponseMetadata) error {
	return &InvalidNodeStateFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNodeStateFault) Code() string {
	return "InvalidNodeStateFault"
}

// Message returns the exception's message.
func (s *InvalidNodeStateFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNodeStateFault) OrigErr() error {
	return nil
}

func (s *InvalidNodeStateFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNodeStateFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNodeStateFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvalidParameterCombinationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterCombinationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterCombinationException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterCombinationException(v protocol.ResponseMetadata) error {
	return &InvalidParameterCombinationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterCombinationException) Code() string {
	return "InvalidParameterCombinationException"
}

// Message returns the exception's message.
func (s *InvalidParameterCombinationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterCombinationException) OrigErr() error {
	return nil
}

func (s *InvalidParameterCombinationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterCombinationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterCombinationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvalidParameterGroupStateFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterGroupStateFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterGroupStateFault) GoString() string {
	return s.String()
}

func newErrorInvalidParameterGroupStateFault(v protocol.ResponseMetadata) error {
	return &InvalidParameterGroupStateFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterGroupStateFault) Code() string {
	return "InvalidParameterGroupStateFault"
}

// Message returns the exception's message.
func (s *InvalidParameterGroupStateFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterGroupStateFault) OrigErr() error {
	return nil
}

func (s *InvalidParameterGroupStateFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterGroupStateFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterGroupStateFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvalidParameterValueException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterValueException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterValueException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterValueException(v protocol.ResponseMetadata) error {
	return &InvalidParameterValueException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterValueException) Code() string {
	return "InvalidParameterValueException"
}

// Message returns the exception's message.
func (s *InvalidParameterValueException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterValueException) OrigErr() error {
	return nil
}

func (s *InvalidParameterValueException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterValueException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterValueException) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvalidSnapshotStateFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSnapshotStateFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSnapshotStateFault) GoString() string {
	return s.String()
}

func newErrorInvalidSnapshotStateFault(v protocol.ResponseMetadata) error {
	return &InvalidSnapshotStateFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidSnapshotStateFault) Code() string {
	return "InvalidSnapshotStateFault"
}

// Message returns the exception's message.
func (s *InvalidSnapshotStateFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidSnapshotStateFault) OrigErr() error {
	return nil
}

func (s *InvalidSnapshotStateFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidSnapshotStateFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidSnapshotStateFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvalidSubnet struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSubnet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidSubnet) GoString() string {
	return s.String()
}

func newErrorInvalidSubnet(v protocol.ResponseMetadata) error {
	return &InvalidSubnet{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidSubnet) Code() string {
	return "InvalidSubnet"
}

// Message returns the exception's message.
func (s *InvalidSubnet) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidSubnet) OrigErr() error {
	return nil
}

func (s *InvalidSubnet) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidSubnet) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidSubnet) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvalidUserStateFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidUserStateFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidUserStateFault) GoString() string {
	return s.String()
}

func newErrorInvalidUserStateFault(v protocol.ResponseMetadata) error {
	return &InvalidUserStateFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidUserStateFault) Code() string {
	return "InvalidUserStateFault"
}

// Message returns the exception's message.
func (s *InvalidUserStateFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidUserStateFault) OrigErr() error {
	return nil
}

func (s *InvalidUserStateFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidUserStateFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidUserStateFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type InvalidVPCNetworkStateFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidVPCNetworkStateFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidVPCNetworkStateFault) GoString() string {
	return s.String()
}

func newErrorInvalidVPCNetworkStateFault(v protocol.ResponseMetadata) error {
	return &InvalidVPCNetworkStateFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidVPCNetworkStateFault) Code() string {
	return "InvalidVPCNetworkStateFault"
}

// Message returns the exception's message.
func (s *InvalidVPCNetworkStateFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidVPCNetworkStateFault) OrigErr() error {
	return nil
}

func (s *InvalidVPCNetworkStateFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidVPCNetworkStateFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidVPCNetworkStateFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAllowedNodeTypeUpdatesInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster you want to scale. MemoryDB uses the cluster name
	// to identify the current node type being used by this cluster, and from that
	// to create a list of node types you can scale up to.
	//
	// ClusterName is a required field
	ClusterName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAllowedNodeTypeUpdatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAllowedNodeTypeUpdatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAllowedNodeTypeUpdatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAllowedNodeTypeUpdatesInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *ListAllowedNodeTypeUpdatesInput) SetClusterName(v string) *ListAllowedNodeTypeUpdatesInput {
	s.ClusterName = &v
	return s
}

type ListAllowedNodeTypeUpdatesOutput struct {
	_ struct{} `type:"structure"`

	// A list node types which you can use to scale down your cluster.
	ScaleDownNodeTypes []*string `type:"list"`

	// A list node types which you can use to scale up your cluster.
	ScaleUpNodeTypes []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAllowedNodeTypeUpdatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAllowedNodeTypeUpdatesOutput) GoString() string {
	return s.String()
}

// SetScaleDownNodeTypes sets the ScaleDownNodeTypes field's value.
func (s *ListAllowedNodeTypeUpdatesOutput) SetScaleDownNodeTypes(v []*string) *ListAllowedNodeTypeUpdatesOutput {
	s.ScaleDownNodeTypes = v
	return s
}

// SetScaleUpNodeTypes sets the ScaleUpNodeTypes field's value.
func (s *ListAllowedNodeTypeUpdatesOutput) SetScaleUpNodeTypes(v []*string) *ListAllowedNodeTypeUpdatesOutput {
	s.ScaleUpNodeTypes = v
	return s
}

type ListTagsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource for which you want the list
	// of tags
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsInput) SetResourceArn(v string) *ListTagsInput {
	s.ResourceArn = &v
	return s
}

type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags as key-value pairs.
	TagList []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *ListTagsOutput) SetTagList(v []*Tag) *ListTagsOutput {
	s.TagList = v
	return s
}

type NoOperationFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoOperationFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoOperationFault) GoString() string {
	return s.String()
}

func newErrorNoOperationFault(v protocol.ResponseMetadata) error {
	return &NoOperationFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoOperationFault) Code() string {
	return "NoOperationFault"
}

// Message returns the exception's message.
func (s *NoOperationFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoOperationFault) OrigErr() error {
	return nil
}

func (s *NoOperationFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoOperationFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoOperationFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents an individual node within a cluster. Each node runs its own instance
// of the cluster's protocol-compliant caching software.
type Node struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which the node resides
	AvailabilityZone *string `type:"string"`

	// The date and time when the node was created.
	CreateTime *time.Time `type:"timestamp"`

	// The hostname for connecting to this node.
	Endpoint *Endpoint `type:"structure"`

	// The node identifier. A node name is a numeric identifier (0001, 0002, etc.).
	// The combination of cluster name, shard name and node name uniquely identifies
	// every node used in a customer's Amazon account.
	Name *string `type:"string"`

	// The status of the service update on the node
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Node) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Node) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *Node) SetAvailabilityZone(v string) *Node {
	s.AvailabilityZone = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *Node) SetCreateTime(v time.Time) *Node {
	s.CreateTime = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *Node) SetEndpoint(v *Endpoint) *Node {
	s.Endpoint = v
	return s
}

// SetName sets the Name field's value.
func (s *Node) SetName(v string) *Node {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Node) SetStatus(v string) *Node {
	s.Status = &v
	return s
}

type NodeQuotaForClusterExceededFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeQuotaForClusterExceededFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeQuotaForClusterExceededFault) GoString() string {
	return s.String()
}

func newErrorNodeQuotaForClusterExceededFault(v protocol.ResponseMetadata) error {
	return &NodeQuotaForClusterExceededFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NodeQuotaForClusterExceededFault) Code() string {
	return "NodeQuotaForClusterExceededFault"
}

// Message returns the exception's message.
func (s *NodeQuotaForClusterExceededFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NodeQuotaForClusterExceededFault) OrigErr() error {
	return nil
}

func (s *NodeQuotaForClusterExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NodeQuotaForClusterExceededFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NodeQuotaForClusterExceededFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type NodeQuotaForCustomerExceededFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeQuotaForCustomerExceededFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodeQuotaForCustomerExceededFault) GoString() string {
	return s.String()
}

func newErrorNodeQuotaForCustomerExceededFault(v protocol.ResponseMetadata) error {
	return &NodeQuotaForCustomerExceededFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NodeQuotaForCustomerExceededFault) Code() string {
	return "NodeQuotaForCustomerExceededFault"
}

// Message returns the exception's message.
func (s *NodeQuotaForCustomerExceededFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NodeQuotaForCustomerExceededFault) OrigErr() error {
	return nil
}

func (s *NodeQuotaForCustomerExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NodeQuotaForCustomerExceededFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NodeQuotaForCustomerExceededFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes an individual setting that controls some aspect of MemoryDB behavior.
type Parameter struct {
	_ struct{} `type:"structure"`

	// The valid range of values for the parameter.
	AllowedValues *string `type:"string"`

	// The parameter's data type
	DataType *string `type:"string"`

	// A description of the parameter
	Description *string `type:"string"`

	// The earliest engine version to which the parameter can apply.
	MinimumEngineVersion *string `type:"string"`

	// The name of the parameter
	Name *string `type:"string"`

	// The value of the parameter
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Parameter) GoString() string {
	return s.String()
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *Parameter) SetAllowedValues(v string) *Parameter {
	s.AllowedValues = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *Parameter) SetDataType(v string) *Parameter {
	s.DataType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Parameter) SetDescription(v string) *Parameter {
	s.Description = &v
	return s
}

// SetMinimumEngineVersion sets the MinimumEngineVersion field's value.
func (s *Parameter) SetMinimumEngineVersion(v string) *Parameter {
	s.MinimumEngineVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *Parameter) SetName(v string) *Parameter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Parameter) SetValue(v string) *Parameter {
	s.Value = &v
	return s
}

// Represents the output of a CreateParameterGroup operation. A parameter group
// represents a combination of specific values for the parameters that are passed
// to the engine software during startup.
type ParameterGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the parameter group
	ARN *string `type:"string"`

	// A description of the parameter group
	Description *string `type:"string"`

	// The name of the parameter group family that this parameter group is compatible
	// with.
	Family *string `type:"string"`

	// The name of the parameter group
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterGroup) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *ParameterGroup) SetARN(v string) *ParameterGroup {
	s.ARN = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ParameterGroup) SetDescription(v string) *ParameterGroup {
	s.Description = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *ParameterGroup) SetFamily(v string) *ParameterGroup {
	s.Family = &v
	return s
}

// SetName sets the Name field's value.
func (s *ParameterGroup) SetName(v string) *ParameterGroup {
	s.Name = &v
	return s
}

type ParameterGroupAlreadyExistsFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterGroupAlreadyExistsFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterGroupAlreadyExistsFault) GoString() string {
	return s.String()
}

func newErrorParameterGroupAlreadyExistsFault(v protocol.ResponseMetadata) error {
	return &ParameterGroupAlreadyExistsFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ParameterGroupAlreadyExistsFault) Code() string {
	return "ParameterGroupAlreadyExistsFault"
}

// Message returns the exception's message.
func (s *ParameterGroupAlreadyExistsFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ParameterGroupAlreadyExistsFault) OrigErr() error {
	return nil
}

func (s *ParameterGroupAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ParameterGroupAlreadyExistsFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ParameterGroupAlreadyExistsFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type ParameterGroupNotFoundFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterGroupNotFoundFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterGroupNotFoundFault) GoString() string {
	return s.String()
}

func newErrorParameterGroupNotFoundFault(v protocol.ResponseMetadata) error {
	return &ParameterGroupNotFoundFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ParameterGroupNotFoundFault) Code() string {
	return "ParameterGroupNotFoundFault"
}

// Message returns the exception's message.
func (s *ParameterGroupNotFoundFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ParameterGroupNotFoundFault) OrigErr() error {
	return nil
}

func (s *ParameterGroupNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ParameterGroupNotFoundFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ParameterGroupNotFoundFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type ParameterGroupQuotaExceededFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterGroupQuotaExceededFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterGroupQuotaExceededFault) GoString() string {
	return s.String()
}

func newErrorParameterGroupQuotaExceededFault(v protocol.ResponseMetadata) error {
	return &ParameterGroupQuotaExceededFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ParameterGroupQuotaExceededFault) Code() string {
	return "ParameterGroupQuotaExceededFault"
}

// Message returns the exception's message.
func (s *ParameterGroupQuotaExceededFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ParameterGroupQuotaExceededFault) OrigErr() error {
	return nil
}

func (s *ParameterGroupQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ParameterGroupQuotaExceededFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ParameterGroupQuotaExceededFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a name-value pair that is used to update the value of a parameter.
type ParameterNameValue struct {
	_ struct{} `type:"structure"`

	// The name of the parameter
	ParameterName *string `type:"string"`

	// The value of the parameter
	ParameterValue *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterNameValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterNameValue) GoString() string {
	return s.String()
}

// SetParameterName sets the ParameterName field's value.
func (s *ParameterNameValue) SetParameterName(v string) *ParameterNameValue {
	s.ParameterName = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *ParameterNameValue) SetParameterValue(v string) *ParameterNameValue {
	s.ParameterValue = &v
	return s
}

// Update action that has yet to be processed for the corresponding apply/stop
// request
type PendingModifiedServiceUpdate struct {
	_ struct{} `type:"structure"`

	// The unique ID of the service update
	ServiceUpdateName *string `type:"string"`

	// The status of the service update
	Status *string `type:"string" enum:"ServiceUpdateStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PendingModifiedServiceUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PendingModifiedServiceUpdate) GoString() string {
	return s.String()
}

// SetServiceUpdateName sets the ServiceUpdateName field's value.
func (s *PendingModifiedServiceUpdate) SetServiceUpdateName(v string) *PendingModifiedServiceUpdate {
	s.ServiceUpdateName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PendingModifiedServiceUpdate) SetStatus(v string) *PendingModifiedServiceUpdate {
	s.Status = &v
	return s
}

// A request to configure the number of replicas in a shard
type ReplicaConfigurationRequest struct {
	_ struct{} `type:"structure"`

	// The number of replicas to scale up or down to
	ReplicaCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicaConfigurationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicaConfigurationRequest) GoString() string {
	return s.String()
}

// SetReplicaCount sets the ReplicaCount field's value.
func (s *ReplicaConfigurationRequest) SetReplicaCount(v int64) *ReplicaConfigurationRequest {
	s.ReplicaCount = &v
	return s
}

type ResetParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// If true, all parameters in the parameter group are reset to their default
	// values. If false, only the parameters listed by ParameterNames are reset
	// to their default values.
	AllParameters *bool `type:"boolean"`

	// The name of the parameter group to reset.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`

	// An array of parameter names to reset to their default values. If AllParameters
	// is true, do not use ParameterNames. If AllParameters is false, you must specify
	// the name of at least one parameter to reset.
	ParameterNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResetParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResetParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetParameterGroupInput"}
	if s.ParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllParameters sets the AllParameters field's value.
func (s *ResetParameterGroupInput) SetAllParameters(v bool) *ResetParameterGroupInput {
	s.AllParameters = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *ResetParameterGroupInput) SetParameterGroupName(v string) *ResetParameterGroupInput {
	s.ParameterGroupName = &v
	return s
}

// SetParameterNames sets the ParameterNames field's value.
func (s *ResetParameterGroupInput) SetParameterNames(v []*string) *ResetParameterGroupInput {
	s.ParameterNames = v
	return s
}

type ResetParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// The parameter group being reset.
	ParameterGroup *ParameterGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResetParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResetParameterGroupOutput) GoString() string {
	return s.String()
}

// SetParameterGroup sets the ParameterGroup field's value.
func (s *ResetParameterGroupOutput) SetParameterGroup(v *ParameterGroup) *ResetParameterGroupOutput {
	s.ParameterGroup = v
	return s
}

// The status of the online resharding
type ReshardingStatus struct {
	_ struct{} `type:"structure"`

	// The status of the online resharding slot migration
	SlotMigration *SlotMigration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReshardingStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReshardingStatus) GoString() string {
	return s.String()
}

// SetSlotMigration sets the SlotMigration field's value.
func (s *ReshardingStatus) SetSlotMigration(v *SlotMigration) *ReshardingStatus {
	s.SlotMigration = v
	return s
}

// Represents a single security group and its status.
type SecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The identifier of the security group.
	SecurityGroupId *string `type:"string"`

	// The status of the security group membership. The status changes whenever
	// a security group is modified, or when the security groups assigned to a cluster
	// are modified.
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityGroupMembership) GoString() string {
	return s.String()
}

// SetSecurityGroupId sets the SecurityGroupId field's value.
func (s *SecurityGroupMembership) SetSecurityGroupId(v string) *SecurityGroupMembership {
	s.SecurityGroupId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SecurityGroupMembership) SetStatus(v string) *SecurityGroupMembership {
	s.Status = &v
	return s
}

type ServiceLinkedRoleNotFoundFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLinkedRoleNotFoundFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceLinkedRoleNotFoundFault) GoString() string {
	return s.String()
}

func newErrorServiceLinkedRoleNotFoundFault(v protocol.ResponseMetadata) error {
	return &ServiceLinkedRoleNotFoundFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceLinkedRoleNotFoundFault) Code() string {
	return "ServiceLinkedRoleNotFoundFault"
}

// Message returns the exception's message.
func (s *ServiceLinkedRoleNotFoundFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceLinkedRoleNotFoundFault) OrigErr() error {
	return nil
}

func (s *ServiceLinkedRoleNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceLinkedRoleNotFoundFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceLinkedRoleNotFoundFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// An update that you can apply to your MemoryDB clusters.
type ServiceUpdate struct {
	_ struct{} `type:"structure"`

	// The date at which the service update will be automatically applied
	AutoUpdateStartDate *time.Time `type:"timestamp"`

	// The name of the cluster to which the service update applies
	ClusterName *string `type:"string"`

	// Provides details of the service update
	Description *string `type:"string"`

	// A list of nodes updated by the service update
	NodesUpdated *string `type:"string"`

	// The date when the service update is initially available
	ReleaseDate *time.Time `type:"timestamp"`

	// The unique ID of the service update
	ServiceUpdateName *string `type:"string"`

	// The status of the service update
	Status *string `type:"string" enum:"ServiceUpdateStatus"`

	// Reflects the nature of the service update
	Type *string `type:"string" enum:"ServiceUpdateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUpdate) GoString() string {
	return s.String()
}

// SetAutoUpdateStartDate sets the AutoUpdateStartDate field's value.
func (s *ServiceUpdate) SetAutoUpdateStartDate(v time.Time) *ServiceUpdate {
	s.AutoUpdateStartDate = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *ServiceUpdate) SetClusterName(v string) *ServiceUpdate {
	s.ClusterName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ServiceUpdate) SetDescription(v string) *ServiceUpdate {
	s.Description = &v
	return s
}

// SetNodesUpdated sets the NodesUpdated field's value.
func (s *ServiceUpdate) SetNodesUpdated(v string) *ServiceUpdate {
	s.NodesUpdated = &v
	return s
}

// SetReleaseDate sets the ReleaseDate field's value.
func (s *ServiceUpdate) SetReleaseDate(v time.Time) *ServiceUpdate {
	s.ReleaseDate = &v
	return s
}

// SetServiceUpdateName sets the ServiceUpdateName field's value.
func (s *ServiceUpdate) SetServiceUpdateName(v string) *ServiceUpdate {
	s.ServiceUpdateName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ServiceUpdate) SetStatus(v string) *ServiceUpdate {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *ServiceUpdate) SetType(v string) *ServiceUpdate {
	s.Type = &v
	return s
}

type ServiceUpdateNotFoundFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUpdateNotFoundFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUpdateNotFoundFault) GoString() string {
	return s.String()
}

func newErrorServiceUpdateNotFoundFault(v protocol.ResponseMetadata) error {
	return &ServiceUpdateNotFoundFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUpdateNotFoundFault) Code() string {
	return "ServiceUpdateNotFoundFault"
}

// Message returns the exception's message.
func (s *ServiceUpdateNotFoundFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUpdateNotFoundFault) OrigErr() error {
	return nil
}

func (s *ServiceUpdateNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUpdateNotFoundFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUpdateNotFoundFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// A request to apply a service update
type ServiceUpdateRequest struct {
	_ struct{} `type:"structure"`

	// The unique ID of the service update
	ServiceUpdateNameToApply *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUpdateRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUpdateRequest) GoString() string {
	return s.String()
}

// SetServiceUpdateNameToApply sets the ServiceUpdateNameToApply field's value.
func (s *ServiceUpdateRequest) SetServiceUpdateNameToApply(v string) *ServiceUpdateRequest {
	s.ServiceUpdateNameToApply = &v
	return s
}

// Represents a collection of nodes in a cluster. One node in the node group
// is the read/write primary node. All the other nodes are read-only Replica
// nodes.
type Shard struct {
	_ struct{} `type:"structure"`

	// The name of the shard
	Name *string `type:"string"`

	// A list containing information about individual nodes within the shard
	Nodes []*Node `type:"list"`

	// The number of nodes in the shard
	NumberOfNodes *int64 `type:"integer"`

	// The keyspace for this shard.
	Slots *string `type:"string"`

	// The current state of this replication group - creating, available, modifying,
	// deleting.
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Shard) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Shard) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Shard) SetName(v string) *Shard {
	s.Name = &v
	return s
}

// SetNodes sets the Nodes field's value.
func (s *Shard) SetNodes(v []*Node) *Shard {
	s.Nodes = v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *Shard) SetNumberOfNodes(v int64) *Shard {
	s.NumberOfNodes = &v
	return s
}

// SetSlots sets the Slots field's value.
func (s *Shard) SetSlots(v string) *Shard {
	s.Slots = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Shard) SetStatus(v string) *Shard {
	s.Status = &v
	return s
}

// Shard configuration options. Each shard configuration has the following:
// Slots and ReplicaCount.
type ShardConfiguration struct {
	_ struct{} `type:"structure"`

	// The number of read replica nodes in this shard.
	ReplicaCount *int64 `type:"integer"`

	// A string that specifies the keyspace for a particular node group. Keyspaces
	// range from 0 to 16,383. The string is in the format startkey-endkey.
	Slots *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShardConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShardConfiguration) GoString() string {
	return s.String()
}

// SetReplicaCount sets the ReplicaCount field's value.
func (s *ShardConfiguration) SetReplicaCount(v int64) *ShardConfiguration {
	s.ReplicaCount = &v
	return s
}

// SetSlots sets the Slots field's value.
func (s *ShardConfiguration) SetSlots(v string) *ShardConfiguration {
	s.Slots = &v
	return s
}

// A request to configure the sharding properties of a cluster
type ShardConfigurationRequest struct {
	_ struct{} `type:"structure"`

	// The number of shards in the cluster
	ShardCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShardConfigurationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShardConfigurationRequest) GoString() string {
	return s.String()
}

// SetShardCount sets the ShardCount field's value.
func (s *ShardConfigurationRequest) SetShardCount(v int64) *ShardConfigurationRequest {
	s.ShardCount = &v
	return s
}

// Provides details of a shard in a snapshot
type ShardDetail struct {
	_ struct{} `type:"structure"`

	// The configuration details of the shard
	Configuration *ShardConfiguration `type:"structure"`

	// The name of the shard
	Name *string `type:"string"`

	// The size of the shard's snapshot
	Size *string `type:"string"`

	// The date and time that the shard's snapshot was created
	SnapshotCreationTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShardDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShardDetail) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *ShardDetail) SetConfiguration(v *ShardConfiguration) *ShardDetail {
	s.Configuration = v
	return s
}

// SetName sets the Name field's value.
func (s *ShardDetail) SetName(v string) *ShardDetail {
	s.Name = &v
	return s
}

// SetSize sets the Size field's value.
func (s *ShardDetail) SetSize(v string) *ShardDetail {
	s.Size = &v
	return s
}

// SetSnapshotCreationTime sets the SnapshotCreationTime field's value.
func (s *ShardDetail) SetSnapshotCreationTime(v time.Time) *ShardDetail {
	s.SnapshotCreationTime = &v
	return s
}

type ShardNotFoundFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShardNotFoundFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShardNotFoundFault) GoString() string {
	return s.String()
}

func newErrorShardNotFoundFault(v protocol.ResponseMetadata) error {
	return &ShardNotFoundFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ShardNotFoundFault) Code() string {
	return "ShardNotFoundFault"
}

// Message returns the exception's message.
func (s *ShardNotFoundFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ShardNotFoundFault) OrigErr() error {
	return nil
}

func (s *ShardNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ShardNotFoundFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ShardNotFoundFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type ShardsPerClusterQuotaExceededFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShardsPerClusterQuotaExceededFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ShardsPerClusterQuotaExceededFault) GoString() string {
	return s.String()
}

func newErrorShardsPerClusterQuotaExceededFault(v protocol.ResponseMetadata) error {
	return &ShardsPerClusterQuotaExceededFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ShardsPerClusterQuotaExceededFault) Code() string {
	return "ShardsPerClusterQuotaExceededFault"
}

// Message returns the exception's message.
func (s *ShardsPerClusterQuotaExceededFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ShardsPerClusterQuotaExceededFault) OrigErr() error {
	return nil
}

func (s *ShardsPerClusterQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ShardsPerClusterQuotaExceededFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ShardsPerClusterQuotaExceededFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the progress of an online resharding operation.
type SlotMigration struct {
	_ struct{} `type:"structure"`

	// The percentage of the slot migration that is complete.
	ProgressPercentage *float64 `type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SlotMigration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SlotMigration) GoString() string {
	return s.String()
}

// SetProgressPercentage sets the ProgressPercentage field's value.
func (s *SlotMigration) SetProgressPercentage(v float64) *SlotMigration {
	s.ProgressPercentage = &v
	return s
}

// Represents a copy of an entire cluster as of the time when the snapshot was
// taken.
type Snapshot struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the snapshot.
	ARN *string `type:"string"`

	// The configuration of the cluster from which the snapshot was taken
	ClusterConfiguration *ClusterConfiguration `type:"structure"`

	// The ID of the KMS key used to encrypt the snapshot.
	KmsKeyId *string `type:"string"`

	// The name of the snapshot
	Name *string `type:"string"`

	// Indicates whether the snapshot is from an automatic backup (automated) or
	// was created manually (manual).
	Source *string `type:"string"`

	// The status of the snapshot. Valid values: creating | available | restoring
	// | copying | deleting.
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Snapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Snapshot) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *Snapshot) SetARN(v string) *Snapshot {
	s.ARN = &v
	return s
}

// SetClusterConfiguration sets the ClusterConfiguration field's value.
func (s *Snapshot) SetClusterConfiguration(v *ClusterConfiguration) *Snapshot {
	s.ClusterConfiguration = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *Snapshot) SetKmsKeyId(v string) *Snapshot {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *Snapshot) SetName(v string) *Snapshot {
	s.Name = &v
	return s
}

// SetSource sets the Source field's value.
func (s *Snapshot) SetSource(v string) *Snapshot {
	s.Source = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Snapshot) SetStatus(v string) *Snapshot {
	s.Status = &v
	return s
}

type SnapshotAlreadyExistsFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotAlreadyExistsFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotAlreadyExistsFault) GoString() string {
	return s.String()
}

func newErrorSnapshotAlreadyExistsFault(v protocol.ResponseMetadata) error {
	return &SnapshotAlreadyExistsFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SnapshotAlreadyExistsFault) Code() string {
	return "SnapshotAlreadyExistsFault"
}

// Message returns the exception's message.
func (s *SnapshotAlreadyExistsFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SnapshotAlreadyExistsFault) OrigErr() error {
	return nil
}

func (s *SnapshotAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SnapshotAlreadyExistsFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SnapshotAlreadyExistsFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type SnapshotNotFoundFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotNotFoundFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotNotFoundFault) GoString() string {
	return s.String()
}

func newErrorSnapshotNotFoundFault(v protocol.ResponseMetadata) error {
	return &SnapshotNotFoundFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SnapshotNotFoundFault) Code() string {
	return "SnapshotNotFoundFault"
}

// Message returns the exception's message.
func (s *SnapshotNotFoundFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SnapshotNotFoundFault) OrigErr() error {
	return nil
}

func (s *SnapshotNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SnapshotNotFoundFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SnapshotNotFoundFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type SnapshotQuotaExceededFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotQuotaExceededFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotQuotaExceededFault) GoString() string {
	return s.String()
}

func newErrorSnapshotQuotaExceededFault(v protocol.ResponseMetadata) error {
	return &SnapshotQuotaExceededFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SnapshotQuotaExceededFault) Code() string {
	return "SnapshotQuotaExceededFault"
}

// Message returns the exception's message.
func (s *SnapshotQuotaExceededFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SnapshotQuotaExceededFault) OrigErr() error {
	return nil
}

func (s *SnapshotQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SnapshotQuotaExceededFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SnapshotQuotaExceededFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the subnet associated with a cluster. This parameter refers to
// subnets defined in Amazon Virtual Private Cloud (Amazon VPC) and used with
// MemoryDB.
type Subnet struct {
	_ struct{} `type:"structure"`

	// The Availability Zone where the subnet resides
	AvailabilityZone *AvailabilityZone `type:"structure"`

	// The unique identifier for the subnet.
	Identifier *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Subnet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Subnet) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *Subnet) SetAvailabilityZone(v *AvailabilityZone) *Subnet {
	s.AvailabilityZone = v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *Subnet) SetIdentifier(v string) *Subnet {
	s.Identifier = &v
	return s
}

// Represents the output of one of the following operations:
//
//   - CreateSubnetGroup
//
//   - UpdateSubnetGroup
//
// A subnet group is a collection of subnets (typically private) that you can
// designate for your clusters running in an Amazon Virtual Private Cloud (VPC)
// environment.
type SubnetGroup struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the subnet group.
	ARN *string `type:"string"`

	// A description of the subnet group
	Description *string `type:"string"`

	// The name of the subnet group
	Name *string `type:"string"`

	// A list of subnets associated with the subnet group.
	Subnets []*Subnet `type:"list"`

	// The Amazon Virtual Private Cloud identifier (VPC ID) of the subnet group.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubnetGroup) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *SubnetGroup) SetARN(v string) *SubnetGroup {
	s.ARN = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SubnetGroup) SetDescription(v string) *SubnetGroup {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *SubnetGroup) SetName(v string) *SubnetGroup {
	s.Name = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *SubnetGroup) SetSubnets(v []*Subnet) *SubnetGroup {
	s.Subnets = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *SubnetGroup) SetVpcId(v string) *SubnetGroup {
	s.VpcId = &v
	return s
}

type SubnetGroupAlreadyExistsFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubnetGroupAlreadyExistsFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubnetGroupAlreadyExistsFault) GoString() string {
	return s.String()
}

func newErrorSubnetGroupAlreadyExistsFault(v protocol.ResponseMetadata) error {
	return &SubnetGroupAlreadyExistsFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SubnetGroupAlreadyExistsFault) Code() string {
	return "SubnetGroupAlreadyExistsFault"
}

// Message returns the exception's message.
func (s *SubnetGroupAlreadyExistsFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SubnetGroupAlreadyExistsFault) OrigErr() error {
	return nil
}

func (s *SubnetGroupAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SubnetGroupAlreadyExistsFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SubnetGroupAlreadyExistsFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type SubnetGroupInUseFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubnetGroupInUseFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubnetGroupInUseFault) GoString() string {
	return s.String()
}

func newErrorSubnetGroupInUseFault(v protocol.ResponseMetadata) error {
	return &SubnetGroupInUseFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SubnetGroupInUseFault) Code() string {
	return "SubnetGroupInUseFault"
}

// Message returns the exception's message.
func (s *SubnetGroupInUseFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SubnetGroupInUseFault) OrigErr() error {
	return nil
}

func (s *SubnetGroupInUseFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SubnetGroupInUseFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SubnetGroupInUseFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type SubnetGroupNotFoundFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubnetGroupNotFoundFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubnetGroupNotFoundFault) GoString() string {
	return s.String()
}

func newErrorSubnetGroupNotFoundFault(v protocol.ResponseMetadata) error {
	return &SubnetGroupNotFoundFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SubnetGroupNotFoundFault) Code() string {
	return "SubnetGroupNotFoundFault"
}

// Message returns the exception's message.
func (s *SubnetGroupNotFoundFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SubnetGroupNotFoundFault) OrigErr() error {
	return nil
}

func (s *SubnetGroupNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SubnetGroupNotFoundFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SubnetGroupNotFoundFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type SubnetGroupQuotaExceededFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubnetGroupQuotaExceededFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubnetGroupQuotaExceededFault) GoString() string {
	return s.String()
}

func newErrorSubnetGroupQuotaExceededFault(v protocol.ResponseMetadata) error {
	return &SubnetGroupQuotaExceededFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SubnetGroupQuotaExceededFault) Code() string {
	return "SubnetGroupQuotaExceededFault"
}

// Message returns the exception's message.
func (s *SubnetGroupQuotaExceededFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SubnetGroupQuotaExceededFault) OrigErr() error {
	return nil
}

func (s *SubnetGroupQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SubnetGroupQuotaExceededFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SubnetGroupQuotaExceededFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type SubnetInUse struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubnetInUse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubnetInUse) GoString() string {
	return s.String()
}

func newErrorSubnetInUse(v protocol.ResponseMetadata) error {
	return &SubnetInUse{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SubnetInUse) Code() string {
	return "SubnetInUse"
}

// Message returns the exception's message.
func (s *SubnetInUse) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SubnetInUse) OrigErr() error {
	return nil
}

func (s *SubnetInUse) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SubnetInUse) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SubnetInUse) RequestID() string {
	return s.RespMetadata.RequestID
}

type SubnetNotAllowedFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubnetNotAllowedFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubnetNotAllowedFault) GoString() string {
	return s.String()
}

func newErrorSubnetNotAllowedFault(v protocol.ResponseMetadata) error {
	return &SubnetNotAllowedFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SubnetNotAllowedFault) Code() string {
	return "SubnetNotAllowedFault"
}

// Message returns the exception's message.
func (s *SubnetNotAllowedFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SubnetNotAllowedFault) OrigErr() error {
	return nil
}

func (s *SubnetNotAllowedFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SubnetNotAllowedFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SubnetNotAllowedFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type SubnetQuotaExceededFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubnetQuotaExceededFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubnetQuotaExceededFault) GoString() string {
	return s.String()
}

func newErrorSubnetQuotaExceededFault(v protocol.ResponseMetadata) error {
	return &SubnetQuotaExceededFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SubnetQuotaExceededFault) Code() string {
	return "SubnetQuotaExceededFault"
}

// Message returns the exception's message.
func (s *SubnetQuotaExceededFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SubnetQuotaExceededFault) OrigErr() error {
	return nil
}

func (s *SubnetQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SubnetQuotaExceededFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SubnetQuotaExceededFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// A tag that can be added to an MemoryDB resource. Tags are composed of a Key/Value
// pair. You can use tags to categorize and track all your MemoryDB resources.
// When you add or remove tags on clusters, those actions will be replicated
// to all nodes in the cluster. A tag with a null Value is permitted. For more
// information, see Tagging your MemoryDB resources (https://docs.aws.amazon.com/MemoryDB/latest/devguide/tagging-resources.html)
type Tag struct {
	_ struct{} `type:"structure"`

	// The key for the tag. May not be null.
	Key *string `type:"string"`

	// The tag's value. May be null.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagNotFoundFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagNotFoundFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagNotFoundFault) GoString() string {
	return s.String()
}

func newErrorTagNotFoundFault(v protocol.ResponseMetadata) error {
	return &TagNotFoundFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TagNotFoundFault) Code() string {
	return "TagNotFoundFault"
}

// Message returns the exception's message.
func (s *TagNotFoundFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TagNotFoundFault) OrigErr() error {
	return nil
}

func (s *TagNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TagNotFoundFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TagNotFoundFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagQuotaPerResourceExceeded struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagQuotaPerResourceExceeded) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagQuotaPerResourceExceeded) GoString() string {
	return s.String()
}

func newErrorTagQuotaPerResourceExceeded(v protocol.ResponseMetadata) error {
	return &TagQuotaPerResourceExceeded{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TagQuotaPerResourceExceeded) Code() string {
	return "TagQuotaPerResourceExceeded"
}

// Message returns the exception's message.
func (s *TagQuotaPerResourceExceeded) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TagQuotaPerResourceExceeded) OrigErr() error {
	return nil
}

func (s *TagQuotaPerResourceExceeded) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TagQuotaPerResourceExceeded) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TagQuotaPerResourceExceeded) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to which the tags are to be
	// added
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// A list of tags to be added to this resource. A tag is a key-value pair. A
	// tag key must be accompanied by a tag value, although null is accepted.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags as key-value pairs.
	TagList []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *TagResourceOutput) SetTagList(v []*Tag) *TagResourceOutput {
	s.TagList = v
	return s
}

type TestFailoverNotAvailableFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestFailoverNotAvailableFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestFailoverNotAvailableFault) GoString() string {
	return s.String()
}

func newErrorTestFailoverNotAvailableFault(v protocol.ResponseMetadata) error {
	return &TestFailoverNotAvailableFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TestFailoverNotAvailableFault) Code() string {
	return "TestFailoverNotAvailableFault"
}

// Message returns the exception's message.
func (s *TestFailoverNotAvailableFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TestFailoverNotAvailableFault) OrigErr() error {
	return nil
}

func (s *TestFailoverNotAvailableFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TestFailoverNotAvailableFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TestFailoverNotAvailableFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// A cluster whose updates have failed
type UnprocessedCluster struct {
	_ struct{} `type:"structure"`

	// The name of the cluster
	ClusterName *string `type:"string"`

	// The error message associated with the update failure
	ErrorMessage *string `type:"string"`

	// The error type associated with the update failure
	ErrorType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnprocessedCluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnprocessedCluster) GoString() string {
	return s.String()
}

// SetClusterName sets the ClusterName field's value.
func (s *UnprocessedCluster) SetClusterName(v string) *UnprocessedCluster {
	s.ClusterName = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *UnprocessedCluster) SetErrorMessage(v string) *UnprocessedCluster {
	s.ErrorMessage = &v
	return s
}

// SetErrorType sets the ErrorType field's value.
func (s *UnprocessedCluster) SetErrorType(v string) *UnprocessedCluster {
	s.ErrorType = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to which the tags are to be
	// removed
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// The list of keys of the tags that are to be removed
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags removed
	TagList []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *UntagResourceOutput) SetTagList(v []*Tag) *UntagResourceOutput {
	s.TagList = v
	return s
}

type UpdateACLInput struct {
	_ struct{} `type:"structure"`

	// The name of the Access Control List
	//
	// ACLName is a required field
	ACLName *string `type:"string" required:"true"`

	// The list of users to add to the Access Control List
	UserNamesToAdd []*string `min:"1" type:"list"`

	// The list of users to remove from the Access Control List
	UserNamesToRemove []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateACLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateACLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateACLInput"}
	if s.ACLName == nil {
		invalidParams.Add(request.NewErrParamRequired("ACLName"))
	}
	if s.UserNamesToAdd != nil && len(s.UserNamesToAdd) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserNamesToAdd", 1))
	}
	if s.UserNamesToRemove != nil && len(s.UserNamesToRemove) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserNamesToRemove", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACLName sets the ACLName field's value.
func (s *UpdateACLInput) SetACLName(v string) *UpdateACLInput {
	s.ACLName = &v
	return s
}

// SetUserNamesToAdd sets the UserNamesToAdd field's value.
func (s *UpdateACLInput) SetUserNamesToAdd(v []*string) *UpdateACLInput {
	s.UserNamesToAdd = v
	return s
}

// SetUserNamesToRemove sets the UserNamesToRemove field's value.
func (s *UpdateACLInput) SetUserNamesToRemove(v []*string) *UpdateACLInput {
	s.UserNamesToRemove = v
	return s
}

type UpdateACLOutput struct {
	_ struct{} `type:"structure"`

	// The updated Access Control List
	ACL *ACL `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateACLOutput) GoString() string {
	return s.String()
}

// SetACL sets the ACL field's value.
func (s *UpdateACLOutput) SetACL(v *ACL) *UpdateACLOutput {
	s.ACL = v
	return s
}

type UpdateClusterInput struct {
	_ struct{} `type:"structure"`

	// The Access Control List that is associated with the cluster
	ACLName *string `min:"1" type:"string"`

	// The name of the cluster to update
	//
	// ClusterName is a required field
	ClusterName *string `type:"string" required:"true"`

	// The description of the cluster to update
	Description *string `type:"string"`

	// The upgraded version of the engine to be run on the nodes. You can upgrade
	// to a newer engine version, but you cannot downgrade to an earlier engine
	// version. If you want to use an earlier engine version, you must delete the
	// existing cluster and create it anew with the earlier engine version.
	EngineVersion *string `type:"string"`

	// The maintenance window to update
	MaintenanceWindow *string `type:"string"`

	// A valid node type that you want to scale this cluster up or down to.
	NodeType *string `type:"string"`

	// The name of the parameter group to update
	ParameterGroupName *string `type:"string"`

	// The number of replicas that will reside in each shard
	ReplicaConfiguration *ReplicaConfigurationRequest `type:"structure"`

	// The SecurityGroupIds to update
	SecurityGroupIds []*string `type:"list"`

	// The number of shards in the cluster
	ShardConfiguration *ShardConfigurationRequest `type:"structure"`

	// The number of days for which MemoryDB retains automatic cluster snapshots
	// before deleting them. For example, if you set SnapshotRetentionLimit to 5,
	// a snapshot that was taken today is retained for 5 days before being deleted.
	SnapshotRetentionLimit *int64 `type:"integer"`

	// The daily time range (in UTC) during which MemoryDB begins taking a daily
	// snapshot of your cluster.
	SnapshotWindow *string `type:"string"`

	// The SNS topic ARN to update
	SnsTopicArn *string `type:"string"`

	// The status of the Amazon SNS notification topic. Notifications are sent only
	// if the status is active.
	SnsTopicStatus *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateClusterInput"}
	if s.ACLName != nil && len(*s.ACLName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ACLName", 1))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetACLName sets the ACLName field's value.
func (s *UpdateClusterInput) SetACLName(v string) *UpdateClusterInput {
	s.ACLName = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *UpdateClusterInput) SetClusterName(v string) *UpdateClusterInput {
	s.ClusterName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateClusterInput) SetDescription(v string) *UpdateClusterInput {
	s.Description = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *UpdateClusterInput) SetEngineVersion(v string) *UpdateClusterInput {
	s.EngineVersion = &v
	return s
}

// SetMaintenanceWindow sets the MaintenanceWindow field's value.
func (s *UpdateClusterInput) SetMaintenanceWindow(v string) *UpdateClusterInput {
	s.MaintenanceWindow = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *UpdateClusterInput) SetNodeType(v string) *UpdateClusterInput {
	s.NodeType = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *UpdateClusterInput) SetParameterGroupName(v string) *UpdateClusterInput {
	s.ParameterGroupName = &v
	return s
}

// SetReplicaConfiguration sets the ReplicaConfiguration field's value.
func (s *UpdateClusterInput) SetReplicaConfiguration(v *ReplicaConfigurationRequest) *UpdateClusterInput {
	s.ReplicaConfiguration = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *UpdateClusterInput) SetSecurityGroupIds(v []*string) *UpdateClusterInput {
	s.SecurityGroupIds = v
	return s
}

// SetShardConfiguration sets the ShardConfiguration field's value.
func (s *UpdateClusterInput) SetShardConfiguration(v *ShardConfigurationRequest) *UpdateClusterInput {
	s.ShardConfiguration = v
	return s
}

// SetSnapshotRetentionLimit sets the SnapshotRetentionLimit field's value.
func (s *UpdateClusterInput) SetSnapshotRetentionLimit(v int64) *UpdateClusterInput {
	s.SnapshotRetentionLimit = &v
	return s
}

// SetSnapshotWindow sets the SnapshotWindow field's value.
func (s *UpdateClusterInput) SetSnapshotWindow(v string) *UpdateClusterInput {
	s.SnapshotWindow = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *UpdateClusterInput) SetSnsTopicArn(v string) *UpdateClusterInput {
	s.SnsTopicArn = &v
	return s
}

// SetSnsTopicStatus sets the SnsTopicStatus field's value.
func (s *UpdateClusterInput) SetSnsTopicStatus(v string) *UpdateClusterInput {
	s.SnsTopicStatus = &v
	return s
}

type UpdateClusterOutput struct {
	_ struct{} `type:"structure"`

	// The updated cluster
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *UpdateClusterOutput) SetCluster(v *Cluster) *UpdateClusterOutput {
	s.Cluster = v
	return s
}

type UpdateParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the parameter group to update.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`

	// An array of parameter names and values for the parameter update. You must
	// supply at least one parameter name and value; subsequent arguments are optional.
	// A maximum of 20 parameters may be updated per request.
	//
	// ParameterNameValues is a required field
	ParameterNameValues []*ParameterNameValue `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateParameterGroupInput"}
	if s.ParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupName"))
	}
	if s.ParameterNameValues == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterNameValues"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *UpdateParameterGroupInput) SetParameterGroupName(v string) *UpdateParameterGroupInput {
	s.ParameterGroupName = &v
	return s
}

// SetParameterNameValues sets the ParameterNameValues field's value.
func (s *UpdateParameterGroupInput) SetParameterNameValues(v []*ParameterNameValue) *UpdateParameterGroupInput {
	s.ParameterNameValues = v
	return s
}

type UpdateParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// The updated parameter group
	ParameterGroup *ParameterGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateParameterGroupOutput) GoString() string {
	return s.String()
}

// SetParameterGroup sets the ParameterGroup field's value.
func (s *UpdateParameterGroupOutput) SetParameterGroup(v *ParameterGroup) *UpdateParameterGroupOutput {
	s.ParameterGroup = v
	return s
}

type UpdateSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// A description of the subnet group
	Description *string `type:"string"`

	// The name of the subnet group
	//
	// SubnetGroupName is a required field
	SubnetGroupName *string `type:"string" required:"true"`

	// The EC2 subnet IDs for the subnet group.
	SubnetIds []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSubnetGroupInput"}
	if s.SubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateSubnetGroupInput) SetDescription(v string) *UpdateSubnetGroupInput {
	s.Description = &v
	return s
}

// SetSubnetGroupName sets the SubnetGroupName field's value.
func (s *UpdateSubnetGroupInput) SetSubnetGroupName(v string) *UpdateSubnetGroupInput {
	s.SubnetGroupName = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *UpdateSubnetGroupInput) SetSubnetIds(v []*string) *UpdateSubnetGroupInput {
	s.SubnetIds = v
	return s
}

type UpdateSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The updated subnet group
	SubnetGroup *SubnetGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetSubnetGroup sets the SubnetGroup field's value.
func (s *UpdateSubnetGroupOutput) SetSubnetGroup(v *SubnetGroup) *UpdateSubnetGroupOutput {
	s.SubnetGroup = v
	return s
}

type UpdateUserInput struct {
	_ struct{} `type:"structure"`

	// Access permissions string used for this user.
	AccessString *string `type:"string"`

	// Denotes the user's authentication properties, such as whether it requires
	// a password to authenticate.
	AuthenticationMode *AuthenticationMode `type:"structure"`

	// The name of the user
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserInput"}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}
	if s.AuthenticationMode != nil {
		if err := s.AuthenticationMode.Validate(); err != nil {
			invalidParams.AddNested("AuthenticationMode", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessString sets the AccessString field's value.
func (s *UpdateUserInput) SetAccessString(v string) *UpdateUserInput {
	s.AccessString = &v
	return s
}

// SetAuthenticationMode sets the AuthenticationMode field's value.
func (s *UpdateUserInput) SetAuthenticationMode(v *AuthenticationMode) *UpdateUserInput {
	s.AuthenticationMode = v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UpdateUserInput) SetUserName(v string) *UpdateUserInput {
	s.UserName = &v
	return s
}

type UpdateUserOutput struct {
	_ struct{} `type:"structure"`

	// The updated user
	User *User `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUserOutput) GoString() string {
	return s.String()
}

// SetUser sets the User field's value.
func (s *UpdateUserOutput) SetUser(v *User) *UpdateUserOutput {
	s.User = v
	return s
}

// You create users and assign them specific permissions by using an access
// string. You assign the users to Access Control Lists aligned with a specific
// role (administrators, human resources) that are then deployed to one or more
// MemoryDB clusters.
type User struct {
	_ struct{} `type:"structure"`

	// The names of the Access Control Lists to which the user belongs
	ACLNames []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the user.
	ARN *string `type:"string"`

	// Access permissions string used for this user.
	AccessString *string `type:"string"`

	// Denotes whether the user requires a password to authenticate.
	Authentication *Authentication `type:"structure"`

	// The minimum engine version supported for the user
	MinimumEngineVersion *string `type:"string"`

	// The name of the user
	Name *string `type:"string"`

	// Indicates the user status. Can be "active", "modifying" or "deleting".
	Status *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s User) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s User) GoString() string {
	return s.String()
}

// SetACLNames sets the ACLNames field's value.
func (s *User) SetACLNames(v []*string) *User {
	s.ACLNames = v
	return s
}

// SetARN sets the ARN field's value.
func (s *User) SetARN(v string) *User {
	s.ARN = &v
	return s
}

// SetAccessString sets the AccessString field's value.
func (s *User) SetAccessString(v string) *User {
	s.AccessString = &v
	return s
}

// SetAuthentication sets the Authentication field's value.
func (s *User) SetAuthentication(v *Authentication) *User {
	s.Authentication = v
	return s
}

// SetMinimumEngineVersion sets the MinimumEngineVersion field's value.
func (s *User) SetMinimumEngineVersion(v string) *User {
	s.MinimumEngineVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *User) SetName(v string) *User {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *User) SetStatus(v string) *User {
	s.Status = &v
	return s
}

type UserAlreadyExistsFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserAlreadyExistsFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserAlreadyExistsFault) GoString() string {
	return s.String()
}

func newErrorUserAlreadyExistsFault(v protocol.ResponseMetadata) error {
	return &UserAlreadyExistsFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UserAlreadyExistsFault) Code() string {
	return "UserAlreadyExistsFault"
}

// Message returns the exception's message.
func (s *UserAlreadyExistsFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UserAlreadyExistsFault) OrigErr() error {
	return nil
}

func (s *UserAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UserAlreadyExistsFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UserAlreadyExistsFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type UserNotFoundFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserNotFoundFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserNotFoundFault) GoString() string {
	return s.String()
}

func newErrorUserNotFoundFault(v protocol.ResponseMetadata) error {
	return &UserNotFoundFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UserNotFoundFault) Code() string {
	return "UserNotFoundFault"
}

// Message returns the exception's message.
func (s *UserNotFoundFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UserNotFoundFault) OrigErr() error {
	return nil
}

func (s *UserNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UserNotFoundFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UserNotFoundFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type UserQuotaExceededFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserQuotaExceededFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserQuotaExceededFault) GoString() string {
	return s.String()
}

func newErrorUserQuotaExceededFault(v protocol.ResponseMetadata) error {
	return &UserQuotaExceededFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UserQuotaExceededFault) Code() string {
	return "UserQuotaExceededFault"
}

// Message returns the exception's message.
func (s *UserQuotaExceededFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UserQuotaExceededFault) OrigErr() error {
	return nil
}

func (s *UserQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UserQuotaExceededFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UserQuotaExceededFault) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AZStatusSingleaz is a AZStatus enum value
	AZStatusSingleaz = "singleaz"

	// AZStatusMultiaz is a AZStatus enum value
	AZStatusMultiaz = "multiaz"
)

// AZStatus_Values returns all elements of the AZStatus enum
func AZStatus_Values() []string {
	return []string{
		AZStatusSingleaz,
		AZStatusMultiaz,
	}
}

const (
	// AuthenticationTypePassword is a AuthenticationType enum value
	AuthenticationTypePassword = "password"

	// AuthenticationTypeNoPassword is a AuthenticationType enum value
	AuthenticationTypeNoPassword = "no-password"
)

// AuthenticationType_Values returns all elements of the AuthenticationType enum
func AuthenticationType_Values() []string {
	return []string{
		AuthenticationTypePassword,
		AuthenticationTypeNoPassword,
	}
}

const (
	// InputAuthenticationTypePassword is a InputAuthenticationType enum value
	InputAuthenticationTypePassword = "password"
)

// InputAuthenticationType_Values returns all elements of the InputAuthenticationType enum
func InputAuthenticationType_Values() []string {
	return []string{
		InputAuthenticationTypePassword,
	}
}

const (
	// ServiceUpdateStatusAvailable is a ServiceUpdateStatus enum value
	ServiceUpdateStatusAvailable = "available"

	// ServiceUpdateStatusInProgress is a ServiceUpdateStatus enum value
	ServiceUpdateStatusInProgress = "in-progress"

	// ServiceUpdateStatusComplete is a ServiceUpdateStatus enum value
	ServiceUpdateStatusComplete = "complete"

	// ServiceUpdateStatusScheduled is a ServiceUpdateStatus enum value
	ServiceUpdateStatusScheduled = "scheduled"
)

// ServiceUpdateStatus_Values returns all elements of the ServiceUpdateStatus enum
func ServiceUpdateStatus_Values() []string {
	return []string{
		ServiceUpdateStatusAvailable,
		ServiceUpdateStatusInProgress,
		ServiceUpdateStatusComplete,
		ServiceUpdateStatusScheduled,
	}
}

const (
	// ServiceUpdateTypeSecurityUpdate is a ServiceUpdateType enum value
	ServiceUpdateTypeSecurityUpdate = "security-update"
)

// ServiceUpdateType_Values returns all elements of the ServiceUpdateType enum
func ServiceUpdateType_Values() []string {
	return []string{
		ServiceUpdateTypeSecurityUpdate,
	}
}

const (
	// SourceTypeNode is a SourceType enum value
	SourceTypeNode = "node"

	// SourceTypeParameterGroup is a SourceType enum value
	SourceTypeParameterGroup = "parameter-group"

	// SourceTypeSubnetGroup is a SourceType enum value
	SourceTypeSubnetGroup = "subnet-group"

	// SourceTypeCluster is a SourceType enum value
	SourceTypeCluster = "cluster"

	// SourceTypeUser is a SourceType enum value
	SourceTypeUser = "user"

	// SourceTypeAcl is a SourceType enum value
	SourceTypeAcl = "acl"
)

// SourceType_Values returns all elements of the SourceType enum
func SourceType_Values() []string {
	return []string{
		SourceTypeNode,
		SourceTypeParameterGroup,
		SourceTypeSubnetGroup,
		SourceTypeCluster,
		SourceTypeUser,
		SourceTypeAcl,
	}
}
