// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehendmedical

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opDescribeEntitiesDetectionV2Job = "DescribeEntitiesDetectionV2Job"

// DescribeEntitiesDetectionV2JobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEntitiesDetectionV2Job operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEntitiesDetectionV2Job for more information on using the DescribeEntitiesDetectionV2Job
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEntitiesDetectionV2JobRequest method.
//	req, resp := client.DescribeEntitiesDetectionV2JobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeEntitiesDetectionV2Job
func (c *ComprehendMedical) DescribeEntitiesDetectionV2JobRequest(input *DescribeEntitiesDetectionV2JobInput) (req *request.Request, output *DescribeEntitiesDetectionV2JobOutput) {
	op := &request.Operation{
		Name:       opDescribeEntitiesDetectionV2Job,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEntitiesDetectionV2JobInput{}
	}

	output = &DescribeEntitiesDetectionV2JobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEntitiesDetectionV2Job API operation for AWS Comprehend Medical.
//
// Gets the properties associated with a medical entities detection job. Use
// this operation to get the status of a detection job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation DescribeEntitiesDetectionV2Job for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - ResourceNotFoundException
//     The resource identified by the specified Amazon Resource Name (ARN) was not
//     found. Check the ARN and try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeEntitiesDetectionV2Job
func (c *ComprehendMedical) DescribeEntitiesDetectionV2Job(input *DescribeEntitiesDetectionV2JobInput) (*DescribeEntitiesDetectionV2JobOutput, error) {
	req, out := c.DescribeEntitiesDetectionV2JobRequest(input)
	return out, req.Send()
}

// DescribeEntitiesDetectionV2JobWithContext is the same as DescribeEntitiesDetectionV2Job with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEntitiesDetectionV2Job for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) DescribeEntitiesDetectionV2JobWithContext(ctx aws.Context, input *DescribeEntitiesDetectionV2JobInput, opts ...request.Option) (*DescribeEntitiesDetectionV2JobOutput, error) {
	req, out := c.DescribeEntitiesDetectionV2JobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeICD10CMInferenceJob = "DescribeICD10CMInferenceJob"

// DescribeICD10CMInferenceJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeICD10CMInferenceJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeICD10CMInferenceJob for more information on using the DescribeICD10CMInferenceJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeICD10CMInferenceJobRequest method.
//	req, resp := client.DescribeICD10CMInferenceJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeICD10CMInferenceJob
func (c *ComprehendMedical) DescribeICD10CMInferenceJobRequest(input *DescribeICD10CMInferenceJobInput) (req *request.Request, output *DescribeICD10CMInferenceJobOutput) {
	op := &request.Operation{
		Name:       opDescribeICD10CMInferenceJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeICD10CMInferenceJobInput{}
	}

	output = &DescribeICD10CMInferenceJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeICD10CMInferenceJob API operation for AWS Comprehend Medical.
//
// Gets the properties associated with an InferICD10CM job. Use this operation
// to get the status of an inference job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation DescribeICD10CMInferenceJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - ResourceNotFoundException
//     The resource identified by the specified Amazon Resource Name (ARN) was not
//     found. Check the ARN and try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeICD10CMInferenceJob
func (c *ComprehendMedical) DescribeICD10CMInferenceJob(input *DescribeICD10CMInferenceJobInput) (*DescribeICD10CMInferenceJobOutput, error) {
	req, out := c.DescribeICD10CMInferenceJobRequest(input)
	return out, req.Send()
}

// DescribeICD10CMInferenceJobWithContext is the same as DescribeICD10CMInferenceJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeICD10CMInferenceJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) DescribeICD10CMInferenceJobWithContext(ctx aws.Context, input *DescribeICD10CMInferenceJobInput, opts ...request.Option) (*DescribeICD10CMInferenceJobOutput, error) {
	req, out := c.DescribeICD10CMInferenceJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePHIDetectionJob = "DescribePHIDetectionJob"

// DescribePHIDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribePHIDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePHIDetectionJob for more information on using the DescribePHIDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePHIDetectionJobRequest method.
//	req, resp := client.DescribePHIDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribePHIDetectionJob
func (c *ComprehendMedical) DescribePHIDetectionJobRequest(input *DescribePHIDetectionJobInput) (req *request.Request, output *DescribePHIDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribePHIDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePHIDetectionJobInput{}
	}

	output = &DescribePHIDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePHIDetectionJob API operation for AWS Comprehend Medical.
//
// Gets the properties associated with a protected health information (PHI)
// detection job. Use this operation to get the status of a detection job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation DescribePHIDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - ResourceNotFoundException
//     The resource identified by the specified Amazon Resource Name (ARN) was not
//     found. Check the ARN and try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribePHIDetectionJob
func (c *ComprehendMedical) DescribePHIDetectionJob(input *DescribePHIDetectionJobInput) (*DescribePHIDetectionJobOutput, error) {
	req, out := c.DescribePHIDetectionJobRequest(input)
	return out, req.Send()
}

// DescribePHIDetectionJobWithContext is the same as DescribePHIDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePHIDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) DescribePHIDetectionJobWithContext(ctx aws.Context, input *DescribePHIDetectionJobInput, opts ...request.Option) (*DescribePHIDetectionJobOutput, error) {
	req, out := c.DescribePHIDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRxNormInferenceJob = "DescribeRxNormInferenceJob"

// DescribeRxNormInferenceJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRxNormInferenceJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRxNormInferenceJob for more information on using the DescribeRxNormInferenceJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRxNormInferenceJobRequest method.
//	req, resp := client.DescribeRxNormInferenceJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeRxNormInferenceJob
func (c *ComprehendMedical) DescribeRxNormInferenceJobRequest(input *DescribeRxNormInferenceJobInput) (req *request.Request, output *DescribeRxNormInferenceJobOutput) {
	op := &request.Operation{
		Name:       opDescribeRxNormInferenceJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRxNormInferenceJobInput{}
	}

	output = &DescribeRxNormInferenceJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRxNormInferenceJob API operation for AWS Comprehend Medical.
//
// Gets the properties associated with an InferRxNorm job. Use this operation
// to get the status of an inference job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation DescribeRxNormInferenceJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - ResourceNotFoundException
//     The resource identified by the specified Amazon Resource Name (ARN) was not
//     found. Check the ARN and try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeRxNormInferenceJob
func (c *ComprehendMedical) DescribeRxNormInferenceJob(input *DescribeRxNormInferenceJobInput) (*DescribeRxNormInferenceJobOutput, error) {
	req, out := c.DescribeRxNormInferenceJobRequest(input)
	return out, req.Send()
}

// DescribeRxNormInferenceJobWithContext is the same as DescribeRxNormInferenceJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRxNormInferenceJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) DescribeRxNormInferenceJobWithContext(ctx aws.Context, input *DescribeRxNormInferenceJobInput, opts ...request.Option) (*DescribeRxNormInferenceJobOutput, error) {
	req, out := c.DescribeRxNormInferenceJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSNOMEDCTInferenceJob = "DescribeSNOMEDCTInferenceJob"

// DescribeSNOMEDCTInferenceJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSNOMEDCTInferenceJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSNOMEDCTInferenceJob for more information on using the DescribeSNOMEDCTInferenceJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSNOMEDCTInferenceJobRequest method.
//	req, resp := client.DescribeSNOMEDCTInferenceJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeSNOMEDCTInferenceJob
func (c *ComprehendMedical) DescribeSNOMEDCTInferenceJobRequest(input *DescribeSNOMEDCTInferenceJobInput) (req *request.Request, output *DescribeSNOMEDCTInferenceJobOutput) {
	op := &request.Operation{
		Name:       opDescribeSNOMEDCTInferenceJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSNOMEDCTInferenceJobInput{}
	}

	output = &DescribeSNOMEDCTInferenceJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSNOMEDCTInferenceJob API operation for AWS Comprehend Medical.
//
// Gets the properties associated with an InferSNOMEDCT job. Use this operation
// to get the status of an inference job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation DescribeSNOMEDCTInferenceJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - ResourceNotFoundException
//     The resource identified by the specified Amazon Resource Name (ARN) was not
//     found. Check the ARN and try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DescribeSNOMEDCTInferenceJob
func (c *ComprehendMedical) DescribeSNOMEDCTInferenceJob(input *DescribeSNOMEDCTInferenceJobInput) (*DescribeSNOMEDCTInferenceJobOutput, error) {
	req, out := c.DescribeSNOMEDCTInferenceJobRequest(input)
	return out, req.Send()
}

// DescribeSNOMEDCTInferenceJobWithContext is the same as DescribeSNOMEDCTInferenceJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSNOMEDCTInferenceJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) DescribeSNOMEDCTInferenceJobWithContext(ctx aws.Context, input *DescribeSNOMEDCTInferenceJobInput, opts ...request.Option) (*DescribeSNOMEDCTInferenceJobOutput, error) {
	req, out := c.DescribeSNOMEDCTInferenceJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectEntities = "DetectEntities"

// DetectEntitiesRequest generates a "aws/request.Request" representing the
// client's request for the DetectEntities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectEntities for more information on using the DetectEntities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DetectEntitiesRequest method.
//	req, resp := client.DetectEntitiesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectEntities
//
// Deprecated: This operation is deprecated, use DetectEntitiesV2 instead.
func (c *ComprehendMedical) DetectEntitiesRequest(input *DetectEntitiesInput) (req *request.Request, output *DetectEntitiesOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DetectEntities, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDetectEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectEntitiesInput{}
	}

	output = &DetectEntitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectEntities API operation for AWS Comprehend Medical.
//
// The DetectEntities operation is deprecated. You should use the DetectEntitiesV2
// operation instead.
//
// Inspects the clinical text for a variety of medical entities and returns
// specific information about them such as entity category, location, and confidence
// score on that information .
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation DetectEntities for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ServiceUnavailableException
//     The Comprehend Medical; service is temporarily unavailable. Please wait and
//     then retry your request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - InvalidEncodingException
//     The input text was not in valid UTF-8 character encoding. Check your text
//     then retry your request.
//
//   - TextSizeLimitExceededException
//     The size of the text you submitted exceeds the size limit. Reduce the size
//     of the text or use a smaller document and then retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectEntities
//
// Deprecated: This operation is deprecated, use DetectEntitiesV2 instead.
func (c *ComprehendMedical) DetectEntities(input *DetectEntitiesInput) (*DetectEntitiesOutput, error) {
	req, out := c.DetectEntitiesRequest(input)
	return out, req.Send()
}

// DetectEntitiesWithContext is the same as DetectEntities with the addition of
// the ability to pass a context and additional request options.
//
// See DetectEntities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: This operation is deprecated, use DetectEntitiesV2 instead.
func (c *ComprehendMedical) DetectEntitiesWithContext(ctx aws.Context, input *DetectEntitiesInput, opts ...request.Option) (*DetectEntitiesOutput, error) {
	req, out := c.DetectEntitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectEntitiesV2 = "DetectEntitiesV2"

// DetectEntitiesV2Request generates a "aws/request.Request" representing the
// client's request for the DetectEntitiesV2 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectEntitiesV2 for more information on using the DetectEntitiesV2
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DetectEntitiesV2Request method.
//	req, resp := client.DetectEntitiesV2Request(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectEntitiesV2
func (c *ComprehendMedical) DetectEntitiesV2Request(input *DetectEntitiesV2Input) (req *request.Request, output *DetectEntitiesV2Output) {
	op := &request.Operation{
		Name:       opDetectEntitiesV2,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectEntitiesV2Input{}
	}

	output = &DetectEntitiesV2Output{}
	req = c.newRequest(op, input, output)
	return
}

// DetectEntitiesV2 API operation for AWS Comprehend Medical.
//
// Inspects the clinical text for a variety of medical entities and returns
// specific information about them such as entity category, location, and confidence
// score on that information. Amazon Comprehend Medical only detects medical
// entities in English language texts.
//
// The DetectEntitiesV2 operation replaces the DetectEntities operation. This
// new action uses a different model for determining the entities in your medical
// text and changes the way that some entities are returned in the output. You
// should use the DetectEntitiesV2 operation in all new applications.
//
// The DetectEntitiesV2 operation returns the Acuity and Direction entities
// as attributes instead of types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation DetectEntitiesV2 for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ServiceUnavailableException
//     The Comprehend Medical; service is temporarily unavailable. Please wait and
//     then retry your request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - InvalidEncodingException
//     The input text was not in valid UTF-8 character encoding. Check your text
//     then retry your request.
//
//   - TextSizeLimitExceededException
//     The size of the text you submitted exceeds the size limit. Reduce the size
//     of the text or use a smaller document and then retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectEntitiesV2
func (c *ComprehendMedical) DetectEntitiesV2(input *DetectEntitiesV2Input) (*DetectEntitiesV2Output, error) {
	req, out := c.DetectEntitiesV2Request(input)
	return out, req.Send()
}

// DetectEntitiesV2WithContext is the same as DetectEntitiesV2 with the addition of
// the ability to pass a context and additional request options.
//
// See DetectEntitiesV2 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) DetectEntitiesV2WithContext(ctx aws.Context, input *DetectEntitiesV2Input, opts ...request.Option) (*DetectEntitiesV2Output, error) {
	req, out := c.DetectEntitiesV2Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectPHI = "DetectPHI"

// DetectPHIRequest generates a "aws/request.Request" representing the
// client's request for the DetectPHI operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectPHI for more information on using the DetectPHI
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DetectPHIRequest method.
//	req, resp := client.DetectPHIRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectPHI
func (c *ComprehendMedical) DetectPHIRequest(input *DetectPHIInput) (req *request.Request, output *DetectPHIOutput) {
	op := &request.Operation{
		Name:       opDetectPHI,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectPHIInput{}
	}

	output = &DetectPHIOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectPHI API operation for AWS Comprehend Medical.
//
// Inspects the clinical text for protected health information (PHI) entities
// and returns the entity category, location, and confidence score for each
// entity. Amazon Comprehend Medical only detects entities in English language
// texts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation DetectPHI for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ServiceUnavailableException
//     The Comprehend Medical; service is temporarily unavailable. Please wait and
//     then retry your request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - InvalidEncodingException
//     The input text was not in valid UTF-8 character encoding. Check your text
//     then retry your request.
//
//   - TextSizeLimitExceededException
//     The size of the text you submitted exceeds the size limit. Reduce the size
//     of the text or use a smaller document and then retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/DetectPHI
func (c *ComprehendMedical) DetectPHI(input *DetectPHIInput) (*DetectPHIOutput, error) {
	req, out := c.DetectPHIRequest(input)
	return out, req.Send()
}

// DetectPHIWithContext is the same as DetectPHI with the addition of
// the ability to pass a context and additional request options.
//
// See DetectPHI for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) DetectPHIWithContext(ctx aws.Context, input *DetectPHIInput, opts ...request.Option) (*DetectPHIOutput, error) {
	req, out := c.DetectPHIRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInferICD10CM = "InferICD10CM"

// InferICD10CMRequest generates a "aws/request.Request" representing the
// client's request for the InferICD10CM operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InferICD10CM for more information on using the InferICD10CM
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the InferICD10CMRequest method.
//	req, resp := client.InferICD10CMRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/InferICD10CM
func (c *ComprehendMedical) InferICD10CMRequest(input *InferICD10CMInput) (req *request.Request, output *InferICD10CMOutput) {
	op := &request.Operation{
		Name:       opInferICD10CM,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &InferICD10CMInput{}
	}

	output = &InferICD10CMOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InferICD10CM API operation for AWS Comprehend Medical.
//
// InferICD10CM detects medical conditions as entities listed in a patient record
// and links those entities to normalized concept identifiers in the ICD-10-CM
// knowledge base from the Centers for Disease Control. Amazon Comprehend Medical
// only detects medical entities in English language texts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation InferICD10CM for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ServiceUnavailableException
//     The Comprehend Medical; service is temporarily unavailable. Please wait and
//     then retry your request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - InvalidEncodingException
//     The input text was not in valid UTF-8 character encoding. Check your text
//     then retry your request.
//
//   - TextSizeLimitExceededException
//     The size of the text you submitted exceeds the size limit. Reduce the size
//     of the text or use a smaller document and then retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/InferICD10CM
func (c *ComprehendMedical) InferICD10CM(input *InferICD10CMInput) (*InferICD10CMOutput, error) {
	req, out := c.InferICD10CMRequest(input)
	return out, req.Send()
}

// InferICD10CMWithContext is the same as InferICD10CM with the addition of
// the ability to pass a context and additional request options.
//
// See InferICD10CM for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) InferICD10CMWithContext(ctx aws.Context, input *InferICD10CMInput, opts ...request.Option) (*InferICD10CMOutput, error) {
	req, out := c.InferICD10CMRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInferRxNorm = "InferRxNorm"

// InferRxNormRequest generates a "aws/request.Request" representing the
// client's request for the InferRxNorm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InferRxNorm for more information on using the InferRxNorm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the InferRxNormRequest method.
//	req, resp := client.InferRxNormRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/InferRxNorm
func (c *ComprehendMedical) InferRxNormRequest(input *InferRxNormInput) (req *request.Request, output *InferRxNormOutput) {
	op := &request.Operation{
		Name:       opInferRxNorm,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &InferRxNormInput{}
	}

	output = &InferRxNormOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InferRxNorm API operation for AWS Comprehend Medical.
//
// InferRxNorm detects medications as entities listed in a patient record and
// links to the normalized concept identifiers in the RxNorm database from the
// National Library of Medicine. Amazon Comprehend Medical only detects medical
// entities in English language texts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation InferRxNorm for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ServiceUnavailableException
//     The Comprehend Medical; service is temporarily unavailable. Please wait and
//     then retry your request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - InvalidEncodingException
//     The input text was not in valid UTF-8 character encoding. Check your text
//     then retry your request.
//
//   - TextSizeLimitExceededException
//     The size of the text you submitted exceeds the size limit. Reduce the size
//     of the text or use a smaller document and then retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/InferRxNorm
func (c *ComprehendMedical) InferRxNorm(input *InferRxNormInput) (*InferRxNormOutput, error) {
	req, out := c.InferRxNormRequest(input)
	return out, req.Send()
}

// InferRxNormWithContext is the same as InferRxNorm with the addition of
// the ability to pass a context and additional request options.
//
// See InferRxNorm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) InferRxNormWithContext(ctx aws.Context, input *InferRxNormInput, opts ...request.Option) (*InferRxNormOutput, error) {
	req, out := c.InferRxNormRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInferSNOMEDCT = "InferSNOMEDCT"

// InferSNOMEDCTRequest generates a "aws/request.Request" representing the
// client's request for the InferSNOMEDCT operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InferSNOMEDCT for more information on using the InferSNOMEDCT
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the InferSNOMEDCTRequest method.
//	req, resp := client.InferSNOMEDCTRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/InferSNOMEDCT
func (c *ComprehendMedical) InferSNOMEDCTRequest(input *InferSNOMEDCTInput) (req *request.Request, output *InferSNOMEDCTOutput) {
	op := &request.Operation{
		Name:       opInferSNOMEDCT,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &InferSNOMEDCTInput{}
	}

	output = &InferSNOMEDCTOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InferSNOMEDCT API operation for AWS Comprehend Medical.
//
// InferSNOMEDCT detects possible medical concepts as entities and links them
// to codes from the Systematized Nomenclature of Medicine, Clinical Terms (SNOMED-CT)
// ontology
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation InferSNOMEDCT for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ServiceUnavailableException
//     The Comprehend Medical; service is temporarily unavailable. Please wait and
//     then retry your request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - InvalidEncodingException
//     The input text was not in valid UTF-8 character encoding. Check your text
//     then retry your request.
//
//   - TextSizeLimitExceededException
//     The size of the text you submitted exceeds the size limit. Reduce the size
//     of the text or use a smaller document and then retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/InferSNOMEDCT
func (c *ComprehendMedical) InferSNOMEDCT(input *InferSNOMEDCTInput) (*InferSNOMEDCTOutput, error) {
	req, out := c.InferSNOMEDCTRequest(input)
	return out, req.Send()
}

// InferSNOMEDCTWithContext is the same as InferSNOMEDCT with the addition of
// the ability to pass a context and additional request options.
//
// See InferSNOMEDCT for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) InferSNOMEDCTWithContext(ctx aws.Context, input *InferSNOMEDCTInput, opts ...request.Option) (*InferSNOMEDCTOutput, error) {
	req, out := c.InferSNOMEDCTRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEntitiesDetectionV2Jobs = "ListEntitiesDetectionV2Jobs"

// ListEntitiesDetectionV2JobsRequest generates a "aws/request.Request" representing the
// client's request for the ListEntitiesDetectionV2Jobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEntitiesDetectionV2Jobs for more information on using the ListEntitiesDetectionV2Jobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEntitiesDetectionV2JobsRequest method.
//	req, resp := client.ListEntitiesDetectionV2JobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListEntitiesDetectionV2Jobs
func (c *ComprehendMedical) ListEntitiesDetectionV2JobsRequest(input *ListEntitiesDetectionV2JobsInput) (req *request.Request, output *ListEntitiesDetectionV2JobsOutput) {
	op := &request.Operation{
		Name:       opListEntitiesDetectionV2Jobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListEntitiesDetectionV2JobsInput{}
	}

	output = &ListEntitiesDetectionV2JobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEntitiesDetectionV2Jobs API operation for AWS Comprehend Medical.
//
// Gets a list of medical entity detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation ListEntitiesDetectionV2Jobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - ValidationException
//     The filter that you specified for the operation is invalid. Check the filter
//     values that you entered and try your request again.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListEntitiesDetectionV2Jobs
func (c *ComprehendMedical) ListEntitiesDetectionV2Jobs(input *ListEntitiesDetectionV2JobsInput) (*ListEntitiesDetectionV2JobsOutput, error) {
	req, out := c.ListEntitiesDetectionV2JobsRequest(input)
	return out, req.Send()
}

// ListEntitiesDetectionV2JobsWithContext is the same as ListEntitiesDetectionV2Jobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListEntitiesDetectionV2Jobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) ListEntitiesDetectionV2JobsWithContext(ctx aws.Context, input *ListEntitiesDetectionV2JobsInput, opts ...request.Option) (*ListEntitiesDetectionV2JobsOutput, error) {
	req, out := c.ListEntitiesDetectionV2JobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListICD10CMInferenceJobs = "ListICD10CMInferenceJobs"

// ListICD10CMInferenceJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListICD10CMInferenceJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListICD10CMInferenceJobs for more information on using the ListICD10CMInferenceJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListICD10CMInferenceJobsRequest method.
//	req, resp := client.ListICD10CMInferenceJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListICD10CMInferenceJobs
func (c *ComprehendMedical) ListICD10CMInferenceJobsRequest(input *ListICD10CMInferenceJobsInput) (req *request.Request, output *ListICD10CMInferenceJobsOutput) {
	op := &request.Operation{
		Name:       opListICD10CMInferenceJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListICD10CMInferenceJobsInput{}
	}

	output = &ListICD10CMInferenceJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListICD10CMInferenceJobs API operation for AWS Comprehend Medical.
//
// Gets a list of InferICD10CM jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation ListICD10CMInferenceJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - ValidationException
//     The filter that you specified for the operation is invalid. Check the filter
//     values that you entered and try your request again.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListICD10CMInferenceJobs
func (c *ComprehendMedical) ListICD10CMInferenceJobs(input *ListICD10CMInferenceJobsInput) (*ListICD10CMInferenceJobsOutput, error) {
	req, out := c.ListICD10CMInferenceJobsRequest(input)
	return out, req.Send()
}

// ListICD10CMInferenceJobsWithContext is the same as ListICD10CMInferenceJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListICD10CMInferenceJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) ListICD10CMInferenceJobsWithContext(ctx aws.Context, input *ListICD10CMInferenceJobsInput, opts ...request.Option) (*ListICD10CMInferenceJobsOutput, error) {
	req, out := c.ListICD10CMInferenceJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPHIDetectionJobs = "ListPHIDetectionJobs"

// ListPHIDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListPHIDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPHIDetectionJobs for more information on using the ListPHIDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPHIDetectionJobsRequest method.
//	req, resp := client.ListPHIDetectionJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListPHIDetectionJobs
func (c *ComprehendMedical) ListPHIDetectionJobsRequest(input *ListPHIDetectionJobsInput) (req *request.Request, output *ListPHIDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListPHIDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPHIDetectionJobsInput{}
	}

	output = &ListPHIDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPHIDetectionJobs API operation for AWS Comprehend Medical.
//
// Gets a list of protected health information (PHI) detection jobs that you
// have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation ListPHIDetectionJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - ValidationException
//     The filter that you specified for the operation is invalid. Check the filter
//     values that you entered and try your request again.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListPHIDetectionJobs
func (c *ComprehendMedical) ListPHIDetectionJobs(input *ListPHIDetectionJobsInput) (*ListPHIDetectionJobsOutput, error) {
	req, out := c.ListPHIDetectionJobsRequest(input)
	return out, req.Send()
}

// ListPHIDetectionJobsWithContext is the same as ListPHIDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListPHIDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) ListPHIDetectionJobsWithContext(ctx aws.Context, input *ListPHIDetectionJobsInput, opts ...request.Option) (*ListPHIDetectionJobsOutput, error) {
	req, out := c.ListPHIDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRxNormInferenceJobs = "ListRxNormInferenceJobs"

// ListRxNormInferenceJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListRxNormInferenceJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRxNormInferenceJobs for more information on using the ListRxNormInferenceJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRxNormInferenceJobsRequest method.
//	req, resp := client.ListRxNormInferenceJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListRxNormInferenceJobs
func (c *ComprehendMedical) ListRxNormInferenceJobsRequest(input *ListRxNormInferenceJobsInput) (req *request.Request, output *ListRxNormInferenceJobsOutput) {
	op := &request.Operation{
		Name:       opListRxNormInferenceJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRxNormInferenceJobsInput{}
	}

	output = &ListRxNormInferenceJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRxNormInferenceJobs API operation for AWS Comprehend Medical.
//
// Gets a list of InferRxNorm jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation ListRxNormInferenceJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - ValidationException
//     The filter that you specified for the operation is invalid. Check the filter
//     values that you entered and try your request again.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListRxNormInferenceJobs
func (c *ComprehendMedical) ListRxNormInferenceJobs(input *ListRxNormInferenceJobsInput) (*ListRxNormInferenceJobsOutput, error) {
	req, out := c.ListRxNormInferenceJobsRequest(input)
	return out, req.Send()
}

// ListRxNormInferenceJobsWithContext is the same as ListRxNormInferenceJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListRxNormInferenceJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) ListRxNormInferenceJobsWithContext(ctx aws.Context, input *ListRxNormInferenceJobsInput, opts ...request.Option) (*ListRxNormInferenceJobsOutput, error) {
	req, out := c.ListRxNormInferenceJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSNOMEDCTInferenceJobs = "ListSNOMEDCTInferenceJobs"

// ListSNOMEDCTInferenceJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListSNOMEDCTInferenceJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSNOMEDCTInferenceJobs for more information on using the ListSNOMEDCTInferenceJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSNOMEDCTInferenceJobsRequest method.
//	req, resp := client.ListSNOMEDCTInferenceJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListSNOMEDCTInferenceJobs
func (c *ComprehendMedical) ListSNOMEDCTInferenceJobsRequest(input *ListSNOMEDCTInferenceJobsInput) (req *request.Request, output *ListSNOMEDCTInferenceJobsOutput) {
	op := &request.Operation{
		Name:       opListSNOMEDCTInferenceJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListSNOMEDCTInferenceJobsInput{}
	}

	output = &ListSNOMEDCTInferenceJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSNOMEDCTInferenceJobs API operation for AWS Comprehend Medical.
//
// Gets a list of InferSNOMEDCT jobs a user has submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation ListSNOMEDCTInferenceJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - ValidationException
//     The filter that you specified for the operation is invalid. Check the filter
//     values that you entered and try your request again.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/ListSNOMEDCTInferenceJobs
func (c *ComprehendMedical) ListSNOMEDCTInferenceJobs(input *ListSNOMEDCTInferenceJobsInput) (*ListSNOMEDCTInferenceJobsOutput, error) {
	req, out := c.ListSNOMEDCTInferenceJobsRequest(input)
	return out, req.Send()
}

// ListSNOMEDCTInferenceJobsWithContext is the same as ListSNOMEDCTInferenceJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListSNOMEDCTInferenceJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) ListSNOMEDCTInferenceJobsWithContext(ctx aws.Context, input *ListSNOMEDCTInferenceJobsInput, opts ...request.Option) (*ListSNOMEDCTInferenceJobsOutput, error) {
	req, out := c.ListSNOMEDCTInferenceJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartEntitiesDetectionV2Job = "StartEntitiesDetectionV2Job"

// StartEntitiesDetectionV2JobRequest generates a "aws/request.Request" representing the
// client's request for the StartEntitiesDetectionV2Job operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartEntitiesDetectionV2Job for more information on using the StartEntitiesDetectionV2Job
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartEntitiesDetectionV2JobRequest method.
//	req, resp := client.StartEntitiesDetectionV2JobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartEntitiesDetectionV2Job
func (c *ComprehendMedical) StartEntitiesDetectionV2JobRequest(input *StartEntitiesDetectionV2JobInput) (req *request.Request, output *StartEntitiesDetectionV2JobOutput) {
	op := &request.Operation{
		Name:       opStartEntitiesDetectionV2Job,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartEntitiesDetectionV2JobInput{}
	}

	output = &StartEntitiesDetectionV2JobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartEntitiesDetectionV2Job API operation for AWS Comprehend Medical.
//
// Starts an asynchronous medical entity detection job for a collection of documents.
// Use the DescribeEntitiesDetectionV2Job operation to track the status of a
// job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation StartEntitiesDetectionV2Job for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - ResourceNotFoundException
//     The resource identified by the specified Amazon Resource Name (ARN) was not
//     found. Check the ARN and try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartEntitiesDetectionV2Job
func (c *ComprehendMedical) StartEntitiesDetectionV2Job(input *StartEntitiesDetectionV2JobInput) (*StartEntitiesDetectionV2JobOutput, error) {
	req, out := c.StartEntitiesDetectionV2JobRequest(input)
	return out, req.Send()
}

// StartEntitiesDetectionV2JobWithContext is the same as StartEntitiesDetectionV2Job with the addition of
// the ability to pass a context and additional request options.
//
// See StartEntitiesDetectionV2Job for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) StartEntitiesDetectionV2JobWithContext(ctx aws.Context, input *StartEntitiesDetectionV2JobInput, opts ...request.Option) (*StartEntitiesDetectionV2JobOutput, error) {
	req, out := c.StartEntitiesDetectionV2JobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartICD10CMInferenceJob = "StartICD10CMInferenceJob"

// StartICD10CMInferenceJobRequest generates a "aws/request.Request" representing the
// client's request for the StartICD10CMInferenceJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartICD10CMInferenceJob for more information on using the StartICD10CMInferenceJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartICD10CMInferenceJobRequest method.
//	req, resp := client.StartICD10CMInferenceJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartICD10CMInferenceJob
func (c *ComprehendMedical) StartICD10CMInferenceJobRequest(input *StartICD10CMInferenceJobInput) (req *request.Request, output *StartICD10CMInferenceJobOutput) {
	op := &request.Operation{
		Name:       opStartICD10CMInferenceJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartICD10CMInferenceJobInput{}
	}

	output = &StartICD10CMInferenceJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartICD10CMInferenceJob API operation for AWS Comprehend Medical.
//
// Starts an asynchronous job to detect medical conditions and link them to
// the ICD-10-CM ontology. Use the DescribeICD10CMInferenceJob operation to
// track the status of a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation StartICD10CMInferenceJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - ResourceNotFoundException
//     The resource identified by the specified Amazon Resource Name (ARN) was not
//     found. Check the ARN and try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartICD10CMInferenceJob
func (c *ComprehendMedical) StartICD10CMInferenceJob(input *StartICD10CMInferenceJobInput) (*StartICD10CMInferenceJobOutput, error) {
	req, out := c.StartICD10CMInferenceJobRequest(input)
	return out, req.Send()
}

// StartICD10CMInferenceJobWithContext is the same as StartICD10CMInferenceJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartICD10CMInferenceJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) StartICD10CMInferenceJobWithContext(ctx aws.Context, input *StartICD10CMInferenceJobInput, opts ...request.Option) (*StartICD10CMInferenceJobOutput, error) {
	req, out := c.StartICD10CMInferenceJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartPHIDetectionJob = "StartPHIDetectionJob"

// StartPHIDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartPHIDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartPHIDetectionJob for more information on using the StartPHIDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartPHIDetectionJobRequest method.
//	req, resp := client.StartPHIDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartPHIDetectionJob
func (c *ComprehendMedical) StartPHIDetectionJobRequest(input *StartPHIDetectionJobInput) (req *request.Request, output *StartPHIDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartPHIDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartPHIDetectionJobInput{}
	}

	output = &StartPHIDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartPHIDetectionJob API operation for AWS Comprehend Medical.
//
// Starts an asynchronous job to detect protected health information (PHI).
// Use the DescribePHIDetectionJob operation to track the status of a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation StartPHIDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - ResourceNotFoundException
//     The resource identified by the specified Amazon Resource Name (ARN) was not
//     found. Check the ARN and try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartPHIDetectionJob
func (c *ComprehendMedical) StartPHIDetectionJob(input *StartPHIDetectionJobInput) (*StartPHIDetectionJobOutput, error) {
	req, out := c.StartPHIDetectionJobRequest(input)
	return out, req.Send()
}

// StartPHIDetectionJobWithContext is the same as StartPHIDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartPHIDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) StartPHIDetectionJobWithContext(ctx aws.Context, input *StartPHIDetectionJobInput, opts ...request.Option) (*StartPHIDetectionJobOutput, error) {
	req, out := c.StartPHIDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartRxNormInferenceJob = "StartRxNormInferenceJob"

// StartRxNormInferenceJobRequest generates a "aws/request.Request" representing the
// client's request for the StartRxNormInferenceJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartRxNormInferenceJob for more information on using the StartRxNormInferenceJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartRxNormInferenceJobRequest method.
//	req, resp := client.StartRxNormInferenceJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartRxNormInferenceJob
func (c *ComprehendMedical) StartRxNormInferenceJobRequest(input *StartRxNormInferenceJobInput) (req *request.Request, output *StartRxNormInferenceJobOutput) {
	op := &request.Operation{
		Name:       opStartRxNormInferenceJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartRxNormInferenceJobInput{}
	}

	output = &StartRxNormInferenceJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartRxNormInferenceJob API operation for AWS Comprehend Medical.
//
// Starts an asynchronous job to detect medication entities and link them to
// the RxNorm ontology. Use the DescribeRxNormInferenceJob operation to track
// the status of a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation StartRxNormInferenceJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - ResourceNotFoundException
//     The resource identified by the specified Amazon Resource Name (ARN) was not
//     found. Check the ARN and try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartRxNormInferenceJob
func (c *ComprehendMedical) StartRxNormInferenceJob(input *StartRxNormInferenceJobInput) (*StartRxNormInferenceJobOutput, error) {
	req, out := c.StartRxNormInferenceJobRequest(input)
	return out, req.Send()
}

// StartRxNormInferenceJobWithContext is the same as StartRxNormInferenceJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartRxNormInferenceJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) StartRxNormInferenceJobWithContext(ctx aws.Context, input *StartRxNormInferenceJobInput, opts ...request.Option) (*StartRxNormInferenceJobOutput, error) {
	req, out := c.StartRxNormInferenceJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSNOMEDCTInferenceJob = "StartSNOMEDCTInferenceJob"

// StartSNOMEDCTInferenceJobRequest generates a "aws/request.Request" representing the
// client's request for the StartSNOMEDCTInferenceJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSNOMEDCTInferenceJob for more information on using the StartSNOMEDCTInferenceJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartSNOMEDCTInferenceJobRequest method.
//	req, resp := client.StartSNOMEDCTInferenceJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartSNOMEDCTInferenceJob
func (c *ComprehendMedical) StartSNOMEDCTInferenceJobRequest(input *StartSNOMEDCTInferenceJobInput) (req *request.Request, output *StartSNOMEDCTInferenceJobOutput) {
	op := &request.Operation{
		Name:       opStartSNOMEDCTInferenceJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartSNOMEDCTInferenceJobInput{}
	}

	output = &StartSNOMEDCTInferenceJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartSNOMEDCTInferenceJob API operation for AWS Comprehend Medical.
//
// Starts an asynchronous job to detect medical concepts and link them to the
// SNOMED-CT ontology. Use the DescribeSNOMEDCTInferenceJob operation to track
// the status of a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation StartSNOMEDCTInferenceJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - ResourceNotFoundException
//     The resource identified by the specified Amazon Resource Name (ARN) was not
//     found. Check the ARN and try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StartSNOMEDCTInferenceJob
func (c *ComprehendMedical) StartSNOMEDCTInferenceJob(input *StartSNOMEDCTInferenceJobInput) (*StartSNOMEDCTInferenceJobOutput, error) {
	req, out := c.StartSNOMEDCTInferenceJobRequest(input)
	return out, req.Send()
}

// StartSNOMEDCTInferenceJobWithContext is the same as StartSNOMEDCTInferenceJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartSNOMEDCTInferenceJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) StartSNOMEDCTInferenceJobWithContext(ctx aws.Context, input *StartSNOMEDCTInferenceJobInput, opts ...request.Option) (*StartSNOMEDCTInferenceJobOutput, error) {
	req, out := c.StartSNOMEDCTInferenceJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopEntitiesDetectionV2Job = "StopEntitiesDetectionV2Job"

// StopEntitiesDetectionV2JobRequest generates a "aws/request.Request" representing the
// client's request for the StopEntitiesDetectionV2Job operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopEntitiesDetectionV2Job for more information on using the StopEntitiesDetectionV2Job
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopEntitiesDetectionV2JobRequest method.
//	req, resp := client.StopEntitiesDetectionV2JobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopEntitiesDetectionV2Job
func (c *ComprehendMedical) StopEntitiesDetectionV2JobRequest(input *StopEntitiesDetectionV2JobInput) (req *request.Request, output *StopEntitiesDetectionV2JobOutput) {
	op := &request.Operation{
		Name:       opStopEntitiesDetectionV2Job,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopEntitiesDetectionV2JobInput{}
	}

	output = &StopEntitiesDetectionV2JobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopEntitiesDetectionV2Job API operation for AWS Comprehend Medical.
//
// Stops a medical entities detection job in progress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation StopEntitiesDetectionV2Job for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - ResourceNotFoundException
//     The resource identified by the specified Amazon Resource Name (ARN) was not
//     found. Check the ARN and try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopEntitiesDetectionV2Job
func (c *ComprehendMedical) StopEntitiesDetectionV2Job(input *StopEntitiesDetectionV2JobInput) (*StopEntitiesDetectionV2JobOutput, error) {
	req, out := c.StopEntitiesDetectionV2JobRequest(input)
	return out, req.Send()
}

// StopEntitiesDetectionV2JobWithContext is the same as StopEntitiesDetectionV2Job with the addition of
// the ability to pass a context and additional request options.
//
// See StopEntitiesDetectionV2Job for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) StopEntitiesDetectionV2JobWithContext(ctx aws.Context, input *StopEntitiesDetectionV2JobInput, opts ...request.Option) (*StopEntitiesDetectionV2JobOutput, error) {
	req, out := c.StopEntitiesDetectionV2JobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopICD10CMInferenceJob = "StopICD10CMInferenceJob"

// StopICD10CMInferenceJobRequest generates a "aws/request.Request" representing the
// client's request for the StopICD10CMInferenceJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopICD10CMInferenceJob for more information on using the StopICD10CMInferenceJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopICD10CMInferenceJobRequest method.
//	req, resp := client.StopICD10CMInferenceJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopICD10CMInferenceJob
func (c *ComprehendMedical) StopICD10CMInferenceJobRequest(input *StopICD10CMInferenceJobInput) (req *request.Request, output *StopICD10CMInferenceJobOutput) {
	op := &request.Operation{
		Name:       opStopICD10CMInferenceJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopICD10CMInferenceJobInput{}
	}

	output = &StopICD10CMInferenceJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopICD10CMInferenceJob API operation for AWS Comprehend Medical.
//
// Stops an InferICD10CM inference job in progress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation StopICD10CMInferenceJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - ResourceNotFoundException
//     The resource identified by the specified Amazon Resource Name (ARN) was not
//     found. Check the ARN and try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopICD10CMInferenceJob
func (c *ComprehendMedical) StopICD10CMInferenceJob(input *StopICD10CMInferenceJobInput) (*StopICD10CMInferenceJobOutput, error) {
	req, out := c.StopICD10CMInferenceJobRequest(input)
	return out, req.Send()
}

// StopICD10CMInferenceJobWithContext is the same as StopICD10CMInferenceJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopICD10CMInferenceJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) StopICD10CMInferenceJobWithContext(ctx aws.Context, input *StopICD10CMInferenceJobInput, opts ...request.Option) (*StopICD10CMInferenceJobOutput, error) {
	req, out := c.StopICD10CMInferenceJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopPHIDetectionJob = "StopPHIDetectionJob"

// StopPHIDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StopPHIDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopPHIDetectionJob for more information on using the StopPHIDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopPHIDetectionJobRequest method.
//	req, resp := client.StopPHIDetectionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopPHIDetectionJob
func (c *ComprehendMedical) StopPHIDetectionJobRequest(input *StopPHIDetectionJobInput) (req *request.Request, output *StopPHIDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStopPHIDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopPHIDetectionJobInput{}
	}

	output = &StopPHIDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopPHIDetectionJob API operation for AWS Comprehend Medical.
//
// Stops a protected health information (PHI) detection job in progress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation StopPHIDetectionJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - ResourceNotFoundException
//     The resource identified by the specified Amazon Resource Name (ARN) was not
//     found. Check the ARN and try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopPHIDetectionJob
func (c *ComprehendMedical) StopPHIDetectionJob(input *StopPHIDetectionJobInput) (*StopPHIDetectionJobOutput, error) {
	req, out := c.StopPHIDetectionJobRequest(input)
	return out, req.Send()
}

// StopPHIDetectionJobWithContext is the same as StopPHIDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopPHIDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) StopPHIDetectionJobWithContext(ctx aws.Context, input *StopPHIDetectionJobInput, opts ...request.Option) (*StopPHIDetectionJobOutput, error) {
	req, out := c.StopPHIDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopRxNormInferenceJob = "StopRxNormInferenceJob"

// StopRxNormInferenceJobRequest generates a "aws/request.Request" representing the
// client's request for the StopRxNormInferenceJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopRxNormInferenceJob for more information on using the StopRxNormInferenceJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopRxNormInferenceJobRequest method.
//	req, resp := client.StopRxNormInferenceJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopRxNormInferenceJob
func (c *ComprehendMedical) StopRxNormInferenceJobRequest(input *StopRxNormInferenceJobInput) (req *request.Request, output *StopRxNormInferenceJobOutput) {
	op := &request.Operation{
		Name:       opStopRxNormInferenceJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopRxNormInferenceJobInput{}
	}

	output = &StopRxNormInferenceJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopRxNormInferenceJob API operation for AWS Comprehend Medical.
//
// Stops an InferRxNorm inference job in progress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation StopRxNormInferenceJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - ResourceNotFoundException
//     The resource identified by the specified Amazon Resource Name (ARN) was not
//     found. Check the ARN and try your request again.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopRxNormInferenceJob
func (c *ComprehendMedical) StopRxNormInferenceJob(input *StopRxNormInferenceJobInput) (*StopRxNormInferenceJobOutput, error) {
	req, out := c.StopRxNormInferenceJobRequest(input)
	return out, req.Send()
}

// StopRxNormInferenceJobWithContext is the same as StopRxNormInferenceJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopRxNormInferenceJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) StopRxNormInferenceJobWithContext(ctx aws.Context, input *StopRxNormInferenceJobInput, opts ...request.Option) (*StopRxNormInferenceJobOutput, error) {
	req, out := c.StopRxNormInferenceJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopSNOMEDCTInferenceJob = "StopSNOMEDCTInferenceJob"

// StopSNOMEDCTInferenceJobRequest generates a "aws/request.Request" representing the
// client's request for the StopSNOMEDCTInferenceJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopSNOMEDCTInferenceJob for more information on using the StopSNOMEDCTInferenceJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopSNOMEDCTInferenceJobRequest method.
//	req, resp := client.StopSNOMEDCTInferenceJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopSNOMEDCTInferenceJob
func (c *ComprehendMedical) StopSNOMEDCTInferenceJobRequest(input *StopSNOMEDCTInferenceJobInput) (req *request.Request, output *StopSNOMEDCTInferenceJobOutput) {
	op := &request.Operation{
		Name:       opStopSNOMEDCTInferenceJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopSNOMEDCTInferenceJobInput{}
	}

	output = &StopSNOMEDCTInferenceJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopSNOMEDCTInferenceJob API operation for AWS Comprehend Medical.
//
// Stops an InferSNOMEDCT inference job in progress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Comprehend Medical's
// API operation StopSNOMEDCTInferenceJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request that you made is invalid. Check your request to determine why
//     it's invalid and then retry the request.
//
//   - ResourceNotFoundException
//     The resource identified by the specified Amazon Resource Name (ARN) was not
//     found. Check the ARN and try your request again.
//
//   - TooManyRequestsException
//     You have made too many requests within a short period of time. Wait for a
//     short time and then try your request again. Contact customer support for
//     more information about a service limit increase.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehendmedical-2018-10-30/StopSNOMEDCTInferenceJob
func (c *ComprehendMedical) StopSNOMEDCTInferenceJob(input *StopSNOMEDCTInferenceJobInput) (*StopSNOMEDCTInferenceJobOutput, error) {
	req, out := c.StopSNOMEDCTInferenceJobRequest(input)
	return out, req.Send()
}

// StopSNOMEDCTInferenceJobWithContext is the same as StopSNOMEDCTInferenceJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopSNOMEDCTInferenceJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ComprehendMedical) StopSNOMEDCTInferenceJobWithContext(ctx aws.Context, input *StopSNOMEDCTInferenceJobInput, opts ...request.Option) (*StopSNOMEDCTInferenceJobOutput, error) {
	req, out := c.StopSNOMEDCTInferenceJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An extracted segment of the text that is an attribute of an entity, or otherwise
// related to an entity, such as the dosage of a medication taken. It contains
// information about the attribute such as id, begin and end offset within the
// input text, and the segment of the input text.
type Attribute struct {
	_ struct{} `type:"structure"`

	// The 0-based character offset in the input text that shows where the attribute
	// begins. The offset returns the UTF-8 code point in the string.
	BeginOffset *int64 `type:"integer"`

	// The category of attribute.
	Category *string `type:"string" enum:"EntityType"`

	// The 0-based character offset in the input text that shows where the attribute
	// ends. The offset returns the UTF-8 code point in the string.
	EndOffset *int64 `type:"integer"`

	// The numeric identifier for this attribute. This is a monotonically increasing
	// id unique within this response rather than a global unique identifier.
	Id *int64 `type:"integer"`

	// The level of confidence that Comprehend Medical; has that this attribute
	// is correctly related to this entity.
	RelationshipScore *float64 `type:"float"`

	// The type of relationship between the entity and attribute. Type for the relationship
	// is OVERLAP, indicating that the entity occurred at the same time as the Date_Expression.
	RelationshipType *string `type:"string" enum:"RelationshipType"`

	// The level of confidence that Comprehend Medical; has that the segment of
	// text is correctly recognized as an attribute.
	Score *float64 `type:"float"`

	// The segment of input text extracted as this attribute.
	Text *string `min:"1" type:"string"`

	// Contextual information for this attribute.
	Traits []*Trait `type:"list"`

	// The type of attribute.
	Type *string `type:"string" enum:"EntitySubType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attribute) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *Attribute) SetBeginOffset(v int64) *Attribute {
	s.BeginOffset = &v
	return s
}

// SetCategory sets the Category field's value.
func (s *Attribute) SetCategory(v string) *Attribute {
	s.Category = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *Attribute) SetEndOffset(v int64) *Attribute {
	s.EndOffset = &v
	return s
}

// SetId sets the Id field's value.
func (s *Attribute) SetId(v int64) *Attribute {
	s.Id = &v
	return s
}

// SetRelationshipScore sets the RelationshipScore field's value.
func (s *Attribute) SetRelationshipScore(v float64) *Attribute {
	s.RelationshipScore = &v
	return s
}

// SetRelationshipType sets the RelationshipType field's value.
func (s *Attribute) SetRelationshipType(v string) *Attribute {
	s.RelationshipType = &v
	return s
}

// SetScore sets the Score field's value.
func (s *Attribute) SetScore(v float64) *Attribute {
	s.Score = &v
	return s
}

// SetText sets the Text field's value.
func (s *Attribute) SetText(v string) *Attribute {
	s.Text = &v
	return s
}

// SetTraits sets the Traits field's value.
func (s *Attribute) SetTraits(v []*Trait) *Attribute {
	s.Traits = v
	return s
}

// SetType sets the Type field's value.
func (s *Attribute) SetType(v string) *Attribute {
	s.Type = &v
	return s
}

// The number of characters in the input text to be analyzed.
type Characters struct {
	_ struct{} `type:"structure"`

	// The number of characters present in the input text document as processed
	// by Comprehend Medical.
	OriginalTextCharacters *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Characters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Characters) GoString() string {
	return s.String()
}

// SetOriginalTextCharacters sets the OriginalTextCharacters field's value.
func (s *Characters) SetOriginalTextCharacters(v int64) *Characters {
	s.OriginalTextCharacters = &v
	return s
}

// Provides information for filtering a list of detection jobs.
type ComprehendMedicalAsyncJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComprehendMedicalAsyncJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComprehendMedicalAsyncJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ComprehendMedicalAsyncJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ComprehendMedicalAsyncJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *ComprehendMedicalAsyncJobFilter) SetJobName(v string) *ComprehendMedicalAsyncJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ComprehendMedicalAsyncJobFilter) SetJobStatus(v string) *ComprehendMedicalAsyncJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *ComprehendMedicalAsyncJobFilter) SetSubmitTimeAfter(v time.Time) *ComprehendMedicalAsyncJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *ComprehendMedicalAsyncJobFilter) SetSubmitTimeBefore(v time.Time) *ComprehendMedicalAsyncJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about a detection job.
type ComprehendMedicalAsyncJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that gives Comprehend Medical; read access
	// to your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the detection job completed.
	EndTime *time.Time `type:"timestamp"`

	// The date and time that job metadata is deleted from the server. Output files
	// in your S3 bucket will not be deleted. After the metadata is deleted, the
	// job will no longer appear in the results of the ListEntitiesDetectionV2Job
	// or the ListPHIDetectionJobs operation.
	ExpirationTime *time.Time `type:"timestamp"`

	// The input data configuration that you supplied when you created the detection
	// job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the detection job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned to the detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the detection job. If the status is FAILED, the Message
	// field shows the reason for the failure.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// The AWS Key Management Service key, if any, used to encrypt the output files.
	KMSKey *string `min:"1" type:"string"`

	// The language code of the input documents.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The path to the file that describes the results of a batch job.
	ManifestFilePath *string `min:"1" type:"string"`

	// A description of the status of a job.
	Message *string `type:"string"`

	// The version of the model used to analyze the documents. The version number
	// looks like X.X.X. You can use this information to track the model used for
	// a particular batch of documents.
	ModelVersion *string `type:"string"`

	// The output data configuration that you supplied when you created the detection
	// job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComprehendMedicalAsyncJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComprehendMedicalAsyncJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetDataAccessRoleArn(v string) *ComprehendMedicalAsyncJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetEndTime(v time.Time) *ComprehendMedicalAsyncJobProperties {
	s.EndTime = &v
	return s
}

// SetExpirationTime sets the ExpirationTime field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetExpirationTime(v time.Time) *ComprehendMedicalAsyncJobProperties {
	s.ExpirationTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetInputDataConfig(v *InputDataConfig) *ComprehendMedicalAsyncJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetJobId(v string) *ComprehendMedicalAsyncJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetJobName(v string) *ComprehendMedicalAsyncJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetJobStatus(v string) *ComprehendMedicalAsyncJobProperties {
	s.JobStatus = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetKMSKey(v string) *ComprehendMedicalAsyncJobProperties {
	s.KMSKey = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetLanguageCode(v string) *ComprehendMedicalAsyncJobProperties {
	s.LanguageCode = &v
	return s
}

// SetManifestFilePath sets the ManifestFilePath field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetManifestFilePath(v string) *ComprehendMedicalAsyncJobProperties {
	s.ManifestFilePath = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetMessage(v string) *ComprehendMedicalAsyncJobProperties {
	s.Message = &v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetModelVersion(v string) *ComprehendMedicalAsyncJobProperties {
	s.ModelVersion = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetOutputDataConfig(v *OutputDataConfig) *ComprehendMedicalAsyncJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *ComprehendMedicalAsyncJobProperties) SetSubmitTime(v time.Time) *ComprehendMedicalAsyncJobProperties {
	s.SubmitTime = &v
	return s
}

type DescribeEntitiesDetectionV2JobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Comprehend Medical; generated for the job. The StartEntitiesDetectionV2Job
	// operation returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEntitiesDetectionV2JobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEntitiesDetectionV2JobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEntitiesDetectionV2JobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEntitiesDetectionV2JobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeEntitiesDetectionV2JobInput) SetJobId(v string) *DescribeEntitiesDetectionV2JobInput {
	s.JobId = &v
	return s
}

type DescribeEntitiesDetectionV2JobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a detection job.
	ComprehendMedicalAsyncJobProperties *ComprehendMedicalAsyncJobProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEntitiesDetectionV2JobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEntitiesDetectionV2JobOutput) GoString() string {
	return s.String()
}

// SetComprehendMedicalAsyncJobProperties sets the ComprehendMedicalAsyncJobProperties field's value.
func (s *DescribeEntitiesDetectionV2JobOutput) SetComprehendMedicalAsyncJobProperties(v *ComprehendMedicalAsyncJobProperties) *DescribeEntitiesDetectionV2JobOutput {
	s.ComprehendMedicalAsyncJobProperties = v
	return s
}

type DescribeICD10CMInferenceJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend Medical generated for the job. The
	// StartICD10CMInferenceJob operation returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeICD10CMInferenceJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeICD10CMInferenceJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeICD10CMInferenceJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeICD10CMInferenceJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeICD10CMInferenceJobInput) SetJobId(v string) *DescribeICD10CMInferenceJobInput {
	s.JobId = &v
	return s
}

type DescribeICD10CMInferenceJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a detection job.
	ComprehendMedicalAsyncJobProperties *ComprehendMedicalAsyncJobProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeICD10CMInferenceJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeICD10CMInferenceJobOutput) GoString() string {
	return s.String()
}

// SetComprehendMedicalAsyncJobProperties sets the ComprehendMedicalAsyncJobProperties field's value.
func (s *DescribeICD10CMInferenceJobOutput) SetComprehendMedicalAsyncJobProperties(v *ComprehendMedicalAsyncJobProperties) *DescribeICD10CMInferenceJobOutput {
	s.ComprehendMedicalAsyncJobProperties = v
	return s
}

type DescribePHIDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Comprehend Medical; generated for the job. The StartPHIDetectionJob
	// operation returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePHIDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePHIDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePHIDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePHIDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribePHIDetectionJobInput) SetJobId(v string) *DescribePHIDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribePHIDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a detection job.
	ComprehendMedicalAsyncJobProperties *ComprehendMedicalAsyncJobProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePHIDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePHIDetectionJobOutput) GoString() string {
	return s.String()
}

// SetComprehendMedicalAsyncJobProperties sets the ComprehendMedicalAsyncJobProperties field's value.
func (s *DescribePHIDetectionJobOutput) SetComprehendMedicalAsyncJobProperties(v *ComprehendMedicalAsyncJobProperties) *DescribePHIDetectionJobOutput {
	s.ComprehendMedicalAsyncJobProperties = v
	return s
}

type DescribeRxNormInferenceJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend Medical generated for the job. The
	// StartRxNormInferenceJob operation returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRxNormInferenceJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRxNormInferenceJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRxNormInferenceJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRxNormInferenceJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeRxNormInferenceJobInput) SetJobId(v string) *DescribeRxNormInferenceJobInput {
	s.JobId = &v
	return s
}

type DescribeRxNormInferenceJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a detection job.
	ComprehendMedicalAsyncJobProperties *ComprehendMedicalAsyncJobProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRxNormInferenceJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRxNormInferenceJobOutput) GoString() string {
	return s.String()
}

// SetComprehendMedicalAsyncJobProperties sets the ComprehendMedicalAsyncJobProperties field's value.
func (s *DescribeRxNormInferenceJobOutput) SetComprehendMedicalAsyncJobProperties(v *ComprehendMedicalAsyncJobProperties) *DescribeRxNormInferenceJobOutput {
	s.ComprehendMedicalAsyncJobProperties = v
	return s
}

type DescribeSNOMEDCTInferenceJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend Medical generated for the job. The
	// StartSNOMEDCTInferenceJob operation returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSNOMEDCTInferenceJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSNOMEDCTInferenceJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSNOMEDCTInferenceJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSNOMEDCTInferenceJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeSNOMEDCTInferenceJobInput) SetJobId(v string) *DescribeSNOMEDCTInferenceJobInput {
	s.JobId = &v
	return s
}

type DescribeSNOMEDCTInferenceJobOutput struct {
	_ struct{} `type:"structure"`

	// Provides information about a detection job.
	ComprehendMedicalAsyncJobProperties *ComprehendMedicalAsyncJobProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSNOMEDCTInferenceJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeSNOMEDCTInferenceJobOutput) GoString() string {
	return s.String()
}

// SetComprehendMedicalAsyncJobProperties sets the ComprehendMedicalAsyncJobProperties field's value.
func (s *DescribeSNOMEDCTInferenceJobOutput) SetComprehendMedicalAsyncJobProperties(v *ComprehendMedicalAsyncJobProperties) *DescribeSNOMEDCTInferenceJobOutput {
	s.ComprehendMedicalAsyncJobProperties = v
	return s
}

type DetectEntitiesInput struct {
	_ struct{} `type:"structure"`

	// A UTF-8 text string containing the clinical content being examined for entities.
	// Each string must contain fewer than 20,000 bytes of characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectEntitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectEntitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectEntitiesInput"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *DetectEntitiesInput) SetText(v string) *DetectEntitiesInput {
	s.Text = &v
	return s
}

type DetectEntitiesOutput struct {
	_ struct{} `type:"structure"`

	// The collection of medical entities extracted from the input text and their
	// associated information. For each entity, the response provides the entity
	// text, the entity category, where the entity text begins and ends, and the
	// level of confidence that Comprehend Medical; has in the detection and analysis.
	// Attributes and traits of the entity are also returned.
	//
	// Entities is a required field
	Entities []*Entity `type:"list" required:"true"`

	// The version of the model used to analyze the documents. The version number
	// looks like X.X.X. You can use this information to track the model used for
	// a particular batch of documents.
	//
	// ModelVersion is a required field
	ModelVersion *string `min:"1" type:"string" required:"true"`

	// If the result of the previous request to DetectEntities was truncated, include
	// the PaginationToken to fetch the next page of entities.
	PaginationToken *string `min:"1" type:"string"`

	// Attributes extracted from the input text that we were unable to relate to
	// an entity.
	UnmappedAttributes []*UnmappedAttribute `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectEntitiesOutput) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *DetectEntitiesOutput) SetEntities(v []*Entity) *DetectEntitiesOutput {
	s.Entities = v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *DetectEntitiesOutput) SetModelVersion(v string) *DetectEntitiesOutput {
	s.ModelVersion = &v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *DetectEntitiesOutput) SetPaginationToken(v string) *DetectEntitiesOutput {
	s.PaginationToken = &v
	return s
}

// SetUnmappedAttributes sets the UnmappedAttributes field's value.
func (s *DetectEntitiesOutput) SetUnmappedAttributes(v []*UnmappedAttribute) *DetectEntitiesOutput {
	s.UnmappedAttributes = v
	return s
}

type DetectEntitiesV2Input struct {
	_ struct{} `type:"structure"`

	// A UTF-8 string containing the clinical content being examined for entities.
	// Each string must contain fewer than 20,000 bytes of characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectEntitiesV2Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectEntitiesV2Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectEntitiesV2Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectEntitiesV2Input"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *DetectEntitiesV2Input) SetText(v string) *DetectEntitiesV2Input {
	s.Text = &v
	return s
}

type DetectEntitiesV2Output struct {
	_ struct{} `type:"structure"`

	// The collection of medical entities extracted from the input text and their
	// associated information. For each entity, the response provides the entity
	// text, the entity category, where the entity text begins and ends, and the
	// level of confidence in the detection and analysis. Attributes and traits
	// of the entity are also returned.
	//
	// Entities is a required field
	Entities []*Entity `type:"list" required:"true"`

	// The version of the model used to analyze the documents. The version number
	// looks like X.X.X. You can use this information to track the model used for
	// a particular batch of documents.
	//
	// ModelVersion is a required field
	ModelVersion *string `min:"1" type:"string" required:"true"`

	// If the result to the DetectEntitiesV2 operation was truncated, include the
	// PaginationToken to fetch the next page of entities.
	PaginationToken *string `min:"1" type:"string"`

	// Attributes extracted from the input text that couldn't be related to an entity.
	UnmappedAttributes []*UnmappedAttribute `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectEntitiesV2Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectEntitiesV2Output) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *DetectEntitiesV2Output) SetEntities(v []*Entity) *DetectEntitiesV2Output {
	s.Entities = v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *DetectEntitiesV2Output) SetModelVersion(v string) *DetectEntitiesV2Output {
	s.ModelVersion = &v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *DetectEntitiesV2Output) SetPaginationToken(v string) *DetectEntitiesV2Output {
	s.PaginationToken = &v
	return s
}

// SetUnmappedAttributes sets the UnmappedAttributes field's value.
func (s *DetectEntitiesV2Output) SetUnmappedAttributes(v []*UnmappedAttribute) *DetectEntitiesV2Output {
	s.UnmappedAttributes = v
	return s
}

type DetectPHIInput struct {
	_ struct{} `type:"structure"`

	// A UTF-8 text string containing the clinical content being examined for PHI
	// entities. Each string must contain fewer than 20,000 bytes of characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectPHIInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectPHIInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectPHIInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectPHIInput"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *DetectPHIInput) SetText(v string) *DetectPHIInput {
	s.Text = &v
	return s
}

type DetectPHIOutput struct {
	_ struct{} `type:"structure"`

	// The collection of PHI entities extracted from the input text and their associated
	// information. For each entity, the response provides the entity text, the
	// entity category, where the entity text begins and ends, and the level of
	// confidence that Comprehend Medical; has in its detection.
	//
	// Entities is a required field
	Entities []*Entity `type:"list" required:"true"`

	// The version of the model used to analyze the documents. The version number
	// looks like X.X.X. You can use this information to track the model used for
	// a particular batch of documents.
	//
	// ModelVersion is a required field
	ModelVersion *string `min:"1" type:"string" required:"true"`

	// If the result of the previous request to DetectPHI was truncated, include
	// the PaginationToken to fetch the next page of PHI entities.
	PaginationToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectPHIOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectPHIOutput) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *DetectPHIOutput) SetEntities(v []*Entity) *DetectPHIOutput {
	s.Entities = v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *DetectPHIOutput) SetModelVersion(v string) *DetectPHIOutput {
	s.ModelVersion = &v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *DetectPHIOutput) SetPaginationToken(v string) *DetectPHIOutput {
	s.PaginationToken = &v
	return s
}

// Provides information about an extracted medical entity.
type Entity struct {
	_ struct{} `type:"structure"`

	// The extracted attributes that relate to this entity.
	Attributes []*Attribute `type:"list"`

	// The 0-based character offset in the input text that shows where the entity
	// begins. The offset returns the UTF-8 code point in the string.
	BeginOffset *int64 `type:"integer"`

	// The category of the entity.
	Category *string `type:"string" enum:"EntityType"`

	// The 0-based character offset in the input text that shows where the entity
	// ends. The offset returns the UTF-8 code point in the string.
	EndOffset *int64 `type:"integer"`

	// The numeric identifier for the entity. This is a monotonically increasing
	// id unique within this response rather than a global unique identifier.
	Id *int64 `type:"integer"`

	// The level of confidence that Comprehend Medical; has in the accuracy of the
	// detection.
	Score *float64 `type:"float"`

	// The segment of input text extracted as this entity.
	Text *string `min:"1" type:"string"`

	// Contextual information for the entity.
	Traits []*Trait `type:"list"`

	// Describes the specific type of entity with category of entities.
	Type *string `type:"string" enum:"EntitySubType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Entity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Entity) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *Entity) SetAttributes(v []*Attribute) *Entity {
	s.Attributes = v
	return s
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *Entity) SetBeginOffset(v int64) *Entity {
	s.BeginOffset = &v
	return s
}

// SetCategory sets the Category field's value.
func (s *Entity) SetCategory(v string) *Entity {
	s.Category = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *Entity) SetEndOffset(v int64) *Entity {
	s.EndOffset = &v
	return s
}

// SetId sets the Id field's value.
func (s *Entity) SetId(v int64) *Entity {
	s.Id = &v
	return s
}

// SetScore sets the Score field's value.
func (s *Entity) SetScore(v float64) *Entity {
	s.Score = &v
	return s
}

// SetText sets the Text field's value.
func (s *Entity) SetText(v string) *Entity {
	s.Text = &v
	return s
}

// SetTraits sets the Traits field's value.
func (s *Entity) SetTraits(v []*Trait) *Entity {
	s.Traits = v
	return s
}

// SetType sets the Type field's value.
func (s *Entity) SetType(v string) *Entity {
	s.Type = &v
	return s
}

// The detected attributes that relate to an entity. This includes an extracted
// segment of the text that is an attribute of an entity, or otherwise related
// to an entity. InferICD10CM detects the following attributes: Direction, System,
// Organ or Site, and Acuity.
type ICD10CMAttribute struct {
	_ struct{} `type:"structure"`

	// The 0-based character offset in the input text that shows where the attribute
	// begins. The offset returns the UTF-8 code point in the string.
	BeginOffset *int64 `type:"integer"`

	// The category of attribute. Can be either of DX_NAME or TIME_EXPRESSION.
	Category *string `type:"string" enum:"ICD10CMEntityType"`

	// The 0-based character offset in the input text that shows where the attribute
	// ends. The offset returns the UTF-8 code point in the string.
	EndOffset *int64 `type:"integer"`

	// The numeric identifier for this attribute. This is a monotonically increasing
	// id unique within this response rather than a global unique identifier.
	Id *int64 `type:"integer"`

	// The level of confidence that Amazon Comprehend Medical has that this attribute
	// is correctly related to this entity.
	RelationshipScore *float64 `type:"float"`

	// The type of relationship between the entity and attribute. Type for the relationship
	// can be either of OVERLAP or SYSTEM_ORGAN_SITE.
	RelationshipType *string `type:"string" enum:"ICD10CMRelationshipType"`

	// The level of confidence that Amazon Comprehend Medical has that the segment
	// of text is correctly recognized as an attribute.
	Score *float64 `type:"float"`

	// The segment of input text which contains the detected attribute.
	Text *string `min:"1" type:"string"`

	// The contextual information for the attribute. The traits recognized by InferICD10CM
	// are DIAGNOSIS, SIGN, SYMPTOM, and NEGATION.
	Traits []*ICD10CMTrait `type:"list"`

	// The type of attribute. InferICD10CM detects entities of the type DX_NAME.
	Type *string `type:"string" enum:"ICD10CMAttributeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ICD10CMAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ICD10CMAttribute) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *ICD10CMAttribute) SetBeginOffset(v int64) *ICD10CMAttribute {
	s.BeginOffset = &v
	return s
}

// SetCategory sets the Category field's value.
func (s *ICD10CMAttribute) SetCategory(v string) *ICD10CMAttribute {
	s.Category = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *ICD10CMAttribute) SetEndOffset(v int64) *ICD10CMAttribute {
	s.EndOffset = &v
	return s
}

// SetId sets the Id field's value.
func (s *ICD10CMAttribute) SetId(v int64) *ICD10CMAttribute {
	s.Id = &v
	return s
}

// SetRelationshipScore sets the RelationshipScore field's value.
func (s *ICD10CMAttribute) SetRelationshipScore(v float64) *ICD10CMAttribute {
	s.RelationshipScore = &v
	return s
}

// SetRelationshipType sets the RelationshipType field's value.
func (s *ICD10CMAttribute) SetRelationshipType(v string) *ICD10CMAttribute {
	s.RelationshipType = &v
	return s
}

// SetScore sets the Score field's value.
func (s *ICD10CMAttribute) SetScore(v float64) *ICD10CMAttribute {
	s.Score = &v
	return s
}

// SetText sets the Text field's value.
func (s *ICD10CMAttribute) SetText(v string) *ICD10CMAttribute {
	s.Text = &v
	return s
}

// SetTraits sets the Traits field's value.
func (s *ICD10CMAttribute) SetTraits(v []*ICD10CMTrait) *ICD10CMAttribute {
	s.Traits = v
	return s
}

// SetType sets the Type field's value.
func (s *ICD10CMAttribute) SetType(v string) *ICD10CMAttribute {
	s.Type = &v
	return s
}

// The ICD-10-CM concepts that the entity could refer to, along with a score
// indicating the likelihood of the match.
type ICD10CMConcept struct {
	_ struct{} `type:"structure"`

	// The ICD-10-CM code that identifies the concept found in the knowledge base
	// from the Centers for Disease Control.
	Code *string `min:"1" type:"string"`

	// The long description of the ICD-10-CM code in the ontology.
	Description *string `min:"1" type:"string"`

	// The level of confidence that Amazon Comprehend Medical has that the entity
	// is accurately linked to an ICD-10-CM concept.
	Score *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ICD10CMConcept) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ICD10CMConcept) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ICD10CMConcept) SetCode(v string) *ICD10CMConcept {
	s.Code = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ICD10CMConcept) SetDescription(v string) *ICD10CMConcept {
	s.Description = &v
	return s
}

// SetScore sets the Score field's value.
func (s *ICD10CMConcept) SetScore(v float64) *ICD10CMConcept {
	s.Score = &v
	return s
}

// The collection of medical entities extracted from the input text and their
// associated information. For each entity, the response provides the entity
// text, the entity category, where the entity text begins and ends, and the
// level of confidence that Amazon Comprehend Medical has in the detection and
// analysis. Attributes and traits of the entity are also returned.
type ICD10CMEntity struct {
	_ struct{} `type:"structure"`

	// The detected attributes that relate to the entity. An extracted segment of
	// the text that is an attribute of an entity, or otherwise related to an entity,
	// such as the nature of a medical condition.
	Attributes []*ICD10CMAttribute `type:"list"`

	// The 0-based character offset in the input text that shows where the entity
	// begins. The offset returns the UTF-8 code point in the string.
	BeginOffset *int64 `type:"integer"`

	// The category of the entity. InferICD10CM detects entities in the MEDICAL_CONDITION
	// category.
	Category *string `type:"string" enum:"ICD10CMEntityCategory"`

	// The 0-based character offset in the input text that shows where the entity
	// ends. The offset returns the UTF-8 code point in the string.
	EndOffset *int64 `type:"integer"`

	// The ICD-10-CM concepts that the entity could refer to, along with a score
	// indicating the likelihood of the match.
	ICD10CMConcepts []*ICD10CMConcept `type:"list"`

	// The numeric identifier for the entity. This is a monotonically increasing
	// id unique within this response rather than a global unique identifier.
	Id *int64 `type:"integer"`

	// The level of confidence that Amazon Comprehend Medical has in the accuracy
	// of the detection.
	Score *float64 `type:"float"`

	// The segment of input text that is matched to the detected entity.
	Text *string `min:"1" type:"string"`

	// Provides Contextual information for the entity. The traits recognized by
	// InferICD10CM are DIAGNOSIS, SIGN, SYMPTOM, and NEGATION.
	Traits []*ICD10CMTrait `type:"list"`

	// Describes the specific type of entity with category of entities. InferICD10CM
	// detects entities of the type DX_NAME and TIME_EXPRESSION.
	Type *string `type:"string" enum:"ICD10CMEntityType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ICD10CMEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ICD10CMEntity) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *ICD10CMEntity) SetAttributes(v []*ICD10CMAttribute) *ICD10CMEntity {
	s.Attributes = v
	return s
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *ICD10CMEntity) SetBeginOffset(v int64) *ICD10CMEntity {
	s.BeginOffset = &v
	return s
}

// SetCategory sets the Category field's value.
func (s *ICD10CMEntity) SetCategory(v string) *ICD10CMEntity {
	s.Category = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *ICD10CMEntity) SetEndOffset(v int64) *ICD10CMEntity {
	s.EndOffset = &v
	return s
}

// SetICD10CMConcepts sets the ICD10CMConcepts field's value.
func (s *ICD10CMEntity) SetICD10CMConcepts(v []*ICD10CMConcept) *ICD10CMEntity {
	s.ICD10CMConcepts = v
	return s
}

// SetId sets the Id field's value.
func (s *ICD10CMEntity) SetId(v int64) *ICD10CMEntity {
	s.Id = &v
	return s
}

// SetScore sets the Score field's value.
func (s *ICD10CMEntity) SetScore(v float64) *ICD10CMEntity {
	s.Score = &v
	return s
}

// SetText sets the Text field's value.
func (s *ICD10CMEntity) SetText(v string) *ICD10CMEntity {
	s.Text = &v
	return s
}

// SetTraits sets the Traits field's value.
func (s *ICD10CMEntity) SetTraits(v []*ICD10CMTrait) *ICD10CMEntity {
	s.Traits = v
	return s
}

// SetType sets the Type field's value.
func (s *ICD10CMEntity) SetType(v string) *ICD10CMEntity {
	s.Type = &v
	return s
}

// Contextual information for the entity. The traits recognized by InferICD10CM
// are DIAGNOSIS, SIGN, SYMPTOM, and NEGATION.
type ICD10CMTrait struct {
	_ struct{} `type:"structure"`

	// Provides a name or contextual description about the trait.
	Name *string `type:"string" enum:"ICD10CMTraitName"`

	// The level of confidence that Comprehend Medical; has that the segment of
	// text is correctly recognized as a trait.
	Score *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ICD10CMTrait) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ICD10CMTrait) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ICD10CMTrait) SetName(v string) *ICD10CMTrait {
	s.Name = &v
	return s
}

// SetScore sets the Score field's value.
func (s *ICD10CMTrait) SetScore(v float64) *ICD10CMTrait {
	s.Score = &v
	return s
}

type InferICD10CMInput struct {
	_ struct{} `type:"structure"`

	// The input text used for analysis. The input for InferICD10CM is a string
	// from 1 to 10000 characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferICD10CMInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferICD10CMInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InferICD10CMInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InferICD10CMInput"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *InferICD10CMInput) SetText(v string) *InferICD10CMInput {
	s.Text = &v
	return s
}

type InferICD10CMOutput struct {
	_ struct{} `type:"structure"`

	// The medical conditions detected in the text linked to ICD-10-CM concepts.
	// If the action is successful, the service sends back an HTTP 200 response,
	// as well as the entities detected.
	//
	// Entities is a required field
	Entities []*ICD10CMEntity `type:"list" required:"true"`

	// The version of the model used to analyze the documents, in the format n.n.n
	// You can use this information to track the model used for a particular batch
	// of documents.
	ModelVersion *string `min:"1" type:"string"`

	// If the result of the previous request to InferICD10CM was truncated, include
	// the PaginationToken to fetch the next page of medical condition entities.
	PaginationToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferICD10CMOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferICD10CMOutput) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *InferICD10CMOutput) SetEntities(v []*ICD10CMEntity) *InferICD10CMOutput {
	s.Entities = v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *InferICD10CMOutput) SetModelVersion(v string) *InferICD10CMOutput {
	s.ModelVersion = &v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *InferICD10CMOutput) SetPaginationToken(v string) *InferICD10CMOutput {
	s.PaginationToken = &v
	return s
}

type InferRxNormInput struct {
	_ struct{} `type:"structure"`

	// The input text used for analysis. The input for InferRxNorm is a string from
	// 1 to 10000 characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferRxNormInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferRxNormInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InferRxNormInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InferRxNormInput"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *InferRxNormInput) SetText(v string) *InferRxNormInput {
	s.Text = &v
	return s
}

type InferRxNormOutput struct {
	_ struct{} `type:"structure"`

	// The medication entities detected in the text linked to RxNorm concepts. If
	// the action is successful, the service sends back an HTTP 200 response, as
	// well as the entities detected.
	//
	// Entities is a required field
	Entities []*RxNormEntity `type:"list" required:"true"`

	// The version of the model used to analyze the documents, in the format n.n.n
	// You can use this information to track the model used for a particular batch
	// of documents.
	ModelVersion *string `min:"1" type:"string"`

	// If the result of the previous request to InferRxNorm was truncated, include
	// the PaginationToken to fetch the next page of medication entities.
	PaginationToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferRxNormOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferRxNormOutput) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *InferRxNormOutput) SetEntities(v []*RxNormEntity) *InferRxNormOutput {
	s.Entities = v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *InferRxNormOutput) SetModelVersion(v string) *InferRxNormOutput {
	s.ModelVersion = &v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *InferRxNormOutput) SetPaginationToken(v string) *InferRxNormOutput {
	s.PaginationToken = &v
	return s
}

type InferSNOMEDCTInput struct {
	_ struct{} `type:"structure"`

	// The input text to be analyzed using InferSNOMEDCT. The text should be a string
	// with 1 to 10000 characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferSNOMEDCTInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferSNOMEDCTInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InferSNOMEDCTInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InferSNOMEDCTInput"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *InferSNOMEDCTInput) SetText(v string) *InferSNOMEDCTInput {
	s.Text = &v
	return s
}

type InferSNOMEDCTOutput struct {
	_ struct{} `type:"structure"`

	// The number of characters in the input request documentation.
	Characters *Characters `type:"structure"`

	// The collection of medical concept entities extracted from the input text
	// and their associated information. For each entity, the response provides
	// the entity text, the entity category, where the entity text begins and ends,
	// and the level of confidence that Comprehend Medical has in the detection
	// and analysis. Attributes and traits of the entity are also returned.
	//
	// Entities is a required field
	Entities []*SNOMEDCTEntity `type:"list" required:"true"`

	// The version of the model used to analyze the documents, in the format n.n.n
	// You can use this information to track the model used for a particular batch
	// of documents.
	ModelVersion *string `min:"1" type:"string"`

	// If the result of the request is truncated, the pagination token can be used
	// to fetch the next page of entities.
	PaginationToken *string `min:"1" type:"string"`

	// The details of the SNOMED-CT revision, including the edition, language, and
	// version date.
	SNOMEDCTDetails *SNOMEDCTDetails `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferSNOMEDCTOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferSNOMEDCTOutput) GoString() string {
	return s.String()
}

// SetCharacters sets the Characters field's value.
func (s *InferSNOMEDCTOutput) SetCharacters(v *Characters) *InferSNOMEDCTOutput {
	s.Characters = v
	return s
}

// SetEntities sets the Entities field's value.
func (s *InferSNOMEDCTOutput) SetEntities(v []*SNOMEDCTEntity) *InferSNOMEDCTOutput {
	s.Entities = v
	return s
}

// SetModelVersion sets the ModelVersion field's value.
func (s *InferSNOMEDCTOutput) SetModelVersion(v string) *InferSNOMEDCTOutput {
	s.ModelVersion = &v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *InferSNOMEDCTOutput) SetPaginationToken(v string) *InferSNOMEDCTOutput {
	s.PaginationToken = &v
	return s
}

// SetSNOMEDCTDetails sets the SNOMEDCTDetails field's value.
func (s *InferSNOMEDCTOutput) SetSNOMEDCTDetails(v *SNOMEDCTDetails) *InferSNOMEDCTOutput {
	s.SNOMEDCTDetails = v
	return s
}

// The input properties for an entities detection job. This includes the name
// of the S3 bucket and the path to the files to be analyzed.
type InputDataConfig struct {
	_ struct{} `type:"structure"`

	// The URI of the S3 bucket that contains the input data. The bucket must be
	// in the same region as the API endpoint that you are calling.
	//
	// Each file in the document collection must be less than 40 KB. You can store
	// a maximum of 30 GB in the bucket.
	//
	// S3Bucket is a required field
	S3Bucket *string `min:"3" type:"string" required:"true"`

	// The path to the input data files in the S3 bucket.
	S3Key *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputDataConfig"}
	if s.S3Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Bucket"))
	}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *InputDataConfig) SetS3Bucket(v string) *InputDataConfig {
	s.S3Bucket = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *InputDataConfig) SetS3Key(v string) *InputDataConfig {
	s.S3Key = &v
	return s
}

// An internal server error occurred. Retry your request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input text was not in valid UTF-8 character encoding. Check your text
// then retry your request.
type InvalidEncodingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidEncodingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidEncodingException) GoString() string {
	return s.String()
}

func newErrorInvalidEncodingException(v protocol.ResponseMetadata) error {
	return &InvalidEncodingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidEncodingException) Code() string {
	return "InvalidEncodingException"
}

// Message returns the exception's message.
func (s *InvalidEncodingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidEncodingException) OrigErr() error {
	return nil
}

func (s *InvalidEncodingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidEncodingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidEncodingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request that you made is invalid. Check your request to determine why
// it's invalid and then retry the request.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListEntitiesDetectionV2JobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs based on their names,
	// status, or the date and time that they were submitted. You can only set one
	// filter at a time.
	Filter *ComprehendMedicalAsyncJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitiesDetectionV2JobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitiesDetectionV2JobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEntitiesDetectionV2JobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEntitiesDetectionV2JobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListEntitiesDetectionV2JobsInput) SetFilter(v *ComprehendMedicalAsyncJobFilter) *ListEntitiesDetectionV2JobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEntitiesDetectionV2JobsInput) SetMaxResults(v int64) *ListEntitiesDetectionV2JobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitiesDetectionV2JobsInput) SetNextToken(v string) *ListEntitiesDetectionV2JobsInput {
	s.NextToken = &v
	return s
}

type ListEntitiesDetectionV2JobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job returned.
	ComprehendMedicalAsyncJobPropertiesList []*ComprehendMedicalAsyncJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitiesDetectionV2JobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEntitiesDetectionV2JobsOutput) GoString() string {
	return s.String()
}

// SetComprehendMedicalAsyncJobPropertiesList sets the ComprehendMedicalAsyncJobPropertiesList field's value.
func (s *ListEntitiesDetectionV2JobsOutput) SetComprehendMedicalAsyncJobPropertiesList(v []*ComprehendMedicalAsyncJobProperties) *ListEntitiesDetectionV2JobsOutput {
	s.ComprehendMedicalAsyncJobPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitiesDetectionV2JobsOutput) SetNextToken(v string) *ListEntitiesDetectionV2JobsOutput {
	s.NextToken = &v
	return s
}

type ListICD10CMInferenceJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs based on their names,
	// status, or the date and time that they were submitted. You can only set one
	// filter at a time.
	Filter *ComprehendMedicalAsyncJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListICD10CMInferenceJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListICD10CMInferenceJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListICD10CMInferenceJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListICD10CMInferenceJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListICD10CMInferenceJobsInput) SetFilter(v *ComprehendMedicalAsyncJobFilter) *ListICD10CMInferenceJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListICD10CMInferenceJobsInput) SetMaxResults(v int64) *ListICD10CMInferenceJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListICD10CMInferenceJobsInput) SetNextToken(v string) *ListICD10CMInferenceJobsInput {
	s.NextToken = &v
	return s
}

type ListICD10CMInferenceJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job that is returned.
	ComprehendMedicalAsyncJobPropertiesList []*ComprehendMedicalAsyncJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListICD10CMInferenceJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListICD10CMInferenceJobsOutput) GoString() string {
	return s.String()
}

// SetComprehendMedicalAsyncJobPropertiesList sets the ComprehendMedicalAsyncJobPropertiesList field's value.
func (s *ListICD10CMInferenceJobsOutput) SetComprehendMedicalAsyncJobPropertiesList(v []*ComprehendMedicalAsyncJobProperties) *ListICD10CMInferenceJobsOutput {
	s.ComprehendMedicalAsyncJobPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListICD10CMInferenceJobsOutput) SetNextToken(v string) *ListICD10CMInferenceJobsOutput {
	s.NextToken = &v
	return s
}

type ListPHIDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs based on their names,
	// status, or the date and time that they were submitted. You can only set one
	// filter at a time.
	Filter *ComprehendMedicalAsyncJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPHIDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPHIDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPHIDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPHIDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListPHIDetectionJobsInput) SetFilter(v *ComprehendMedicalAsyncJobFilter) *ListPHIDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPHIDetectionJobsInput) SetMaxResults(v int64) *ListPHIDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPHIDetectionJobsInput) SetNextToken(v string) *ListPHIDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListPHIDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job returned.
	ComprehendMedicalAsyncJobPropertiesList []*ComprehendMedicalAsyncJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPHIDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPHIDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetComprehendMedicalAsyncJobPropertiesList sets the ComprehendMedicalAsyncJobPropertiesList field's value.
func (s *ListPHIDetectionJobsOutput) SetComprehendMedicalAsyncJobPropertiesList(v []*ComprehendMedicalAsyncJobProperties) *ListPHIDetectionJobsOutput {
	s.ComprehendMedicalAsyncJobPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPHIDetectionJobsOutput) SetNextToken(v string) *ListPHIDetectionJobsOutput {
	s.NextToken = &v
	return s
}

type ListRxNormInferenceJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs based on their names,
	// status, or the date and time that they were submitted. You can only set one
	// filter at a time.
	Filter *ComprehendMedicalAsyncJobFilter `type:"structure"`

	// Identifies the next page of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRxNormInferenceJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRxNormInferenceJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRxNormInferenceJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRxNormInferenceJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListRxNormInferenceJobsInput) SetFilter(v *ComprehendMedicalAsyncJobFilter) *ListRxNormInferenceJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRxNormInferenceJobsInput) SetMaxResults(v int64) *ListRxNormInferenceJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRxNormInferenceJobsInput) SetNextToken(v string) *ListRxNormInferenceJobsInput {
	s.NextToken = &v
	return s
}

type ListRxNormInferenceJobsOutput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	ComprehendMedicalAsyncJobPropertiesList []*ComprehendMedicalAsyncJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRxNormInferenceJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRxNormInferenceJobsOutput) GoString() string {
	return s.String()
}

// SetComprehendMedicalAsyncJobPropertiesList sets the ComprehendMedicalAsyncJobPropertiesList field's value.
func (s *ListRxNormInferenceJobsOutput) SetComprehendMedicalAsyncJobPropertiesList(v []*ComprehendMedicalAsyncJobProperties) *ListRxNormInferenceJobsOutput {
	s.ComprehendMedicalAsyncJobPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRxNormInferenceJobsOutput) SetNextToken(v string) *ListRxNormInferenceJobsOutput {
	s.NextToken = &v
	return s
}

type ListSNOMEDCTInferenceJobsInput struct {
	_ struct{} `type:"structure"`

	// Provides information for filtering a list of detection jobs.
	Filter *ComprehendMedicalAsyncJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of InferSNOMEDCT results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSNOMEDCTInferenceJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSNOMEDCTInferenceJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSNOMEDCTInferenceJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSNOMEDCTInferenceJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListSNOMEDCTInferenceJobsInput) SetFilter(v *ComprehendMedicalAsyncJobFilter) *ListSNOMEDCTInferenceJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSNOMEDCTInferenceJobsInput) SetMaxResults(v int64) *ListSNOMEDCTInferenceJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSNOMEDCTInferenceJobsInput) SetNextToken(v string) *ListSNOMEDCTInferenceJobsInput {
	s.NextToken = &v
	return s
}

type ListSNOMEDCTInferenceJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job that is returned.
	ComprehendMedicalAsyncJobPropertiesList []*ComprehendMedicalAsyncJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSNOMEDCTInferenceJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSNOMEDCTInferenceJobsOutput) GoString() string {
	return s.String()
}

// SetComprehendMedicalAsyncJobPropertiesList sets the ComprehendMedicalAsyncJobPropertiesList field's value.
func (s *ListSNOMEDCTInferenceJobsOutput) SetComprehendMedicalAsyncJobPropertiesList(v []*ComprehendMedicalAsyncJobProperties) *ListSNOMEDCTInferenceJobsOutput {
	s.ComprehendMedicalAsyncJobPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSNOMEDCTInferenceJobsOutput) SetNextToken(v string) *ListSNOMEDCTInferenceJobsOutput {
	s.NextToken = &v
	return s
}

// The output properties for a detection job.
type OutputDataConfig struct {
	_ struct{} `type:"structure"`

	// When you use the OutputDataConfig object with asynchronous operations, you
	// specify the Amazon S3 location where you want to write the output data. The
	// URI must be in the same region as the API endpoint that you are calling.
	// The location is used as the prefix for the actual location of the output.
	//
	// S3Bucket is a required field
	S3Bucket *string `min:"3" type:"string" required:"true"`

	// The path to the output data files in the S3 bucket. Comprehend Medical; creates
	// an output directory using the job ID so that the output from one job does
	// not overwrite the output of another.
	S3Key *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputDataConfig"}
	if s.S3Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Bucket"))
	}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *OutputDataConfig) SetS3Bucket(v string) *OutputDataConfig {
	s.S3Bucket = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *OutputDataConfig) SetS3Key(v string) *OutputDataConfig {
	s.S3Key = &v
	return s
}

// The resource identified by the specified Amazon Resource Name (ARN) was not
// found. Check the ARN and try your request again.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The extracted attributes that relate to this entity. The attributes recognized
// by InferRxNorm are DOSAGE, DURATION, FORM, FREQUENCY, RATE, ROUTE_OR_MODE.
type RxNormAttribute struct {
	_ struct{} `type:"structure"`

	// The 0-based character offset in the input text that shows where the attribute
	// begins. The offset returns the UTF-8 code point in the string.
	BeginOffset *int64 `type:"integer"`

	// The 0-based character offset in the input text that shows where the attribute
	// ends. The offset returns the UTF-8 code point in the string.
	EndOffset *int64 `type:"integer"`

	// The numeric identifier for this attribute. This is a monotonically increasing
	// id unique within this response rather than a global unique identifier.
	Id *int64 `type:"integer"`

	// The level of confidence that Amazon Comprehend Medical has that the attribute
	// is accurately linked to an entity.
	RelationshipScore *float64 `type:"float"`

	// The level of confidence that Comprehend Medical has that the segment of text
	// is correctly recognized as an attribute.
	Score *float64 `type:"float"`

	// The segment of input text which corresponds to the detected attribute.
	Text *string `min:"1" type:"string"`

	// Contextual information for the attribute. InferRxNorm recognizes the trait
	// NEGATION for attributes, i.e. that the patient is not taking a specific dose
	// or form of a medication.
	Traits []*RxNormTrait `type:"list"`

	// The type of attribute. The types of attributes recognized by InferRxNorm
	// are BRAND_NAME and GENERIC_NAME.
	Type *string `type:"string" enum:"RxNormAttributeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RxNormAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RxNormAttribute) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *RxNormAttribute) SetBeginOffset(v int64) *RxNormAttribute {
	s.BeginOffset = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *RxNormAttribute) SetEndOffset(v int64) *RxNormAttribute {
	s.EndOffset = &v
	return s
}

// SetId sets the Id field's value.
func (s *RxNormAttribute) SetId(v int64) *RxNormAttribute {
	s.Id = &v
	return s
}

// SetRelationshipScore sets the RelationshipScore field's value.
func (s *RxNormAttribute) SetRelationshipScore(v float64) *RxNormAttribute {
	s.RelationshipScore = &v
	return s
}

// SetScore sets the Score field's value.
func (s *RxNormAttribute) SetScore(v float64) *RxNormAttribute {
	s.Score = &v
	return s
}

// SetText sets the Text field's value.
func (s *RxNormAttribute) SetText(v string) *RxNormAttribute {
	s.Text = &v
	return s
}

// SetTraits sets the Traits field's value.
func (s *RxNormAttribute) SetTraits(v []*RxNormTrait) *RxNormAttribute {
	s.Traits = v
	return s
}

// SetType sets the Type field's value.
func (s *RxNormAttribute) SetType(v string) *RxNormAttribute {
	s.Type = &v
	return s
}

// The RxNorm concept that the entity could refer to, along with a score indicating
// the likelihood of the match.
type RxNormConcept struct {
	_ struct{} `type:"structure"`

	// RxNorm concept ID, also known as the RxCUI.
	Code *string `min:"1" type:"string"`

	// The description of the RxNorm concept.
	Description *string `min:"1" type:"string"`

	// The level of confidence that Amazon Comprehend Medical has that the entity
	// is accurately linked to the reported RxNorm concept.
	Score *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RxNormConcept) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RxNormConcept) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *RxNormConcept) SetCode(v string) *RxNormConcept {
	s.Code = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RxNormConcept) SetDescription(v string) *RxNormConcept {
	s.Description = &v
	return s
}

// SetScore sets the Score field's value.
func (s *RxNormConcept) SetScore(v float64) *RxNormConcept {
	s.Score = &v
	return s
}

// The collection of medical entities extracted from the input text and their
// associated information. For each entity, the response provides the entity
// text, the entity category, where the entity text begins and ends, and the
// level of confidence that Amazon Comprehend Medical has in the detection and
// analysis. Attributes and traits of the entity are also returned.
type RxNormEntity struct {
	_ struct{} `type:"structure"`

	// The extracted attributes that relate to the entity. The attributes recognized
	// by InferRxNorm are DOSAGE, DURATION, FORM, FREQUENCY, RATE, ROUTE_OR_MODE,
	// and STRENGTH.
	Attributes []*RxNormAttribute `type:"list"`

	// The 0-based character offset in the input text that shows where the entity
	// begins. The offset returns the UTF-8 code point in the string.
	BeginOffset *int64 `type:"integer"`

	// The category of the entity. The recognized categories are GENERIC or BRAND_NAME.
	Category *string `type:"string" enum:"RxNormEntityCategory"`

	// The 0-based character offset in the input text that shows where the entity
	// ends. The offset returns the UTF-8 code point in the string.
	EndOffset *int64 `type:"integer"`

	// The numeric identifier for the entity. This is a monotonically increasing
	// id unique within this response rather than a global unique identifier.
	Id *int64 `type:"integer"`

	// The RxNorm concepts that the entity could refer to, along with a score indicating
	// the likelihood of the match.
	RxNormConcepts []*RxNormConcept `type:"list"`

	// The level of confidence that Amazon Comprehend Medical has in the accuracy
	// of the detected entity.
	Score *float64 `type:"float"`

	// The segment of input text extracted from which the entity was detected.
	Text *string `min:"1" type:"string"`

	// Contextual information for the entity.
	Traits []*RxNormTrait `type:"list"`

	// Describes the specific type of entity. For InferRxNorm, the recognized entity
	// type is MEDICATION.
	Type *string `type:"string" enum:"RxNormEntityType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RxNormEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RxNormEntity) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *RxNormEntity) SetAttributes(v []*RxNormAttribute) *RxNormEntity {
	s.Attributes = v
	return s
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *RxNormEntity) SetBeginOffset(v int64) *RxNormEntity {
	s.BeginOffset = &v
	return s
}

// SetCategory sets the Category field's value.
func (s *RxNormEntity) SetCategory(v string) *RxNormEntity {
	s.Category = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *RxNormEntity) SetEndOffset(v int64) *RxNormEntity {
	s.EndOffset = &v
	return s
}

// SetId sets the Id field's value.
func (s *RxNormEntity) SetId(v int64) *RxNormEntity {
	s.Id = &v
	return s
}

// SetRxNormConcepts sets the RxNormConcepts field's value.
func (s *RxNormEntity) SetRxNormConcepts(v []*RxNormConcept) *RxNormEntity {
	s.RxNormConcepts = v
	return s
}

// SetScore sets the Score field's value.
func (s *RxNormEntity) SetScore(v float64) *RxNormEntity {
	s.Score = &v
	return s
}

// SetText sets the Text field's value.
func (s *RxNormEntity) SetText(v string) *RxNormEntity {
	s.Text = &v
	return s
}

// SetTraits sets the Traits field's value.
func (s *RxNormEntity) SetTraits(v []*RxNormTrait) *RxNormEntity {
	s.Traits = v
	return s
}

// SetType sets the Type field's value.
func (s *RxNormEntity) SetType(v string) *RxNormEntity {
	s.Type = &v
	return s
}

// The contextual information for the entity. InferRxNorm recognizes the trait
// NEGATION, which is any indication that the patient is not taking a medication.
type RxNormTrait struct {
	_ struct{} `type:"structure"`

	// Provides a name or contextual description about the trait.
	Name *string `type:"string" enum:"RxNormTraitName"`

	// The level of confidence that Amazon Comprehend Medical has in the accuracy
	// of the detected trait.
	Score *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RxNormTrait) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RxNormTrait) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RxNormTrait) SetName(v string) *RxNormTrait {
	s.Name = &v
	return s
}

// SetScore sets the Score field's value.
func (s *RxNormTrait) SetScore(v float64) *RxNormTrait {
	s.Score = &v
	return s
}

// The extracted attributes that relate to an entity. An extracted segment of
// the text that is an attribute of an entity, or otherwise related to an entity,
// such as the dosage of a medication taken.
type SNOMEDCTAttribute struct {
	_ struct{} `type:"structure"`

	// The 0-based character offset in the input text that shows where the attribute
	// begins. The offset returns the UTF-8 code point in the string.
	BeginOffset *int64 `type:"integer"`

	// The category of the detected attribute. Possible categories include MEDICAL_CONDITION,
	// ANATOMY, and TEST_TREATMENT_PROCEDURE.
	Category *string `type:"string" enum:"SNOMEDCTEntityCategory"`

	// The 0-based character offset in the input text that shows where the attribute
	// ends. The offset returns the UTF-8 code point in the string.
	EndOffset *int64 `type:"integer"`

	// The numeric identifier for this attribute. This is a monotonically increasing
	// id unique within this response rather than a global unique identifier.
	Id *int64 `type:"integer"`

	// The level of confidence that Comprehend Medical has that this attribute is
	// correctly related to this entity.
	RelationshipScore *float64 `type:"float"`

	// The type of relationship that exists between the entity and the related attribute.
	RelationshipType *string `type:"string" enum:"SNOMEDCTRelationshipType"`

	// The SNOMED-CT concepts specific to an attribute, along with a score indicating
	// the likelihood of the match.
	SNOMEDCTConcepts []*SNOMEDCTConcept `type:"list"`

	// The level of confidence that Comprehend Medical has that the segment of text
	// is correctly recognized as an attribute.
	Score *float64 `type:"float"`

	// The segment of input text extracted as this attribute.
	Text *string `min:"1" type:"string"`

	// Contextual information for an attribute. Examples include signs, symptoms,
	// diagnosis, and negation.
	Traits []*SNOMEDCTTrait `type:"list"`

	// The type of attribute. Possible types include DX_NAME, ACUITY, DIRECTION,
	// SYSTEM_ORGAN_SITE,TEST_NAME, TEST_VALUE, TEST_UNIT, PROCEDURE_NAME, and TREATMENT_NAME.
	Type *string `type:"string" enum:"SNOMEDCTAttributeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SNOMEDCTAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SNOMEDCTAttribute) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *SNOMEDCTAttribute) SetBeginOffset(v int64) *SNOMEDCTAttribute {
	s.BeginOffset = &v
	return s
}

// SetCategory sets the Category field's value.
func (s *SNOMEDCTAttribute) SetCategory(v string) *SNOMEDCTAttribute {
	s.Category = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *SNOMEDCTAttribute) SetEndOffset(v int64) *SNOMEDCTAttribute {
	s.EndOffset = &v
	return s
}

// SetId sets the Id field's value.
func (s *SNOMEDCTAttribute) SetId(v int64) *SNOMEDCTAttribute {
	s.Id = &v
	return s
}

// SetRelationshipScore sets the RelationshipScore field's value.
func (s *SNOMEDCTAttribute) SetRelationshipScore(v float64) *SNOMEDCTAttribute {
	s.RelationshipScore = &v
	return s
}

// SetRelationshipType sets the RelationshipType field's value.
func (s *SNOMEDCTAttribute) SetRelationshipType(v string) *SNOMEDCTAttribute {
	s.RelationshipType = &v
	return s
}

// SetSNOMEDCTConcepts sets the SNOMEDCTConcepts field's value.
func (s *SNOMEDCTAttribute) SetSNOMEDCTConcepts(v []*SNOMEDCTConcept) *SNOMEDCTAttribute {
	s.SNOMEDCTConcepts = v
	return s
}

// SetScore sets the Score field's value.
func (s *SNOMEDCTAttribute) SetScore(v float64) *SNOMEDCTAttribute {
	s.Score = &v
	return s
}

// SetText sets the Text field's value.
func (s *SNOMEDCTAttribute) SetText(v string) *SNOMEDCTAttribute {
	s.Text = &v
	return s
}

// SetTraits sets the Traits field's value.
func (s *SNOMEDCTAttribute) SetTraits(v []*SNOMEDCTTrait) *SNOMEDCTAttribute {
	s.Traits = v
	return s
}

// SetType sets the Type field's value.
func (s *SNOMEDCTAttribute) SetType(v string) *SNOMEDCTAttribute {
	s.Type = &v
	return s
}

// The SNOMED-CT concepts that the entity could refer to, along with a score
// indicating the likelihood of the match.
type SNOMEDCTConcept struct {
	_ struct{} `type:"structure"`

	// The numeric ID for the SNOMED-CT concept.
	Code *string `min:"1" type:"string"`

	// The description of the SNOMED-CT concept.
	Description *string `min:"1" type:"string"`

	// The level of confidence Comprehend Medical has that the entity should be
	// linked to the identified SNOMED-CT concept.
	Score *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SNOMEDCTConcept) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SNOMEDCTConcept) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *SNOMEDCTConcept) SetCode(v string) *SNOMEDCTConcept {
	s.Code = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SNOMEDCTConcept) SetDescription(v string) *SNOMEDCTConcept {
	s.Description = &v
	return s
}

// SetScore sets the Score field's value.
func (s *SNOMEDCTConcept) SetScore(v float64) *SNOMEDCTConcept {
	s.Score = &v
	return s
}

// The information about the revision of the SNOMED-CT ontology in the response.
// Specifically, the details include the SNOMED-CT edition, language, and version
// date.
type SNOMEDCTDetails struct {
	_ struct{} `type:"structure"`

	// The edition of SNOMED-CT used. The edition used for the InferSNOMEDCT editions
	// is the US edition.
	Edition *string `min:"1" type:"string"`

	// The language used in the SNOMED-CT ontology. All Amazon Comprehend Medical
	// operations are US English (en).
	Language *string `min:"1" type:"string"`

	// The version date of the SNOMED-CT ontology used.
	VersionDate *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SNOMEDCTDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SNOMEDCTDetails) GoString() string {
	return s.String()
}

// SetEdition sets the Edition field's value.
func (s *SNOMEDCTDetails) SetEdition(v string) *SNOMEDCTDetails {
	s.Edition = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *SNOMEDCTDetails) SetLanguage(v string) *SNOMEDCTDetails {
	s.Language = &v
	return s
}

// SetVersionDate sets the VersionDate field's value.
func (s *SNOMEDCTDetails) SetVersionDate(v string) *SNOMEDCTDetails {
	s.VersionDate = &v
	return s
}

// The collection of medical entities extracted from the input text and their
// associated information. For each entity, the response provides the entity
// text, the entity category, where the entity text begins and ends, and the
// level of confidence that Comprehend Medical has in the detection and analysis.
// Attributes and traits of the entity are also returned.
type SNOMEDCTEntity struct {
	_ struct{} `type:"structure"`

	// An extracted segment of the text that is an attribute of an entity, or otherwise
	// related to an entity, such as the dosage of a medication taken.
	Attributes []*SNOMEDCTAttribute `type:"list"`

	// The 0-based character offset in the input text that shows where the entity
	// begins. The offset returns the UTF-8 code point in the string.
	BeginOffset *int64 `type:"integer"`

	// The category of the detected entity. Possible categories are MEDICAL_CONDITION,
	// ANATOMY, or TEST_TREATMENT_PROCEDURE.
	Category *string `type:"string" enum:"SNOMEDCTEntityCategory"`

	// The 0-based character offset in the input text that shows where the entity
	// ends. The offset returns the UTF-8 code point in the string.
	EndOffset *int64 `type:"integer"`

	// The numeric identifier for the entity. This is a monotonically increasing
	// id unique within this response rather than a global unique identifier.
	Id *int64 `type:"integer"`

	// The SNOMED concepts that the entity could refer to, along with a score indicating
	// the likelihood of the match.
	SNOMEDCTConcepts []*SNOMEDCTConcept `type:"list"`

	// The level of confidence that Comprehend Medical has in the accuracy of the
	// detected entity.
	Score *float64 `type:"float"`

	// The segment of input text extracted as this entity.
	Text *string `min:"1" type:"string"`

	// Contextual information for the entity.
	Traits []*SNOMEDCTTrait `type:"list"`

	// Describes the specific type of entity with category of entities. Possible
	// types include DX_NAME, ACUITY, DIRECTION, SYSTEM_ORGAN_SITE, TEST_NAME, TEST_VALUE,
	// TEST_UNIT, PROCEDURE_NAME, or TREATMENT_NAME.
	Type *string `type:"string" enum:"SNOMEDCTEntityType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SNOMEDCTEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SNOMEDCTEntity) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *SNOMEDCTEntity) SetAttributes(v []*SNOMEDCTAttribute) *SNOMEDCTEntity {
	s.Attributes = v
	return s
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *SNOMEDCTEntity) SetBeginOffset(v int64) *SNOMEDCTEntity {
	s.BeginOffset = &v
	return s
}

// SetCategory sets the Category field's value.
func (s *SNOMEDCTEntity) SetCategory(v string) *SNOMEDCTEntity {
	s.Category = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *SNOMEDCTEntity) SetEndOffset(v int64) *SNOMEDCTEntity {
	s.EndOffset = &v
	return s
}

// SetId sets the Id field's value.
func (s *SNOMEDCTEntity) SetId(v int64) *SNOMEDCTEntity {
	s.Id = &v
	return s
}

// SetSNOMEDCTConcepts sets the SNOMEDCTConcepts field's value.
func (s *SNOMEDCTEntity) SetSNOMEDCTConcepts(v []*SNOMEDCTConcept) *SNOMEDCTEntity {
	s.SNOMEDCTConcepts = v
	return s
}

// SetScore sets the Score field's value.
func (s *SNOMEDCTEntity) SetScore(v float64) *SNOMEDCTEntity {
	s.Score = &v
	return s
}

// SetText sets the Text field's value.
func (s *SNOMEDCTEntity) SetText(v string) *SNOMEDCTEntity {
	s.Text = &v
	return s
}

// SetTraits sets the Traits field's value.
func (s *SNOMEDCTEntity) SetTraits(v []*SNOMEDCTTrait) *SNOMEDCTEntity {
	s.Traits = v
	return s
}

// SetType sets the Type field's value.
func (s *SNOMEDCTEntity) SetType(v string) *SNOMEDCTEntity {
	s.Type = &v
	return s
}

// Contextual information for an entity.
type SNOMEDCTTrait struct {
	_ struct{} `type:"structure"`

	// The name or contextual description of a detected trait.
	Name *string `type:"string" enum:"SNOMEDCTTraitName"`

	// The level of confidence that Comprehend Medical has in the accuracy of a
	// detected trait.
	Score *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SNOMEDCTTrait) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SNOMEDCTTrait) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *SNOMEDCTTrait) SetName(v string) *SNOMEDCTTrait {
	s.Name = &v
	return s
}

// SetScore sets the Score field's value.
func (s *SNOMEDCTTrait) SetScore(v float64) *SNOMEDCTTrait {
	s.Score = &v
	return s
}

// The Comprehend Medical; service is temporarily unavailable. Please wait and
// then retry your request.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartEntitiesDetectionV2JobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Comprehend Medical; generates one for you.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that grants Comprehend Medical; read access to your input data.
	// For more information, see Role-Based Permissions Required for Asynchronous
	// Operations (https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions-med.html#auth-role-permissions-med).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// The input configuration that specifies the format and location of the input
	// data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// An AWS Key Management Service key to encrypt your output files. If you do
	// not specify a key, the files are written in plain text.
	KMSKey *string `min:"1" type:"string"`

	// The language of the input documents. All documents must be in the same language.
	// Comprehend Medical; processes files in US English (en).
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// The output configuration that specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEntitiesDetectionV2JobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEntitiesDetectionV2JobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartEntitiesDetectionV2JobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartEntitiesDetectionV2JobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.KMSKey != nil && len(*s.KMSKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KMSKey", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartEntitiesDetectionV2JobInput) SetClientRequestToken(v string) *StartEntitiesDetectionV2JobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartEntitiesDetectionV2JobInput) SetDataAccessRoleArn(v string) *StartEntitiesDetectionV2JobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartEntitiesDetectionV2JobInput) SetInputDataConfig(v *InputDataConfig) *StartEntitiesDetectionV2JobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartEntitiesDetectionV2JobInput) SetJobName(v string) *StartEntitiesDetectionV2JobInput {
	s.JobName = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *StartEntitiesDetectionV2JobInput) SetKMSKey(v string) *StartEntitiesDetectionV2JobInput {
	s.KMSKey = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartEntitiesDetectionV2JobInput) SetLanguageCode(v string) *StartEntitiesDetectionV2JobInput {
	s.LanguageCode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartEntitiesDetectionV2JobInput) SetOutputDataConfig(v *OutputDataConfig) *StartEntitiesDetectionV2JobInput {
	s.OutputDataConfig = v
	return s
}

type StartEntitiesDetectionV2JobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of a job, use this
	// identifier with the DescribeEntitiesDetectionV2Job operation.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEntitiesDetectionV2JobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartEntitiesDetectionV2JobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartEntitiesDetectionV2JobOutput) SetJobId(v string) *StartEntitiesDetectionV2JobOutput {
	s.JobId = &v
	return s
}

type StartICD10CMInferenceJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Comprehend Medical; generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that grants Comprehend Medical; read access to your input data.
	// For more information, see Role-Based Permissions Required for Asynchronous
	// Operations (https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions-med.html#auth-role-permissions-med).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// An AWS Key Management Service key to encrypt your output files. If you do
	// not specify a key, the files are written in plain text.
	KMSKey *string `min:"1" type:"string"`

	// The language of the input documents. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartICD10CMInferenceJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartICD10CMInferenceJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartICD10CMInferenceJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartICD10CMInferenceJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.KMSKey != nil && len(*s.KMSKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KMSKey", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartICD10CMInferenceJobInput) SetClientRequestToken(v string) *StartICD10CMInferenceJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartICD10CMInferenceJobInput) SetDataAccessRoleArn(v string) *StartICD10CMInferenceJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartICD10CMInferenceJobInput) SetInputDataConfig(v *InputDataConfig) *StartICD10CMInferenceJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartICD10CMInferenceJobInput) SetJobName(v string) *StartICD10CMInferenceJobInput {
	s.JobName = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *StartICD10CMInferenceJobInput) SetKMSKey(v string) *StartICD10CMInferenceJobInput {
	s.KMSKey = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartICD10CMInferenceJobInput) SetLanguageCode(v string) *StartICD10CMInferenceJobInput {
	s.LanguageCode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartICD10CMInferenceJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartICD10CMInferenceJobInput {
	s.OutputDataConfig = v
	return s
}

type StartICD10CMInferenceJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of a job, use this
	// identifier with the StartICD10CMInferenceJob operation.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartICD10CMInferenceJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartICD10CMInferenceJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartICD10CMInferenceJobOutput) SetJobId(v string) *StartICD10CMInferenceJobOutput {
	s.JobId = &v
	return s
}

type StartPHIDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Comprehend Medical; generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that grants Comprehend Medical; read access to your input data.
	// For more information, see Role-Based Permissions Required for Asynchronous
	// Operations (https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions-med.html#auth-role-permissions-med).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// An AWS Key Management Service key to encrypt your output files. If you do
	// not specify a key, the files are written in plain text.
	KMSKey *string `min:"1" type:"string"`

	// The language of the input documents. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPHIDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPHIDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartPHIDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartPHIDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.KMSKey != nil && len(*s.KMSKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KMSKey", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartPHIDetectionJobInput) SetClientRequestToken(v string) *StartPHIDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartPHIDetectionJobInput) SetDataAccessRoleArn(v string) *StartPHIDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartPHIDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartPHIDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartPHIDetectionJobInput) SetJobName(v string) *StartPHIDetectionJobInput {
	s.JobName = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *StartPHIDetectionJobInput) SetKMSKey(v string) *StartPHIDetectionJobInput {
	s.KMSKey = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartPHIDetectionJobInput) SetLanguageCode(v string) *StartPHIDetectionJobInput {
	s.LanguageCode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartPHIDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartPHIDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

type StartPHIDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of a job, use this
	// identifier with the DescribePHIDetectionJob operation.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPHIDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPHIDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartPHIDetectionJobOutput) SetJobId(v string) *StartPHIDetectionJobOutput {
	s.JobId = &v
	return s
}

type StartRxNormInferenceJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Comprehend Medical; generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that grants Comprehend Medical; read access to your input data.
	// For more information, see Role-Based Permissions Required for Asynchronous
	// Operations (https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions-med.html#auth-role-permissions-med).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// An AWS Key Management Service key to encrypt your output files. If you do
	// not specify a key, the files are written in plain text.
	KMSKey *string `min:"1" type:"string"`

	// The language of the input documents. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRxNormInferenceJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRxNormInferenceJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartRxNormInferenceJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartRxNormInferenceJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.KMSKey != nil && len(*s.KMSKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KMSKey", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartRxNormInferenceJobInput) SetClientRequestToken(v string) *StartRxNormInferenceJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartRxNormInferenceJobInput) SetDataAccessRoleArn(v string) *StartRxNormInferenceJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartRxNormInferenceJobInput) SetInputDataConfig(v *InputDataConfig) *StartRxNormInferenceJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartRxNormInferenceJobInput) SetJobName(v string) *StartRxNormInferenceJobInput {
	s.JobName = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *StartRxNormInferenceJobInput) SetKMSKey(v string) *StartRxNormInferenceJobInput {
	s.KMSKey = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartRxNormInferenceJobInput) SetLanguageCode(v string) *StartRxNormInferenceJobInput {
	s.LanguageCode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartRxNormInferenceJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartRxNormInferenceJobInput {
	s.OutputDataConfig = v
	return s
}

type StartRxNormInferenceJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the job.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRxNormInferenceJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRxNormInferenceJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartRxNormInferenceJobOutput) SetJobId(v string) *StartRxNormInferenceJobOutput {
	s.JobId = &v
	return s
}

type StartSNOMEDCTInferenceJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend Medical generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that grants Amazon Comprehend Medical read access to your input
	// data.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// The input properties for an entities detection job. This includes the name
	// of the S3 bucket and the path to the files to be analyzed.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The user generated name the asynchronous InferSNOMEDCT job.
	JobName *string `min:"1" type:"string"`

	// An AWS Key Management Service key used to encrypt your output files. If you
	// do not specify a key, the files are written in plain text.
	KMSKey *string `min:"1" type:"string"`

	// The language of the input documents. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// The output properties for a detection job.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSNOMEDCTInferenceJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSNOMEDCTInferenceJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSNOMEDCTInferenceJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartSNOMEDCTInferenceJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.KMSKey != nil && len(*s.KMSKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KMSKey", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartSNOMEDCTInferenceJobInput) SetClientRequestToken(v string) *StartSNOMEDCTInferenceJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartSNOMEDCTInferenceJobInput) SetDataAccessRoleArn(v string) *StartSNOMEDCTInferenceJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartSNOMEDCTInferenceJobInput) SetInputDataConfig(v *InputDataConfig) *StartSNOMEDCTInferenceJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartSNOMEDCTInferenceJobInput) SetJobName(v string) *StartSNOMEDCTInferenceJobInput {
	s.JobName = &v
	return s
}

// SetKMSKey sets the KMSKey field's value.
func (s *StartSNOMEDCTInferenceJobInput) SetKMSKey(v string) *StartSNOMEDCTInferenceJobInput {
	s.KMSKey = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartSNOMEDCTInferenceJobInput) SetLanguageCode(v string) *StartSNOMEDCTInferenceJobInput {
	s.LanguageCode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartSNOMEDCTInferenceJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartSNOMEDCTInferenceJobInput {
	s.OutputDataConfig = v
	return s
}

type StartSNOMEDCTInferenceJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of a job, use this
	// identifier with the StartSNOMEDCTInferenceJob operation.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSNOMEDCTInferenceJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSNOMEDCTInferenceJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartSNOMEDCTInferenceJobOutput) SetJobId(v string) *StartSNOMEDCTInferenceJobOutput {
	s.JobId = &v
	return s
}

type StopEntitiesDetectionV2JobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the medical entities job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEntitiesDetectionV2JobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEntitiesDetectionV2JobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopEntitiesDetectionV2JobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopEntitiesDetectionV2JobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopEntitiesDetectionV2JobInput) SetJobId(v string) *StopEntitiesDetectionV2JobInput {
	s.JobId = &v
	return s
}

type StopEntitiesDetectionV2JobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the medical entities detection job that was stopped.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEntitiesDetectionV2JobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopEntitiesDetectionV2JobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopEntitiesDetectionV2JobOutput) SetJobId(v string) *StopEntitiesDetectionV2JobOutput {
	s.JobId = &v
	return s
}

type StopICD10CMInferenceJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopICD10CMInferenceJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopICD10CMInferenceJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopICD10CMInferenceJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopICD10CMInferenceJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopICD10CMInferenceJobInput) SetJobId(v string) *StopICD10CMInferenceJobInput {
	s.JobId = &v
	return s
}

type StopICD10CMInferenceJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of job, use this
	// identifier with the DescribeICD10CMInferenceJob operation.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopICD10CMInferenceJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopICD10CMInferenceJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopICD10CMInferenceJobOutput) SetJobId(v string) *StopICD10CMInferenceJobOutput {
	s.JobId = &v
	return s
}

type StopPHIDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the PHI detection job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopPHIDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopPHIDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopPHIDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopPHIDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopPHIDetectionJobInput) SetJobId(v string) *StopPHIDetectionJobInput {
	s.JobId = &v
	return s
}

type StopPHIDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the PHI detection job that was stopped.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopPHIDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopPHIDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopPHIDetectionJobOutput) SetJobId(v string) *StopPHIDetectionJobOutput {
	s.JobId = &v
	return s
}

type StopRxNormInferenceJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopRxNormInferenceJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopRxNormInferenceJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopRxNormInferenceJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopRxNormInferenceJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopRxNormInferenceJobInput) SetJobId(v string) *StopRxNormInferenceJobInput {
	s.JobId = &v
	return s
}

type StopRxNormInferenceJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of job, use this
	// identifier with the DescribeRxNormInferenceJob operation.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopRxNormInferenceJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopRxNormInferenceJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopRxNormInferenceJobOutput) SetJobId(v string) *StopRxNormInferenceJobOutput {
	s.JobId = &v
	return s
}

type StopSNOMEDCTInferenceJobInput struct {
	_ struct{} `type:"structure"`

	// The job id of the asynchronous InferSNOMEDCT job to be stopped.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSNOMEDCTInferenceJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSNOMEDCTInferenceJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopSNOMEDCTInferenceJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopSNOMEDCTInferenceJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopSNOMEDCTInferenceJobInput) SetJobId(v string) *StopSNOMEDCTInferenceJobInput {
	s.JobId = &v
	return s
}

type StopSNOMEDCTInferenceJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of job, use this
	// identifier with the DescribeSNOMEDCTInferenceJob operation.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSNOMEDCTInferenceJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSNOMEDCTInferenceJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopSNOMEDCTInferenceJobOutput) SetJobId(v string) *StopSNOMEDCTInferenceJobOutput {
	s.JobId = &v
	return s
}

// The size of the text you submitted exceeds the size limit. Reduce the size
// of the text or use a smaller document and then retry your request.
type TextSizeLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextSizeLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextSizeLimitExceededException) GoString() string {
	return s.String()
}

func newErrorTextSizeLimitExceededException(v protocol.ResponseMetadata) error {
	return &TextSizeLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TextSizeLimitExceededException) Code() string {
	return "TextSizeLimitExceededException"
}

// Message returns the exception's message.
func (s *TextSizeLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TextSizeLimitExceededException) OrigErr() error {
	return nil
}

func (s *TextSizeLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TextSizeLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TextSizeLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have made too many requests within a short period of time. Wait for a
// short time and then try your request again. Contact customer support for
// more information about a service limit increase.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides contextual information about the extracted entity.
type Trait struct {
	_ struct{} `type:"structure"`

	// Provides a name or contextual description about the trait.
	Name *string `type:"string" enum:"AttributeName"`

	// The level of confidence that Comprehend Medical; has in the accuracy of this
	// trait.
	Score *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Trait) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Trait) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *Trait) SetName(v string) *Trait {
	s.Name = &v
	return s
}

// SetScore sets the Score field's value.
func (s *Trait) SetScore(v float64) *Trait {
	s.Score = &v
	return s
}

// An attribute that was extracted, but Comprehend Medical; was unable to relate
// to an entity.
type UnmappedAttribute struct {
	_ struct{} `type:"structure"`

	// The specific attribute that has been extracted but not mapped to an entity.
	Attribute *Attribute `type:"structure"`

	// The type of the unmapped attribute, could be one of the following values:
	// "MEDICATION", "MEDICAL_CONDITION", "ANATOMY", "TEST_AND_TREATMENT_PROCEDURE"
	// or "PROTECTED_HEALTH_INFORMATION".
	Type *string `type:"string" enum:"EntityType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnmappedAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnmappedAttribute) GoString() string {
	return s.String()
}

// SetAttribute sets the Attribute field's value.
func (s *UnmappedAttribute) SetAttribute(v *Attribute) *UnmappedAttribute {
	s.Attribute = v
	return s
}

// SetType sets the Type field's value.
func (s *UnmappedAttribute) SetType(v string) *UnmappedAttribute {
	s.Type = &v
	return s
}

// The filter that you specified for the operation is invalid. Check the filter
// values that you entered and try your request again.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AttributeNameSign is a AttributeName enum value
	AttributeNameSign = "SIGN"

	// AttributeNameSymptom is a AttributeName enum value
	AttributeNameSymptom = "SYMPTOM"

	// AttributeNameDiagnosis is a AttributeName enum value
	AttributeNameDiagnosis = "DIAGNOSIS"

	// AttributeNameNegation is a AttributeName enum value
	AttributeNameNegation = "NEGATION"
)

// AttributeName_Values returns all elements of the AttributeName enum
func AttributeName_Values() []string {
	return []string{
		AttributeNameSign,
		AttributeNameSymptom,
		AttributeNameDiagnosis,
		AttributeNameNegation,
	}
}

const (
	// EntitySubTypeName is a EntitySubType enum value
	EntitySubTypeName = "NAME"

	// EntitySubTypeDxName is a EntitySubType enum value
	EntitySubTypeDxName = "DX_NAME"

	// EntitySubTypeDosage is a EntitySubType enum value
	EntitySubTypeDosage = "DOSAGE"

	// EntitySubTypeRouteOrMode is a EntitySubType enum value
	EntitySubTypeRouteOrMode = "ROUTE_OR_MODE"

	// EntitySubTypeForm is a EntitySubType enum value
	EntitySubTypeForm = "FORM"

	// EntitySubTypeFrequency is a EntitySubType enum value
	EntitySubTypeFrequency = "FREQUENCY"

	// EntitySubTypeDuration is a EntitySubType enum value
	EntitySubTypeDuration = "DURATION"

	// EntitySubTypeGenericName is a EntitySubType enum value
	EntitySubTypeGenericName = "GENERIC_NAME"

	// EntitySubTypeBrandName is a EntitySubType enum value
	EntitySubTypeBrandName = "BRAND_NAME"

	// EntitySubTypeStrength is a EntitySubType enum value
	EntitySubTypeStrength = "STRENGTH"

	// EntitySubTypeRate is a EntitySubType enum value
	EntitySubTypeRate = "RATE"

	// EntitySubTypeAcuity is a EntitySubType enum value
	EntitySubTypeAcuity = "ACUITY"

	// EntitySubTypeTestName is a EntitySubType enum value
	EntitySubTypeTestName = "TEST_NAME"

	// EntitySubTypeTestValue is a EntitySubType enum value
	EntitySubTypeTestValue = "TEST_VALUE"

	// EntitySubTypeTestUnits is a EntitySubType enum value
	EntitySubTypeTestUnits = "TEST_UNITS"

	// EntitySubTypeTestUnit is a EntitySubType enum value
	EntitySubTypeTestUnit = "TEST_UNIT"

	// EntitySubTypeProcedureName is a EntitySubType enum value
	EntitySubTypeProcedureName = "PROCEDURE_NAME"

	// EntitySubTypeTreatmentName is a EntitySubType enum value
	EntitySubTypeTreatmentName = "TREATMENT_NAME"

	// EntitySubTypeDate is a EntitySubType enum value
	EntitySubTypeDate = "DATE"

	// EntitySubTypeAge is a EntitySubType enum value
	EntitySubTypeAge = "AGE"

	// EntitySubTypeContactPoint is a EntitySubType enum value
	EntitySubTypeContactPoint = "CONTACT_POINT"

	// EntitySubTypePhoneOrFax is a EntitySubType enum value
	EntitySubTypePhoneOrFax = "PHONE_OR_FAX"

	// EntitySubTypeEmail is a EntitySubType enum value
	EntitySubTypeEmail = "EMAIL"

	// EntitySubTypeIdentifier is a EntitySubType enum value
	EntitySubTypeIdentifier = "IDENTIFIER"

	// EntitySubTypeId is a EntitySubType enum value
	EntitySubTypeId = "ID"

	// EntitySubTypeUrl is a EntitySubType enum value
	EntitySubTypeUrl = "URL"

	// EntitySubTypeAddress is a EntitySubType enum value
	EntitySubTypeAddress = "ADDRESS"

	// EntitySubTypeProfession is a EntitySubType enum value
	EntitySubTypeProfession = "PROFESSION"

	// EntitySubTypeSystemOrganSite is a EntitySubType enum value
	EntitySubTypeSystemOrganSite = "SYSTEM_ORGAN_SITE"

	// EntitySubTypeDirection is a EntitySubType enum value
	EntitySubTypeDirection = "DIRECTION"

	// EntitySubTypeQuality is a EntitySubType enum value
	EntitySubTypeQuality = "QUALITY"

	// EntitySubTypeQuantity is a EntitySubType enum value
	EntitySubTypeQuantity = "QUANTITY"

	// EntitySubTypeTimeExpression is a EntitySubType enum value
	EntitySubTypeTimeExpression = "TIME_EXPRESSION"

	// EntitySubTypeTimeToMedicationName is a EntitySubType enum value
	EntitySubTypeTimeToMedicationName = "TIME_TO_MEDICATION_NAME"

	// EntitySubTypeTimeToDxName is a EntitySubType enum value
	EntitySubTypeTimeToDxName = "TIME_TO_DX_NAME"

	// EntitySubTypeTimeToTestName is a EntitySubType enum value
	EntitySubTypeTimeToTestName = "TIME_TO_TEST_NAME"

	// EntitySubTypeTimeToProcedureName is a EntitySubType enum value
	EntitySubTypeTimeToProcedureName = "TIME_TO_PROCEDURE_NAME"

	// EntitySubTypeTimeToTreatmentName is a EntitySubType enum value
	EntitySubTypeTimeToTreatmentName = "TIME_TO_TREATMENT_NAME"
)

// EntitySubType_Values returns all elements of the EntitySubType enum
func EntitySubType_Values() []string {
	return []string{
		EntitySubTypeName,
		EntitySubTypeDxName,
		EntitySubTypeDosage,
		EntitySubTypeRouteOrMode,
		EntitySubTypeForm,
		EntitySubTypeFrequency,
		EntitySubTypeDuration,
		EntitySubTypeGenericName,
		EntitySubTypeBrandName,
		EntitySubTypeStrength,
		EntitySubTypeRate,
		EntitySubTypeAcuity,
		EntitySubTypeTestName,
		EntitySubTypeTestValue,
		EntitySubTypeTestUnits,
		EntitySubTypeTestUnit,
		EntitySubTypeProcedureName,
		EntitySubTypeTreatmentName,
		EntitySubTypeDate,
		EntitySubTypeAge,
		EntitySubTypeContactPoint,
		EntitySubTypePhoneOrFax,
		EntitySubTypeEmail,
		EntitySubTypeIdentifier,
		EntitySubTypeId,
		EntitySubTypeUrl,
		EntitySubTypeAddress,
		EntitySubTypeProfession,
		EntitySubTypeSystemOrganSite,
		EntitySubTypeDirection,
		EntitySubTypeQuality,
		EntitySubTypeQuantity,
		EntitySubTypeTimeExpression,
		EntitySubTypeTimeToMedicationName,
		EntitySubTypeTimeToDxName,
		EntitySubTypeTimeToTestName,
		EntitySubTypeTimeToProcedureName,
		EntitySubTypeTimeToTreatmentName,
	}
}

const (
	// EntityTypeMedication is a EntityType enum value
	EntityTypeMedication = "MEDICATION"

	// EntityTypeMedicalCondition is a EntityType enum value
	EntityTypeMedicalCondition = "MEDICAL_CONDITION"

	// EntityTypeProtectedHealthInformation is a EntityType enum value
	EntityTypeProtectedHealthInformation = "PROTECTED_HEALTH_INFORMATION"

	// EntityTypeTestTreatmentProcedure is a EntityType enum value
	EntityTypeTestTreatmentProcedure = "TEST_TREATMENT_PROCEDURE"

	// EntityTypeAnatomy is a EntityType enum value
	EntityTypeAnatomy = "ANATOMY"

	// EntityTypeTimeExpression is a EntityType enum value
	EntityTypeTimeExpression = "TIME_EXPRESSION"
)

// EntityType_Values returns all elements of the EntityType enum
func EntityType_Values() []string {
	return []string{
		EntityTypeMedication,
		EntityTypeMedicalCondition,
		EntityTypeProtectedHealthInformation,
		EntityTypeTestTreatmentProcedure,
		EntityTypeAnatomy,
		EntityTypeTimeExpression,
	}
}

const (
	// ICD10CMAttributeTypeAcuity is a ICD10CMAttributeType enum value
	ICD10CMAttributeTypeAcuity = "ACUITY"

	// ICD10CMAttributeTypeDirection is a ICD10CMAttributeType enum value
	ICD10CMAttributeTypeDirection = "DIRECTION"

	// ICD10CMAttributeTypeSystemOrganSite is a ICD10CMAttributeType enum value
	ICD10CMAttributeTypeSystemOrganSite = "SYSTEM_ORGAN_SITE"

	// ICD10CMAttributeTypeQuality is a ICD10CMAttributeType enum value
	ICD10CMAttributeTypeQuality = "QUALITY"

	// ICD10CMAttributeTypeQuantity is a ICD10CMAttributeType enum value
	ICD10CMAttributeTypeQuantity = "QUANTITY"

	// ICD10CMAttributeTypeTimeToDxName is a ICD10CMAttributeType enum value
	ICD10CMAttributeTypeTimeToDxName = "TIME_TO_DX_NAME"

	// ICD10CMAttributeTypeTimeExpression is a ICD10CMAttributeType enum value
	ICD10CMAttributeTypeTimeExpression = "TIME_EXPRESSION"
)

// ICD10CMAttributeType_Values returns all elements of the ICD10CMAttributeType enum
func ICD10CMAttributeType_Values() []string {
	return []string{
		ICD10CMAttributeTypeAcuity,
		ICD10CMAttributeTypeDirection,
		ICD10CMAttributeTypeSystemOrganSite,
		ICD10CMAttributeTypeQuality,
		ICD10CMAttributeTypeQuantity,
		ICD10CMAttributeTypeTimeToDxName,
		ICD10CMAttributeTypeTimeExpression,
	}
}

const (
	// ICD10CMEntityCategoryMedicalCondition is a ICD10CMEntityCategory enum value
	ICD10CMEntityCategoryMedicalCondition = "MEDICAL_CONDITION"
)

// ICD10CMEntityCategory_Values returns all elements of the ICD10CMEntityCategory enum
func ICD10CMEntityCategory_Values() []string {
	return []string{
		ICD10CMEntityCategoryMedicalCondition,
	}
}

const (
	// ICD10CMEntityTypeDxName is a ICD10CMEntityType enum value
	ICD10CMEntityTypeDxName = "DX_NAME"

	// ICD10CMEntityTypeTimeExpression is a ICD10CMEntityType enum value
	ICD10CMEntityTypeTimeExpression = "TIME_EXPRESSION"
)

// ICD10CMEntityType_Values returns all elements of the ICD10CMEntityType enum
func ICD10CMEntityType_Values() []string {
	return []string{
		ICD10CMEntityTypeDxName,
		ICD10CMEntityTypeTimeExpression,
	}
}

const (
	// ICD10CMRelationshipTypeOverlap is a ICD10CMRelationshipType enum value
	ICD10CMRelationshipTypeOverlap = "OVERLAP"

	// ICD10CMRelationshipTypeSystemOrganSite is a ICD10CMRelationshipType enum value
	ICD10CMRelationshipTypeSystemOrganSite = "SYSTEM_ORGAN_SITE"
)

// ICD10CMRelationshipType_Values returns all elements of the ICD10CMRelationshipType enum
func ICD10CMRelationshipType_Values() []string {
	return []string{
		ICD10CMRelationshipTypeOverlap,
		ICD10CMRelationshipTypeSystemOrganSite,
	}
}

const (
	// ICD10CMTraitNameNegation is a ICD10CMTraitName enum value
	ICD10CMTraitNameNegation = "NEGATION"

	// ICD10CMTraitNameDiagnosis is a ICD10CMTraitName enum value
	ICD10CMTraitNameDiagnosis = "DIAGNOSIS"

	// ICD10CMTraitNameSign is a ICD10CMTraitName enum value
	ICD10CMTraitNameSign = "SIGN"

	// ICD10CMTraitNameSymptom is a ICD10CMTraitName enum value
	ICD10CMTraitNameSymptom = "SYMPTOM"
)

// ICD10CMTraitName_Values returns all elements of the ICD10CMTraitName enum
func ICD10CMTraitName_Values() []string {
	return []string{
		ICD10CMTraitNameNegation,
		ICD10CMTraitNameDiagnosis,
		ICD10CMTraitNameSign,
		ICD10CMTraitNameSymptom,
	}
}

const (
	// JobStatusSubmitted is a JobStatus enum value
	JobStatusSubmitted = "SUBMITTED"

	// JobStatusInProgress is a JobStatus enum value
	JobStatusInProgress = "IN_PROGRESS"

	// JobStatusCompleted is a JobStatus enum value
	JobStatusCompleted = "COMPLETED"

	// JobStatusPartialSuccess is a JobStatus enum value
	JobStatusPartialSuccess = "PARTIAL_SUCCESS"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"

	// JobStatusStopRequested is a JobStatus enum value
	JobStatusStopRequested = "STOP_REQUESTED"

	// JobStatusStopped is a JobStatus enum value
	JobStatusStopped = "STOPPED"
)

// JobStatus_Values returns all elements of the JobStatus enum
func JobStatus_Values() []string {
	return []string{
		JobStatusSubmitted,
		JobStatusInProgress,
		JobStatusCompleted,
		JobStatusPartialSuccess,
		JobStatusFailed,
		JobStatusStopRequested,
		JobStatusStopped,
	}
}

const (
	// LanguageCodeEn is a LanguageCode enum value
	LanguageCodeEn = "en"
)

// LanguageCode_Values returns all elements of the LanguageCode enum
func LanguageCode_Values() []string {
	return []string{
		LanguageCodeEn,
	}
}

const (
	// RelationshipTypeEvery is a RelationshipType enum value
	RelationshipTypeEvery = "EVERY"

	// RelationshipTypeWithDosage is a RelationshipType enum value
	RelationshipTypeWithDosage = "WITH_DOSAGE"

	// RelationshipTypeAdministeredVia is a RelationshipType enum value
	RelationshipTypeAdministeredVia = "ADMINISTERED_VIA"

	// RelationshipTypeFor is a RelationshipType enum value
	RelationshipTypeFor = "FOR"

	// RelationshipTypeNegative is a RelationshipType enum value
	RelationshipTypeNegative = "NEGATIVE"

	// RelationshipTypeOverlap is a RelationshipType enum value
	RelationshipTypeOverlap = "OVERLAP"

	// RelationshipTypeDosage is a RelationshipType enum value
	RelationshipTypeDosage = "DOSAGE"

	// RelationshipTypeRouteOrMode is a RelationshipType enum value
	RelationshipTypeRouteOrMode = "ROUTE_OR_MODE"

	// RelationshipTypeForm is a RelationshipType enum value
	RelationshipTypeForm = "FORM"

	// RelationshipTypeFrequency is a RelationshipType enum value
	RelationshipTypeFrequency = "FREQUENCY"

	// RelationshipTypeDuration is a RelationshipType enum value
	RelationshipTypeDuration = "DURATION"

	// RelationshipTypeStrength is a RelationshipType enum value
	RelationshipTypeStrength = "STRENGTH"

	// RelationshipTypeRate is a RelationshipType enum value
	RelationshipTypeRate = "RATE"

	// RelationshipTypeAcuity is a RelationshipType enum value
	RelationshipTypeAcuity = "ACUITY"

	// RelationshipTypeTestValue is a RelationshipType enum value
	RelationshipTypeTestValue = "TEST_VALUE"

	// RelationshipTypeTestUnits is a RelationshipType enum value
	RelationshipTypeTestUnits = "TEST_UNITS"

	// RelationshipTypeTestUnit is a RelationshipType enum value
	RelationshipTypeTestUnit = "TEST_UNIT"

	// RelationshipTypeDirection is a RelationshipType enum value
	RelationshipTypeDirection = "DIRECTION"

	// RelationshipTypeSystemOrganSite is a RelationshipType enum value
	RelationshipTypeSystemOrganSite = "SYSTEM_ORGAN_SITE"
)

// RelationshipType_Values returns all elements of the RelationshipType enum
func RelationshipType_Values() []string {
	return []string{
		RelationshipTypeEvery,
		RelationshipTypeWithDosage,
		RelationshipTypeAdministeredVia,
		RelationshipTypeFor,
		RelationshipTypeNegative,
		RelationshipTypeOverlap,
		RelationshipTypeDosage,
		RelationshipTypeRouteOrMode,
		RelationshipTypeForm,
		RelationshipTypeFrequency,
		RelationshipTypeDuration,
		RelationshipTypeStrength,
		RelationshipTypeRate,
		RelationshipTypeAcuity,
		RelationshipTypeTestValue,
		RelationshipTypeTestUnits,
		RelationshipTypeTestUnit,
		RelationshipTypeDirection,
		RelationshipTypeSystemOrganSite,
	}
}

const (
	// RxNormAttributeTypeDosage is a RxNormAttributeType enum value
	RxNormAttributeTypeDosage = "DOSAGE"

	// RxNormAttributeTypeDuration is a RxNormAttributeType enum value
	RxNormAttributeTypeDuration = "DURATION"

	// RxNormAttributeTypeForm is a RxNormAttributeType enum value
	RxNormAttributeTypeForm = "FORM"

	// RxNormAttributeTypeFrequency is a RxNormAttributeType enum value
	RxNormAttributeTypeFrequency = "FREQUENCY"

	// RxNormAttributeTypeRate is a RxNormAttributeType enum value
	RxNormAttributeTypeRate = "RATE"

	// RxNormAttributeTypeRouteOrMode is a RxNormAttributeType enum value
	RxNormAttributeTypeRouteOrMode = "ROUTE_OR_MODE"

	// RxNormAttributeTypeStrength is a RxNormAttributeType enum value
	RxNormAttributeTypeStrength = "STRENGTH"
)

// RxNormAttributeType_Values returns all elements of the RxNormAttributeType enum
func RxNormAttributeType_Values() []string {
	return []string{
		RxNormAttributeTypeDosage,
		RxNormAttributeTypeDuration,
		RxNormAttributeTypeForm,
		RxNormAttributeTypeFrequency,
		RxNormAttributeTypeRate,
		RxNormAttributeTypeRouteOrMode,
		RxNormAttributeTypeStrength,
	}
}

const (
	// RxNormEntityCategoryMedication is a RxNormEntityCategory enum value
	RxNormEntityCategoryMedication = "MEDICATION"
)

// RxNormEntityCategory_Values returns all elements of the RxNormEntityCategory enum
func RxNormEntityCategory_Values() []string {
	return []string{
		RxNormEntityCategoryMedication,
	}
}

const (
	// RxNormEntityTypeBrandName is a RxNormEntityType enum value
	RxNormEntityTypeBrandName = "BRAND_NAME"

	// RxNormEntityTypeGenericName is a RxNormEntityType enum value
	RxNormEntityTypeGenericName = "GENERIC_NAME"
)

// RxNormEntityType_Values returns all elements of the RxNormEntityType enum
func RxNormEntityType_Values() []string {
	return []string{
		RxNormEntityTypeBrandName,
		RxNormEntityTypeGenericName,
	}
}

const (
	// RxNormTraitNameNegation is a RxNormTraitName enum value
	RxNormTraitNameNegation = "NEGATION"
)

// RxNormTraitName_Values returns all elements of the RxNormTraitName enum
func RxNormTraitName_Values() []string {
	return []string{
		RxNormTraitNameNegation,
	}
}

const (
	// SNOMEDCTAttributeTypeAcuity is a SNOMEDCTAttributeType enum value
	SNOMEDCTAttributeTypeAcuity = "ACUITY"

	// SNOMEDCTAttributeTypeQuality is a SNOMEDCTAttributeType enum value
	SNOMEDCTAttributeTypeQuality = "QUALITY"

	// SNOMEDCTAttributeTypeDirection is a SNOMEDCTAttributeType enum value
	SNOMEDCTAttributeTypeDirection = "DIRECTION"

	// SNOMEDCTAttributeTypeSystemOrganSite is a SNOMEDCTAttributeType enum value
	SNOMEDCTAttributeTypeSystemOrganSite = "SYSTEM_ORGAN_SITE"

	// SNOMEDCTAttributeTypeTestValue is a SNOMEDCTAttributeType enum value
	SNOMEDCTAttributeTypeTestValue = "TEST_VALUE"

	// SNOMEDCTAttributeTypeTestUnit is a SNOMEDCTAttributeType enum value
	SNOMEDCTAttributeTypeTestUnit = "TEST_UNIT"
)

// SNOMEDCTAttributeType_Values returns all elements of the SNOMEDCTAttributeType enum
func SNOMEDCTAttributeType_Values() []string {
	return []string{
		SNOMEDCTAttributeTypeAcuity,
		SNOMEDCTAttributeTypeQuality,
		SNOMEDCTAttributeTypeDirection,
		SNOMEDCTAttributeTypeSystemOrganSite,
		SNOMEDCTAttributeTypeTestValue,
		SNOMEDCTAttributeTypeTestUnit,
	}
}

const (
	// SNOMEDCTEntityCategoryMedicalCondition is a SNOMEDCTEntityCategory enum value
	SNOMEDCTEntityCategoryMedicalCondition = "MEDICAL_CONDITION"

	// SNOMEDCTEntityCategoryAnatomy is a SNOMEDCTEntityCategory enum value
	SNOMEDCTEntityCategoryAnatomy = "ANATOMY"

	// SNOMEDCTEntityCategoryTestTreatmentProcedure is a SNOMEDCTEntityCategory enum value
	SNOMEDCTEntityCategoryTestTreatmentProcedure = "TEST_TREATMENT_PROCEDURE"
)

// SNOMEDCTEntityCategory_Values returns all elements of the SNOMEDCTEntityCategory enum
func SNOMEDCTEntityCategory_Values() []string {
	return []string{
		SNOMEDCTEntityCategoryMedicalCondition,
		SNOMEDCTEntityCategoryAnatomy,
		SNOMEDCTEntityCategoryTestTreatmentProcedure,
	}
}

const (
	// SNOMEDCTEntityTypeDxName is a SNOMEDCTEntityType enum value
	SNOMEDCTEntityTypeDxName = "DX_NAME"

	// SNOMEDCTEntityTypeTestName is a SNOMEDCTEntityType enum value
	SNOMEDCTEntityTypeTestName = "TEST_NAME"

	// SNOMEDCTEntityTypeProcedureName is a SNOMEDCTEntityType enum value
	SNOMEDCTEntityTypeProcedureName = "PROCEDURE_NAME"

	// SNOMEDCTEntityTypeTreatmentName is a SNOMEDCTEntityType enum value
	SNOMEDCTEntityTypeTreatmentName = "TREATMENT_NAME"
)

// SNOMEDCTEntityType_Values returns all elements of the SNOMEDCTEntityType enum
func SNOMEDCTEntityType_Values() []string {
	return []string{
		SNOMEDCTEntityTypeDxName,
		SNOMEDCTEntityTypeTestName,
		SNOMEDCTEntityTypeProcedureName,
		SNOMEDCTEntityTypeTreatmentName,
	}
}

const (
	// SNOMEDCTRelationshipTypeAcuity is a SNOMEDCTRelationshipType enum value
	SNOMEDCTRelationshipTypeAcuity = "ACUITY"

	// SNOMEDCTRelationshipTypeQuality is a SNOMEDCTRelationshipType enum value
	SNOMEDCTRelationshipTypeQuality = "QUALITY"

	// SNOMEDCTRelationshipTypeTestValue is a SNOMEDCTRelationshipType enum value
	SNOMEDCTRelationshipTypeTestValue = "TEST_VALUE"

	// SNOMEDCTRelationshipTypeTestUnits is a SNOMEDCTRelationshipType enum value
	SNOMEDCTRelationshipTypeTestUnits = "TEST_UNITS"

	// SNOMEDCTRelationshipTypeDirection is a SNOMEDCTRelationshipType enum value
	SNOMEDCTRelationshipTypeDirection = "DIRECTION"

	// SNOMEDCTRelationshipTypeSystemOrganSite is a SNOMEDCTRelationshipType enum value
	SNOMEDCTRelationshipTypeSystemOrganSite = "SYSTEM_ORGAN_SITE"
)

// SNOMEDCTRelationshipType_Values returns all elements of the SNOMEDCTRelationshipType enum
func SNOMEDCTRelationshipType_Values() []string {
	return []string{
		SNOMEDCTRelationshipTypeAcuity,
		SNOMEDCTRelationshipTypeQuality,
		SNOMEDCTRelationshipTypeTestValue,
		SNOMEDCTRelationshipTypeTestUnits,
		SNOMEDCTRelationshipTypeDirection,
		SNOMEDCTRelationshipTypeSystemOrganSite,
	}
}

const (
	// SNOMEDCTTraitNameNegation is a SNOMEDCTTraitName enum value
	SNOMEDCTTraitNameNegation = "NEGATION"

	// SNOMEDCTTraitNameDiagnosis is a SNOMEDCTTraitName enum value
	SNOMEDCTTraitNameDiagnosis = "DIAGNOSIS"

	// SNOMEDCTTraitNameSign is a SNOMEDCTTraitName enum value
	SNOMEDCTTraitNameSign = "SIGN"

	// SNOMEDCTTraitNameSymptom is a SNOMEDCTTraitName enum value
	SNOMEDCTTraitNameSymptom = "SYMPTOM"
)

// SNOMEDCTTraitName_Values returns all elements of the SNOMEDCTTraitName enum
func SNOMEDCTTraitName_Values() []string {
	return []string{
		SNOMEDCTTraitNameNegation,
		SNOMEDCTTraitNameDiagnosis,
		SNOMEDCTTraitNameSign,
		SNOMEDCTTraitNameSymptom,
	}
}
