package visionai_poc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizeEntity invokes the visionai_poc.RecognizeEntity API synchronously
// api document: https://help.aliyun.com/api/visionai-poc/recognizeentity.html
func (client *Client) RecognizeEntity(request *RecognizeEntityRequest) (response *RecognizeEntityResponse, err error) {
	response = CreateRecognizeEntityResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizeEntityWithChan invokes the visionai_poc.RecognizeEntity API asynchronously
// api document: https://help.aliyun.com/api/visionai-poc/recognizeentity.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RecognizeEntityWithChan(request *RecognizeEntityRequest) (<-chan *RecognizeEntityResponse, <-chan error) {
	responseChan := make(chan *RecognizeEntityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizeEntity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizeEntityWithCallback invokes the visionai_poc.RecognizeEntity API asynchronously
// api document: https://help.aliyun.com/api/visionai-poc/recognizeentity.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RecognizeEntityWithCallback(request *RecognizeEntityRequest, callback func(response *RecognizeEntityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizeEntityResponse
		var err error
		defer close(result)
		response, err = client.RecognizeEntity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizeEntityRequest is the request struct for api RecognizeEntity
type RecognizeEntityRequest struct {
	*requests.RpcRequest
	Method   string `position:"Body" name:"Method"`
	ImageUrl string `position:"Body" name:"ImageUrl"`
	Url      string `position:"Body" name:"Url"`
}

// RecognizeEntityResponse is the response struct for api RecognizeEntity
type RecognizeEntityResponse struct {
	*responses.BaseResponse
	Code     int                       `json:"Code" xml:"Code"`
	Message  string                    `json:"Message" xml:"Message"`
	Success  bool                      `json:"Success" xml:"Success"`
	Response ResponseInRecognizeEntity `json:"Response" xml:"Response"`
}

// CreateRecognizeEntityRequest creates a request to invoke RecognizeEntity API
func CreateRecognizeEntityRequest() (request *RecognizeEntityRequest) {
	request = &RecognizeEntityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("visionai-poc", "2020-04-08", "RecognizeEntity", "", "")
	return
}

// CreateRecognizeEntityResponse creates a response to parse from RecognizeEntity response
func CreateRecognizeEntityResponse() (response *RecognizeEntityResponse) {
	response = &RecognizeEntityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
