package tdsr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetHotspotConfig invokes the tdsr.GetHotspotConfig API synchronously
// api document: https://help.aliyun.com/api/tdsr/gethotspotconfig.html
func (client *Client) GetHotspotConfig(request *GetHotspotConfigRequest) (response *GetHotspotConfigResponse, err error) {
	response = CreateGetHotspotConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetHotspotConfigWithChan invokes the tdsr.GetHotspotConfig API asynchronously
// api document: https://help.aliyun.com/api/tdsr/gethotspotconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetHotspotConfigWithChan(request *GetHotspotConfigRequest) (<-chan *GetHotspotConfigResponse, <-chan error) {
	responseChan := make(chan *GetHotspotConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetHotspotConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetHotspotConfigWithCallback invokes the tdsr.GetHotspotConfig API asynchronously
// api document: https://help.aliyun.com/api/tdsr/gethotspotconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetHotspotConfigWithCallback(request *GetHotspotConfigRequest, callback func(response *GetHotspotConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetHotspotConfigResponse
		var err error
		defer close(result)
		response, err = client.GetHotspotConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetHotspotConfigRequest is the request struct for api GetHotspotConfig
type GetHotspotConfigRequest struct {
	*requests.RpcRequest
	PreviewToken string `position:"Query" name:"PreviewToken"`
}

// GetHotspotConfigResponse is the response struct for api GetHotspotConfig
type GetHotspotConfigResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrMessage   string `json:"ErrMessage" xml:"ErrMessage"`
	Data         string `json:"Data" xml:"Data"`
	ObjectString string `json:"ObjectString" xml:"ObjectString"`
}

// CreateGetHotspotConfigRequest creates a request to invoke GetHotspotConfig API
func CreateGetHotspotConfigRequest() (request *GetHotspotConfigRequest) {
	request = &GetHotspotConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("tdsr", "2020-01-01", "GetHotspotConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateGetHotspotConfigResponse creates a response to parse from GetHotspotConfig response
func CreateGetHotspotConfigResponse() (response *GetHotspotConfigResponse) {
	response = &GetHotspotConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
