package privatelink

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveUserFromVpcEndpointService invokes the privatelink.RemoveUserFromVpcEndpointService API synchronously
func (client *Client) RemoveUserFromVpcEndpointService(request *RemoveUserFromVpcEndpointServiceRequest) (response *RemoveUserFromVpcEndpointServiceResponse, err error) {
	response = CreateRemoveUserFromVpcEndpointServiceResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveUserFromVpcEndpointServiceWithChan invokes the privatelink.RemoveUserFromVpcEndpointService API asynchronously
func (client *Client) RemoveUserFromVpcEndpointServiceWithChan(request *RemoveUserFromVpcEndpointServiceRequest) (<-chan *RemoveUserFromVpcEndpointServiceResponse, <-chan error) {
	responseChan := make(chan *RemoveUserFromVpcEndpointServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveUserFromVpcEndpointService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveUserFromVpcEndpointServiceWithCallback invokes the privatelink.RemoveUserFromVpcEndpointService API asynchronously
func (client *Client) RemoveUserFromVpcEndpointServiceWithCallback(request *RemoveUserFromVpcEndpointServiceRequest, callback func(response *RemoveUserFromVpcEndpointServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveUserFromVpcEndpointServiceResponse
		var err error
		defer close(result)
		response, err = client.RemoveUserFromVpcEndpointService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveUserFromVpcEndpointServiceRequest is the request struct for api RemoveUserFromVpcEndpointService
type RemoveUserFromVpcEndpointServiceRequest struct {
	*requests.RpcRequest
	ClientToken string           `position:"Query" name:"ClientToken"`
	UserId      requests.Integer `position:"Query" name:"UserId"`
	DryRun      requests.Boolean `position:"Query" name:"DryRun"`
	ServiceId   string           `position:"Query" name:"ServiceId"`
}

// RemoveUserFromVpcEndpointServiceResponse is the response struct for api RemoveUserFromVpcEndpointService
type RemoveUserFromVpcEndpointServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRemoveUserFromVpcEndpointServiceRequest creates a request to invoke RemoveUserFromVpcEndpointService API
func CreateRemoveUserFromVpcEndpointServiceRequest() (request *RemoveUserFromVpcEndpointServiceRequest) {
	request = &RemoveUserFromVpcEndpointServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Privatelink", "2020-04-15", "RemoveUserFromVpcEndpointService", "privatelink", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveUserFromVpcEndpointServiceResponse creates a response to parse from RemoveUserFromVpcEndpointService response
func CreateRemoveUserFromVpcEndpointServiceResponse() (response *RemoveUserFromVpcEndpointServiceResponse) {
	response = &RemoveUserFromVpcEndpointServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
