package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstanceStoragePerformance invokes the polardbx.DescribeInstanceStoragePerformance API synchronously
func (client *Client) DescribeInstanceStoragePerformance(request *DescribeInstanceStoragePerformanceRequest) (response *DescribeInstanceStoragePerformanceResponse, err error) {
	response = CreateDescribeInstanceStoragePerformanceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstanceStoragePerformanceWithChan invokes the polardbx.DescribeInstanceStoragePerformance API asynchronously
func (client *Client) DescribeInstanceStoragePerformanceWithChan(request *DescribeInstanceStoragePerformanceRequest) (<-chan *DescribeInstanceStoragePerformanceResponse, <-chan error) {
	responseChan := make(chan *DescribeInstanceStoragePerformanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstanceStoragePerformance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstanceStoragePerformanceWithCallback invokes the polardbx.DescribeInstanceStoragePerformance API asynchronously
func (client *Client) DescribeInstanceStoragePerformanceWithCallback(request *DescribeInstanceStoragePerformanceRequest, callback func(response *DescribeInstanceStoragePerformanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstanceStoragePerformanceResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstanceStoragePerformance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstanceStoragePerformanceRequest is the request struct for api DescribeInstanceStoragePerformance
type DescribeInstanceStoragePerformanceRequest struct {
	*requests.RpcRequest
	DbInstanceName    string `position:"Query" name:"DbInstanceName"`
	StorageInstanceId string `position:"Query" name:"StorageInstanceId"`
	Keys              string `position:"Query" name:"Keys"`
	EndTime           string `position:"Query" name:"EndTime"`
	StartTime         string `position:"Query" name:"StartTime"`
}

// DescribeInstanceStoragePerformanceResponse is the response struct for api DescribeInstanceStoragePerformance
type DescribeInstanceStoragePerformanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeInstanceStoragePerformanceRequest creates a request to invoke DescribeInstanceStoragePerformance API
func CreateDescribeInstanceStoragePerformanceRequest() (request *DescribeInstanceStoragePerformanceRequest) {
	request = &DescribeInstanceStoragePerformanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "DescribeInstanceStoragePerformance", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstanceStoragePerformanceResponse creates a response to parse from DescribeInstanceStoragePerformance response
func CreateDescribeInstanceStoragePerformanceResponse() (response *DescribeInstanceStoragePerformanceResponse) {
	response = &DescribeInstanceStoragePerformanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
