package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRamRoles invokes the opensearch.ListRamRoles API synchronously
func (client *Client) ListRamRoles(request *ListRamRolesRequest) (response *ListRamRolesResponse, err error) {
	response = CreateListRamRolesResponse()
	err = client.DoAction(request, response)
	return
}

// ListRamRolesWithChan invokes the opensearch.ListRamRoles API asynchronously
func (client *Client) ListRamRolesWithChan(request *ListRamRolesRequest) (<-chan *ListRamRolesResponse, <-chan error) {
	responseChan := make(chan *ListRamRolesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRamRoles(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRamRolesWithCallback invokes the opensearch.ListRamRoles API asynchronously
func (client *Client) ListRamRolesWithCallback(request *ListRamRolesRequest, callback func(response *ListRamRolesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRamRolesResponse
		var err error
		defer close(result)
		response, err = client.ListRamRoles(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRamRolesRequest is the request struct for api ListRamRoles
type ListRamRolesRequest struct {
	*requests.RoaRequest
}

// ListRamRolesResponse is the response struct for api ListRamRoles
type ListRamRolesResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"requestId" xml:"requestId"`
	Result    []ResultItem `json:"result" xml:"result"`
}

// CreateListRamRolesRequest creates a request to invoke ListRamRoles API
func CreateListRamRolesRequest() (request *ListRamRolesRequest) {
	request = &ListRamRolesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ListRamRoles", "/v4/openapi/assist/ram/roles", "opensearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListRamRolesResponse creates a response to parse from ListRamRoles response
func CreateListRamRolesResponse() (response *ListRamRolesResponse) {
	response = &ListRamRolesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
