package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CategoryTree invokes the mts.CategoryTree API synchronously
func (client *Client) CategoryTree(request *CategoryTreeRequest) (response *CategoryTreeResponse, err error) {
	response = CreateCategoryTreeResponse()
	err = client.DoAction(request, response)
	return
}

// CategoryTreeWithChan invokes the mts.CategoryTree API asynchronously
func (client *Client) CategoryTreeWithChan(request *CategoryTreeRequest) (<-chan *CategoryTreeResponse, <-chan error) {
	responseChan := make(chan *CategoryTreeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CategoryTree(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CategoryTreeWithCallback invokes the mts.CategoryTree API asynchronously
func (client *Client) CategoryTreeWithCallback(request *CategoryTreeRequest, callback func(response *CategoryTreeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CategoryTreeResponse
		var err error
		defer close(result)
		response, err = client.CategoryTree(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CategoryTreeRequest is the request struct for api CategoryTree
type CategoryTreeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// CategoryTreeResponse is the response struct for api CategoryTree
type CategoryTreeResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	CategoryTree string `json:"CategoryTree" xml:"CategoryTree"`
}

// CreateCategoryTreeRequest creates a request to invoke CategoryTree API
func CreateCategoryTreeRequest() (request *CategoryTreeRequest) {
	request = &CategoryTreeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "CategoryTree", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCategoryTreeResponse creates a response to parse from CategoryTree response
func CreateCategoryTreeResponse() (response *CategoryTreeResponse) {
	response = &CategoryTreeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
