package market

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMarketImages invokes the market.QueryMarketImages API synchronously
// api document: https://help.aliyun.com/api/market/querymarketimages.html
func (client *Client) QueryMarketImages(request *QueryMarketImagesRequest) (response *QueryMarketImagesResponse, err error) {
	response = CreateQueryMarketImagesResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMarketImagesWithChan invokes the market.QueryMarketImages API asynchronously
// api document: https://help.aliyun.com/api/market/querymarketimages.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryMarketImagesWithChan(request *QueryMarketImagesRequest) (<-chan *QueryMarketImagesResponse, <-chan error) {
	responseChan := make(chan *QueryMarketImagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMarketImages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMarketImagesWithCallback invokes the market.QueryMarketImages API asynchronously
// api document: https://help.aliyun.com/api/market/querymarketimages.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryMarketImagesWithCallback(request *QueryMarketImagesRequest, callback func(response *QueryMarketImagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMarketImagesResponse
		var err error
		defer close(result)
		response, err = client.QueryMarketImages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMarketImagesRequest is the request struct for api QueryMarketImages
type QueryMarketImagesRequest struct {
	*requests.RpcRequest
	Param string `position:"Query" name:"Param"`
}

// QueryMarketImagesResponse is the response struct for api QueryMarketImages
type QueryMarketImagesResponse struct {
	*responses.BaseResponse
	PageNumber int    `json:"PageNumber" xml:"PageNumber"`
	PageSize   int    `json:"PageSize" xml:"PageSize"`
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Result     Result `json:"Result" xml:"Result"`
}

// CreateQueryMarketImagesRequest creates a request to invoke QueryMarketImages API
func CreateQueryMarketImagesRequest() (request *QueryMarketImagesRequest) {
	request = &QueryMarketImagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Market", "2015-11-01", "QueryMarketImages", "yunmarket", "openAPI")
	return
}

// CreateQueryMarketImagesResponse creates a response to parse from QueryMarketImages response
func CreateQueryMarketImagesResponse() (response *QueryMarketImagesResponse) {
	response = &QueryMarketImagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
