package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetJoinPermissionAuthOrder invokes the linkwan.GetJoinPermissionAuthOrder API synchronously
func (client *Client) GetJoinPermissionAuthOrder(request *GetJoinPermissionAuthOrderRequest) (response *GetJoinPermissionAuthOrderResponse, err error) {
	response = CreateGetJoinPermissionAuthOrderResponse()
	err = client.DoAction(request, response)
	return
}

// GetJoinPermissionAuthOrderWithChan invokes the linkwan.GetJoinPermissionAuthOrder API asynchronously
func (client *Client) GetJoinPermissionAuthOrderWithChan(request *GetJoinPermissionAuthOrderRequest) (<-chan *GetJoinPermissionAuthOrderResponse, <-chan error) {
	responseChan := make(chan *GetJoinPermissionAuthOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetJoinPermissionAuthOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetJoinPermissionAuthOrderWithCallback invokes the linkwan.GetJoinPermissionAuthOrder API asynchronously
func (client *Client) GetJoinPermissionAuthOrderWithCallback(request *GetJoinPermissionAuthOrderRequest, callback func(response *GetJoinPermissionAuthOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetJoinPermissionAuthOrderResponse
		var err error
		defer close(result)
		response, err = client.GetJoinPermissionAuthOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetJoinPermissionAuthOrderRequest is the request struct for api GetJoinPermissionAuthOrder
type GetJoinPermissionAuthOrderRequest struct {
	*requests.RpcRequest
	OrderId     string `position:"Query" name:"OrderId"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// GetJoinPermissionAuthOrderResponse is the response struct for api GetJoinPermissionAuthOrder
type GetJoinPermissionAuthOrderResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetJoinPermissionAuthOrderRequest creates a request to invoke GetJoinPermissionAuthOrder API
func CreateGetJoinPermissionAuthOrderRequest() (request *GetJoinPermissionAuthOrderRequest) {
	request = &GetJoinPermissionAuthOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "GetJoinPermissionAuthOrder", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetJoinPermissionAuthOrderResponse creates a response to parse from GetJoinPermissionAuthOrder response
func CreateGetJoinPermissionAuthOrderResponse() (response *GetJoinPermissionAuthOrderResponse) {
	response = &GetJoinPermissionAuthOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
