package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImportEncryptionCertificate invokes the kms.ImportEncryptionCertificate API synchronously
func (client *Client) ImportEncryptionCertificate(request *ImportEncryptionCertificateRequest) (response *ImportEncryptionCertificateResponse, err error) {
	response = CreateImportEncryptionCertificateResponse()
	err = client.DoAction(request, response)
	return
}

// ImportEncryptionCertificateWithChan invokes the kms.ImportEncryptionCertificate API asynchronously
func (client *Client) ImportEncryptionCertificateWithChan(request *ImportEncryptionCertificateRequest) (<-chan *ImportEncryptionCertificateResponse, <-chan error) {
	responseChan := make(chan *ImportEncryptionCertificateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImportEncryptionCertificate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImportEncryptionCertificateWithCallback invokes the kms.ImportEncryptionCertificate API asynchronously
func (client *Client) ImportEncryptionCertificateWithCallback(request *ImportEncryptionCertificateRequest, callback func(response *ImportEncryptionCertificateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImportEncryptionCertificateResponse
		var err error
		defer close(result)
		response, err = client.ImportEncryptionCertificate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImportEncryptionCertificateRequest is the request struct for api ImportEncryptionCertificate
type ImportEncryptionCertificateRequest struct {
	*requests.RpcRequest
	AsymmetricAlgorithm   string `position:"Query" name:"AsymmetricAlgorithm"`
	SymmetricAlgorithm    string `position:"Query" name:"SymmetricAlgorithm"`
	EncryptedPrivateKey   string `position:"Query" name:"EncryptedPrivateKey"`
	EncryptedSymmetricKey string `position:"Query" name:"EncryptedSymmetricKey"`
	CertificateId         string `position:"Query" name:"CertificateId"`
	Certificate           string `position:"Query" name:"Certificate"`
	CertificateChain      string `position:"Query" name:"CertificateChain"`
}

// ImportEncryptionCertificateResponse is the response struct for api ImportEncryptionCertificate
type ImportEncryptionCertificateResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	CertificateId string `json:"CertificateId" xml:"CertificateId"`
	Arn           string `json:"Arn" xml:"Arn"`
}

// CreateImportEncryptionCertificateRequest creates a request to invoke ImportEncryptionCertificate API
func CreateImportEncryptionCertificateRequest() (request *ImportEncryptionCertificateRequest) {
	request = &ImportEncryptionCertificateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "ImportEncryptionCertificate", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateImportEncryptionCertificateResponse creates a response to parse from ImportEncryptionCertificate response
func CreateImportEncryptionCertificateResponse() (response *ImportEncryptionCertificateResponse) {
	response = &ImportEncryptionCertificateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
