//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package eci

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateImageCache invokes the eci.CreateImageCache API synchronously
// api document: https://help.aliyun.com/api/eci/createimagecache.html
func (client *Client) CreateImageCache(request *CreateImageCacheRequest) (response *CreateImageCacheResponse, err error) {
	response = CreateCreateImageCacheResponse()
	err = client.DoAction(request, response)
	return
}

// CreateImageCacheWithChan invokes the eci.CreateImageCache API asynchronously
// api document: https://help.aliyun.com/api/eci/createimagecache.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateImageCacheWithChan(request *CreateImageCacheRequest) (<-chan *CreateImageCacheResponse, <-chan error) {
	responseChan := make(chan *CreateImageCacheResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateImageCache(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateImageCacheWithCallback invokes the eci.CreateImageCache API asynchronously
// api document: https://help.aliyun.com/api/eci/createimagecache.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateImageCacheWithCallback(request *CreateImageCacheRequest, callback func(response *CreateImageCacheResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateImageCacheResponse
		var err error
		defer close(result)
		response, err = client.CreateImageCache(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateImageCacheRequest is the request struct for api CreateImageCache
type CreateImageCacheRequest struct {
	*requests.RpcRequest
	OwnerId                 requests.Integer                           `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount    string                                     `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId         requests.Integer                           `position:"Query" name:"ResourceOwnerId"`
	OwnerAccount            string                                     `position:"Query" name:"OwnerAccount"`
	RegionId                string                                     `position:"Query" name:"RegionId"`
	ZoneId                  string                                     `position:"Query" name:"ZoneId"`
	SecurityGroupId         string                                     `position:"Query" name:"SecurityGroupId"`
	VSwitchId               string                                     `position:"Query" name:"VSwitchId"`
	ImageCacheName          string                                     `position:"Query" name:"ImageCacheName"`
	ImageRegistryCredential *[]CreateImageCacheImageRegistryCredential `position:"Query" name:"ImageRegistryCredential" type:"Repeated"`
	EipInstanceId           string                                     `position:"Query" name:"EipInstanceId"`
	ResourceGroupId         string                                     `position:"Query" name:"ResourceGroupId"`
	ClientToken             string                                     `position:"Query" name:"ClientToken"`
	Image                   []string                                   `position:"Query" name:"Image" type:"Repeated"`
	ImageCacheSize          requests.Integer                           `position:"Query" name:"ImageCacheSize"`
	VkClientVersion         string                                     `position:"Query" name:"VkClientVersion"`
	RetentionDays           requests.Integer                           `position:"Query" name:"RetentionDays"`
}

type CreateImageCacheImageRegistryCredential struct {
	Server   string `name:"Server"`
	UserName string `name:"UserName"`
	Password string `name:"Password"`
}

// CreateImageCacheResponse is the response struct for api CreateImageCache
type CreateImageCacheResponse struct {
	*responses.BaseResponse
	RequestId        string `json:"RequestId" xml:"RequestId"`
	ImageCacheId     string `json:"ImageCacheId" xml:"ImageCacheId"`
	ContainerGroupId string `json:"ContainerGroupId" xml:"ContainerGroupId"`
}

// CreateCreateImageCacheRequest creates a request to invoke CreateImageCache API
func CreateCreateImageCacheRequest() (request *CreateImageCacheRequest) {
	request = &CreateImageCacheRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Eci", "2018-08-08", "CreateImageCache", "eci", "openAPI")
	return
}

// CreateCreateImageCacheResponse creates a response to parse from CreateImageCache response
func CreateCreateImageCacheResponse() (response *CreateImageCacheResponse) {
	response = &CreateImageCacheResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
