package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRole invokes the eas.DescribeRole API synchronously
func (client *Client) DescribeRole(request *DescribeRoleRequest) (response *DescribeRoleResponse, err error) {
	response = CreateDescribeRoleResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRoleWithChan invokes the eas.DescribeRole API asynchronously
func (client *Client) DescribeRoleWithChan(request *DescribeRoleRequest) (<-chan *DescribeRoleResponse, <-chan error) {
	responseChan := make(chan *DescribeRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRoleWithCallback invokes the eas.DescribeRole API asynchronously
func (client *Client) DescribeRoleWithCallback(request *DescribeRoleRequest, callback func(response *DescribeRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRoleResponse
		var err error
		defer close(result)
		response, err = client.DescribeRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRoleRequest is the request struct for api DescribeRole
type DescribeRoleRequest struct {
	*requests.RoaRequest
}

// DescribeRoleResponse is the response struct for api DescribeRole
type DescribeRoleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Exist     bool   `json:"Exist" xml:"Exist"`
}

// CreateDescribeRoleRequest creates a request to invoke DescribeRole API
func CreateDescribeRoleRequest() (request *DescribeRoleRequest) {
	request = &DescribeRoleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2021-07-01", "DescribeRole", "/api/v2/role", "eas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeRoleResponse creates a response to parse from DescribeRole response
func CreateDescribeRoleResponse() (response *DescribeRoleResponse) {
	response = &DescribeRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
