package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDrdsSqlAuditStatus invokes the drds.DescribeDrdsSqlAuditStatus API synchronously
func (client *Client) DescribeDrdsSqlAuditStatus(request *DescribeDrdsSqlAuditStatusRequest) (response *DescribeDrdsSqlAuditStatusResponse, err error) {
	response = CreateDescribeDrdsSqlAuditStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDrdsSqlAuditStatusWithChan invokes the drds.DescribeDrdsSqlAuditStatus API asynchronously
func (client *Client) DescribeDrdsSqlAuditStatusWithChan(request *DescribeDrdsSqlAuditStatusRequest) (<-chan *DescribeDrdsSqlAuditStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeDrdsSqlAuditStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDrdsSqlAuditStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDrdsSqlAuditStatusWithCallback invokes the drds.DescribeDrdsSqlAuditStatus API asynchronously
func (client *Client) DescribeDrdsSqlAuditStatusWithCallback(request *DescribeDrdsSqlAuditStatusRequest, callback func(response *DescribeDrdsSqlAuditStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDrdsSqlAuditStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeDrdsSqlAuditStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDrdsSqlAuditStatusRequest is the request struct for api DescribeDrdsSqlAuditStatus
type DescribeDrdsSqlAuditStatusRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
}

// DescribeDrdsSqlAuditStatusResponse is the response struct for api DescribeDrdsSqlAuditStatus
type DescribeDrdsSqlAuditStatusResponse struct {
	*responses.BaseResponse
	RequestId string                           `json:"RequestId" xml:"RequestId"`
	Success   bool                             `json:"Success" xml:"Success"`
	Data      DataInDescribeDrdsSqlAuditStatus `json:"Data" xml:"Data"`
}

// CreateDescribeDrdsSqlAuditStatusRequest creates a request to invoke DescribeDrdsSqlAuditStatus API
func CreateDescribeDrdsSqlAuditStatusRequest() (request *DescribeDrdsSqlAuditStatusRequest) {
	request = &DescribeDrdsSqlAuditStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DescribeDrdsSqlAuditStatus", "drds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDrdsSqlAuditStatusResponse creates a response to parse from DescribeDrdsSqlAuditStatus response
func CreateDescribeDrdsSqlAuditStatusResponse() (response *DescribeDrdsSqlAuditStatusResponse) {
	response = &DescribeDrdsSqlAuditStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
