package cusanalytic_sc_online

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPortrayal invokes the cusanalytic_sc_online.GetPortrayal API synchronously
// api document: https://help.aliyun.com/api/cusanalytic_sc_online/getportrayal.html
func (client *Client) GetPortrayal(request *GetPortrayalRequest) (response *GetPortrayalResponse, err error) {
	response = CreateGetPortrayalResponse()
	err = client.DoAction(request, response)
	return
}

// GetPortrayalWithChan invokes the cusanalytic_sc_online.GetPortrayal API asynchronously
// api document: https://help.aliyun.com/api/cusanalytic_sc_online/getportrayal.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPortrayalWithChan(request *GetPortrayalRequest) (<-chan *GetPortrayalResponse, <-chan error) {
	responseChan := make(chan *GetPortrayalResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPortrayal(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPortrayalWithCallback invokes the cusanalytic_sc_online.GetPortrayal API asynchronously
// api document: https://help.aliyun.com/api/cusanalytic_sc_online/getportrayal.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPortrayalWithCallback(request *GetPortrayalRequest, callback func(response *GetPortrayalResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPortrayalResponse
		var err error
		defer close(result)
		response, err = client.GetPortrayal(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPortrayalRequest is the request struct for api GetPortrayal
type GetPortrayalRequest struct {
	*requests.RpcRequest
	Date        string `position:"Body" name:"Date"`
	LocationIds string `position:"Body" name:"LocationIds"`
	StoreIds    string `position:"Body" name:"StoreIds"`
}

// GetPortrayalResponse is the response struct for api GetPortrayal
type GetPortrayalResponse struct {
	*responses.BaseResponse
	FemalePercent       float64 `json:"FemalePercent" xml:"FemalePercent"`
	Mcount              int64   `json:"Mcount" xml:"Mcount"`
	Mcount1120          int64   `json:"Mcount1120" xml:"Mcount1120"`
	Newcount            int64   `json:"Newcount" xml:"Newcount"`
	Agecount3140Percent float64 `json:"Agecount3140Percent" xml:"Agecount3140Percent"`
	Agecount4150Percent float64 `json:"Agecount4150Percent" xml:"Agecount4150Percent"`
	Agecount010Percent  float64 `json:"Agecount010Percent" xml:"Agecount010Percent"`
	Fcount5160          int64   `json:"Fcount5160" xml:"Fcount5160"`
	Mcount010           int64   `json:"Mcount010" xml:"Mcount010"`
	Mcountgt60          int64   `json:"Mcountgt60" xml:"Mcountgt60"`
	Agecount1120Percent float64 `json:"Agecount1120Percent" xml:"Agecount1120Percent"`
	Fcountgt60          int64   `json:"Fcountgt60" xml:"Fcountgt60"`
	Fcount4150          int64   `json:"Fcount4150" xml:"Fcount4150"`
	Oldcount            int64   `json:"Oldcount" xml:"Oldcount"`
	Fcount3140          int64   `json:"Fcount3140" xml:"Fcount3140"`
	Fcount2130          int64   `json:"Fcount2130" xml:"Fcount2130"`
	Agecountgt60Percent float64 `json:"Agecountgt60Percent" xml:"Agecountgt60Percent"`
	Fcount1120          int64   `json:"Fcount1120" xml:"Fcount1120"`
	OldcountPercent     float64 `json:"OldcountPercent" xml:"OldcountPercent"`
	Mcount4150          int64   `json:"Mcount4150" xml:"Mcount4150"`
	Fcount              int64   `json:"Fcount" xml:"Fcount"`
	NewcountPercent     float64 `json:"NewcountPercent" xml:"NewcountPercent"`
	Mcount2130          int64   `json:"Mcount2130" xml:"Mcount2130"`
	Mcount3140          int64   `json:"Mcount3140" xml:"Mcount3140"`
	Agecount5160Percent float64 `json:"Agecount5160Percent" xml:"Agecount5160Percent"`
	Agecount2130Percent float64 `json:"Agecount2130Percent" xml:"Agecount2130Percent"`
	Fcount010           int64   `json:"Fcount010" xml:"Fcount010"`
	Mcount5160          int64   `json:"Mcount5160" xml:"Mcount5160"`
	MalePercent         float64 `json:"MalePercent" xml:"MalePercent"`
}

// CreateGetPortrayalRequest creates a request to invoke GetPortrayal API
func CreateGetPortrayalRequest() (request *GetPortrayalRequest) {
	request = &GetPortrayalRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cusanalytic_sc_online", "2019-05-24", "GetPortrayal", "", "")
	return
}

// CreateGetPortrayalResponse creates a response to parse from GetPortrayal response
func CreateGetPortrayalResponse() (response *GetPortrayalResponse) {
	response = &GetPortrayalResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
