package crm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddLabelForBid invokes the crm.AddLabelForBid API synchronously
// api document: https://help.aliyun.com/api/crm/addlabelforbid.html
func (client *Client) AddLabelForBid(request *AddLabelForBidRequest) (response *AddLabelForBidResponse, err error) {
	response = CreateAddLabelForBidResponse()
	err = client.DoAction(request, response)
	return
}

// AddLabelForBidWithChan invokes the crm.AddLabelForBid API asynchronously
// api document: https://help.aliyun.com/api/crm/addlabelforbid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddLabelForBidWithChan(request *AddLabelForBidRequest) (<-chan *AddLabelForBidResponse, <-chan error) {
	responseChan := make(chan *AddLabelForBidResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddLabelForBid(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddLabelForBidWithCallback invokes the crm.AddLabelForBid API asynchronously
// api document: https://help.aliyun.com/api/crm/addlabelforbid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddLabelForBidWithCallback(request *AddLabelForBidRequest, callback func(response *AddLabelForBidResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddLabelForBidResponse
		var err error
		defer close(result)
		response, err = client.AddLabelForBid(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddLabelForBidRequest is the request struct for api AddLabelForBid
type AddLabelForBidRequest struct {
	*requests.RpcRequest
	LabelSeries string `position:"Query" name:"LabelSeries"`
	EndTime     string `position:"Query" name:"EndTime"`
	PK          string `position:"Query" name:"PK"`
	Label       string `position:"Query" name:"Label"`
}

// AddLabelForBidResponse is the response struct for api AddLabelForBid
type AddLabelForBidResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateAddLabelForBidRequest creates a request to invoke AddLabelForBid API
func CreateAddLabelForBidRequest() (request *AddLabelForBidRequest) {
	request = &AddLabelForBidRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Crm", "2015-04-08", "AddLabelForBid", "crm", "openAPI")
	return
}

// CreateAddLabelForBidResponse creates a response to parse from AddLabelForBid response
func CreateAddLabelForBidResponse() (response *AddLabelForBidResponse) {
	response = &AddLabelForBidResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
