package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRepoTag invokes the cr.GetRepoTag API synchronously
func (client *Client) GetRepoTag(request *GetRepoTagRequest) (response *GetRepoTagResponse, err error) {
	response = CreateGetRepoTagResponse()
	err = client.DoAction(request, response)
	return
}

// GetRepoTagWithChan invokes the cr.GetRepoTag API asynchronously
func (client *Client) GetRepoTagWithChan(request *GetRepoTagRequest) (<-chan *GetRepoTagResponse, <-chan error) {
	responseChan := make(chan *GetRepoTagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRepoTag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRepoTagWithCallback invokes the cr.GetRepoTag API asynchronously
func (client *Client) GetRepoTagWithCallback(request *GetRepoTagRequest, callback func(response *GetRepoTagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRepoTagResponse
		var err error
		defer close(result)
		response, err = client.GetRepoTag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRepoTagRequest is the request struct for api GetRepoTag
type GetRepoTagRequest struct {
	*requests.RoaRequest
	RepoNamespace string `position:"Path" name:"RepoNamespace"`
	RepoName      string `position:"Path" name:"RepoName"`
	Tag           string `position:"Path" name:"Tag"`
}

// GetRepoTagResponse is the response struct for api GetRepoTag
type GetRepoTagResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"requestId" xml:"requestId"`
	Status      string `json:"status" xml:"status"`
	Tag         string `json:"tag" xml:"tag"`
	Digest      string `json:"digest" xml:"digest"`
	ImageId     string `json:"imageId" xml:"imageId"`
	ImageCreate int64  `json:"imageCreate" xml:"imageCreate"`
	ImageUpdate int64  `json:"imageUpdate" xml:"imageUpdate"`
	ImageSize   int64  `json:"imageSize" xml:"imageSize"`
}

// CreateGetRepoTagRequest creates a request to invoke GetRepoTag API
func CreateGetRepoTagRequest() (request *GetRepoTagRequest) {
	request = &GetRepoTagRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "GetRepoTag", "/repos/[RepoNamespace]/[RepoName]/tags/[Tag]", "acr", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetRepoTagResponse creates a response to parse from GetRepoTag response
func CreateGetRepoTagResponse() (response *GetRepoTagResponse) {
	response = &GetRepoTagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
