package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetGroupApRadioConfigTemplate invokes the cloudwf.GetGroupApRadioConfigTemplate API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getgroupapradioconfigtemplate.html
func (client *Client) GetGroupApRadioConfigTemplate(request *GetGroupApRadioConfigTemplateRequest) (response *GetGroupApRadioConfigTemplateResponse, err error) {
	response = CreateGetGroupApRadioConfigTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// GetGroupApRadioConfigTemplateWithChan invokes the cloudwf.GetGroupApRadioConfigTemplate API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getgroupapradioconfigtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetGroupApRadioConfigTemplateWithChan(request *GetGroupApRadioConfigTemplateRequest) (<-chan *GetGroupApRadioConfigTemplateResponse, <-chan error) {
	responseChan := make(chan *GetGroupApRadioConfigTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetGroupApRadioConfigTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetGroupApRadioConfigTemplateWithCallback invokes the cloudwf.GetGroupApRadioConfigTemplate API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getgroupapradioconfigtemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetGroupApRadioConfigTemplateWithCallback(request *GetGroupApRadioConfigTemplateRequest, callback func(response *GetGroupApRadioConfigTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetGroupApRadioConfigTemplateResponse
		var err error
		defer close(result)
		response, err = client.GetGroupApRadioConfigTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetGroupApRadioConfigTemplateRequest is the request struct for api GetGroupApRadioConfigTemplate
type GetGroupApRadioConfigTemplateRequest struct {
	*requests.RpcRequest
}

// GetGroupApRadioConfigTemplateResponse is the response struct for api GetGroupApRadioConfigTemplate
type GetGroupApRadioConfigTemplateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetGroupApRadioConfigTemplateRequest creates a request to invoke GetGroupApRadioConfigTemplate API
func CreateGetGroupApRadioConfigTemplateRequest() (request *GetGroupApRadioConfigTemplateRequest) {
	request = &GetGroupApRadioConfigTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetGroupApRadioConfigTemplate", "cloudwf", "openAPI")
	return
}

// CreateGetGroupApRadioConfigTemplateResponse creates a response to parse from GetGroupApRadioConfigTemplate response
func CreateGetGroupApRadioConfigTemplateResponse() (response *GetGroupApRadioConfigTemplateResponse) {
	response = &GetGroupApRadioConfigTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
