package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteApgroupSsidConfig invokes the cloudwf.DeleteApgroupSsidConfig API synchronously
// api document: https://help.aliyun.com/api/cloudwf/deleteapgroupssidconfig.html
func (client *Client) DeleteApgroupSsidConfig(request *DeleteApgroupSsidConfigRequest) (response *DeleteApgroupSsidConfigResponse, err error) {
	response = CreateDeleteApgroupSsidConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteApgroupSsidConfigWithChan invokes the cloudwf.DeleteApgroupSsidConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/deleteapgroupssidconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteApgroupSsidConfigWithChan(request *DeleteApgroupSsidConfigRequest) (<-chan *DeleteApgroupSsidConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteApgroupSsidConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteApgroupSsidConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteApgroupSsidConfigWithCallback invokes the cloudwf.DeleteApgroupSsidConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/deleteapgroupssidconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteApgroupSsidConfigWithCallback(request *DeleteApgroupSsidConfigRequest, callback func(response *DeleteApgroupSsidConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteApgroupSsidConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteApgroupSsidConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteApgroupSsidConfigRequest is the request struct for api DeleteApgroupSsidConfig
type DeleteApgroupSsidConfigRequest struct {
	*requests.RpcRequest
	ApgroupId requests.Integer `position:"Query" name:"ApgroupId"`
	Id        requests.Integer `position:"Query" name:"Id"`
}

// DeleteApgroupSsidConfigResponse is the response struct for api DeleteApgroupSsidConfig
type DeleteApgroupSsidConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateDeleteApgroupSsidConfigRequest creates a request to invoke DeleteApgroupSsidConfig API
func CreateDeleteApgroupSsidConfigRequest() (request *DeleteApgroupSsidConfigRequest) {
	request = &DeleteApgroupSsidConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "DeleteApgroupSsidConfig", "cloudwf", "openAPI")
	return
}

// CreateDeleteApgroupSsidConfigResponse creates a response to parse from DeleteApgroupSsidConfig response
func CreateDeleteApgroupSsidConfigResponse() (response *DeleteApgroupSsidConfigResponse) {
	response = &DeleteApgroupSsidConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
