package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPerformanceSummary invokes the cloudcallcenter.ListPerformanceSummary API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listperformancesummary.html
func (client *Client) ListPerformanceSummary(request *ListPerformanceSummaryRequest) (response *ListPerformanceSummaryResponse, err error) {
	response = CreateListPerformanceSummaryResponse()
	err = client.DoAction(request, response)
	return
}

// ListPerformanceSummaryWithChan invokes the cloudcallcenter.ListPerformanceSummary API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listperformancesummary.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPerformanceSummaryWithChan(request *ListPerformanceSummaryRequest) (<-chan *ListPerformanceSummaryResponse, <-chan error) {
	responseChan := make(chan *ListPerformanceSummaryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPerformanceSummary(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPerformanceSummaryWithCallback invokes the cloudcallcenter.ListPerformanceSummary API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listperformancesummary.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListPerformanceSummaryWithCallback(request *ListPerformanceSummaryRequest, callback func(response *ListPerformanceSummaryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPerformanceSummaryResponse
		var err error
		defer close(result)
		response, err = client.ListPerformanceSummary(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPerformanceSummaryRequest is the request struct for api ListPerformanceSummary
type ListPerformanceSummaryRequest struct {
	*requests.RpcRequest
	InstanceId    string           `position:"Query" name:"InstanceId"`
	PhoneNumberId string           `position:"Query" name:"PhoneNumberId"`
	StartTime     requests.Integer `position:"Query" name:"StartTime"`
	StopTime      requests.Integer `position:"Query" name:"StopTime"`
}

// ListPerformanceSummaryResponse is the response struct for api ListPerformanceSummary
type ListPerformanceSummaryResponse struct {
	*responses.BaseResponse
	RequestId      string                         `json:"RequestId" xml:"RequestId"`
	Success        bool                           `json:"Success" xml:"Success"`
	Code           string                         `json:"Code" xml:"Code"`
	Message        string                         `json:"Message" xml:"Message"`
	HttpStatusCode int                            `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Report         ReportInListPerformanceSummary `json:"Report" xml:"Report"`
}

// CreateListPerformanceSummaryRequest creates a request to invoke ListPerformanceSummary API
func CreateListPerformanceSummaryRequest() (request *ListPerformanceSummaryRequest) {
	request = &ListPerformanceSummaryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListPerformanceSummary", "", "")
	request.Method = requests.POST
	return
}

// CreateListPerformanceSummaryResponse creates a response to parse from ListPerformanceSummary response
func CreateListPerformanceSummaryResponse() (response *ListPerformanceSummaryResponse) {
	response = &ListPerformanceSummaryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
