package afs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigurationStyle invokes the afs.ConfigurationStyle API synchronously
// api document: https://help.aliyun.com/api/afs/configurationstyle.html
func (client *Client) ConfigurationStyle(request *ConfigurationStyleRequest) (response *ConfigurationStyleResponse, err error) {
	response = CreateConfigurationStyleResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigurationStyleWithChan invokes the afs.ConfigurationStyle API asynchronously
// api document: https://help.aliyun.com/api/afs/configurationstyle.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConfigurationStyleWithChan(request *ConfigurationStyleRequest) (<-chan *ConfigurationStyleResponse, <-chan error) {
	responseChan := make(chan *ConfigurationStyleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigurationStyle(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigurationStyleWithCallback invokes the afs.ConfigurationStyle API asynchronously
// api document: https://help.aliyun.com/api/afs/configurationstyle.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConfigurationStyleWithCallback(request *ConfigurationStyleRequest, callback func(response *ConfigurationStyleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigurationStyleResponse
		var err error
		defer close(result)
		response, err = client.ConfigurationStyle(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigurationStyleRequest is the request struct for api ConfigurationStyle
type ConfigurationStyleRequest struct {
	*requests.RpcRequest
	SourceIp            string `position:"Query" name:"SourceIp"`
	ConfigurationMethod string `position:"Query" name:"ConfigurationMethod"`
	RefExtId            string `position:"Query" name:"RefExtId"`
	ApplyType           string `position:"Query" name:"ApplyType"`
	Scene               string `position:"Query" name:"Scene"`
}

// ConfigurationStyleResponse is the response struct for api ConfigurationStyle
type ConfigurationStyleResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	BizCode   string   `json:"BizCode" xml:"BizCode"`
	CodeData  CodeData `json:"CodeData" xml:"CodeData"`
}

// CreateConfigurationStyleRequest creates a request to invoke ConfigurationStyle API
func CreateConfigurationStyleRequest() (request *ConfigurationStyleRequest) {
	request = &ConfigurationStyleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("afs", "2018-01-12", "ConfigurationStyle", "afs", "openAPI")
	return
}

// CreateConfigurationStyleResponse creates a response to parse from ConfigurationStyle response
func CreateConfigurationStyleResponse() (response *ConfigurationStyleResponse) {
	response = &ConfigurationStyleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
