//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfoundationversionwithfilemanagerresourceforksupport?language=objc)
pub const NSFoundationVersionWithFileManagerResourceForkSupport: c_uint = 412;
/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfileattributekey?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
#[cfg(feature = "NSString")]
pub type NSFileAttributeKey = NSString;

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfileattributetype?language=objc)
// NS_TYPED_ENUM
#[cfg(feature = "NSString")]
pub type NSFileAttributeType = NSString;

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfileprotectiontype?language=objc)
// NS_TYPED_ENUM
#[cfg(feature = "NSString")]
pub type NSFileProtectionType = NSString;

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfileproviderservicename?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
#[cfg(feature = "NSString")]
pub type NSFileProviderServiceName = NSString;

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsvolumeenumerationoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSVolumeEnumerationOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSVolumeEnumerationOptions: NSUInteger {
        #[doc(alias = "NSVolumeEnumerationSkipHiddenVolumes")]
        const SkipHiddenVolumes = 1<<1;
        #[doc(alias = "NSVolumeEnumerationProduceFileReferenceURLs")]
        const ProduceFileReferenceURLs = 1<<2;
    }
}

unsafe impl Encode for NSVolumeEnumerationOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSVolumeEnumerationOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsdirectoryenumerationoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSDirectoryEnumerationOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSDirectoryEnumerationOptions: NSUInteger {
        #[doc(alias = "NSDirectoryEnumerationSkipsSubdirectoryDescendants")]
        const SkipsSubdirectoryDescendants = 1<<0;
        #[doc(alias = "NSDirectoryEnumerationSkipsPackageDescendants")]
        const SkipsPackageDescendants = 1<<1;
        #[doc(alias = "NSDirectoryEnumerationSkipsHiddenFiles")]
        const SkipsHiddenFiles = 1<<2;
        #[doc(alias = "NSDirectoryEnumerationIncludesDirectoriesPostOrder")]
        const IncludesDirectoriesPostOrder = 1<<3;
        #[doc(alias = "NSDirectoryEnumerationProducesRelativePathURLs")]
        const ProducesRelativePathURLs = 1<<4;
    }
}

unsafe impl Encode for NSDirectoryEnumerationOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSDirectoryEnumerationOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilemanageritemreplacementoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSFileManagerItemReplacementOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSFileManagerItemReplacementOptions: NSUInteger {
        #[doc(alias = "NSFileManagerItemReplacementUsingNewMetadataOnly")]
        const UsingNewMetadataOnly = 1<<0;
        #[doc(alias = "NSFileManagerItemReplacementWithoutDeletingBackupItem")]
        const WithoutDeletingBackupItem = 1<<1;
    }
}

unsafe impl Encode for NSFileManagerItemReplacementOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSFileManagerItemReplacementOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsurlrelationship?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSURLRelationship(pub NSInteger);
impl NSURLRelationship {
    #[doc(alias = "NSURLRelationshipContains")]
    pub const Contains: Self = Self(0);
    #[doc(alias = "NSURLRelationshipSame")]
    pub const Same: Self = Self(1);
    #[doc(alias = "NSURLRelationshipOther")]
    pub const Other: Self = Self(2);
}

unsafe impl Encode for NSURLRelationship {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSURLRelationship {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilemanagerunmountoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSFileManagerUnmountOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSFileManagerUnmountOptions: NSUInteger {
        #[doc(alias = "NSFileManagerUnmountAllPartitionsAndEjectDisk")]
        const AllPartitionsAndEjectDisk = 1<<0;
        #[doc(alias = "NSFileManagerUnmountWithoutUI")]
        const WithoutUI = 1<<1;
    }
}

unsafe impl Encode for NSFileManagerUnmountOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSFileManagerUnmountOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilemanagerunmountdissentingprocessidentifiererrorkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileManagerUnmountDissentingProcessIdentifierErrorKey: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsubiquityidentitydidchangenotification?language=objc)
    #[cfg(all(feature = "NSNotification", feature = "NSString"))]
    pub static NSUbiquityIdentityDidChangeNotification: &'static NSNotificationName;
}

/// An option set of the sync controls available for an item.
///
/// Get an instance of this type by calling ``URL/resourceValues(forKeys:)`` on a ``URL`` instance (Swift) or ``NSURL/getResourceValue:forKey:error:`` on an ``NSURL`` (Swift or Objective-C) and passing in the key ``NSURLUbiquitousItemSupportedSyncControlsKey``.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilemanagersupportedsynccontrols?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSFileManagerSupportedSyncControls(pub NSUInteger);
bitflags::bitflags! {
    impl NSFileManagerSupportedSyncControls: NSUInteger {
/// The file provider supports pausing the sync on the item.
        #[doc(alias = "NSFileManagerSupportedSyncControlsPauseSync")]
        const PauseSync = 1<<0;
/// The file provider supports failing an upload if the local and server versions conflict.
        #[doc(alias = "NSFileManagerSupportedSyncControlsFailUploadOnConflict")]
        const FailUploadOnConflict = 1<<1;
    }
}

unsafe impl Encode for NSFileManagerSupportedSyncControls {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSFileManagerSupportedSyncControls {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The behaviors the file manager can apply to resolve conflicts when resuming a sync.
///
/// You use this type when calling ``FileManager/resumeSyncForUbiquitousItem(at:with:completionHandler:)`` to resume synchronizing.
/// In most situations, the ``NSFileManagerResumeSyncBehavior/preserveLocalChanges`` behavior is the best choice to avoid risk of data loss.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilemanagerresumesyncbehavior?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSFileManagerResumeSyncBehavior(pub NSInteger);
impl NSFileManagerResumeSyncBehavior {
    /// Resumes synchronizing by uploading the local version of the file.
    ///
    /// If the server has a newer version, the server may create a conflict copy of the file, or may automatically pick the winner of the conflict.
    /// Apps can choose to implement conflict handling themselves by passing `NSFileManagerResumeSyncBehaviorAfterUploadWithFailOnConflict`.
    #[doc(alias = "NSFileManagerResumeSyncBehaviorPreserveLocalChanges")]
    pub const PreserveLocalChanges: Self = Self(0);
    /// Resumes sync by first uploading the local version of the file, failing if the provider detects a conflict.
    ///
    /// If the upload succeeds, the sync resumes with the ``preserveLocalChanges`` behavior.
    ///
    /// If the provider detects a conflict, the upload fails with an  ``NSFileWriteUnknownError-enum.case``, with the underlying error of
    /// <doc
    /// ://com.apple.documentation/documentation/FileProvider/NSFileProviderError/localVersionConflictingWithServer>.
    /// In this case, the app needs to call ``FileManager/fetchLatestRemoteVersionOfItem(at:completionHandler:)``, rebase local changes on top of the newly fetched version to resolve the conflict, and try again to resume sync.
    /// This scenario is only available on paused items for which the file provider supports the fail-on-conflict behavior.
    /// To check that the file provider supports the behavior, get the ``NSURLUbiquitousItemSupportedSyncControlsKey`` URL resource and verify that ``NSFileManagerSupportedSyncControls/failUploadOnConflict`` is `true`.
    #[doc(alias = "NSFileManagerResumeSyncBehaviorAfterUploadWithFailOnConflict")]
    pub const AfterUploadWithFailOnConflict: Self = Self(1);
    /// Resumes synchronizing by overwriting any local changes with the remote version of the file.
    ///
    /// If a conflict occurs, the file manager stores the local changes as an alternate version.
    /// Only use this behavior if you provide a separate means of resolving and merging conflicts.
    #[doc(alias = "NSFileManagerResumeSyncBehaviorDropLocalChanges")]
    pub const DropLocalChanges: Self = Self(2);
}

unsafe impl Encode for NSFileManagerResumeSyncBehavior {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSFileManagerResumeSyncBehavior {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The policies the file manager can apply to resolve conflicts when uploading a local version of a file.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilemanageruploadlocalversionconflictpolicy?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSFileManagerUploadLocalVersionConflictPolicy(pub NSInteger);
impl NSFileManagerUploadLocalVersionConflictPolicy {
    /// Resolves the conflict using the policy defined by the file provider.
    #[doc(alias = "NSFileManagerUploadConflictPolicyDefault")]
    pub const ConflictPolicyDefault: Self = Self(0);
    /// Resolves the conflict by causing the upload to fail.
    ///
    /// This policy causes an upload to fail if the local version of a file, with any local changes applied, doesn't match the server version.
    /// In this scenario, call ``FileManager/fetchLatestRemoteVersionOfItem(at:completionHandler:)``, rebase local changes on top of the newly fetched version, and retry the upload.
    ///
    /// This policy is only available on paused items for which the file provider supports the fail-on-conflict behavior.
    /// To check that the file provider supports the behavior, get the ``NSURLUbiquitousItemSupportedSyncControlsKey`` URL resource and verify that ``NSFileManagerSupportedSyncControls/failUploadOnConflict`` is `true`.
    #[doc(alias = "NSFileManagerUploadConflictPolicyFailOnConflict")]
    pub const ConflictPolicyFailOnConflict: Self = Self(1);
}

unsafe impl Encode for NSFileManagerUploadLocalVersionConflictPolicy {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSFileManagerUploadLocalVersionConflictPolicy {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilemanager?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSFileManager;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSFileManager {}
);

impl NSFileManager {
    extern_methods!(
        #[unsafe(method(defaultManager))]
        #[unsafe(method_family = none)]
        pub fn defaultManager() -> Retained<NSFileManager>;

        #[cfg(all(feature = "NSArray", feature = "NSString", feature = "NSURL"))]
        #[unsafe(method(mountedVolumeURLsIncludingResourceValuesForKeys:options:))]
        #[unsafe(method_family = none)]
        pub fn mountedVolumeURLsIncludingResourceValuesForKeys_options(
            &self,
            property_keys: Option<&NSArray<NSURLResourceKey>>,
            options: NSVolumeEnumerationOptions,
        ) -> Option<Retained<NSArray<NSURL>>>;

        #[cfg(all(feature = "NSError", feature = "NSURL", feature = "block2"))]
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(unmountVolumeAtURL:options:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn unmountVolumeAtURL_options_completionHandler(
            &self,
            url: &NSURL,
            mask: NSFileManagerUnmountOptions,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(all(
            feature = "NSArray",
            feature = "NSError",
            feature = "NSString",
            feature = "NSURL"
        ))]
        #[unsafe(method(contentsOfDirectoryAtURL:includingPropertiesForKeys:options:error:_))]
        #[unsafe(method_family = none)]
        pub fn contentsOfDirectoryAtURL_includingPropertiesForKeys_options_error(
            &self,
            url: &NSURL,
            keys: Option<&NSArray<NSURLResourceKey>>,
            mask: NSDirectoryEnumerationOptions,
        ) -> Result<Retained<NSArray<NSURL>>, Retained<NSError>>;

        #[cfg(all(feature = "NSArray", feature = "NSPathUtilities", feature = "NSURL"))]
        #[unsafe(method(URLsForDirectory:inDomains:))]
        #[unsafe(method_family = none)]
        pub fn URLsForDirectory_inDomains(
            &self,
            directory: NSSearchPathDirectory,
            domain_mask: NSSearchPathDomainMask,
        ) -> Retained<NSArray<NSURL>>;

        #[cfg(all(feature = "NSError", feature = "NSPathUtilities", feature = "NSURL"))]
        #[unsafe(method(URLForDirectory:inDomain:appropriateForURL:create:error:_))]
        #[unsafe(method_family = none)]
        pub fn URLForDirectory_inDomain_appropriateForURL_create_error(
            &self,
            directory: NSSearchPathDirectory,
            domain: NSSearchPathDomainMask,
            url: Option<&NSURL>,
            should_create: bool,
        ) -> Result<Retained<NSURL>, Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        /// # Safety
        ///
        /// `out_relationship` must be a valid pointer.
        #[unsafe(method(getRelationship:ofDirectoryAtURL:toItemAtURL:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn getRelationship_ofDirectoryAtURL_toItemAtURL_error(
            &self,
            out_relationship: NonNull<NSURLRelationship>,
            directory_url: &NSURL,
            other_url: &NSURL,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSPathUtilities", feature = "NSURL"))]
        /// # Safety
        ///
        /// `out_relationship` must be a valid pointer.
        #[unsafe(method(getRelationship:ofDirectory:inDomain:toItemAtURL:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn getRelationship_ofDirectory_inDomain_toItemAtURL_error(
            &self,
            out_relationship: NonNull<NSURLRelationship>,
            directory: NSSearchPathDirectory,
            domain_mask: NSSearchPathDomainMask,
            url: &NSURL,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(
            feature = "NSDictionary",
            feature = "NSError",
            feature = "NSString",
            feature = "NSURL"
        ))]
        /// # Safety
        ///
        /// `attributes` generic should be of the correct type.
        #[unsafe(method(createDirectoryAtURL:withIntermediateDirectories:attributes:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn createDirectoryAtURL_withIntermediateDirectories_attributes_error(
            &self,
            url: &NSURL,
            create_intermediates: bool,
            attributes: Option<&NSDictionary<NSFileAttributeKey, AnyObject>>,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(createSymbolicLinkAtURL:withDestinationURL:error:_))]
        #[unsafe(method_family = none)]
        pub fn createSymbolicLinkAtURL_withDestinationURL_error(
            &self,
            url: &NSURL,
            dest_url: &NSURL,
        ) -> Result<(), Retained<NSError>>;

        /// # Safety
        ///
        /// This is not retained internally, you must ensure the object is still alive.
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn NSFileManagerDelegate>>>;

        /// Setter for [`delegate`][Self::delegate].
        ///
        /// # Safety
        ///
        /// This is unretained, you must ensure the object is kept alive while in use.
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn NSFileManagerDelegate>>,
        );

        #[cfg(all(feature = "NSDictionary", feature = "NSError", feature = "NSString"))]
        /// # Safety
        ///
        /// `attributes` generic should be of the correct type.
        #[unsafe(method(setAttributes:ofItemAtPath:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAttributes_ofItemAtPath_error(
            &self,
            attributes: &NSDictionary<NSFileAttributeKey, AnyObject>,
            path: &NSString,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "NSDictionary", feature = "NSError", feature = "NSString"))]
        /// # Safety
        ///
        /// `attributes` generic should be of the correct type.
        #[unsafe(method(createDirectoryAtPath:withIntermediateDirectories:attributes:error:_))]
        #[unsafe(method_family = none)]
        pub unsafe fn createDirectoryAtPath_withIntermediateDirectories_attributes_error(
            &self,
            path: &NSString,
            create_intermediates: bool,
            attributes: Option<&NSDictionary<NSFileAttributeKey, AnyObject>>,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "NSArray", feature = "NSError", feature = "NSString"))]
        #[unsafe(method(contentsOfDirectoryAtPath:error:_))]
        #[unsafe(method_family = none)]
        pub fn contentsOfDirectoryAtPath_error(
            &self,
            path: &NSString,
        ) -> Result<Retained<NSArray<NSString>>, Retained<NSError>>;

        #[cfg(all(feature = "NSArray", feature = "NSError", feature = "NSString"))]
        #[unsafe(method(subpathsOfDirectoryAtPath:error:_))]
        #[unsafe(method_family = none)]
        pub fn subpathsOfDirectoryAtPath_error(
            &self,
            path: &NSString,
        ) -> Result<Retained<NSArray<NSString>>, Retained<NSError>>;

        #[cfg(all(feature = "NSDictionary", feature = "NSError", feature = "NSString"))]
        #[unsafe(method(attributesOfItemAtPath:error:_))]
        #[unsafe(method_family = none)]
        pub fn attributesOfItemAtPath_error(
            &self,
            path: &NSString,
        ) -> Result<Retained<NSDictionary<NSFileAttributeKey, AnyObject>>, Retained<NSError>>;

        #[cfg(all(feature = "NSDictionary", feature = "NSError", feature = "NSString"))]
        #[unsafe(method(attributesOfFileSystemForPath:error:_))]
        #[unsafe(method_family = none)]
        pub fn attributesOfFileSystemForPath_error(
            &self,
            path: &NSString,
        ) -> Result<Retained<NSDictionary<NSFileAttributeKey, AnyObject>>, Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSString"))]
        #[unsafe(method(createSymbolicLinkAtPath:withDestinationPath:error:_))]
        #[unsafe(method_family = none)]
        pub fn createSymbolicLinkAtPath_withDestinationPath_error(
            &self,
            path: &NSString,
            dest_path: &NSString,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSString"))]
        #[unsafe(method(destinationOfSymbolicLinkAtPath:error:_))]
        #[unsafe(method_family = none)]
        pub fn destinationOfSymbolicLinkAtPath_error(
            &self,
            path: &NSString,
        ) -> Result<Retained<NSString>, Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSString"))]
        #[unsafe(method(copyItemAtPath:toPath:error:_))]
        #[unsafe(method_family = none)]
        pub fn copyItemAtPath_toPath_error(
            &self,
            src_path: &NSString,
            dst_path: &NSString,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSString"))]
        #[unsafe(method(moveItemAtPath:toPath:error:_))]
        #[unsafe(method_family = none)]
        pub fn moveItemAtPath_toPath_error(
            &self,
            src_path: &NSString,
            dst_path: &NSString,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSString"))]
        #[unsafe(method(linkItemAtPath:toPath:error:_))]
        #[unsafe(method_family = none)]
        pub fn linkItemAtPath_toPath_error(
            &self,
            src_path: &NSString,
            dst_path: &NSString,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSString"))]
        #[unsafe(method(removeItemAtPath:error:_))]
        #[unsafe(method_family = none)]
        pub fn removeItemAtPath_error(&self, path: &NSString) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(copyItemAtURL:toURL:error:_))]
        #[unsafe(method_family = none)]
        pub fn copyItemAtURL_toURL_error(
            &self,
            src_url: &NSURL,
            dst_url: &NSURL,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(moveItemAtURL:toURL:error:_))]
        #[unsafe(method_family = none)]
        pub fn moveItemAtURL_toURL_error(
            &self,
            src_url: &NSURL,
            dst_url: &NSURL,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(linkItemAtURL:toURL:error:_))]
        #[unsafe(method_family = none)]
        pub fn linkItemAtURL_toURL_error(
            &self,
            src_url: &NSURL,
            dst_url: &NSURL,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(removeItemAtURL:error:_))]
        #[unsafe(method_family = none)]
        pub fn removeItemAtURL_error(&self, url: &NSURL) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(trashItemAtURL:resultingItemURL:error:_))]
        #[unsafe(method_family = none)]
        pub fn trashItemAtURL_resultingItemURL_error(
            &self,
            url: &NSURL,
            out_resulting_url: Option<&mut Option<Retained<NSURL>>>,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        #[deprecated = "Use -attributesOfItemAtPath:error: instead"]
        #[unsafe(method(fileAttributesAtPath:traverseLink:))]
        #[unsafe(method_family = none)]
        pub fn fileAttributesAtPath_traverseLink(
            &self,
            path: &NSString,
            yorn: bool,
        ) -> Option<Retained<NSDictionary>>;

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        /// # Safety
        ///
        /// `attributes` generic should be of the correct type.
        #[deprecated = "Use -setAttributes:ofItemAtPath:error: instead"]
        #[unsafe(method(changeFileAttributes:atPath:))]
        #[unsafe(method_family = none)]
        pub unsafe fn changeFileAttributes_atPath(
            &self,
            attributes: &NSDictionary,
            path: &NSString,
        ) -> bool;

        #[cfg(all(feature = "NSArray", feature = "NSString"))]
        #[deprecated = "Use -contentsOfDirectoryAtPath:error: instead"]
        #[unsafe(method(directoryContentsAtPath:))]
        #[unsafe(method_family = none)]
        pub fn directoryContentsAtPath(&self, path: &NSString) -> Option<Retained<NSArray>>;

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        #[deprecated = "Use -attributesOfFileSystemForPath:error: instead"]
        #[unsafe(method(fileSystemAttributesAtPath:))]
        #[unsafe(method_family = none)]
        pub fn fileSystemAttributesAtPath(&self, path: &NSString)
            -> Option<Retained<NSDictionary>>;

        #[cfg(feature = "NSString")]
        #[deprecated = "Use -destinationOfSymbolicLinkAtPath:error:"]
        #[unsafe(method(pathContentOfSymbolicLinkAtPath:))]
        #[unsafe(method_family = none)]
        pub fn pathContentOfSymbolicLinkAtPath(
            &self,
            path: &NSString,
        ) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[deprecated = "Use -createSymbolicLinkAtPath:error: instead"]
        #[unsafe(method(createSymbolicLinkAtPath:pathContent:))]
        #[unsafe(method_family = none)]
        pub fn createSymbolicLinkAtPath_pathContent(
            &self,
            path: &NSString,
            otherpath: &NSString,
        ) -> bool;

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        /// # Safety
        ///
        /// `attributes` generic should be of the correct type.
        #[deprecated = "Use -createDirectoryAtPath:withIntermediateDirectories:attributes:error: instead"]
        #[unsafe(method(createDirectoryAtPath:attributes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn createDirectoryAtPath_attributes(
            &self,
            path: &NSString,
            attributes: &NSDictionary,
        ) -> bool;

        #[cfg(feature = "NSString")]
        /// # Safety
        ///
        /// `handler` should be of the correct type.
        #[deprecated = "Not supported"]
        #[unsafe(method(linkPath:toPath:handler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn linkPath_toPath_handler(
            &self,
            src: &NSString,
            dest: &NSString,
            handler: Option<&AnyObject>,
        ) -> bool;

        #[cfg(feature = "NSString")]
        /// # Safety
        ///
        /// `handler` should be of the correct type.
        #[deprecated = "Not supported"]
        #[unsafe(method(copyPath:toPath:handler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn copyPath_toPath_handler(
            &self,
            src: &NSString,
            dest: &NSString,
            handler: Option<&AnyObject>,
        ) -> bool;

        #[cfg(feature = "NSString")]
        /// # Safety
        ///
        /// `handler` should be of the correct type.
        #[deprecated = "Not supported"]
        #[unsafe(method(movePath:toPath:handler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn movePath_toPath_handler(
            &self,
            src: &NSString,
            dest: &NSString,
            handler: Option<&AnyObject>,
        ) -> bool;

        #[cfg(feature = "NSString")]
        /// # Safety
        ///
        /// `handler` should be of the correct type.
        #[deprecated = "Not supported"]
        #[unsafe(method(removeFileAtPath:handler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeFileAtPath_handler(
            &self,
            path: &NSString,
            handler: Option<&AnyObject>,
        ) -> bool;

        #[cfg(feature = "NSString")]
        #[unsafe(method(currentDirectoryPath))]
        #[unsafe(method_family = none)]
        pub fn currentDirectoryPath(&self) -> Retained<NSString>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(changeCurrentDirectoryPath:))]
        #[unsafe(method_family = none)]
        pub fn changeCurrentDirectoryPath(&self, path: &NSString) -> bool;

        #[cfg(feature = "NSString")]
        #[unsafe(method(fileExistsAtPath:))]
        #[unsafe(method_family = none)]
        pub fn fileExistsAtPath(&self, path: &NSString) -> bool;

        #[cfg(feature = "NSString")]
        /// # Safety
        ///
        /// `is_directory` must be a valid pointer or null.
        #[unsafe(method(fileExistsAtPath:isDirectory:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fileExistsAtPath_isDirectory(
            &self,
            path: &NSString,
            is_directory: *mut Bool,
        ) -> bool;

        #[cfg(feature = "NSString")]
        #[unsafe(method(isReadableFileAtPath:))]
        #[unsafe(method_family = none)]
        pub fn isReadableFileAtPath(&self, path: &NSString) -> bool;

        #[cfg(feature = "NSString")]
        #[unsafe(method(isWritableFileAtPath:))]
        #[unsafe(method_family = none)]
        pub fn isWritableFileAtPath(&self, path: &NSString) -> bool;

        #[cfg(feature = "NSString")]
        #[unsafe(method(isExecutableFileAtPath:))]
        #[unsafe(method_family = none)]
        pub fn isExecutableFileAtPath(&self, path: &NSString) -> bool;

        #[cfg(feature = "NSString")]
        #[unsafe(method(isDeletableFileAtPath:))]
        #[unsafe(method_family = none)]
        pub fn isDeletableFileAtPath(&self, path: &NSString) -> bool;

        #[cfg(feature = "NSString")]
        #[unsafe(method(contentsEqualAtPath:andPath:))]
        #[unsafe(method_family = none)]
        pub fn contentsEqualAtPath_andPath(&self, path1: &NSString, path2: &NSString) -> bool;

        #[cfg(feature = "NSString")]
        #[unsafe(method(displayNameAtPath:))]
        #[unsafe(method_family = none)]
        pub fn displayNameAtPath(&self, path: &NSString) -> Retained<NSString>;

        #[cfg(all(feature = "NSArray", feature = "NSString"))]
        #[unsafe(method(componentsToDisplayForPath:))]
        #[unsafe(method_family = none)]
        pub fn componentsToDisplayForPath(
            &self,
            path: &NSString,
        ) -> Option<Retained<NSArray<NSString>>>;

        #[cfg(all(feature = "NSEnumerator", feature = "NSString"))]
        #[unsafe(method(enumeratorAtPath:))]
        #[unsafe(method_family = none)]
        pub fn enumeratorAtPath(
            &self,
            path: &NSString,
        ) -> Option<Retained<NSDirectoryEnumerator<NSString>>>;

        #[cfg(all(
            feature = "NSArray",
            feature = "NSEnumerator",
            feature = "NSError",
            feature = "NSString",
            feature = "NSURL",
            feature = "block2"
        ))]
        #[unsafe(method(enumeratorAtURL:includingPropertiesForKeys:options:errorHandler:))]
        #[unsafe(method_family = none)]
        pub fn enumeratorAtURL_includingPropertiesForKeys_options_errorHandler(
            &self,
            url: &NSURL,
            keys: Option<&NSArray<NSURLResourceKey>>,
            mask: NSDirectoryEnumerationOptions,
            handler: Option<&block2::DynBlock<dyn Fn(NonNull<NSURL>, NonNull<NSError>) -> Bool>>,
        ) -> Option<Retained<NSDirectoryEnumerator<NSURL>>>;

        #[cfg(all(feature = "NSArray", feature = "NSString"))]
        #[unsafe(method(subpathsAtPath:))]
        #[unsafe(method_family = none)]
        pub fn subpathsAtPath(&self, path: &NSString) -> Option<Retained<NSArray<NSString>>>;

        #[cfg(all(feature = "NSData", feature = "NSString"))]
        #[unsafe(method(contentsAtPath:))]
        #[unsafe(method_family = none)]
        pub fn contentsAtPath(&self, path: &NSString) -> Option<Retained<NSData>>;

        #[cfg(all(feature = "NSData", feature = "NSDictionary", feature = "NSString"))]
        /// # Safety
        ///
        /// `attr` generic should be of the correct type.
        #[unsafe(method(createFileAtPath:contents:attributes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn createFileAtPath_contents_attributes(
            &self,
            path: &NSString,
            data: Option<&NSData>,
            attr: Option<&NSDictionary<NSFileAttributeKey, AnyObject>>,
        ) -> bool;

        #[cfg(feature = "NSString")]
        #[unsafe(method(fileSystemRepresentationWithPath:))]
        #[unsafe(method_family = none)]
        pub fn fileSystemRepresentationWithPath(&self, path: &NSString) -> NonNull<c_char>;

        #[cfg(feature = "NSString")]
        /// # Safety
        ///
        /// `str` must be a valid pointer.
        #[unsafe(method(stringWithFileSystemRepresentation:length:))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringWithFileSystemRepresentation_length(
            &self,
            str: NonNull<c_char>,
            len: NSUInteger,
        ) -> Retained<NSString>;

        #[cfg(all(feature = "NSError", feature = "NSString", feature = "NSURL"))]
        #[unsafe(method(replaceItemAtURL:withItemAtURL:backupItemName:options:resultingItemURL:error:_))]
        #[unsafe(method_family = none)]
        pub fn replaceItemAtURL_withItemAtURL_backupItemName_options_resultingItemURL_error(
            &self,
            original_item_url: &NSURL,
            new_item_url: &NSURL,
            backup_item_name: Option<&NSString>,
            options: NSFileManagerItemReplacementOptions,
            resulting_url: Option<&mut Option<Retained<NSURL>>>,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(setUbiquitous:itemAtURL:destinationURL:error:_))]
        #[unsafe(method_family = none)]
        pub fn setUbiquitous_itemAtURL_destinationURL_error(
            &self,
            flag: bool,
            url: &NSURL,
            destination_url: &NSURL,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(feature = "NSURL")]
        #[unsafe(method(isUbiquitousItemAtURL:))]
        #[unsafe(method_family = none)]
        pub fn isUbiquitousItemAtURL(&self, url: &NSURL) -> bool;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(startDownloadingUbiquitousItemAtURL:error:_))]
        #[unsafe(method_family = none)]
        pub fn startDownloadingUbiquitousItemAtURL_error(
            &self,
            url: &NSURL,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(evictUbiquitousItemAtURL:error:_))]
        #[unsafe(method_family = none)]
        pub fn evictUbiquitousItemAtURL_error(&self, url: &NSURL) -> Result<(), Retained<NSError>>;

        #[cfg(all(feature = "NSString", feature = "NSURL"))]
        #[unsafe(method(URLForUbiquityContainerIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn URLForUbiquityContainerIdentifier(
            &self,
            container_identifier: Option<&NSString>,
        ) -> Option<Retained<NSURL>>;

        #[cfg(all(feature = "NSDate", feature = "NSError", feature = "NSURL"))]
        #[unsafe(method(URLForPublishingUbiquitousItemAtURL:expirationDate:error:_))]
        #[unsafe(method_family = none)]
        pub fn URLForPublishingUbiquitousItemAtURL_expirationDate_error(
            &self,
            url: &NSURL,
            out_date: Option<&mut Option<Retained<NSDate>>>,
        ) -> Result<Retained<NSURL>, Retained<NSError>>;

        #[cfg(feature = "NSObject")]
        #[unsafe(method(ubiquityIdentityToken))]
        #[unsafe(method_family = none)]
        pub fn ubiquityIdentityToken(
            &self,
        ) -> Option<Retained<AnyObject /* NSObjectProtocol+ NSCopying+ NSCoding */>>;

        #[cfg(all(feature = "NSError", feature = "NSURL", feature = "block2"))]
        /// Asynchronously pauses sync of an item at the given URL.
        ///
        /// Call this when opening an item to prevent sync from altering the contents of the URL.
        /// Once paused, the file provider will not upload local changes nor download remote changes.
        ///
        /// While paused, call ``uploadLocalVersionOfUbiquitousItem(at:withConflictResolutionPolicy:completionHandler:)`` when the document is in a stable state.
        /// This action keeps the server version as up-to-date as possible.
        ///
        /// If the item is already paused, a second call to this method reports success.
        /// If the file provider is already applying changes to the item, the pause fails with an ``NSFileWriteUnknownError-enum.case``, with an underlying error that has domain ``NSPOSIXErrorDomain`` and code ``POSIXError/EBUSY``.
        /// If the pause fails, wait for the state to stabilize before retrying.
        /// Pausing also fails with ``CocoaError/featureUnsupported`` if `url` refers to a regular (non-package) directory.
        ///
        /// Pausing sync is independent of the calling app's lifecycle; sync doesn't automatically resume if the app closes or crashes and relaunches later.
        /// To resume syncing, explicitly call ``resumeSyncForUbiquitousItem(at:with:completionHandler:)``.
        /// Always be sure to resume syncing before you close the item.
        ///
        /// - Parameters:
        /// - url: The URL of the item for which to pause sync.
        /// - completionHandler: A closure or block that the framework calls when the pause action completes. It receives a single ``NSError`` parameter to indicate an error that prevented pausing; this value is `nil` if the pause succeeded. In Swift, you can omit the completion handler and catch the thrown error instead.
        ///
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(pauseSyncForUbiquitousItemAtURL:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn pauseSyncForUbiquitousItemAtURL_completionHandler(
            &self,
            url: &NSURL,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(all(feature = "NSError", feature = "NSURL", feature = "block2"))]
        /// Asynchronously resumes the sync on a paused item using the given resume behavior.
        ///
        /// Always call this method when your app closes an item to allow the file provider to sync local changes back to the server.
        ///
        /// In most situations, the ``NSFileManagerResumeSyncBehavior/preserveLocalChanges`` behavior is the best choice to avoid any risk of data loss.
        ///
        /// The resume call fails with ``CocoaError/featureUnsupported`` if `url` isn't currently paused.
        /// If the device isn't connected to the network, the call may fail with ``NSFileWriteUnknownError-enum.case``, with the underlying error of
        /// <doc
        /// ://com.apple.documentation/documentation/FileProvider/NSFileProviderError/serverUnreachable>.
        ///
        /// - Parameters:
        /// - url: The URL of the item for which to resume sync.
        /// - behavior: A ``NSFileManagerResumeSyncBehavior`` value that tells the file manager how to handle conflicts between local and remote versions of files.
        /// - completionHandler: A closure or block that the framework calls when the resume action completes. It receives a single ``NSError`` parameter to indicate an error that prevented the resume action; the value is `nil` if the resume succeeded. In Swift, you can omit the completion handler and catch the thrown error instead.
        ///
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(resumeSyncForUbiquitousItemAtURL:withBehavior:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn resumeSyncForUbiquitousItemAtURL_withBehavior_completionHandler(
            &self,
            url: &NSURL,
            behavior: NSFileManagerResumeSyncBehavior,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSError)>,
        );

        #[cfg(all(
            feature = "NSError",
            feature = "NSFileVersion",
            feature = "NSURL",
            feature = "block2"
        ))]
        /// Asynchronously fetches the latest remote version of a given item from the server.
        ///
        /// Use this method if uploading fails due to a version conflict and sync is paused.
        /// In this case, fetching the latest remote version allows you to inspect the newer item from the server, resolve the conflict, and resume uploading.
        ///
        /// The version provided by this call depends on several factors:
        /// * If there is no newer version of the file on the server, the caller receives the current version of the file.
        /// * If the server has a newer version and sync isn't paused, this call replaces the local item and provides the version of the new item.
        /// * If the server has a newer version but sync is paused, the returned version points to a side location. In this case, call ``NSFileVersion/replaceItem(at:options:)`` on the provided version object to replace the local item with the newer item from the server.
        ///
        /// If the device isn't connected to the network, the call may fail with ``NSFileReadUnknownError-enum.case``, with the underlying error of
        /// <doc
        /// ://com.apple.documentation/documentation/FileProvider/NSFileProviderError/serverUnreachable>.
        ///
        /// - Parameters:
        /// - url: The URL of the item for which to check the version.
        /// - completionHandler: A closure or block that the framework calls when the fetch action completes. It receives parameters of types ``NSFileVersion`` and ``NSError``. The error is `nil` if fetching the remote version succeeded; otherwise it indicates the error that caused the call to fail. In Swift, you can omit the completion handler, catching any error in a `do`-`catch` block and receiving the version as the return value.
        ///
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(fetchLatestRemoteVersionOfItemAtURL:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchLatestRemoteVersionOfItemAtURL_completionHandler(
            &self,
            url: &NSURL,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSFileVersion, *mut NSError)>,
        );

        #[cfg(all(
            feature = "NSError",
            feature = "NSFileVersion",
            feature = "NSURL",
            feature = "block2"
        ))]
        /// Asynchronously uploads the local version of the item using the provided conflict resolution policy.
        ///
        /// Once your app pauses a sync for an item, call this method every time your document is in a stable state.
        /// This action keeps the server version as up-to-date as possible.
        ///
        /// If the server has a newer version than the one to which the app made changes, uploading fails with ``NSFileWriteUnknownError-enum.case``, with an underlying error of
        /// <doc
        /// ://com.apple.documentation/documentation/FileProvider/NSFileProviderError/localVersionConflictingWithServer>.
        /// In this case, call ``FileManager/fetchLatestRemoteVersionOfItem(at:completionHandler:)``, rebase local changes on top of that version, and retry the upload.
        ///
        /// If the device isn't connected to the network, the call may fail with ``NSFileWriteUnknownError-enum.case``, with the underlying error of
        /// <doc
        /// ://com.apple.documentation/documentation/FileProvider/NSFileProviderError/serverUnreachable>.
        ///
        /// - Parameters:
        /// - url: The URL of the item for which to check the version.
        /// - conflictResolutionPolicy: The policy the file manager applies if the local and server versions conflict.
        /// - completionHandler: A closure or block that the framework calls when the upload completes. It receives parameters of types ``NSFileVersion`` and ``NSError``. The error is `nil` if fetching the remote version succeeded; otherwise it indicates the error that caused the call to fail. In Swift, you can omit the completion handler, catching any error in a `do`-`catch` block and receiving the version as the return value.
        ///
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(uploadLocalVersionOfUbiquitousItemAtURL:withConflictResolutionPolicy:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn uploadLocalVersionOfUbiquitousItemAtURL_withConflictResolutionPolicy_completionHandler(
            &self,
            url: &NSURL,
            conflict_resolution_policy: NSFileManagerUploadLocalVersionConflictPolicy,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSFileVersion, *mut NSError)>,
        );

        #[cfg(all(
            feature = "NSDictionary",
            feature = "NSError",
            feature = "NSString",
            feature = "NSURL",
            feature = "block2"
        ))]
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(getFileProviderServicesForItemAtURL:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getFileProviderServicesForItemAtURL_completionHandler(
            &self,
            url: &NSURL,
            completion_handler: &block2::DynBlock<
                dyn Fn(
                    *mut NSDictionary<NSFileProviderServiceName, NSFileProviderService>,
                    *mut NSError,
                ),
            >,
        );

        #[cfg(all(feature = "NSString", feature = "NSURL"))]
        #[unsafe(method(containerURLForSecurityApplicationGroupIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn containerURLForSecurityApplicationGroupIdentifier(
            &self,
            group_identifier: &NSString,
        ) -> Option<Retained<NSURL>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSFileManager {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSFileManager {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

/// NSUserInformation.
impl NSFileManager {
    extern_methods!(
        #[cfg(feature = "NSURL")]
        #[unsafe(method(homeDirectoryForCurrentUser))]
        #[unsafe(method_family = none)]
        pub fn homeDirectoryForCurrentUser(&self) -> Retained<NSURL>;

        #[cfg(feature = "NSURL")]
        #[unsafe(method(temporaryDirectory))]
        #[unsafe(method_family = none)]
        pub fn temporaryDirectory(&self) -> Retained<NSURL>;

        #[cfg(all(feature = "NSString", feature = "NSURL"))]
        #[unsafe(method(homeDirectoryForUser:))]
        #[unsafe(method_family = none)]
        pub fn homeDirectoryForUser(&self, user_name: &NSString) -> Option<Retained<NSURL>>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilemanagerdelegate?language=objc)
    pub unsafe trait NSFileManagerDelegate: NSObjectProtocol {
        #[cfg(feature = "NSString")]
        #[optional]
        #[unsafe(method(fileManager:shouldCopyItemAtPath:toPath:))]
        #[unsafe(method_family = none)]
        fn fileManager_shouldCopyItemAtPath_toPath(
            &self,
            file_manager: &NSFileManager,
            src_path: &NSString,
            dst_path: &NSString,
        ) -> bool;

        #[cfg(feature = "NSURL")]
        #[optional]
        #[unsafe(method(fileManager:shouldCopyItemAtURL:toURL:))]
        #[unsafe(method_family = none)]
        fn fileManager_shouldCopyItemAtURL_toURL(
            &self,
            file_manager: &NSFileManager,
            src_url: &NSURL,
            dst_url: &NSURL,
        ) -> bool;

        #[cfg(all(feature = "NSError", feature = "NSString"))]
        #[optional]
        #[unsafe(method(fileManager:shouldProceedAfterError:copyingItemAtPath:toPath:))]
        #[unsafe(method_family = none)]
        fn fileManager_shouldProceedAfterError_copyingItemAtPath_toPath(
            &self,
            file_manager: &NSFileManager,
            error: &NSError,
            src_path: &NSString,
            dst_path: &NSString,
        ) -> bool;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[optional]
        #[unsafe(method(fileManager:shouldProceedAfterError:copyingItemAtURL:toURL:))]
        #[unsafe(method_family = none)]
        fn fileManager_shouldProceedAfterError_copyingItemAtURL_toURL(
            &self,
            file_manager: &NSFileManager,
            error: &NSError,
            src_url: &NSURL,
            dst_url: &NSURL,
        ) -> bool;

        #[cfg(feature = "NSString")]
        #[optional]
        #[unsafe(method(fileManager:shouldMoveItemAtPath:toPath:))]
        #[unsafe(method_family = none)]
        fn fileManager_shouldMoveItemAtPath_toPath(
            &self,
            file_manager: &NSFileManager,
            src_path: &NSString,
            dst_path: &NSString,
        ) -> bool;

        #[cfg(feature = "NSURL")]
        #[optional]
        #[unsafe(method(fileManager:shouldMoveItemAtURL:toURL:))]
        #[unsafe(method_family = none)]
        fn fileManager_shouldMoveItemAtURL_toURL(
            &self,
            file_manager: &NSFileManager,
            src_url: &NSURL,
            dst_url: &NSURL,
        ) -> bool;

        #[cfg(all(feature = "NSError", feature = "NSString"))]
        #[optional]
        #[unsafe(method(fileManager:shouldProceedAfterError:movingItemAtPath:toPath:))]
        #[unsafe(method_family = none)]
        fn fileManager_shouldProceedAfterError_movingItemAtPath_toPath(
            &self,
            file_manager: &NSFileManager,
            error: &NSError,
            src_path: &NSString,
            dst_path: &NSString,
        ) -> bool;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[optional]
        #[unsafe(method(fileManager:shouldProceedAfterError:movingItemAtURL:toURL:))]
        #[unsafe(method_family = none)]
        fn fileManager_shouldProceedAfterError_movingItemAtURL_toURL(
            &self,
            file_manager: &NSFileManager,
            error: &NSError,
            src_url: &NSURL,
            dst_url: &NSURL,
        ) -> bool;

        #[cfg(feature = "NSString")]
        #[optional]
        #[unsafe(method(fileManager:shouldLinkItemAtPath:toPath:))]
        #[unsafe(method_family = none)]
        fn fileManager_shouldLinkItemAtPath_toPath(
            &self,
            file_manager: &NSFileManager,
            src_path: &NSString,
            dst_path: &NSString,
        ) -> bool;

        #[cfg(feature = "NSURL")]
        #[optional]
        #[unsafe(method(fileManager:shouldLinkItemAtURL:toURL:))]
        #[unsafe(method_family = none)]
        fn fileManager_shouldLinkItemAtURL_toURL(
            &self,
            file_manager: &NSFileManager,
            src_url: &NSURL,
            dst_url: &NSURL,
        ) -> bool;

        #[cfg(all(feature = "NSError", feature = "NSString"))]
        #[optional]
        #[unsafe(method(fileManager:shouldProceedAfterError:linkingItemAtPath:toPath:))]
        #[unsafe(method_family = none)]
        fn fileManager_shouldProceedAfterError_linkingItemAtPath_toPath(
            &self,
            file_manager: &NSFileManager,
            error: &NSError,
            src_path: &NSString,
            dst_path: &NSString,
        ) -> bool;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[optional]
        #[unsafe(method(fileManager:shouldProceedAfterError:linkingItemAtURL:toURL:))]
        #[unsafe(method_family = none)]
        fn fileManager_shouldProceedAfterError_linkingItemAtURL_toURL(
            &self,
            file_manager: &NSFileManager,
            error: &NSError,
            src_url: &NSURL,
            dst_url: &NSURL,
        ) -> bool;

        #[cfg(feature = "NSString")]
        #[optional]
        #[unsafe(method(fileManager:shouldRemoveItemAtPath:))]
        #[unsafe(method_family = none)]
        fn fileManager_shouldRemoveItemAtPath(
            &self,
            file_manager: &NSFileManager,
            path: &NSString,
        ) -> bool;

        #[cfg(feature = "NSURL")]
        #[optional]
        #[unsafe(method(fileManager:shouldRemoveItemAtURL:))]
        #[unsafe(method_family = none)]
        fn fileManager_shouldRemoveItemAtURL(
            &self,
            file_manager: &NSFileManager,
            url: &NSURL,
        ) -> bool;

        #[cfg(all(feature = "NSError", feature = "NSString"))]
        #[optional]
        #[unsafe(method(fileManager:shouldProceedAfterError:removingItemAtPath:))]
        #[unsafe(method_family = none)]
        fn fileManager_shouldProceedAfterError_removingItemAtPath(
            &self,
            file_manager: &NSFileManager,
            error: &NSError,
            path: &NSString,
        ) -> bool;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[optional]
        #[unsafe(method(fileManager:shouldProceedAfterError:removingItemAtURL:))]
        #[unsafe(method_family = none)]
        fn fileManager_shouldProceedAfterError_removingItemAtURL(
            &self,
            file_manager: &NSFileManager,
            error: &NSError,
            url: &NSURL,
        ) -> bool;
    }
);

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsdirectoryenumerator?language=objc)
    #[unsafe(super(NSEnumerator<ObjectType>, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "NSEnumerator")]
    pub struct NSDirectoryEnumerator<ObjectType: ?Sized = AnyObject>;
);

#[cfg(feature = "NSEnumerator")]
impl<ObjectType: ?Sized + Message> NSDirectoryEnumerator<ObjectType> {
    /// Unchecked conversion of the generic parameter.
    ///
    /// # Safety
    ///
    /// The generic must be valid to reinterpret as the given type.
    #[inline]
    pub unsafe fn cast_unchecked<NewObjectType: ?Sized + Message>(
        &self,
    ) -> &NSDirectoryEnumerator<NewObjectType> {
        unsafe { &*((self as *const Self).cast()) }
    }
}

#[cfg(feature = "NSEnumerator")]
extern_conformance!(
    unsafe impl<ObjectType: ?Sized> NSFastEnumeration for NSDirectoryEnumerator<ObjectType> {}
);

#[cfg(feature = "NSEnumerator")]
extern_conformance!(
    unsafe impl<ObjectType: ?Sized> NSObjectProtocol for NSDirectoryEnumerator<ObjectType> {}
);

#[cfg(feature = "NSEnumerator")]
impl<ObjectType: Message> NSDirectoryEnumerator<ObjectType> {
    extern_methods!(
        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        #[unsafe(method(fileAttributes))]
        #[unsafe(method_family = none)]
        pub fn fileAttributes(
            &self,
        ) -> Option<Retained<NSDictionary<NSFileAttributeKey, AnyObject>>>;

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        #[unsafe(method(directoryAttributes))]
        #[unsafe(method_family = none)]
        pub fn directoryAttributes(
            &self,
        ) -> Option<Retained<NSDictionary<NSFileAttributeKey, AnyObject>>>;

        #[unsafe(method(isEnumeratingDirectoryPostOrder))]
        #[unsafe(method_family = none)]
        pub fn isEnumeratingDirectoryPostOrder(&self) -> bool;

        #[unsafe(method(skipDescendents))]
        #[unsafe(method_family = none)]
        pub fn skipDescendents(&self);

        #[unsafe(method(level))]
        #[unsafe(method_family = none)]
        pub fn level(&self) -> NSUInteger;

        #[unsafe(method(skipDescendants))]
        #[unsafe(method_family = none)]
        pub fn skipDescendants(&self);
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "NSEnumerator")]
impl<ObjectType: Message> NSDirectoryEnumerator<ObjectType> {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

#[cfg(feature = "NSEnumerator")]
impl<ObjectType: Message> DefaultRetained for NSDirectoryEnumerator<ObjectType> {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfileproviderservice?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSFileProviderService;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSFileProviderService {}
);

impl NSFileProviderService {
    extern_methods!(
        #[cfg(all(feature = "NSError", feature = "NSXPCConnection", feature = "block2"))]
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(getFileProviderConnectionWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getFileProviderConnectionWithCompletionHandler(
            &self,
            completion_handler: &block2::DynBlock<dyn Fn(*mut NSXPCConnection, *mut NSError)>,
        );

        #[cfg(feature = "NSString")]
        #[unsafe(method(name))]
        #[unsafe(method_family = none)]
        pub fn name(&self) -> Retained<NSFileProviderServiceName>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSFileProviderService {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSFileProviderService {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfiletype?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileType: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfiletypedirectory?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileTypeDirectory: &'static NSFileAttributeType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfiletyperegular?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileTypeRegular: &'static NSFileAttributeType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfiletypesymboliclink?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileTypeSymbolicLink: &'static NSFileAttributeType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfiletypesocket?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileTypeSocket: &'static NSFileAttributeType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfiletypecharacterspecial?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileTypeCharacterSpecial: &'static NSFileAttributeType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfiletypeblockspecial?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileTypeBlockSpecial: &'static NSFileAttributeType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfiletypeunknown?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileTypeUnknown: &'static NSFileAttributeType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilesize?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileSize: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilemodificationdate?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileModificationDate: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilereferencecount?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileReferenceCount: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfiledeviceidentifier?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileDeviceIdentifier: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfileowneraccountname?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileOwnerAccountName: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilegroupowneraccountname?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileGroupOwnerAccountName: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfileposixpermissions?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFilePosixPermissions: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilesystemnumber?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileSystemNumber: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilesystemfilenumber?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileSystemFileNumber: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfileextensionhidden?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileExtensionHidden: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilehfscreatorcode?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileHFSCreatorCode: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilehfstypecode?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileHFSTypeCode: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfileimmutable?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileImmutable: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfileappendonly?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileAppendOnly: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilecreationdate?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileCreationDate: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfileowneraccountid?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileOwnerAccountID: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilegroupowneraccountid?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileGroupOwnerAccountID: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilebusy?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileBusy: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfileprotectionkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileProtectionKey: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfileprotectionnone?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileProtectionNone: &'static NSFileProtectionType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfileprotectioncomplete?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileProtectionComplete: &'static NSFileProtectionType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfileprotectioncompleteunlessopen?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileProtectionCompleteUnlessOpen: &'static NSFileProtectionType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfileprotectioncompleteuntilfirstuserauthentication?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileProtectionCompleteUntilFirstUserAuthentication: &'static NSFileProtectionType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfileprotectioncompletewhenuserinactive?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileProtectionCompleteWhenUserInactive: &'static NSFileProtectionType;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilesystemsize?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileSystemSize: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilesystemfreesize?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileSystemFreeSize: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilesystemnodes?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileSystemNodes: &'static NSFileAttributeKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsfilesystemfreenodes?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSFileSystemFreeNodes: &'static NSFileAttributeKey;
}

/// NSFileAttributes.
#[cfg(feature = "NSDictionary")]
impl<KeyType: Message, ObjectType: Message> NSDictionary<KeyType, ObjectType> {
    extern_methods!(
        #[unsafe(method(fileSize))]
        #[unsafe(method_family = none)]
        pub fn fileSize(&self) -> c_ulonglong;

        #[cfg(feature = "NSDate")]
        #[unsafe(method(fileModificationDate))]
        #[unsafe(method_family = none)]
        pub fn fileModificationDate(&self) -> Option<Retained<NSDate>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(fileType))]
        #[unsafe(method_family = none)]
        pub fn fileType(&self) -> Option<Retained<NSString>>;

        #[unsafe(method(filePosixPermissions))]
        #[unsafe(method_family = none)]
        pub fn filePosixPermissions(&self) -> NSUInteger;

        #[cfg(feature = "NSString")]
        #[unsafe(method(fileOwnerAccountName))]
        #[unsafe(method_family = none)]
        pub fn fileOwnerAccountName(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(fileGroupOwnerAccountName))]
        #[unsafe(method_family = none)]
        pub fn fileGroupOwnerAccountName(&self) -> Option<Retained<NSString>>;

        #[unsafe(method(fileSystemNumber))]
        #[unsafe(method_family = none)]
        pub fn fileSystemNumber(&self) -> NSInteger;

        #[unsafe(method(fileSystemFileNumber))]
        #[unsafe(method_family = none)]
        pub fn fileSystemFileNumber(&self) -> NSUInteger;

        #[unsafe(method(fileExtensionHidden))]
        #[unsafe(method_family = none)]
        pub fn fileExtensionHidden(&self) -> bool;

        #[unsafe(method(fileHFSCreatorCode))]
        #[unsafe(method_family = none)]
        pub fn fileHFSCreatorCode(&self) -> OSType;

        #[unsafe(method(fileHFSTypeCode))]
        #[unsafe(method_family = none)]
        pub fn fileHFSTypeCode(&self) -> OSType;

        #[unsafe(method(fileIsImmutable))]
        #[unsafe(method_family = none)]
        pub fn fileIsImmutable(&self) -> bool;

        #[unsafe(method(fileIsAppendOnly))]
        #[unsafe(method_family = none)]
        pub fn fileIsAppendOnly(&self) -> bool;

        #[cfg(feature = "NSDate")]
        #[unsafe(method(fileCreationDate))]
        #[unsafe(method_family = none)]
        pub fn fileCreationDate(&self) -> Option<Retained<NSDate>>;

        #[cfg(feature = "NSValue")]
        #[unsafe(method(fileOwnerAccountID))]
        #[unsafe(method_family = none)]
        pub fn fileOwnerAccountID(&self) -> Option<Retained<NSNumber>>;

        #[cfg(feature = "NSValue")]
        #[unsafe(method(fileGroupOwnerAccountID))]
        #[unsafe(method_family = none)]
        pub fn fileGroupOwnerAccountID(&self) -> Option<Retained<NSNumber>>;
    );
}
