/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.CalledByNative;
import org.webrtc.JniCommon;

public class FrameCryptorKeyProvider {
    private long nativeKeyProvider;

    @CalledByNative
    public FrameCryptorKeyProvider(long nativeKeyProvider) {
        this.nativeKeyProvider = nativeKeyProvider;
    }

    public long getNativeKeyProvider() {
        return this.nativeKeyProvider;
    }

    public boolean setKey(String participantId, int index, byte[] key) {
        this.checkKeyProviderExists();
        return FrameCryptorKeyProvider.nativeSetKey(this.nativeKeyProvider, participantId, index, key);
    }

    public byte[] ratchetKey(String participantId, int index) {
        this.checkKeyProviderExists();
        return FrameCryptorKeyProvider.nativeRatchetKey(this.nativeKeyProvider, participantId, index);
    }

    public byte[] exportKey(String participantId, int index) {
        this.checkKeyProviderExists();
        return FrameCryptorKeyProvider.nativeExportKey(this.nativeKeyProvider, participantId, index);
    }

    public void dispose() {
        this.checkKeyProviderExists();
        JniCommon.nativeReleaseRef(this.nativeKeyProvider);
        this.nativeKeyProvider = 0L;
    }

    private void checkKeyProviderExists() {
        if (this.nativeKeyProvider == 0L) {
            throw new IllegalStateException("FrameCryptorKeyProvider has been disposed.");
        }
    }

    private static native boolean nativeSetKey(long var0, String var2, int var3, byte[] var4);

    private static native byte[] nativeRatchetKey(long var0, String var2, int var3);

    private static native byte[] nativeExportKey(long var0, String var2, int var3);
}

