/////////////////////////////////////////////////////////////////////////////////////////////
// Copyright 2024 Garmin International, Inc.
// Licensed under the Flexible and Interoperable Data Transfer (FIT) Protocol License; you
// may not use this file except in compliance with the Flexible and Interoperable Data
// Transfer (FIT) Protocol License.
/////////////////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 21.158.0Release
// Tag = production/release/21.158.0-0-gc9428aa
/////////////////////////////////////////////////////////////////////////////////////////////


#if !defined(FIT_MEMO_GLOB_MESG_HPP)
#define FIT_MEMO_GLOB_MESG_HPP

#include "fit_mesg.hpp"

namespace fit
{

class MemoGlobMesg : public Mesg
{
public:
    class FieldDefNum final
    {
    public:
       static const FIT_UINT8 PartIndex = 250;
       static const FIT_UINT8 Memo = 0;
       static const FIT_UINT8 MesgNum = 1;
       static const FIT_UINT8 ParentIndex = 2;
       static const FIT_UINT8 FieldNum = 3;
       static const FIT_UINT8 Data = 4;
       static const FIT_UINT8 Invalid = FIT_FIELD_NUM_INVALID;
    };

    MemoGlobMesg(void) : Mesg(Profile::MESG_MEMO_GLOB)
    {
    }

    MemoGlobMesg(const Mesg &mesg) : Mesg(mesg)
    {
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of part_index field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsPartIndexValid() const
    {
        const Field* field = GetField(250);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns part_index field
    // Comment: Sequence number of memo blocks
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetPartIndex(void) const
    {
        return GetFieldUINT32Value(250, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set part_index field
    // Comment: Sequence number of memo blocks
    ///////////////////////////////////////////////////////////////////////
    void SetPartIndex(FIT_UINT32 partIndex)
    {
        SetFieldUINT32Value(250, partIndex, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of memo
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumMemo(void) const
    {
        return GetFieldNumValues(0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of memo field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMemoValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(0);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns memo field
    // Comment: Deprecated. Use data field.
    ///////////////////////////////////////////////////////////////////////
    FIT_BYTE GetMemo(FIT_UINT8 index) const
    {
        return GetFieldBYTEValue(0, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set memo field
    // Comment: Deprecated. Use data field.
    ///////////////////////////////////////////////////////////////////////
    void SetMemo(FIT_UINT8 index, FIT_BYTE memo)
    {
        SetFieldBYTEValue(0, memo, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of mesg_num field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMesgNumValid() const
    {
        const Field* field = GetField(1);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns mesg_num field
    // Comment: Message Number of the parent message
    ///////////////////////////////////////////////////////////////////////
    FIT_MESG_NUM GetMesgNum(void) const
    {
        return GetFieldUINT16Value(1, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set mesg_num field
    // Comment: Message Number of the parent message
    ///////////////////////////////////////////////////////////////////////
    void SetMesgNum(FIT_MESG_NUM mesgNum)
    {
        SetFieldUINT16Value(1, mesgNum, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of parent_index field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsParentIndexValid() const
    {
        const Field* field = GetField(2);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns parent_index field
    // Comment: Index of mesg that this glob is associated with.
    ///////////////////////////////////////////////////////////////////////
    FIT_MESSAGE_INDEX GetParentIndex(void) const
    {
        return GetFieldUINT16Value(2, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set parent_index field
    // Comment: Index of mesg that this glob is associated with.
    ///////////////////////////////////////////////////////////////////////
    void SetParentIndex(FIT_MESSAGE_INDEX parentIndex)
    {
        SetFieldUINT16Value(2, parentIndex, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of field_num field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsFieldNumValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns field_num field
    // Comment: Field within the parent that this glob is associated with
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetFieldNum(void) const
    {
        return GetFieldUINT8Value(3, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set field_num field
    // Comment: Field within the parent that this glob is associated with
    ///////////////////////////////////////////////////////////////////////
    void SetFieldNum(FIT_UINT8 fieldNum)
    {
        SetFieldUINT8Value(3, fieldNum, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of data
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumData(void) const
    {
        return GetFieldNumValues(4, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of data field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsDataValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns data field
    // Comment: Block of utf8 bytes. Note, mutltibyte characters may be split across adjoining memo_glob messages.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8Z GetData(FIT_UINT8 index) const
    {
        return GetFieldUINT8ZValue(4, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set data field
    // Comment: Block of utf8 bytes. Note, mutltibyte characters may be split across adjoining memo_glob messages.
    ///////////////////////////////////////////////////////////////////////
    void SetData(FIT_UINT8 index, FIT_UINT8Z data)
    {
        SetFieldUINT8ZValue(4, data, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

};

} // namespace fit

#endif // !defined(FIT_MEMO_GLOB_MESG_HPP)
