/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.JdbcColumnDescriptor;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationsStorage;
import com.intellij.database.datagrid.TypedValue;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.MutationData;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class MutationsStorageImpl
implements MutationsStorage {
    private static final double MULTIPLIER = 1.5;
    private final double myMultiplier;
    private final GridModel<GridRow, GridColumn> myModel;
    private final RowsCounter myModifiedRowsCounter;
    private final RowsCounter myRowsWithUnparsedValuesCounter;
    private final Queue<ModelIndex<GridRow>> myInsertedRows;
    private final HashMap<ModelIndex<GridColumn>, GridColumn> myInsertedColumns;
    private final Set<ModelIndex<GridRow>> myDeletedRows;
    private final Set<ModelIndex<GridColumn>> myDeletedColumns;
    private MutationData[][] myValues;
    private int myMaxRows;
    private int myRows;
    private int myMaxColumns;
    private int myColumns;

    public MutationsStorageImpl(@NotNull GridModel<GridRow, GridColumn> model2, int rows, int columns) {
        if (model2 == null) {
            MutationsStorageImpl.$$$reportNull$$$0(0);
        }
        this(model2, rows, columns, 1.5);
    }

    private MutationsStorageImpl(@NotNull GridModel<GridRow, GridColumn> model2, int rows, int columns, double multiplier) {
        if (model2 == null) {
            MutationsStorageImpl.$$$reportNull$$$0(1);
        }
        this.myMultiplier = multiplier;
        this.myRows = rows;
        this.myColumns = columns;
        this.myMaxRows = this.getIncreasedValue(rows);
        this.myMaxColumns = this.getIncreasedValue(columns);
        this.myModel = model2;
        this.myValues = new MutationData[this.myMaxRows][];
        this.myModifiedRowsCounter = new ModifiedRowsCounter();
        this.myRowsWithUnparsedValuesCounter = new RowsWithUnparsedValuesCounter();
        this.myInsertedRows = new PriorityQueue<ModelIndex<GridRow>>((o1, o2) -> Integer.compare(o2.asInteger(), o1.asInteger()));
        this.myDeletedRows = new HashSet<ModelIndex<GridRow>>();
        this.myDeletedColumns = new HashSet<ModelIndex<GridColumn>>();
        this.myInsertedColumns = new HashMap();
    }

    public void set(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column, @Nullable CellMutation value) {
        if (row == null) {
            MutationsStorageImpl.$$$reportNull$$$0(2);
        }
        if (column == null) {
            MutationsStorageImpl.$$$reportNull$$$0(3);
        }
        if (!this.isValid(row, column)) {
            return;
        }
        this.allocateSpace(row, column);
        this.countModifications(value, row, column);
        this.myValues[row.asInteger()][column.asInteger()] = value == null ? null : new MutationData(value.getValue());
    }

    protected void allocateSpace(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (row == null) {
            MutationsStorageImpl.$$$reportNull$$$0(4);
        }
        if (column == null) {
            MutationsStorageImpl.$$$reportNull$$$0(5);
        }
        int rowIdx = row.asInteger();
        int colIdx = column.asInteger();
        if (rowIdx >= this.myMaxRows || colIdx >= this.myMaxColumns) {
            this.reallocate(Math.max(rowIdx, this.myMaxRows), Math.max(colIdx, this.myMaxColumns));
        }
        this.increase(rowIdx, colIdx);
        if (this.myValues[rowIdx] == null) {
            this.myValues[rowIdx] = new MutationData[this.myMaxColumns];
        }
    }

    private void shiftUpColumn(@NotNull ModelIndex<GridColumn> column) {
        if (column == null) {
            MutationsStorageImpl.$$$reportNull$$$0(6);
        }
        this.myModifiedRowsCounter.deleteColumn(column);
        this.myRowsWithUnparsedValuesCounter.deleteColumn(column);
        int idx = column.asInteger();
        for (int i = 0; i < this.myValues.length; ++i) {
            if (this.myValues[i] == null) continue;
            System.arraycopy(this.myValues[i], idx + 1, this.myValues[i], idx, this.myColumns - 1 - idx);
            this.myValues[i][this.myColumns - 1] = null;
        }
    }

    private void shiftUpRow(@NotNull ModelIndex<GridRow> row) {
        if (row == null) {
            MutationsStorageImpl.$$$reportNull$$$0(7);
        }
        int idx = row.asInteger();
        System.arraycopy(this.myValues, idx + 1, this.myValues, idx, this.myRows - 1 - idx);
        this.myValues[this.myRows - 1] = null;
        this.myModifiedRowsCounter.shiftUp(row);
        this.myRowsWithUnparsedValuesCounter.shiftUp(row);
    }

    @NotNull
    public Set<ModelIndex<GridRow>> getModifiedRows() {
        HashSet<ModelIndex<GridRow>> modifiedRows = new HashSet<ModelIndex<GridRow>>();
        IntIterator intIterator = this.myModifiedRowsCounter.get().iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            modifiedRows.add((ModelIndex<GridRow>)ModelIndex.forRow(this.myModel, (int)i));
        }
        HashSet<ModelIndex<GridRow>> hashSet = modifiedRows;
        if (hashSet == null) {
            MutationsStorageImpl.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    public void deleteColumn(@NotNull ModelIndex<GridColumn> columnIdx) {
        if (columnIdx == null) {
            MutationsStorageImpl.$$$reportNull$$$0(9);
        }
        if (!this.isValidColumn(columnIdx)) {
            return;
        }
        boolean isInserted = this.isInsertedColumn(columnIdx);
        this.clearColumn(columnIdx);
        if (isInserted) {
            this.insertedColumnRemoved(columnIdx);
        } else {
            this.myDeletedColumns.add(columnIdx);
        }
    }

    public void deleteRow(@NotNull ModelIndex<GridRow> rowIdx) {
        if (rowIdx == null) {
            MutationsStorageImpl.$$$reportNull$$$0(10);
        }
        if (!this.isValidRow(rowIdx)) {
            return;
        }
        boolean isInserted = this.isInsertedRow(rowIdx);
        this.clearRow(rowIdx);
        if (isInserted) {
            this.insertedRowRemoved(rowIdx);
        } else {
            this.myDeletedRows.add(rowIdx);
        }
    }

    private void insertedColumnRemoved(ModelIndex<GridColumn> columnIdx) {
        List<ModelIndex<GridColumn>> indexesToShift = MutationsStorageImpl.findBiggerIndices(this.myInsertedColumns.keySet(), columnIdx);
        Map columnsToShift = ContainerUtil.map2Map(indexesToShift, key -> new Pair(key, (Object)this.myInsertedColumns.get(key)));
        for (ModelIndex<GridColumn> idx : indexesToShift) {
            this.myInsertedColumns.remove(idx);
        }
        JBIterable.from(columnsToShift.entrySet()).transform(keyValue -> new Pair((Object)ModelIndex.forColumn(this.myModel, (int)(((ModelIndex)keyValue.getKey()).asInteger() - 1)), (Object)((GridColumn)keyValue.getValue()))).filter(keyValue -> ((ModelIndex)keyValue.getFirst()).asInteger() >= 0).forEach(keyValue -> this.myInsertedColumns.put((ModelIndex<GridColumn>)((ModelIndex)keyValue.getFirst()), (GridColumn)keyValue.getSecond()));
        this.shiftUpColumn(columnIdx);
    }

    private void insertedRowRemoved(ModelIndex<GridRow> rowIdx) {
        List<ModelIndex<GridRow>> indexesToShift = MutationsStorageImpl.findBiggerIndices(this.myInsertedRows, rowIdx);
        this.myInsertedRows.removeAll(indexesToShift);
        JBIterable.from(indexesToShift).transform(idx -> ModelIndex.forRow(this.myModel, (int)(idx.asInteger() - 1))).filter(idx -> idx.asInteger() >= 0).forEach(this.myInsertedRows::add);
        this.shiftUpRow(rowIdx);
    }

    private static <T> @Unmodifiable @NotNull List<ModelIndex<T>> findBiggerIndices(@NotNull Collection<ModelIndex<T>> indexes, @NotNull ModelIndex<T> idx) {
        if (indexes == null) {
            MutationsStorageImpl.$$$reportNull$$$0(11);
        }
        if (idx == null) {
            MutationsStorageImpl.$$$reportNull$$$0(12);
        }
        List list = ContainerUtil.filter(indexes, i -> i.asInteger() > idx.asInteger());
        if (list == null) {
            MutationsStorageImpl.$$$reportNull$$$0(13);
        }
        return list;
    }

    public boolean isModified(@NotNull ModelIndex<GridRow> row) {
        if (row == null) {
            MutationsStorageImpl.$$$reportNull$$$0(14);
        }
        return this.isValidRow(row) && this.myModifiedRowsCounter.contains(row.asInteger());
    }

    @Nullable
    public MutationData get(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (row == null) {
            MutationsStorageImpl.$$$reportNull$$$0(15);
        }
        if (column == null) {
            MutationsStorageImpl.$$$reportNull$$$0(16);
        }
        return this.getInner(row, column);
    }

    @Nullable
    private MutationData getInner(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (row == null) {
            MutationsStorageImpl.$$$reportNull$$$0(17);
        }
        if (column == null) {
            MutationsStorageImpl.$$$reportNull$$$0(18);
        }
        int rowIdx = row.asInteger();
        int colIdx = column.asInteger();
        return !this.isValid(row, column) || rowIdx >= this.myRows || colIdx >= this.myColumns || this.myValues[rowIdx] == null ? null : this.myValues[rowIdx][colIdx];
    }

    public boolean hasChanges() {
        return !this.myModifiedRowsCounter.isEmpty() || !this.myInsertedRows.isEmpty() || !this.myDeletedRows.isEmpty() || !this.myDeletedColumns.isEmpty();
    }

    public int getModifiedRowsCount() {
        return this.myModifiedRowsCounter.myRowsSet.size();
    }

    private boolean isValidRow(@Nullable ModelIndex<GridRow> row) {
        return this.isValid(row, null);
    }

    private boolean isValidColumn(@Nullable ModelIndex<GridColumn> column) {
        return this.isValid(null, column);
    }

    public boolean isValid(@Nullable ModelIndex<GridRow> row, @Nullable ModelIndex<GridColumn> column) {
        return !(row != null && !row.isValid(this.myModel) && !this.isInsertedRow(row) || column != null && !column.isValid(this.myModel) && !this.isInsertedColumn(column));
    }

    private void increase(int rows, int columns) {
        this.myRows = rows >= this.myRows ? rows + 1 : this.myRows;
        this.myColumns = columns >= this.myColumns ? columns + 1 : this.myColumns;
    }

    private void countModifications(@Nullable CellMutation value, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (row == null) {
            MutationsStorageImpl.$$$reportNull$$$0(19);
        }
        if (column == null) {
            MutationsStorageImpl.$$$reportNull$$$0(20);
        }
        MutationData oldData = this.myValues[row.asInteger()] == null ? null : this.myValues[row.asInteger()][column.asInteger()];
        this.myModifiedRowsCounter.countModifications(value, oldData, row, column);
        this.myRowsWithUnparsedValuesCounter.countModifications(value, oldData, row, column);
    }

    private void reallocate(int rows, int columns) {
        this.myMaxRows = rows >= this.myMaxRows ? this.getIncreasedValue(rows) : this.myMaxRows;
        this.myMaxColumns = columns >= this.myMaxColumns ? this.getIncreasedValue(columns) : this.myMaxColumns;
        this.increase(rows, columns);
        this.myValues = MutationsStorageImpl.copy(this.myValues, this.myMaxRows, this.myMaxColumns);
        this.myModifiedRowsCounter.reallocate();
        this.myRowsWithUnparsedValuesCounter.reallocate();
    }

    public boolean hasUnparsedValues() {
        return !this.myRowsWithUnparsedValuesCounter.isEmpty();
    }

    public boolean hasUnparsedValues(ModelIndex<GridRow> row) {
        return this.myRowsWithUnparsedValuesCounter.contains(row.asInteger());
    }

    public boolean isInsertedRow(@NotNull ModelIndex<GridRow> row) {
        if (row == null) {
            MutationsStorageImpl.$$$reportNull$$$0(21);
        }
        return this.myInsertedRows.contains(row);
    }

    public boolean isInsertedColumn(@NotNull ModelIndex<GridColumn> idx) {
        if (idx == null) {
            MutationsStorageImpl.$$$reportNull$$$0(22);
        }
        return this.myInsertedColumns.containsKey(idx);
    }

    public int getInsertedRowsCount() {
        return this.myInsertedRows.size();
    }

    public int getInsertedColumnsCount() {
        return this.myInsertedColumns.size();
    }

    public int getDeletedRowsCount() {
        return this.myDeletedRows.size();
    }

    public int getDeletedColumnsCount() {
        return this.myDeletedColumns.size();
    }

    public boolean isDeletedRow(@NotNull ModelIndex<GridRow> row) {
        if (row == null) {
            MutationsStorageImpl.$$$reportNull$$$0(23);
        }
        return this.myDeletedRows.contains(row);
    }

    public boolean isDeletedColumn(@NotNull ModelIndex<GridColumn> column) {
        if (column == null) {
            MutationsStorageImpl.$$$reportNull$$$0(24);
        }
        return this.myDeletedColumns.contains(column);
    }

    public boolean isDeletedRows(ModelIndexSet<GridRow> rows) {
        return this.myDeletedRows.containsAll(rows.asList());
    }

    @Nullable
    public ModelIndex<GridRow> getLastInsertedRow() {
        return this.myInsertedRows.peek();
    }

    public JBIterable<ModelIndex<GridRow>> getDeletedRows() {
        return JBIterable.from(this.myDeletedRows);
    }

    public JBIterable<ModelIndex<GridColumn>> getDeletedColumns() {
        return JBIterable.from(this.myDeletedColumns);
    }

    public JBIterable<ModelIndex<GridRow>> getInsertedRows() {
        return JBIterable.from(this.myInsertedRows);
    }

    public JBIterable<ModelIndex<GridColumn>> getInsertedColumns() {
        return JBIterable.from(this.myInsertedColumns.keySet());
    }

    public void insertRow(@NotNull ModelIndex<GridRow> row) {
        if (row == null) {
            MutationsStorageImpl.$$$reportNull$$$0(25);
        }
        this.myInsertedRows.add(row);
    }

    public void insertColumn(@NotNull ModelIndex<GridColumn> idx, @NotNull GridColumn column) {
        if (idx == null) {
            MutationsStorageImpl.$$$reportNull$$$0(26);
        }
        if (column == null) {
            MutationsStorageImpl.$$$reportNull$$$0(27);
        }
        this.myInsertedColumns.put(idx, column);
    }

    public void renameColumn(@NotNull ModelIndex<GridColumn> idx, @NotNull String newName) {
        GridColumn column;
        if (idx == null) {
            MutationsStorageImpl.$$$reportNull$$$0(28);
        }
        if (newName == null) {
            MutationsStorageImpl.$$$reportNull$$$0(29);
        }
        if ((column = this.myInsertedColumns.get(idx)) == null) {
            return;
        }
        String className = column instanceof JdbcColumnDescriptor ? ((JdbcColumnDescriptor)column).getJavaClassName() : null;
        this.myInsertedColumns.put(idx, (GridColumn)new DataConsumer.Column(idx.asInteger(), newName, column.getType(), column.getTypeName(), className));
    }

    public void removeColumnFromDeleted(@NotNull ModelIndex<GridColumn> index) {
        if (index == null) {
            MutationsStorageImpl.$$$reportNull$$$0(30);
        }
        this.myDeletedColumns.remove(index);
    }

    private void clearColumn(@NotNull ModelIndex<GridColumn> column) {
        if (column == null) {
            MutationsStorageImpl.$$$reportNull$$$0(31);
        }
        this.myInsertedColumns.remove(column);
        this.myDeletedColumns.remove(column);
        this.myModifiedRowsCounter.deleteColumn(column);
        this.myRowsWithUnparsedValuesCounter.deleteColumn(column);
        for (int i = 0; i < this.myMaxRows; ++i) {
            if (this.myValues[i] == null) continue;
            this.myValues[i][column.asInteger()] = null;
        }
    }

    public void removeRowFromDeleted(@NotNull ModelIndex<GridRow> index) {
        if (index == null) {
            MutationsStorageImpl.$$$reportNull$$$0(32);
        }
        this.myDeletedRows.remove(index);
    }

    public void clearRow(@NotNull ModelIndex<GridRow> rowIdx) {
        if (rowIdx == null) {
            MutationsStorageImpl.$$$reportNull$$$0(33);
        }
        this.myInsertedRows.remove(rowIdx);
        this.myDeletedRows.remove(rowIdx);
        if (rowIdx.asInteger() < this.myRows) {
            this.myValues[rowIdx.asInteger()] = null;
        }
        this.myModifiedRowsCounter.deleteRow(rowIdx);
        this.myRowsWithUnparsedValuesCounter.deleteRow(rowIdx);
    }

    public void clearColumns() {
        this.myInsertedColumns.clear();
        this.myDeletedColumns.clear();
    }

    @Nullable
    public GridColumn getInsertedColumn(ModelIndex<GridColumn> idx) {
        return this.myInsertedColumns.get(idx);
    }

    private static MutationData @NotNull [][] copy(MutationData @NotNull [][] from, int rows, int columns) {
        if (from == null) {
            MutationsStorageImpl.$$$reportNull$$$0(34);
        }
        MutationData[][] newArray = new MutationData[rows][];
        for (int i = 0; i < from.length; ++i) {
            if (from[i] == null) continue;
            newArray[i] = new MutationData[columns];
            System.arraycopy(from[i], 0, newArray[i], 0, from[i].length);
        }
        if (newArray == null) {
            MutationsStorageImpl.$$$reportNull$$$0(35);
        }
        return newArray;
    }

    private int getIncreasedValue(int value) {
        return (int)Math.round((double)value * this.myMultiplier);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 13, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 16: 
            case 18: 
            case 20: 
            case 24: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 8: 
            case 13: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/MutationsStorageImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 10: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexes";
                break;
            }
            case 12: 
            case 22: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idx";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/MutationsStorageImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedRows";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findBiggerIndices";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "allocateSpace";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shiftUpColumn";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shiftUpRow";
                break;
            }
            case 8: 
            case 13: 
            case 35: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deleteColumn";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deleteRow";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findBiggerIndices";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getInner";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "countModifications";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isInsertedRow";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isInsertedColumn";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isDeletedRow";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isDeletedColumn";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "insertRow";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "insertColumn";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "renameColumn";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "removeColumnFromDeleted";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "clearColumn";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "removeRowFromDeleted";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "clearRow";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 13, 35 -> new IllegalStateException(string);
        };
    }

    private class ModifiedRowsCounter
    extends RowsCounter {
        private ModifiedRowsCounter() {
        }

        @Override
        protected int countModificationsInner(@Nullable CellMutation value, @Nullable MutationData oldValue, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
            boolean oldValueEqualToDatabase;
            if (row == null) {
                ModifiedRowsCounter.$$$reportNull$$$0(0);
            }
            if (column == null) {
                ModifiedRowsCounter.$$$reportNull$$$0(1);
            }
            boolean newValueEqualToDatabase = value == null || this.equalToDatabase(value.getValue(), row, column);
            boolean bl = oldValueEqualToDatabase = oldValue == null || this.equalToDatabase(oldValue.getValue(), row, column);
            return !newValueEqualToDatabase && oldValueEqualToDatabase ? 1 : (!oldValueEqualToDatabase && newValueEqualToDatabase ? -1 : 0);
        }

        boolean equalToDatabase(@Nullable Object value, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
            if (row == null) {
                ModifiedRowsCounter.$$$reportNull$$$0(2);
            }
            if (column == null) {
                ModifiedRowsCounter.$$$reportNull$$$0(3);
            }
            if (!MutationsStorageImpl.this.isValid(row, column) || MutationsStorageImpl.this.isInsertedRow(row) || MutationsStorageImpl.this.isInsertedColumn(column)) {
                return TypedValue.unwrap((Object)value) == ReservedCellValue.UNSET;
            }
            Object databaseValue = MutationsStorageImpl.this.myModel.getValueAt(row, column);
            return ObjectUtils.notNull((Object)databaseValue, (Object)ReservedCellValue.NULL) == ObjectUtils.notNull((Object)TypedValue.unwrap((Object)value), (Object)ReservedCellValue.NULL);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/MutationsStorageImpl$ModifiedRowsCounter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "countModificationsInner";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "equalToDatabase";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class RowsCounter {
        private final IntSet myRowsSet;
        private int[] myCount;

        RowsCounter() {
            this.myCount = new int[MutationsStorageImpl.this.myMaxRows];
            this.myRowsSet = new IntOpenHashSet(MutationsStorageImpl.this.myMaxRows);
        }

        void shiftUp(@NotNull ModelIndex<GridRow> row) {
            if (row == null) {
                RowsCounter.$$$reportNull$$$0(0);
            }
            int idx = row.asInteger();
            System.arraycopy(this.myCount, idx + 1, this.myCount, idx, MutationsStorageImpl.this.myRows - 1 - idx);
            this.myCount[MutationsStorageImpl.this.myRows - 1] = 0;
            this.myRowsSet.remove(idx);
            IntOpenHashSet newRowsSet = new IntOpenHashSet();
            IntIterator intIterator = this.myRowsSet.iterator();
            while (intIterator.hasNext()) {
                int oldRowIdx = (Integer)intIterator.next();
                if (oldRowIdx > idx) {
                    newRowsSet.add(oldRowIdx - 1);
                    continue;
                }
                newRowsSet.add(oldRowIdx);
            }
            this.myRowsSet.clear();
            this.myRowsSet.addAll((IntCollection)newRowsSet);
        }

        void deleteColumn(@NotNull ModelIndex<GridColumn> idx) {
            if (idx == null) {
                RowsCounter.$$$reportNull$$$0(1);
            }
            for (int i = 0; i < MutationsStorageImpl.this.myMaxRows; ++i) {
                MutationData oldValue = MutationsStorageImpl.this.myValues[i] == null ? null : MutationsStorageImpl.this.myValues[i][idx.asInteger()];
                this.countModifications(null, oldValue, (ModelIndex<GridRow>)ModelIndex.forRow(MutationsStorageImpl.this.myModel, (int)i), idx);
            }
        }

        void deleteRow(@NotNull ModelIndex<GridRow> idx) {
            int i;
            if (idx == null) {
                RowsCounter.$$$reportNull$$$0(2);
            }
            if ((i = idx.asInteger()) < MutationsStorageImpl.this.myRows) {
                this.myCount[i] = 0;
            }
            this.myRowsSet.remove(i);
        }

        public boolean isEmpty() {
            return this.myRowsSet.isEmpty();
        }

        public void clear() {
            this.myCount = new int[MutationsStorageImpl.this.myMaxRows];
            this.myRowsSet.clear();
        }

        public boolean contains(int row) {
            return this.myRowsSet.contains(row);
        }

        public void countModifications(@Nullable CellMutation value, @Nullable MutationData oldValue, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
            if (row == null) {
                RowsCounter.$$$reportNull$$$0(3);
            }
            if (column == null) {
                RowsCounter.$$$reportNull$$$0(4);
            }
            int n = row.asInteger();
            this.myCount[n] = this.myCount[n] + this.countModificationsInner(value, oldValue, row, column);
            if (this.myCount[row.asInteger()] > 0) {
                this.myRowsSet.add(row.asInteger());
                return;
            }
            this.myRowsSet.remove(row.asInteger());
        }

        protected abstract int countModificationsInner(@Nullable CellMutation var1, @Nullable MutationData var2, @NotNull ModelIndex<GridRow> var3, @NotNull ModelIndex<GridColumn> var4);

        public void reallocate() {
            int[] myNewCount = new int[MutationsStorageImpl.this.myMaxRows];
            System.arraycopy(this.myCount, 0, myNewCount, 0, this.myCount.length);
            this.myCount = myNewCount;
        }

        @NotNull
        public IntSet get() {
            IntSet intSet = this.myRowsSet;
            if (intSet == null) {
                RowsCounter.$$$reportNull$$$0(5);
            }
            return intSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "idx";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/MutationsStorageImpl$RowsCounter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/MutationsStorageImpl$RowsCounter";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "shiftUp";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteColumn";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteRow";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "countModifications";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    private class RowsWithUnparsedValuesCounter
    extends RowsCounter {
        private RowsWithUnparsedValuesCounter() {
        }

        @Override
        protected int countModificationsInner(@Nullable CellMutation value, @Nullable MutationData oldValue, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
            if (row == null) {
                RowsWithUnparsedValuesCounter.$$$reportNull$$$0(0);
            }
            if (column == null) {
                RowsWithUnparsedValuesCounter.$$$reportNull$$$0(1);
            }
            return RowsWithUnparsedValuesCounter.unwrap(value) instanceof UnparsedValue && !(RowsWithUnparsedValuesCounter.unwrap(oldValue) instanceof UnparsedValue) ? 1 : (RowsWithUnparsedValuesCounter.unwrap(oldValue) instanceof UnparsedValue && !(RowsWithUnparsedValuesCounter.unwrap(value) instanceof UnparsedValue) ? -1 : 0);
        }

        @Nullable
        private static Object unwrap(@Nullable CellMutation value) {
            return value == null ? null : value.getValue();
        }

        @Nullable
        private static Object unwrap(@Nullable MutationData value) {
            return value == null ? null : value.getValue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "row";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "column";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/MutationsStorageImpl$RowsWithUnparsedValuesCounter";
            objectArray[2] = "countModificationsInner";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

