<!--
SPDX-FileCopyrightText: © 2024 David Bliss

SPDX-License-Identifier: GFDL-1.3-or-later
-->

# Thumbnails

Fotema generates thumbnails for all of your library's images and videos
so that albums can be quickly displayed and scrolled.

## XDG thumbnail specification

Since version 2.0.0, Fotema generates thumbnails in a format that is compliant with the
[XDG thumbnail specification](https://specifications.freedesktop.org/thumbnail-spec/latest/index.html#history).

However, Fotema __does not__ store thumbnails in the XDG thumbnail specification standard
location (`~/.cache/thumbnails`). This means thumbnails generated by Fotema
will not be useable by other applications, such as your file manager.

### Why non-compliance?

The XDG thumbnail directory is automatically cleaned up by your desktop environment.
By default the cleanup policy is quite aggressive and Fotema will frequently spend
much CPU and wall-clock time re-generating thumbnails, thereby defeating one of the
stated goals of the thumbnail specification.

This leads to a pretty poor experience without changing the thumbnail
cache [cleanup policies](https://davejansen.com/increase-thumbnail-cache-in-ubuntu/).

## Thumbnail sizes

Fotema generates and uses the following thumbnail sizes:

| Size    | Dimension | Use |
|---------|-----------|--------------------|
| Small   | 64  | Narrow view on map album. |
| Normal  | 128 | Wide view on map album. Narrow view on other albums. |
| Large   | 256 | Wide view on albums. |
| X-Large | 512 | Input image for face detection. |
