import yoda,math
def patch(path, ao):
    # split dists and fix bin number -> x values
    if "BELLE_2023_I2624324" in path and ("d03" in path or "d06" in path) :
        bins = [[1.00, 1.05, 1.10, 1.15, 1.20, 1.25, 1.30, 1.35, 1.40, 1.45, 1.51],
                [-1.00, -0.80, -0.60, -0.40, -0.20, 0.00, 0.20, 0.40, 0.60, 0.80, 1.00],
                [-1.00, -0.80, -0.60, -0.40, -0.20, 0.00, 0.20, 0.40, 0.60, 0.80, 1.00]]
        bins.append([0.])
        xmin=0.
        while xmin<2.*math.pi :
            xmin+=math.pi/5.
            bins[-1].append(xmin)
        if "d06" in path : imax = 5
        else             : imax = 2
        output=[]
        for iy in range (1,imax) :
            for ix in range(1,5) :
                output.append(yoda.core.Scatter2D())
                output[-1].setPath(ao.path().replace("x01","x0%s"%ix).replace("y01","y0%s"%iy))
                for ipoint in range(0,10) :
                    p  = ao.points()[40*(iy-1)+10*(ix-1)+ipoint]
                    x  = 0.5*(bins[ix-1][ipoint+1]+bins[ix-1][ipoint])
                    dx = 0.5*(bins[ix-1][ipoint+1]-bins[ix-1][ipoint])
                    p.setX(x)
                    p.setXErrs(dx)
                    p.setY(0.5*p.y()/dx)
                    for (key,value) in p.errMap().items() :
                        temp=(0.5*value[0]/dx,0.5*value[1]/dx)
                        p.setYErrs(temp,key)
                    output[-1].addPoint(p)
        return output
    return ao
