%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0":  ["0x20F9B0697CD37844", "0x3B8E6EAE8C165248", "0x0000000000000000", "0x0000000000000000"],
    "XMM1":  ["0x1ED685B8691D35CA", "0x5DAE74E0AB7B51E2", "0x0000000000000000", "0x0000000000000000"],
    "XMM2":  ["0x15DC41A91EA818CC", "0x092363BC321300C5", "0x0000000000000000", "0x0000000000000000"],
    "XMM3":  ["0x20F9B0697CD37844", "0x3B8E6EAE8C165248", "0x0000000000000000", "0x0000000000000000"],
    "XMM4":  ["0x1ED685B8691D35CA", "0x5DAE74E0AB7B51E2", "0x0000000000000000", "0x0000000000000000"],
    "XMM5":  ["0x15DC41A91EA818CC", "0x092363BC321300C5", "0x0000000000000000", "0x0000000000000000"],
    "XMM10": ["0x20F9B0697CD37844", "0x3B8E6EAE8C165248", "0x20F9B0697CD37844", "0x3B8E6EAE8C165248"],
    "XMM11": ["0x1ED685B8691D35CA", "0x5DAE74E0AB7B51E2", "0x1ED685B8691D35CA", "0x5DAE74E0AB7B51E2"],
    "XMM12": ["0x15DC41A91EA818CC", "0x092363BC321300C5", "0x15DC41A91EA818CC", "0x092363BC321300C5"],
    "XMM13": ["0x20F9B0697CD37844", "0x3B8E6EAE8C165248", "0x20F9B0697CD37844", "0x3B8E6EAE8C165248"],
    "XMM14": ["0x1ED685B8691D35CA", "0x5DAE74E0AB7B51E2", "0x1ED685B8691D35CA", "0x5DAE74E0AB7B51E2"],
    "XMM15": ["0x15DC41A91EA818CC", "0x092363BC321300C5", "0x15DC41A91EA818CC", "0x092363BC321300C5"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd ymm6, [rdx + 32 * 1]
vmovapd ymm7, [rdx + 32 * 2]
vmovapd ymm8, [rdx + 32 * 3]
vmovapd ymm9, [rdx]

; 128-bit register only
vpavgw xmm0, xmm9, xmm6
vpavgw xmm1, xmm9, xmm7
vpavgw xmm2, xmm9, xmm8

; 128-bit memory operand
vpavgw xmm3, xmm9, [rdx + 32 * 1]
vpavgw xmm4, xmm9, [rdx + 32 * 2]
vpavgw xmm5, xmm9, [rdx + 32 * 3]

; 256-bit register only
vpavgw ymm10, ymm9, ymm6
vpavgw ymm11, ymm9, ymm7
vpavgw ymm12, ymm9, ymm8

; 256-bit memory operand
vpavgw ymm13, ymm9, [rdx + 32 * 1]
vpavgw ymm14, ymm9, [rdx + 32 * 2]
vpavgw ymm15, ymm9, [rdx + 32 * 3]

hlt

align 32
.data:
dq 0x2BB883523D4F3197
dq 0x1246C77764260189
dq 0x2BB883523D4F3197
dq 0x1246C77764260189

dq 0x163ADD80BC57BEF1
dq 0x64D615E5B405A306
dq 0x163ADD80BC57BEF1
dq 0x64D615E5B405A306

dq 0x11F4881D94EB39FC
dq 0xA9162248F2D0A23A
dq 0x11F4881D94EB39FC
dq 0xA9162248F2D0A23A

dq 0x0000000000000000
dq 0x0000000000000000
dq 0x0000000000000000
dq 0x0000000000000000
