/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.HashSet;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;
import org.xmlresolver.CatalogResolver;
import org.xmlresolver.NamespaceResolver;
import org.xmlresolver.ResolvedResource;
import org.xmlresolver.ResolvedResourceImpl;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.XMLResolverConfiguration;
import org.xmlresolver.logging.ResolverLogger;
import org.xmlresolver.sources.ResolverInputSource;
import org.xmlresolver.sources.ResolverLSInput;
import org.xmlresolver.sources.ResolverSAXSource;
import org.xmlresolver.utils.URIUtils;

public class Resolver
implements URIResolver,
EntityResolver,
EntityResolver2,
NamespaceResolver,
LSResourceResolver {
    public static final String PURPOSE_SCHEMA_VALIDATION = "http://www.rddl.org/purposes#schema-validation";
    public static final String NATURE_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String NATURE_XML_SCHEMA_1_1 = "http://www.w3.org/2001/XMLSchema/v1.1";
    public static final String NATURE_RELAX_NG = "http://relaxng.org/ns/structure/1.0";
    private final ResolverLogger logger;
    protected final XMLResolverConfiguration config;
    protected final CatalogResolver resolver;

    public Resolver() {
        this.config = new XMLResolverConfiguration();
        this.resolver = new CatalogResolver(this.config);
        this.logger = this.config.getFeature(ResolverFeature.RESOLVER_LOGGER);
    }

    public Resolver(XMLResolverConfiguration config) {
        this.config = config;
        this.resolver = new CatalogResolver(config);
        this.logger = config.getFeature(ResolverFeature.RESOLVER_LOGGER);
    }

    public Resolver(CatalogResolver resolver) {
        this.config = resolver.getConfiguration();
        this.resolver = resolver;
        this.logger = this.config.getFeature(ResolverFeature.RESOLVER_LOGGER);
    }

    public static String version() {
        return "5.3.3";
    }

    public XMLResolverConfiguration getConfiguration() {
        return this.resolver.getConfiguration();
    }

    public CatalogResolver getCatalogResolver() {
        return this.resolver;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        ResolvedResource rsrc = this.resolver.resolveURI(href, base);
        if (rsrc == null) {
            if (href == null || !this.config.getFeature(ResolverFeature.ALWAYS_RESOLVE).booleanValue()) {
                return null;
            }
            try {
                URI uri;
                URI uRI = uri = base == null ? null : new URI(base);
                if (!"".equals(href)) {
                    uri = uri == null ? new URI(href) : uri.resolve(href);
                }
                rsrc = this.openConnection(uri, false);
            }
            catch (IOException | IllegalArgumentException | URISyntaxException ex) {
                if (this.resolver.getConfiguration().getFeature(ResolverFeature.THROW_URI_EXCEPTIONS).booleanValue()) {
                    throw new TransformerException(ex);
                }
                return null;
            }
            if (rsrc == null) {
                return null;
            }
        }
        ResolverSAXSource source = new ResolverSAXSource(rsrc);
        source.setSystemId(rsrc.getResolvedURI().toString());
        return source;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (type == null || "http://www.w3.org/TR/REC-xml".equals(type)) {
            return this.lsResolveDtd(type, namespaceURI, publicId, systemId, baseURI);
        }
        return this.lsResolveSchema(type, namespaceURI, publicId, systemId, baseURI);
    }

    public LSInput lsResolveDtd(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        ResolvedResource rsrc = null;
        this.logger.log("request", "resolveResource: XML: %s (baseURI: %s, publicId: %s)", systemId, baseURI, publicId);
        rsrc = this.resolver.resolveEntity(null, publicId, systemId, baseURI);
        if (rsrc == null) {
            return null;
        }
        return new ResolverLSInput(rsrc, publicId);
    }

    public LSInput lsResolveSchema(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        ResolvedResource rsrc = null;
        this.logger.log("request", "resolveResource: %s, %s (namespace: %s, baseURI: %s, publicId: %s)", type, systemId, namespaceURI, baseURI, publicId);
        String purpose = null;
        if (NATURE_XML_SCHEMA.equals(type) || NATURE_XML_SCHEMA_1_1.equals(type) || NATURE_RELAX_NG.equals(type)) {
            purpose = PURPOSE_SCHEMA_VALIDATION;
        }
        if (systemId != null) {
            rsrc = this.resolver.resolveNamespace(systemId, baseURI, type, purpose);
        }
        if (rsrc == null) {
            rsrc = this.resolver.resolveNamespace(namespaceURI, baseURI, type, purpose);
        }
        if (rsrc == null) {
            return null;
        }
        return new ResolverLSInput(rsrc, publicId);
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        ResolvedResource rsrc = this.resolver.resolveEntity(name, null, null, baseURI);
        if (rsrc == null) {
            return null;
        }
        ResolverInputSource source = new ResolverInputSource(rsrc);
        source.setSystemId(rsrc.getResolvedURI().toString());
        return source;
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        ResolvedResource rsrc = this.resolver.resolveEntity(name, publicId, systemId, baseURI);
        if (rsrc == null) {
            if (systemId == null || !this.config.getFeature(ResolverFeature.ALWAYS_RESOLVE).booleanValue()) {
                return null;
            }
            rsrc = this.openConnection(systemId, baseURI, true);
            if (rsrc == null) {
                return null;
            }
        }
        ResolverInputSource source = new ResolverInputSource(rsrc);
        source.setSystemId(rsrc.getResolvedURI().toString());
        return source;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        ResolvedResource rsrc = this.resolver.resolveEntity(null, publicId, systemId, null);
        if (rsrc == null) {
            if (systemId == null || !this.config.getFeature(ResolverFeature.ALWAYS_RESOLVE).booleanValue()) {
                return null;
            }
            rsrc = this.openConnection(systemId, null, true);
            if (rsrc == null) {
                return null;
            }
        }
        ResolverInputSource source = new ResolverInputSource(rsrc);
        source.setSystemId(rsrc.getResolvedURI().toString());
        return source;
    }

    @Override
    public Source resolveNamespace(String uri, String nature, String purpose) throws TransformerException {
        ResolvedResource rsrc = this.resolver.resolveNamespace(uri, null, nature, purpose);
        if (rsrc == null) {
            return null;
        }
        ResolverSAXSource source = new ResolverSAXSource(rsrc.getLocalURI(), new InputSource(rsrc.getInputStream()));
        source.setSystemId(rsrc.getResolvedURI().toString());
        return source;
    }

    protected ResolvedResource openConnection(String uri, String baseURI, boolean asEntity) throws IOException {
        if (this.config.getFeature(ResolverFeature.FIX_WINDOWS_SYSTEM_IDENTIFIERS).booleanValue()) {
            uri = uri.replace("\\", "/");
            if (baseURI != null) {
                baseURI = baseURI.replace("\\", "/");
            }
        }
        try {
            URI absuri = baseURI == null ? URIUtils.cwd() : new URI(baseURI);
            absuri = absuri.resolve(uri);
            return this.openConnection(absuri, asEntity);
        }
        catch (IllegalArgumentException ex) {
            if (this.config.getFeature(ResolverFeature.THROW_URI_EXCEPTIONS).booleanValue()) {
                throw ex;
            }
            return null;
        }
        catch (URISyntaxException ex) {
            if (this.config.getFeature(ResolverFeature.THROW_URI_EXCEPTIONS).booleanValue()) {
                throw new IOException(ex);
            }
            return null;
        }
    }

    protected ResolvedResource openConnection(URI originalURI, boolean asEntity) throws IOException {
        boolean throwExceptions = this.config.getFeature(ResolverFeature.THROW_URI_EXCEPTIONS);
        HashSet<URI> seen = new HashSet<URI>();
        int count = 100;
        URI absoluteURI = originalURI;
        URLConnection connection = null;
        boolean done = false;
        int code = 200;
        boolean mergeHttps = this.config.getFeature(ResolverFeature.MERGE_HTTPS);
        String accessList = asEntity ? this.config.getFeature(ResolverFeature.ACCESS_EXTERNAL_ENTITY) : this.config.getFeature(ResolverFeature.ACCESS_EXTERNAL_DOCUMENT);
        while (!done) {
            if (URIUtils.forbidAccess(accessList, absoluteURI.toString(), mergeHttps)) {
                if (asEntity) {
                    this.logger.log("request", "resolveEntity, access denied: null", new Object[0]);
                } else {
                    this.logger.log("request", "resolveURI, access denied: null", new Object[0]);
                }
                return null;
            }
            if (seen.contains(absoluteURI)) {
                if (throwExceptions) {
                    throw new IOException("Redirect loop on " + absoluteURI);
                }
                return null;
            }
            if (count <= 0) {
                if (throwExceptions) {
                    throw new IOException("Too many redirects on " + absoluteURI);
                }
                return null;
            }
            seen.add(absoluteURI);
            --count;
            try {
                connection = absoluteURI.toURL().openConnection();
                connection.connect();
            }
            catch (Exception ex) {
                if (throwExceptions) {
                    throw ex;
                }
                return null;
            }
            done = !(connection instanceof HttpURLConnection);
            if (done) continue;
            HttpURLConnection conn = (HttpURLConnection)connection;
            code = conn.getResponseCode();
            if (code >= 300 && code < 400) {
                String loc = conn.getHeaderField("location");
                absoluteURI = absoluteURI.resolve(loc);
                continue;
            }
            done = true;
        }
        ResolvedResourceImpl rsrc = new ResolvedResourceImpl(originalURI, absoluteURI, connection.getInputStream(), code, connection.getHeaderFields());
        return rsrc;
    }
}

