# Cantera 3.1.0

Published on December 14, 2024 | [Full release on GitHub](https://github.com/Cantera/cantera/releases/tag/v3.1.0)

The Cantera development team is pleased to announce the availability of Cantera 3.1.0. There have been over [800 commits](https://github.com/Cantera/cantera/wiki/Cantera-3.1.0-Changelog) to Cantera since the last version, 3.0.0, which was released in August 2023. We have closed or merged [128 pull requests](https://github.com/Cantera/cantera/pulls?q=is%3Apr+merged%3A2023-08-23..2024-11-10+is%3Aclosed) and closed [81 issues](https://github.com/Cantera/cantera/issues?q=is%3Aissue+closed%3A2023-08-23..2024-12-14+is%3Aclosed) and [24 enhancement proposals](https://github.com/Cantera/enhancements/issues?q=is:issue+closed:2023-08-23..2024-12-14+is:closed). Instructions for installing Cantera 3.1 are available on the [Cantera website](/install/index).

## Highlights
- Render [examples](/examples/python/index) using Sphinx-gallery ([#1621](https://github.com/Cantera/cantera/pull/1621), [#1681](https://github.com/Cantera/cantera/pull/1681), [#1724](https://github.com/Cantera/cantera/pull/1724), [#1821](https://github.com/Cantera/cantera/pull/1821), [E#88](https://github.com/Cantera/enhancements/issues/88))
- Added visualizations of reactor networks; see [`mix1.py`](/examples/python/reactors/mix1) and [`reactor2.py`](/examples/python/reactors/reactor2) ([E#180](https://github.com/Cantera/enhancements/issues/180), [#1624](https://github.com/Cantera/cantera/pull/1624), [#1714](https://github.com/Cantera/cantera/pull/1714), [#1792](https://github.com/Cantera/cantera/pull/1792), [E#212](https://github.com/Cantera/enhancements/issues/212))
- Added ability to solve diffusion flames on the unstable branch using control of the temperature at two interior points; see [`diffusion_flame_continuation.py`](/examples/python/onedim/diffusion_flame_continuation) ([#1622](https://github.com/Cantera/cantera/pull/1622), [#1779](https://github.com/Cantera/cantera/pull/1779), [#1813](https://github.com/Cantera/cantera/pull/1813))
- Added the [`linear-Burke`](sec-linear-Burke) reaction rate parameterization which models pressure-dependent reactions with collider-specific behavior; see [`shock_tube.py`](/examples/python/kinetics/shock_tube), [`jet_stirred_reactor.py`](/examples/python/kinetics/jet_stirred_reactor), and [`flame_speed.py`](/examples/python/onedim/flame_speed) ([E#157](https://github.com/Cantera/enhancements/issues/157), [#1710](https://github.com/Cantera/cantera/pull/1710), [#1801](https://github.com/Cantera/cantera/pull/1801))
- Major expansion of documentation for [contributing to Cantera](/develop/index) and [understanding its internal workings](/reference/onedim/index) ([E#25](https://github.com/Cantera/enhancements/issues/25), [#1700](https://github.com/Cantera/cantera/pull/1700), [#1757](https://github.com/Cantera/cantera/pull/1757), [#1786](https://github.com/Cantera/cantera/pull/1786))
- Update website structure to keep all version-specific documentation together and simplify URLs ([E#145](https://github.com/Cantera/enhancements/issues/145), [E#146](https://github.com/Cantera/enhancements/issues/146), [#1631](https://github.com/Cantera/cantera/pull/1631), [#1638](https://github.com/Cantera/cantera/pull/1638), [#1647](https://github.com/Cantera/cantera/pull/1647), [#1657](https://github.com/Cantera/cantera/pull/1657), [#1657](https://github.com/Cantera/cantera/pull/1657), [#1737](https://github.com/Cantera/cantera/pull/1737), [#1766](https://github.com/Cantera/cantera/pull/1766), [#1790](https://github.com/Cantera/cantera/pull/1790))
- Significant refactoring of the `clib` interface, which is now declared *experimental* and subject to API changes without receiving deprecation warnings. ([E#211](https://github.com/Cantera/enhancements/issues/211), [E#199](https://github.com/Cantera/enhancements/issues/199), [#1741](https://github.com/Cantera/cantera/pull/1741), [#1752](https://github.com/Cantera/cantera/pull/1752), [#1760](https://github.com/Cantera/cantera/pull/1760), [#1769](https://github.com/Cantera/cantera/pull/1769), [#1773](https://github.com/Cantera/cantera/pull/1773), [#1780](https://github.com/Cantera/cantera/pull/1780))

## New features
- Add electron collision reactions (C++ class {ct}`ElectronCollisionPlasmaRate`) based on cross section data from the LXCat database; see [`plasma.py`](/examples/python/reactors/plasma) ([#1262](https://github.com/Cantera/cantera/pull/1262))
- Added an example demonstrating a 1D packed-bed reactor; see [`1D_packed_bed.py`](/examples/python/reactors/1D_packed_bed) ([E#43](https://github.com/Cantera/enhancements/issues/43))
- Added option to compute diffusive fluxes using mass fraction gradients in the 1D solver ([E#195](https://github.com/Cantera/enhancements/issues/195), [#1668](https://github.com/Cantera/cantera/pull/1668))
- Expose Peng-Robinson EoS parameters to Python interface ([#1664](https://github.com/Cantera/cantera/pull/1664))
- Created a new repository to clearly identify example input data and allow use of larger, more detailed mechanisms ([E#22](https://github.com/Cantera/enhancements/issues/22), [#1689](https://github.com/Cantera/cantera/pull/1689))
- Add HDF5 support to PyPI packages ([E#205](https://github.com/Cantera/enhancements/issues/205), ([#1727](https://github.com/Cantera/cantera/pull/1727))
- Add stack trace option to `CanteraError` for enhanced debugging ([#1730](https://github.com/Cantera/cantera/pull/1730))
- Enable cross compiling support without patches to simplify some package builds ([E#210](https://github.com/Cantera/enhancements/issues/210), [#1749](https://github.com/Cantera/cantera/pull/1749))
- Add support for Python 3.12 ([#1604](https://github.com/Cantera/cantera/pull/1604), [#1648](https://github.com/Cantera/cantera/pull/1648), [#1716](https://github.com/Cantera/cantera/pull/1716))
- Add compatibility with SUNDIALS 7.0 ([#1672](https://github.com/Cantera/cantera/pull/1672))
- Add compatibility with NumPy 2.0 ([#1706](https://github.com/Cantera/cantera/pull/1706), [#1713](https://github.com/Cantera/cantera/pull/1713))
- Support compilation in C++20 mode ([#1739](https://github.com/Cantera/cantera/pull/1739))
- Automatically adjust temperature bounds for low-temperature flames ([#1684](https://github.com/Cantera/cantera/issues/1684), [#1705](https://github.com/Cantera/cantera/pull/1705))
- Add BLAS/LAPACK support for PyPI packages on Linux and macOS ([#1797](https://github.com/Cantera/cantera/pull/1797))
- Add programmatic access to logging information about transport property fits ([#1824](https://github.com/Cantera/cantera/pull/1824))

## Changes to existing capabilities
- Refactored implementation of 1D flame governing equations ([#1595](https://github.com/Cantera/cantera/pull/1595), [#1619](https://github.com/Cantera/cantera/pull/1619))
- Improvements to 1D solver logging ([#1660](https://github.com/Cantera/cantera/pull/1660), [#1759](https://github.com/Cantera/cantera/pull/1759))
- Significant improvements to error messages reported when converting mechanisms using `ck2yaml` ([#1669](https://github.com/Cantera/cantera/pull/1669), [#1736](https://github.com/Cantera/cantera/pull/1736))
- Improved handling of edge cases involving third body colliders and "duplicate" reactions ([#1696](https://github.com/Cantera/cantera/pull/1696))
- Improve distinction between selecting `none` and `default` transport models ([#1680](https://github.com/Cantera/cantera/issues/1680), [#1705](https://github.com/Cantera/cantera/pull/1705))
- Improve error message for flames initialized with bad boundary conditions ([#1694](https://github.com/Cantera/cantera/issues/1694), [#1705](https://github.com/Cantera/cantera/pull/1705))
- Disallow redundant flame grid specification ([#1693](https://github.com/Cantera/cantera/issues/1693), [#1705](https://github.com/Cantera/cantera/pull/1705))
- Simplify YAML input for extensible interface reactions ([#1709](https://github.com/Cantera/cantera/pull/1709))
- Improve consistency of `Func1` API between Matlab and Python interfaces ([#1758](https://github.com/Cantera/cantera/pull/1758), [#1798](https://github.com/Cantera/cantera/pull/1798))
- Use `Solution` objects to store reactor contents ([#1663](https://github.com/Cantera/cantera/pull/1663), [#1685](https://github.com/Cantera/cantera/pull/1685))
- Move locks that prevent adding species to `ThermoPhase` objects that are in use from Python to C++ ([#1686](https://github.com/Cantera/cantera/pull/1686))
- Use Jinja templates in C# `sourcegen` ([#1785](https://github.com/Cantera/cantera/pull/1785))
- Update `ck2yaml` to use `argparse` ([#1616](https://github.com/Cantera/cantera/pull/1616))
- Make names generated for reactor network objects reproducible ([#1765](https://github.com/Cantera/cantera/pull/1765))
- Make generated sources and error messages deterministic ([#1804](https://github.com/Cantera/cantera/pull/1804))
- Remove features deprecated in Cantera 3.0. ([#1605](https://github.com/Cantera/cantera/pull/1605))
- Remove legacy Matlab toolbox ([E#196](https://github.com/Cantera/enhancements/issues/196), [#1670](https://github.com/Cantera/cantera/pull/1670), [#1688](https://github.com/Cantera/cantera/pull/1688))
- Remove `python_minimal` interface ([E#208](https://github.com/Cantera/enhancements/issues/208), [#1745](https://github.com/Cantera/cantera/pull/1745))
- Expanded automated CI testing and other CI maintenance ([#1608](https://github.com/Cantera/cantera/pull/1608), [#1612](https://github.com/Cantera/cantera/pull/1612), [#1630](https://github.com/Cantera/cantera/pull/1630), [#1652](https://github.com/Cantera/cantera/pull/1652), [#1662](https://github.com/Cantera/cantera/pull/1662), [#1671](https://github.com/Cantera/cantera/pull/1671), [#1677](https://github.com/Cantera/cantera/pull/1677), [#1703](https://github.com/Cantera/cantera/pull/1703), [#1738](https://github.com/Cantera/cantera/pull/1738), [#1752](https://github.com/Cantera/cantera/pull/1752), [#1808](https://github.com/Cantera/cantera/pull/1808), [#1815](https://github.com/Cantera/cantera/pull/1815), [#1818](https://github.com/Cantera/cantera/pull/1818))
- Various documentation updates ([#1618](https://github.com/Cantera/cantera/pull/1618), [#1659](https://github.com/Cantera/cantera/pull/1659), [#1702](https://github.com/Cantera/cantera/pull/1702), [#1795](https://github.com/Cantera/cantera/pull/1795), [#1803](https://github.com/Cantera/cantera/pull/1803), [#1807](https://github.com/Cantera/cantera/pull/1807), [#1810](https://github.com/Cantera/cantera/pull/1810), [#1817](https://github.com/Cantera/cantera/pull/1817), [#1826](https://github.com/Cantera/cantera/pull/1826))
- Various build system updates ([#1723](https://github.com/Cantera/cantera/pull/1723), [#1746](https://github.com/Cantera/cantera/pull/1746), [#1750](https://github.com/Cantera/cantera/pull/1750), [#1755](https://github.com/Cantera/cantera/pull/1755), [#1768](https://github.com/Cantera/cantera/pull/1768), [#1782](https://github.com/Cantera/cantera/pull/1782), [#1791](https://github.com/Cantera/cantera/pull/1791), [E#209](https://github.com/Cantera/enhancements/issues/209), [#1820](https://github.com/Cantera/cantera/pull/1820))
- Fix some compiler warnings ([#1729](https://github.com/Cantera/cantera/pull/1729))
- Maintenance of the sdist / PyPI packages ([#1625](https://github.com/Cantera/cantera/pull/1625), [#1708](https://github.com/Cantera/cantera/pull/1708), [#1796](https://github.com/Cantera/cantera/pull/1796))
- Address some website accessibility issues ([E#41](https://github.com/Cantera/enhancements/issues/41), [#1753](https://github.com/Cantera/cantera/pull/1753))
- Complete transition of the Python test suite to use `pytest` instead of the `unittest` module ([#1793](https://github.com/Cantera/cantera/pull/1793))
- Update generated `CMakeLists.txt` files ([#1742](https://github.com/Cantera/cantera/issues/1742), [#1744](https://github.com/Cantera/cantera/pull/1744))
- Provide better error checking and messages in Python `Quantity` class ([#1816](https://github.com/Cantera/cantera/pull/1816))
- Improve error handling with cubic equation solver used for Redlich-Kwong and Peng-Robinson phases ([#1819](https://github.com/Cantera/cantera/pull/1819))

## Bugs fixed
- Fix missing porosity in `PorousMediaBurner.py` ([#1617](https://github.com/Cantera/cantera/pull/1617))
- Fix various issues in the experimental Matlab toolbox and add missing functions ([#1586](https://github.com/Cantera/cantera/pull/1586), [#1701](https://github.com/Cantera/cantera/pull/1701), [#1761](https://github.com/Cantera/cantera/pull/1761))
- Fix converting surface mechanisms that use a separate thermo data file ([#1637](https://github.com/Cantera/cantera/pull/1637))
- Use midpoint properties for diffusion fluxes in 1D solver ([E#187](https://github.com/Cantera/enhancements/issues/187), [#1626](https://github.com/Cantera/cantera/pull/1626))
- Fix access to `Solution` report when using `with_units` ([#1650](https://github.com/Cantera/cantera/pull/1650))
- Prevent segfaults from accessing partially-constructed reactor objects ([#1661](https://github.com/Cantera/cantera/pull/1661))
- Fix setting diffusion flame initial guess from known data ([#1674](https://github.com/Cantera/cantera/issues/1674), [#1705](https://github.com/Cantera/cantera/pull/1705))
- Fix issues with slicing `SolutionArray` ([#1725](https://github.com/Cantera/cantera/pull/1725), [#1726](https://github.com/Cantera/cantera/pull/1726))
- Fix `yaml2ck` handling of multiline `note` fields and phases with no reactions ([#1733](https://github.com/Cantera/cantera/pull/1733))
- Fix a memory leak when reinitializing a reactor using the GMRES sparse solver ([#1732](https://github.com/Cantera/cantera/pull/1732))
- Fix YAML serialization of changes to reaction/species flags with default values that are normally omitted ([#1629](https://github.com/Cantera/cantera/issues/1629), [#1740](https://github.com/Cantera/cantera/pull/1740))
- Fix serialization of `note` fields that can be erroneously interpreted as integers ([#1610](https://github.com/Cantera/cantera/issues/1610), [#1740](https://github.com/Cantera/cantera/pull/1740))
- Fix YAML serialization of multiline strings ([#1695](https://github.com/Cantera/cantera/issues/1695), [#1740](https://github.com/Cantera/cantera/pull/1740))
- Fix garbage collection-related segfault with `CustomRate` ([#1763](https://github.com/Cantera/cantera/pull/1763))
- Fix compatibility with SUNDIALS 6.0 and 6.1 ([#1774](https://github.com/Cantera/cantera/pull/1774))
- Fix overwriting and ordering of components when outputting `SolutionArray` to YAML ([#1775](https://github.com/Cantera/cantera/pull/1775), [#1781](https://github.com/Cantera/cantera/pull/1781))
- Fix use of `kineticsSpeciesIndex` in `diamond_cvd` examples ([#1814](https://github.com/Cantera/cantera/pull/1814))
- Fix spatial scaling in `MultiTransport::getMassFluxes` and `getMolarFluxes` and improve testing of transport calculations ([#1825](https://github.com/Cantera/cantera/pull/1825))

## Contributors

This release was made possible by the following contributors: [@BangShiuh](https://github.com/BangShiuh), [@Naikless](https://github.com/Naikless), [@bryanwweber](https://github.com/bryanwweber), [@corykinney](https://github.com/corykinney), [@cpilko](https://github.com/cpilko), [@d-e-t](https://github.com/d-e-t), [@decaluwe](https://github.com/decaluwe), [@dholland88](https://github.com/dholland88), [@g3bk47](https://github.com/g3bk47), [@guusbertens](https://github.com/guusbertens), [@ischoegl](https://github.com/ischoegl), [@keszybz](https://github.com/keszybz), [@martey](https://github.com/martey), [@matthiasdiener](https://github.com/matthiasdiener), [@mefuller](https://github.com/mefuller), [@pjsingal](https://github.com/pjsingal), [@speth](https://github.com/speth), [@ssun30](https://github.com/ssun30), [@wandadars](https://github.com/wandadars)
