# Cantera 2.3.0

Published on January 19, 2017 | [Full release on GitHub](https://github.com/Cantera/cantera/releases/tag/v2.3.0)

## Installation Options

- Conda / anaconda packages for Windows, Linux, and macOS via the `cantera` channel. See [installation instructions](https://cantera.org/2.3/sphinx/html/install.html) for more details.
- Windows binary installers (downloads below; To use the Matlab toolbox on Windows, install both `Cantera-2.3.0-x64.msi` and one of the Python modules. The Python installers are standalone and do not require the base Cantera package. Installers are available Python 2.7, Python 3.4, Python 3.5, and Python 3.6. See [detailed instructions](https://cantera.org/2.3/sphinx/html/install.html#windows) for more.
- Ubuntu packages for 16.04 (Xenial Xerus) and 16.10 (Yakkety Yak) are available via the PPA at https://launchpad.net/~speth/+archive/ubuntu/cantera. Additional details available [here](https://cantera.org/2.3/sphinx/html/install.html#ubuntu).
- Homebrew formula for macOS. See [additional instructions](https://cantera.org/2.3/sphinx/html/install.html#homebrew).
- Download and compile the source code. Full instructions [here](https://cantera.org/2.3/sphinx/html/compiling/index.html).

## Documentation

Documentation for Cantera 2.3.0 can be found at <https://cantera.org/2.3/sphinx/html/index.html>.

## Changes in Cantera 2.3.0

Highlights are listed here. See the [full changelog](https://github.com/Cantera/cantera/pull/399#issuecomment-263736973) for more.

- Add ability to modify species data for existing Phase objects
- Make species names case-preserving instead of case-sensitive, and allow colons in species names
- Add option for Motz & Wise correction to sticking reactions
- Implement enthalpy of formation sensitivity analysis for reactor networks
- Implement the Cython function `advance_to_steady_state` for reactor networks
- Eliminate most known 1D flame solver failures by improving Jacobian evaluation, and using better default initial grids and initial guesses
- Introduce 'auto' option to `Sim1D.solve` to automatically try multiple initial grids
- Generalize initial profile generation for diffusion flames for arbitrary fuel/oxidizer combinations
- Add general support for calculating adjoint sensitivities for 1D flames
- Add a Twin Premixed Counterflow Flame class and example
- Support conversion of surface mechanism files
- Provide better error message for problematic reaction and thermo entries when converting input files
- Add 'nonreactant_orders' option to allow non-reactant orders
- Allow adding species / reactions from Python
- Add new classes `Quantity` and `SolutionArray` to Python
- Make Python test suite runnable from an installed copy of the Python module
- Introduced Continuous Integration testing using Travis CI and AppVeyor
- Use Git submodules for Sundials, Eigen, Google Test, and libfmt if system versions are not installed
- Use Sundials and Eigen to eliminate the need for bundled LAPACK
- Added Conda build recipe and made binaries available through anaconda.org
- Add support for Sundials 2.7
- Deprecate unused classes, functions, arguments, and constants (see <https://cantera.org/2.3/doxygen/html/deprecated.html> for details)
- Add notices to documentation for classes with no tests or examples (see https://github.com/Cantera/cantera/issues/267)
- Make clib usable as a pure C (not C++) interface and add tests
