// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

package environments

func baseEnvironmentWithName(name string) Environment {
	return Environment{
		Name: name,

		// MicrosoftGraph and ResourceManager should always be overridden
		MicrosoftGraph:  applicationIdOnly("MicrosoftGraph", microsoftGraphAppId),
		ResourceManager: applicationIdOnly("ResourceManager", azureServiceManagementAppId),

		// The Api which are defined below are Application IDs which are common to all Environments
		// to define these in one place but have these available in all Environments.
		AnalysisServices:                  applicationIdOnly("AzureAnalysisServices", analysisServicesAppId),
		ApiManagement:                     applicationIdOnly("ApiManagement", apiManagementAppId),
		AppConfiguration:                  applicationIdOnly("AzureAppConfiguration", appConfigurationAppId),
		AppService:                        applicationIdOnly("AzureAppService", appServiceAppId),
		ApplicationInsights:               applicationIdOnly("ApplicationInsights", applicationInsightsAppId),
		Attestation:                       applicationIdOnly("AttestationService", attestationServiceAppId),
		AzureADIdentityGovernanceInsights: applicationIdOnly("AzureAdIdentityGovernanceInsights", azureAdIdentityGovernanceInsightsAppId),
		AzureADIntegratedApp:              applicationIdOnly("AzureAdIntegratedApp", azureAdIntegratedAppAppId),
		AzureADNotification:               applicationIdOnly("AzureAdNotification", azureAdNotificationAppId),
		AzureDevOps:                       applicationIdOnly("AzureDevOps", azureDevOpsAppId),
		AzureServiceManagement:            applicationIdOnly("AzureServiceManagement", azureServiceManagementAppId),
		AzureVPN:                          applicationIdOnly("AzureVPN", azureVPNAppId),
		Batch:                             applicationIdOnly("AzureBatch", batchAppId),
		Bing:                              applicationIdOnly("Bing", bingAppId),
		BotFrameworkDevPortal:             applicationIdOnly("BotFrameworkDevPortal", botFrameworkDevPortalAppId),
		BranchConnectWebService:           applicationIdOnly("BranchConnectWebService", branchConnectWebServiceAppId),
		CDNFrontDoor:                      applicationIdOnly("CDNFrontDoor", cdnFrontDoorAppId),
		Cognitive:                         applicationIdOnly("CognitiveServices", cognitiveServicesAppId),
		ComputeRecommendations:            applicationIdOnly("ComputeRecommendationService", computeRecommendationServiceAppId),
		Connections:                       applicationIdOnly("ConnectionsService", connectionsServiceAppId),
		ContainerRegistry:                 applicationIdOnly("AzureContainerRegistry", containerRegistryAppId),
		CortanaAtWork:                     applicationIdOnly("CortanaAtWorkService", cortanaAtWorkServiceAppId),
		CortanaRuntime:                    applicationIdOnly("CortanaRuntimeService", cortanaRuntimeServiceAppId),
		CortanaAtWorkBing:                 applicationIdOnly("CortanaAtWorkBingServices", cortanaAtWorkBingServicesAppId),
		CosmosDB:                          applicationIdOnly("CosmosDB", cosmosDBAppId),
		CustomerInsights:                  applicationIdOnly("CustomerInsights", customerInsightsAppId),
		DataBricks:                        applicationIdOnly("AzureDataBricks", dataBricksAppId),
		DataCatalog:                       applicationIdOnly("AzureDataCatalog", dataCatalogAppId),
		DataMigrations:                    applicationIdOnly("DataMigrationService", dataMigrationsServiceAppId),
		DataLake:                          applicationIdOnly("AzureDataLake", dataLakeAppId),
		DigitalTwins:                      applicationIdOnly("AzureDigitalTwins", digitalTwinsAppId),
		DomainController:                  applicationIdOnly("DomainControllerServices", domainControllerServiceAppId),
		Dynamic365BusinessCentral:         applicationIdOnly("Dynamic365BusinessCentral", dynamic365BusinessCentralAppId),
		Dynamics365DataExportService:      applicationIdOnly("Dynamics365DataExportService", dynamics365DataExportServiceAppId),
		DynamicsCRM:                       applicationIdOnly("DynamicsCrm", dynamicsCRMAppId),
		DynamicsERP:                       applicationIdOnly("DynamicsErp", dynamicsERPAppId),
		EventHubs:                         applicationIdOnly("AzureEventHubs", eventHubsAppId),
		Flow:                              applicationIdOnly("FlowService", flowServiceAppId),
		HDInsight:                         applicationIdOnly("AzureHdInsightCluster", hdinsightClusterAppId),
		HealthCare:                        applicationIdOnly("AzureHealthcare", healthCareAppId),
		GraphConnector:                    applicationIdOnly("GraphConnectorService", graphConnectorServiceAppId),
		IamSupportability:                 applicationIdOnly("AzureIamSupportability", iamSupportabilityAppId),
		ImportExport:                      applicationIdOnly("AzureImportExport", importExportAppId),
		InformationProtectionSyncService:  applicationIdOnly("InformationProtectionSyncService", informationProtectionSyncServiceAppId),
		InTune:                            applicationIdOnly("InTune", inTuneAppId),
		IoTCentral:                        applicationIdOnly("AzureIotCentral", iotCentralAppId),
		IoTHubDeviceProvisioning:          applicationIdOnly("AzureIotHubDeviceProvisioning", iotHubDeviceProvisioningAppId),
		KeyVault:                          applicationIdOnly("KeyVault", keyVaultAppId),
		KubernetesServiceAADServer:        applicationIdOnly("AzureKubernetesServiceAadServer", kubernetesServiceAadServerAppId),
		Kusto:                             applicationIdOnly("KustoService", kustoServiceAppId),
		KustoMFA:                          applicationIdOnly("KustoServiceMFA", kustoServiceMFAAppId),
		LogAnalytics:                      applicationIdOnly("LogAnalytics", logAnalyticsAppId),
		ManagedHSM:                        applicationIdOnly("ManagedHSM", managedHSMAppId),
		Maps:                              applicationIdOnly("AzureMaps", mapsAppId),
		MariaDB:                           applicationIdOnly("MariaDB", ossRDBMSAppId),
		MediaServices:                     applicationIdOnly("AzureMediaServices", mediaServicesAppId),
		MicrosoftAzureCli:                 applicationIdOnly("MicrosoftAzureCli", microsoftAzureCliAppId),
		Microsoft365DataAtRestEncryption:  applicationIdOnly("Microsoft365DataAtRestEncryption", microsoft365DataAtRestEncryptionAppId),
		MicrosoftInvoicing:                applicationIdOnly("MicrosoftInvoicing", microsoftInvoicingAppId),
		MicrosoftOffice:                   applicationIdOnly("MicrosoftOffice", microsoftOfficeAppId),
		MicrosoftStorageSync:              applicationIdOnly("MicrosoftStorageSync", microsoftStorageSyncAppId),
		MicrosoftTeams:                    applicationIdOnly("MicrosoftTeams", microsoftTeamsAppId),
		MicrosoftTeamsWebClient:           applicationIdOnly("MicrosoftTeamsWebClient", microsoftTeamsWebClientAppId),
		MileIqAdminCenter:                 applicationIdOnly("MileIqAdminCenter", mileIqAdminCenterAppId),
		MileIqDashboard:                   applicationIdOnly("MileIqDashboard", mileIqDashboardAppId),
		MileIqRestService:                 applicationIdOnly("MileIqRestService", mileIqRestServiceAppId),
		MixedReality:                      applicationIdOnly("MixedReality", mixedRealityAppId),
		MySql:                             applicationIdOnly("MySql", ossRDBMSAppId),
		Office365Connectors:               applicationIdOnly("Office365Connectors", office365ConnectorsAppId),
		Office365Demeter:                  applicationIdOnly("Office365Demeter", office365DemeterAppId),
		Office365DwEngineV2:               applicationIdOnly("Office365DwEngineV2", office365DwEngineV2AppId),
		Office365ExchangeOnline:           applicationIdOnly("Office365ExchangeOnline", office365ExchangeOnlineAppId),
		Office365ExchangeOnlineProtection: applicationIdOnly("Office365ExchangeOnlineProtection", office365ExchangeOnlineProtectionAppId),
		Office365InformationProtection:    applicationIdOnly("Office365InformationProtection", office365InformationProtectionAppId),
		Office365Management:               applicationIdOnly("Office365Management", office365ManagementAppId),
		Office365Portal:                   applicationIdOnly("Office365Portal", office365PortalAppId),
		Office365SharePointOnline:         applicationIdOnly("Office365SharePointOnline", office365SharePointOnlineAppId),
		Office365SuiteUx:                  applicationIdOnly("Office365SuiteUx", office365SuiteUxAppId),
		Office365Zoom:                     applicationIdOnly("Office365Zoom", office365ZoomAppId),
		OfficeHome:                        applicationIdOnly("OfficeHome", officeHomeAppId),
		OfficeUwpPwa:                      applicationIdOnly("OfficeUwpPwa", officeUwpPwaAppId),
		OneNote:                           applicationIdOnly("OneNote", oneNoteAppId),
		OneProfile:                        applicationIdOnly("OneProfileService", oneProfileServiceAppId),
		OperationalInsights:               applicationIdOnly("OperationalInsights", logAnalyticsAppId),
		OSSRDMBS:                          applicationIdOnly("OssRdbms", ossRDBMSAppId),
		OSSRDBMSPostgreSQLFlexibleServerAadAuthentication: applicationIdOnly("OssRdbmsPostgreSqlFlexibleServerAadAuthentication", ossRdbmsPostgreSqlFlexibleServerAadAuthenticationAppId),
		PeopleCards:             applicationIdOnly("PeopleCardsService", peopleCardsServiceAppId),
		PolicyAdministration:    applicationIdOnly("PolicyAdministrationService", policyAdministrationServiceAppId),
		Portal:                  applicationIdOnly("AzurePortal", portalAppId),
		Postgresql:              applicationIdOnly("Postgresql", ossRDBMSAppId),
		PowerAppsRuntime:        applicationIdOnly("PowerAppsRuntime", powerAppsRuntimeServiceAppId),
		PowerAppsRuntimeService: applicationIdOnly("PowerAppsRuntimeService", powerAppsRuntimeServiceAppId),
		PowerBiService:          applicationIdOnly("PowerBiService", powerBiServiceAppId),
		Purview:                 applicationIdOnly("Purview", purviewAppId),
		RightsManagement:        applicationIdOnly("RightsManagementServices", rightsManagementServiceAppId),
		SecurityInsights:        applicationIdOnly("AzureSecurityInsights", securityInsightsAppId),
		ServiceBus:              applicationIdOnly("AzureServiceBus", serviceBusAppId),
		ServiceDeploy:           applicationIdOnly("AzureServiceDeploy", serviceDeployAppId),
		ServiceTrust:            applicationIdOnly("ServiceTrust", serviceTrustAppId),
		SkypeForBusinessOnline:  applicationIdOnly("SkypeForBusinessOnline", skypeForBusinessOnlineAppId),
		Signup:                  applicationIdOnly("Signup", signupAppId),
		Sql:                     applicationIdOnly("AzureSqlDatabase", sqlDatabaseAppId),
		SpeechRecognition:       applicationIdOnly("SpeechRecognition", speechRecognitionAppId),
		StackHCI:                applicationIdOnly("AzureStackHciService", stackHciServiceAppId),
		StreamAnalytics:         applicationIdOnly("AzureStreamAnalytics", streamAnalyticsAppId),
		Storage:                 applicationIdOnly("AzureStorage", storageAppId),
		StorageSync:             applicationIdOnly("StorageSync", storageSyncAppId),
		Synapse:                 applicationIdOnly("Synapse", synapseAppId),
		SynapseGateway:          applicationIdOnly("AzureSynapseGateway", synapseGatewayAppId),
		SynapseStudio:           applicationIdOnly("AzureSynapseStudio", synapseStudioAppId),
		TargetedMessaging:       applicationIdOnly("TargetedMessagingService", targetedMessagingServiceAppId),
		Teams:                   applicationIdOnly("TeamsServices", teamsServiceAppId),
		ThreatProtection:        applicationIdOnly("ThreatProtection", threatProtectionAppId),
		TimeSeriesInsights:      applicationIdOnly("AzureTimeSeriesInsights", timeSeriesInsightsAppId),
		TrafficManager:          applicationIdOnly("TrafficManager", trafficManagerAppId),
		UniversalPrint:          applicationIdOnly("UniversalPrint", universalPrintAppId),
		WindowsDefenderATP:      applicationIdOnly("WindowsDefenderAtp", windowsDefenderAtpAppId),
		WindowsVirtualDesktop:   applicationIdOnly("WindowsVirtualDesktop", windowsVirtualDesktopAppId),
		Yammer:                  applicationIdOnly("Yammer", yammerAppId),
	}
}
