//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-quartz-core")]
#[cfg(not(target_os = "watchos"))]
use objc2_quartz_core::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UITableViewStyle(pub NSInteger);
impl UITableViewStyle {
    #[doc(alias = "UITableViewStylePlain")]
    pub const Plain: Self = Self(0);
    #[doc(alias = "UITableViewStyleGrouped")]
    pub const Grouped: Self = Self(1);
    #[doc(alias = "UITableViewStyleInsetGrouped")]
    pub const InsetGrouped: Self = Self(2);
}

unsafe impl Encode for UITableViewStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UITableViewStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewscrollposition?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UITableViewScrollPosition(pub NSInteger);
impl UITableViewScrollPosition {
    #[doc(alias = "UITableViewScrollPositionNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "UITableViewScrollPositionTop")]
    pub const Top: Self = Self(1);
    #[doc(alias = "UITableViewScrollPositionMiddle")]
    pub const Middle: Self = Self(2);
    #[doc(alias = "UITableViewScrollPositionBottom")]
    pub const Bottom: Self = Self(3);
}

unsafe impl Encode for UITableViewScrollPosition {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UITableViewScrollPosition {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewrowanimation?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UITableViewRowAnimation(pub NSInteger);
impl UITableViewRowAnimation {
    #[doc(alias = "UITableViewRowAnimationFade")]
    pub const Fade: Self = Self(0);
    #[doc(alias = "UITableViewRowAnimationRight")]
    pub const Right: Self = Self(1);
    #[doc(alias = "UITableViewRowAnimationLeft")]
    pub const Left: Self = Self(2);
    #[doc(alias = "UITableViewRowAnimationTop")]
    pub const Top: Self = Self(3);
    #[doc(alias = "UITableViewRowAnimationBottom")]
    pub const Bottom: Self = Self(4);
    #[doc(alias = "UITableViewRowAnimationNone")]
    pub const None: Self = Self(5);
    #[doc(alias = "UITableViewRowAnimationMiddle")]
    pub const Middle: Self = Self(6);
    #[doc(alias = "UITableViewRowAnimationAutomatic")]
    pub const Automatic: Self = Self(100);
}

unsafe impl Encode for UITableViewRowAnimation {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UITableViewRowAnimation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// A setting for which items in the table view should tightly hug their content
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewcontenthuggingelements?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UITableViewContentHuggingElements(pub NSInteger);
bitflags::bitflags! {
    impl UITableViewContentHuggingElements: NSInteger {
/// A content hugging mode where none of the items in the table view tightly hug their content
        #[doc(alias = "UITableViewContentHuggingElementsNone")]
        const None = 0;
/// A content hugging mode where section headers in the table view tightly hug their content
        #[doc(alias = "UITableViewContentHuggingElementsSectionHeaders")]
        const SectionHeaders = 1<<0;
    }
}

unsafe impl Encode for UITableViewContentHuggingElements {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UITableViewContentHuggingElements {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewindexsearch?language=objc)
    pub static UITableViewIndexSearch: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewautomaticdimension?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static UITableViewAutomaticDimension: CGFloat;
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewrowactionstyle?language=objc)
// NS_ENUM
#[deprecated = "Use UIContextualAction and related APIs instead."]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UITableViewRowActionStyle(pub NSInteger);
impl UITableViewRowActionStyle {
    #[doc(alias = "UITableViewRowActionStyleDefault")]
    #[deprecated = "Use UIContextualAction and related APIs instead."]
    pub const Default: Self = Self(0);
    #[doc(alias = "UITableViewRowActionStyleDestructive")]
    #[deprecated = "Use UIContextualAction and related APIs instead."]
    pub const Destructive: Self = Self(UITableViewRowActionStyle::Default.0);
    #[doc(alias = "UITableViewRowActionStyleNormal")]
    #[deprecated = "Use UIContextualAction and related APIs instead."]
    pub const Normal: Self = Self(1);
}

unsafe impl Encode for UITableViewRowActionStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UITableViewRowActionStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewrowaction?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[deprecated = "Use UIContextualAction and related APIs instead."]
    pub struct UITableViewRowAction;
);

extern_conformance!(
    unsafe impl NSCopying for UITableViewRowAction {}
);

unsafe impl CopyingHelper for UITableViewRowAction {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UITableViewRowAction {}
);

impl UITableViewRowAction {
    extern_methods!(
        #[cfg(feature = "block2")]
        #[deprecated = "Use UIContextualAction and related APIs instead."]
        #[unsafe(method(rowActionWithStyle:title:handler:))]
        #[unsafe(method_family = none)]
        pub fn rowActionWithStyle_title_handler(
            style: UITableViewRowActionStyle,
            title: Option<&NSString>,
            handler: &block2::DynBlock<dyn Fn(NonNull<UITableViewRowAction>, NonNull<NSIndexPath>)>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[deprecated = "Use UIContextualAction and related APIs instead."]
        #[unsafe(method(style))]
        #[unsafe(method_family = none)]
        pub fn style(&self) -> UITableViewRowActionStyle;

        #[deprecated = "Use UIContextualAction and related APIs instead."]
        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        pub fn title(&self) -> Option<Retained<NSString>>;

        /// Setter for [`title`][Self::title].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[deprecated = "Use UIContextualAction and related APIs instead."]
        #[unsafe(method(setTitle:))]
        #[unsafe(method_family = none)]
        pub fn setTitle(&self, title: Option<&NSString>);

        #[cfg(feature = "UIColor")]
        #[deprecated = "Use UIContextualAction and related APIs instead."]
        #[unsafe(method(backgroundColor))]
        #[unsafe(method_family = none)]
        pub fn backgroundColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`backgroundColor`][Self::backgroundColor].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[deprecated = "Use UIContextualAction and related APIs instead."]
        #[unsafe(method(setBackgroundColor:))]
        #[unsafe(method_family = none)]
        pub fn setBackgroundColor(&self, background_color: Option<&UIColor>);

        #[cfg(feature = "UIVisualEffect")]
        #[deprecated = "Use UIContextualAction and related APIs instead."]
        #[unsafe(method(backgroundEffect))]
        #[unsafe(method_family = none)]
        pub fn backgroundEffect(&self) -> Option<Retained<UIVisualEffect>>;

        #[cfg(feature = "UIVisualEffect")]
        /// Setter for [`backgroundEffect`][Self::backgroundEffect].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[deprecated = "Use UIContextualAction and related APIs instead."]
        #[unsafe(method(setBackgroundEffect:))]
        #[unsafe(method_family = none)]
        pub fn setBackgroundEffect(&self, background_effect: Option<&UIVisualEffect>);
    );
}

/// Methods declared on superclass `NSObject`.
impl UITableViewRowAction {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewfocusupdatecontext?language=objc)
    #[unsafe(super(UIFocusUpdateContext, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "UIFocus")]
    pub struct UITableViewFocusUpdateContext;
);

#[cfg(feature = "UIFocus")]
extern_conformance!(
    unsafe impl NSObjectProtocol for UITableViewFocusUpdateContext {}
);

#[cfg(feature = "UIFocus")]
impl UITableViewFocusUpdateContext {
    extern_methods!(
        #[unsafe(method(previouslyFocusedIndexPath))]
        #[unsafe(method_family = none)]
        pub fn previouslyFocusedIndexPath(&self) -> Option<Retained<NSIndexPath>>;

        #[unsafe(method(nextFocusedIndexPath))]
        #[unsafe(method_family = none)]
        pub fn nextFocusedIndexPath(&self) -> Option<Retained<NSIndexPath>>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "UIFocus")]
impl UITableViewFocusUpdateContext {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewdelegate?language=objc)
    #[cfg(feature = "UIScrollView")]
    pub unsafe trait UITableViewDelegate:
        NSObjectProtocol + UIScrollViewDelegate + MainThreadOnly
    {
        #[cfg(all(
            feature = "UIResponder",
            feature = "UITableViewCell",
            feature = "UIView"
        ))]
        #[optional]
        #[unsafe(method(tableView:willDisplayCell:forRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_willDisplayCell_forRowAtIndexPath(
            &self,
            table_view: &UITableView,
            cell: &UITableViewCell,
            index_path: &NSIndexPath,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:willDisplayHeaderView:forSection:))]
        #[unsafe(method_family = none)]
        fn tableView_willDisplayHeaderView_forSection(
            &self,
            table_view: &UITableView,
            view: &UIView,
            section: NSInteger,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:willDisplayFooterView:forSection:))]
        #[unsafe(method_family = none)]
        fn tableView_willDisplayFooterView_forSection(
            &self,
            table_view: &UITableView,
            view: &UIView,
            section: NSInteger,
        );

        #[cfg(all(
            feature = "UIResponder",
            feature = "UITableViewCell",
            feature = "UIView"
        ))]
        #[optional]
        #[unsafe(method(tableView:didEndDisplayingCell:forRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_didEndDisplayingCell_forRowAtIndexPath(
            &self,
            table_view: &UITableView,
            cell: &UITableViewCell,
            index_path: &NSIndexPath,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:didEndDisplayingHeaderView:forSection:))]
        #[unsafe(method_family = none)]
        fn tableView_didEndDisplayingHeaderView_forSection(
            &self,
            table_view: &UITableView,
            view: &UIView,
            section: NSInteger,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:didEndDisplayingFooterView:forSection:))]
        #[unsafe(method_family = none)]
        fn tableView_didEndDisplayingFooterView_forSection(
            &self,
            table_view: &UITableView,
            view: &UIView,
            section: NSInteger,
        );

        #[cfg(all(
            feature = "UIResponder",
            feature = "UIView",
            feature = "objc2-core-foundation"
        ))]
        #[optional]
        #[unsafe(method(tableView:heightForRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_heightForRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> CGFloat;

        #[cfg(all(
            feature = "UIResponder",
            feature = "UIView",
            feature = "objc2-core-foundation"
        ))]
        #[optional]
        #[unsafe(method(tableView:heightForHeaderInSection:))]
        #[unsafe(method_family = none)]
        fn tableView_heightForHeaderInSection(
            &self,
            table_view: &UITableView,
            section: NSInteger,
        ) -> CGFloat;

        #[cfg(all(
            feature = "UIResponder",
            feature = "UIView",
            feature = "objc2-core-foundation"
        ))]
        #[optional]
        #[unsafe(method(tableView:heightForFooterInSection:))]
        #[unsafe(method_family = none)]
        fn tableView_heightForFooterInSection(
            &self,
            table_view: &UITableView,
            section: NSInteger,
        ) -> CGFloat;

        #[cfg(all(
            feature = "UIResponder",
            feature = "UIView",
            feature = "objc2-core-foundation"
        ))]
        #[optional]
        #[unsafe(method(tableView:estimatedHeightForRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_estimatedHeightForRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> CGFloat;

        #[cfg(all(
            feature = "UIResponder",
            feature = "UIView",
            feature = "objc2-core-foundation"
        ))]
        #[optional]
        #[unsafe(method(tableView:estimatedHeightForHeaderInSection:))]
        #[unsafe(method_family = none)]
        fn tableView_estimatedHeightForHeaderInSection(
            &self,
            table_view: &UITableView,
            section: NSInteger,
        ) -> CGFloat;

        #[cfg(all(
            feature = "UIResponder",
            feature = "UIView",
            feature = "objc2-core-foundation"
        ))]
        #[optional]
        #[unsafe(method(tableView:estimatedHeightForFooterInSection:))]
        #[unsafe(method_family = none)]
        fn tableView_estimatedHeightForFooterInSection(
            &self,
            table_view: &UITableView,
            section: NSInteger,
        ) -> CGFloat;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:viewForHeaderInSection:))]
        #[unsafe(method_family = none)]
        fn tableView_viewForHeaderInSection(
            &self,
            table_view: &UITableView,
            section: NSInteger,
        ) -> Option<Retained<UIView>>;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:viewForFooterInSection:))]
        #[unsafe(method_family = none)]
        fn tableView_viewForFooterInSection(
            &self,
            table_view: &UITableView,
            section: NSInteger,
        ) -> Option<Retained<UIView>>;

        #[cfg(all(
            feature = "UIResponder",
            feature = "UITableViewCell",
            feature = "UIView"
        ))]
        #[deprecated]
        #[optional]
        #[unsafe(method(tableView:accessoryTypeForRowWithIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_accessoryTypeForRowWithIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> UITableViewCellAccessoryType;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:accessoryButtonTappedForRowWithIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_accessoryButtonTappedForRowWithIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:shouldHighlightRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_shouldHighlightRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> bool;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:didHighlightRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_didHighlightRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:didUnhighlightRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_didUnhighlightRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:willSelectRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_willSelectRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> Option<Retained<NSIndexPath>>;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:willDeselectRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_willDeselectRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> Option<Retained<NSIndexPath>>;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:didSelectRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_didSelectRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:didDeselectRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_didDeselectRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// Called to determine if a primary action can be performed for the row at the given indexPath.
        /// See
        /// `tableView:performPrimaryActionForRowAtIndexPath:`for more details about primary actions.
        ///
        ///
        /// Parameter `tableView`: This UITableView
        ///
        /// Parameter `indexPath`: NSIndexPath of the row
        ///
        ///
        /// Returns: `YES` if the primary action can be performed; otherwise `NO`. If not implemented defaults to `YES` when not editing
        /// and `NO` when editing.
        #[optional]
        #[unsafe(method(tableView:canPerformPrimaryActionForRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_canPerformPrimaryActionForRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> bool;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// Called when the primary action should be performed for the row at the given indexPath.
        ///
        ///
        /// Primary actions allow you to distinguish between a change of selection (which can be based on focus changes or
        /// other indirect selection changes) and distinct user actions. Primary actions are performed when the user selects a cell without extending
        /// an existing selection. This is called after
        /// `willSelectRow`and
        /// `didSelectRow`, regardless of whether the cell's selection
        /// state was allowed to change.
        ///
        /// As an example, use
        /// `didSelectRowAtIndexPath`for updating state in the current view controller (i.e. buttons, title, etc) and
        /// use the primary action for navigation or showing another split view column.
        ///
        ///
        /// Parameter `tableView`: This UITableView
        ///
        /// Parameter `indexPath`: NSIndexPath of the row to perform the action on
        #[optional]
        #[unsafe(method(tableView:performPrimaryActionForRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_performPrimaryActionForRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        );

        #[cfg(all(
            feature = "UIResponder",
            feature = "UITableViewCell",
            feature = "UIView"
        ))]
        #[optional]
        #[unsafe(method(tableView:editingStyleForRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_editingStyleForRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> UITableViewCellEditingStyle;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:titleForDeleteConfirmationButtonForRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_titleForDeleteConfirmationButtonForRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> Option<Retained<NSString>>;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[deprecated]
        #[optional]
        #[unsafe(method(tableView:editActionsForRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_editActionsForRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> Option<Retained<NSArray<UITableViewRowAction>>>;

        #[cfg(all(
            feature = "UIResponder",
            feature = "UISwipeActionsConfiguration",
            feature = "UIView"
        ))]
        #[optional]
        #[unsafe(method(tableView:leadingSwipeActionsConfigurationForRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_leadingSwipeActionsConfigurationForRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> Option<Retained<UISwipeActionsConfiguration>>;

        #[cfg(all(
            feature = "UIResponder",
            feature = "UISwipeActionsConfiguration",
            feature = "UIView"
        ))]
        #[optional]
        #[unsafe(method(tableView:trailingSwipeActionsConfigurationForRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_trailingSwipeActionsConfigurationForRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> Option<Retained<UISwipeActionsConfiguration>>;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:shouldIndentWhileEditingRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_shouldIndentWhileEditingRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> bool;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:willBeginEditingRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_willBeginEditingRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:didEndEditingRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_didEndEditingRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: Option<&NSIndexPath>,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:targetIndexPathForMoveFromRowAtIndexPath:toProposedIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_targetIndexPathForMoveFromRowAtIndexPath_toProposedIndexPath(
            &self,
            table_view: &UITableView,
            source_index_path: &NSIndexPath,
            proposed_destination_index_path: &NSIndexPath,
        ) -> Retained<NSIndexPath>;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:indentationLevelForRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_indentationLevelForRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> NSInteger;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[deprecated]
        #[optional]
        #[unsafe(method(tableView:shouldShowMenuForRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_shouldShowMenuForRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> bool;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// # Safety
        ///
        /// - `action` must be a valid selector.
        /// - `sender` should be of the correct type.
        #[deprecated]
        #[optional]
        #[unsafe(method(tableView:canPerformAction:forRowAtIndexPath:withSender:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_canPerformAction_forRowAtIndexPath_withSender(
            &self,
            table_view: &UITableView,
            action: Sel,
            index_path: &NSIndexPath,
            sender: Option<&AnyObject>,
        ) -> bool;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// # Safety
        ///
        /// - `action` must be a valid selector.
        /// - `sender` should be of the correct type.
        #[deprecated]
        #[optional]
        #[unsafe(method(tableView:performAction:forRowAtIndexPath:withSender:))]
        #[unsafe(method_family = none)]
        unsafe fn tableView_performAction_forRowAtIndexPath_withSender(
            &self,
            table_view: &UITableView,
            action: Sel,
            index_path: &NSIndexPath,
            sender: Option<&AnyObject>,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:canFocusRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_canFocusRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> bool;

        #[cfg(all(feature = "UIFocus", feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:shouldUpdateFocusInContext:))]
        #[unsafe(method_family = none)]
        fn tableView_shouldUpdateFocusInContext(
            &self,
            table_view: &UITableView,
            context: &UITableViewFocusUpdateContext,
        ) -> bool;

        #[cfg(all(
            feature = "UIFocus",
            feature = "UIFocusAnimationCoordinator",
            feature = "UIResponder",
            feature = "UIView"
        ))]
        #[optional]
        #[unsafe(method(tableView:didUpdateFocusInContext:withAnimationCoordinator:))]
        #[unsafe(method_family = none)]
        fn tableView_didUpdateFocusInContext_withAnimationCoordinator(
            &self,
            table_view: &UITableView,
            context: &UITableViewFocusUpdateContext,
            coordinator: &UIFocusAnimationCoordinator,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(indexPathForPreferredFocusedViewInTableView:))]
        #[unsafe(method_family = none)]
        fn indexPathForPreferredFocusedViewInTableView(
            &self,
            table_view: &UITableView,
        ) -> Option<Retained<NSIndexPath>>;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// Determines if the row at the specified index path should also become selected when focus moves to it.
        /// If the table view's global selectionFollowsFocus is enabled, this method will allow you to override that behavior on a per-index path basis. This method is not called if selectionFollowsFocus is disabled.
        #[optional]
        #[unsafe(method(tableView:selectionFollowsFocusForRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_selectionFollowsFocusForRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> bool;

        #[cfg(all(
            feature = "UIResponder",
            feature = "UISpringLoadedInteraction",
            feature = "UIView"
        ))]
        #[optional]
        #[unsafe(method(tableView:shouldSpringLoadRowAtIndexPath:withContext:))]
        #[unsafe(method_family = none)]
        fn tableView_shouldSpringLoadRowAtIndexPath_withContext(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
            context: &ProtocolObject<dyn UISpringLoadedInteractionContext>,
        ) -> bool;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:shouldBeginMultipleSelectionInteractionAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_shouldBeginMultipleSelectionInteractionAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> bool;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:didBeginMultipleSelectionInteractionAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_didBeginMultipleSelectionInteractionAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableViewDidEndMultipleSelectionInteraction:))]
        #[unsafe(method_family = none)]
        fn tableViewDidEndMultipleSelectionInteraction(&self, table_view: &UITableView);

        #[cfg(all(
            feature = "UIContextMenuConfiguration",
            feature = "UIResponder",
            feature = "UIView",
            feature = "objc2-core-foundation"
        ))]
        /// Called when the interaction begins.
        ///
        ///
        /// Parameter `tableView`: This UITableView.
        ///
        /// Parameter `indexPath`: IndexPath of the row for which a configuration is being requested.
        ///
        /// Parameter `point`: Location of the interaction in the table view's coordinate space
        ///
        ///
        /// Returns: A UIContextMenuConfiguration describing the menu to be presented. Return nil to prevent the interaction from beginning.
        /// Returning an empty configuration causes the interaction to begin then fail with a cancellation effect. You might use this
        /// to indicate to users that it's possible for a menu to be presented from this element, but that there are no actions to
        /// present at this particular time.
        #[optional]
        #[unsafe(method(tableView:contextMenuConfigurationForRowAtIndexPath:point:))]
        #[unsafe(method_family = none)]
        fn tableView_contextMenuConfigurationForRowAtIndexPath_point(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
            point: CGPoint,
        ) -> Option<Retained<UIContextMenuConfiguration>>;

        #[cfg(all(
            feature = "UIContextMenuConfiguration",
            feature = "UIResponder",
            feature = "UITargetedPreview",
            feature = "UIView"
        ))]
        /// Called when the interaction begins. Return a UITargetedPreview to override the default preview created by the table view.
        ///
        ///
        /// Parameter `tableView`: This UITableView.
        ///
        /// Parameter `configuration`: The configuration of the menu about to be displayed by this interaction.
        #[optional]
        #[unsafe(method(tableView:previewForHighlightingContextMenuWithConfiguration:))]
        #[unsafe(method_family = none)]
        fn tableView_previewForHighlightingContextMenuWithConfiguration(
            &self,
            table_view: &UITableView,
            configuration: &UIContextMenuConfiguration,
        ) -> Option<Retained<UITargetedPreview>>;

        #[cfg(all(
            feature = "UIContextMenuConfiguration",
            feature = "UIResponder",
            feature = "UITargetedPreview",
            feature = "UIView"
        ))]
        /// Called when the interaction is about to dismiss. Return a UITargetedPreview describing the desired dismissal target.
        /// The interaction will animate the presented menu to the target. Use this to customize the dismissal animation.
        ///
        ///
        /// Parameter `tableView`: This UITableView.
        ///
        /// Parameter `configuration`: The configuration of the menu displayed by this interaction.
        #[optional]
        #[unsafe(method(tableView:previewForDismissingContextMenuWithConfiguration:))]
        #[unsafe(method_family = none)]
        fn tableView_previewForDismissingContextMenuWithConfiguration(
            &self,
            table_view: &UITableView,
            configuration: &UIContextMenuConfiguration,
        ) -> Option<Retained<UITargetedPreview>>;

        #[cfg(all(
            feature = "UIContextMenuConfiguration",
            feature = "UIContextMenuInteraction",
            feature = "UIResponder",
            feature = "UIView"
        ))]
        /// Called when the interaction is about to "commit" in response to the user tapping the preview.
        ///
        ///
        /// Parameter `tableView`: This UITableView.
        ///
        /// Parameter `configuration`: Configuration of the currently displayed menu.
        ///
        /// Parameter `animator`: Commit animator. Add animations to this object to run them alongside the commit transition.
        #[optional]
        #[unsafe(method(tableView:willPerformPreviewActionForMenuWithConfiguration:animator:))]
        #[unsafe(method_family = none)]
        fn tableView_willPerformPreviewActionForMenuWithConfiguration_animator(
            &self,
            table_view: &UITableView,
            configuration: &UIContextMenuConfiguration,
            animator: &ProtocolObject<dyn UIContextMenuInteractionCommitAnimating>,
        );

        #[cfg(all(
            feature = "UIContextMenuConfiguration",
            feature = "UIContextMenuInteraction",
            feature = "UIResponder",
            feature = "UIView"
        ))]
        /// Called when the table view is about to display a menu.
        ///
        ///
        /// Parameter `tableView`: This UITableView.
        ///
        /// Parameter `configuration`: The configuration of the menu about to be displayed.
        ///
        /// Parameter `animator`: Appearance animator. Add animations to run them alongside the appearance transition.
        #[optional]
        #[unsafe(method(tableView:willDisplayContextMenuWithConfiguration:animator:))]
        #[unsafe(method_family = none)]
        fn tableView_willDisplayContextMenuWithConfiguration_animator(
            &self,
            table_view: &UITableView,
            configuration: &UIContextMenuConfiguration,
            animator: Option<&ProtocolObject<dyn UIContextMenuInteractionAnimating>>,
        );

        #[cfg(all(
            feature = "UIContextMenuConfiguration",
            feature = "UIContextMenuInteraction",
            feature = "UIResponder",
            feature = "UIView"
        ))]
        /// Called when the table view's context menu interaction is about to end.
        ///
        ///
        /// Parameter `tableView`: This UITableView.
        ///
        /// Parameter `configuration`: Ending configuration.
        ///
        /// Parameter `animator`: Disappearance animator. Add animations to run them alongside the disappearance transition.
        #[optional]
        #[unsafe(method(tableView:willEndContextMenuInteractionWithConfiguration:animator:))]
        #[unsafe(method_family = none)]
        fn tableView_willEndContextMenuInteractionWithConfiguration_animator(
            &self,
            table_view: &UITableView,
            configuration: &UIContextMenuConfiguration,
            animator: Option<&ProtocolObject<dyn UIContextMenuInteractionAnimating>>,
        );
    }
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewselectiondidchangenotification?language=objc)
    pub static UITableViewSelectionDidChangeNotification: &'static NSNotificationName;
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewseparatorinsetreference?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UITableViewSeparatorInsetReference(pub NSInteger);
impl UITableViewSeparatorInsetReference {
    #[doc(alias = "UITableViewSeparatorInsetFromCellEdges")]
    pub const FromCellEdges: Self = Self(0);
    #[doc(alias = "UITableViewSeparatorInsetFromAutomaticInsets")]
    pub const FromAutomaticInsets: Self = Self(1);
}

unsafe impl Encode for UITableViewSeparatorInsetReference {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UITableViewSeparatorInsetReference {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewselfsizinginvalidation?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UITableViewSelfSizingInvalidation(pub NSInteger);
impl UITableViewSelfSizingInvalidation {
    /// No updates will take place when -invalidateIntrinsicContentSize is called on a self-sizing cell or its contentView.
    #[doc(alias = "UITableViewSelfSizingInvalidationDisabled")]
    pub const Disabled: Self = Self(0);
    /// Calling -invalidateIntrinsicContentSize on a self-sizing cell or its contentView will cause it to be resized if necessary.
    #[doc(alias = "UITableViewSelfSizingInvalidationEnabled")]
    pub const Enabled: Self = Self(1);
    /// Calling -invalidateIntrinsicContentSize on a self-sizing cell or its contentView will cause it to be resized if necessary, and
    /// any Auto Layout changes within the contentView of a self-sizing cell will automatically trigger -invalidateIntrinsicContentSize.
    #[doc(alias = "UITableViewSelfSizingInvalidationEnabledIncludingConstraints")]
    pub const EnabledIncludingConstraints: Self = Self(2);
}

unsafe impl Encode for UITableViewSelfSizingInvalidation {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UITableViewSelfSizingInvalidation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableview?language=objc)
    #[unsafe(super(UIScrollView, UIView, UIResponder, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
    pub struct UITableView;
);

#[cfg(all(
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UIView",
    feature = "objc2-quartz-core"
))]
#[cfg(not(target_os = "watchos"))]
extern_conformance!(
    unsafe impl CALayerDelegate for UITableView {}
);

#[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
extern_conformance!(
    unsafe impl NSCoding for UITableView {}
);

#[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for UITableView {}
);

#[cfg(all(
    feature = "UIAppearance",
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIAppearance for UITableView {}
);

#[cfg(all(
    feature = "UIAppearance",
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIAppearanceContainer for UITableView {}
);

#[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
extern_conformance!(
    unsafe impl UICoordinateSpace for UITableView {}
);

#[cfg(all(
    feature = "UIDataSourceTranslating",
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIDataSourceTranslating for UITableView {}
);

#[cfg(all(
    feature = "UIDynamicBehavior",
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIDynamicItem for UITableView {}
);

#[cfg(all(
    feature = "UIFocus",
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIFocusEnvironment for UITableView {}
);

#[cfg(all(
    feature = "UIFocus",
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIFocusItem for UITableView {}
);

#[cfg(all(
    feature = "UIFocus",
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIFocusItemContainer for UITableView {}
);

#[cfg(all(
    feature = "UIFocus",
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UIFocusItemScrollableContainer for UITableView {}
);

#[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
extern_conformance!(
    unsafe impl UIResponderStandardEditActions for UITableView {}
);

#[cfg(all(
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UITraitCollection",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UITraitEnvironment for UITableView {}
);

#[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
impl UITableView {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(initWithFrame:style:))]
        #[unsafe(method_family = init)]
        pub fn initWithFrame_style(
            this: Allocated<Self>,
            frame: CGRect,
            style: UITableViewStyle,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(style))]
        #[unsafe(method_family = none)]
        pub fn style(&self) -> UITableViewStyle;

        #[unsafe(method(dataSource))]
        #[unsafe(method_family = none)]
        pub fn dataSource(&self) -> Option<Retained<ProtocolObject<dyn UITableViewDataSource>>>;

        /// Setter for [`dataSource`][Self::dataSource].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDataSource:))]
        #[unsafe(method_family = none)]
        pub fn setDataSource(
            &self,
            data_source: Option<&ProtocolObject<dyn UITableViewDataSource>>,
        );

        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub fn delegate(&self) -> Option<Retained<ProtocolObject<dyn UITableViewDelegate>>>;

        /// Setter for [`delegate`][Self::delegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn UITableViewDelegate>>,
        );

        #[unsafe(method(prefetchDataSource))]
        #[unsafe(method_family = none)]
        pub fn prefetchDataSource(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn UITableViewDataSourcePrefetching>>>;

        /// Setter for [`prefetchDataSource`][Self::prefetchDataSource].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setPrefetchDataSource:))]
        #[unsafe(method_family = none)]
        pub fn setPrefetchDataSource(
            &self,
            prefetch_data_source: Option<&ProtocolObject<dyn UITableViewDataSourcePrefetching>>,
        );

        #[unsafe(method(isPrefetchingEnabled))]
        #[unsafe(method_family = none)]
        pub fn isPrefetchingEnabled(&self) -> bool;

        /// Setter for [`isPrefetchingEnabled`][Self::isPrefetchingEnabled].
        #[unsafe(method(setPrefetchingEnabled:))]
        #[unsafe(method_family = none)]
        pub fn setPrefetchingEnabled(&self, prefetching_enabled: bool);

        #[unsafe(method(dragDelegate))]
        #[unsafe(method_family = none)]
        pub fn dragDelegate(&self)
            -> Option<Retained<ProtocolObject<dyn UITableViewDragDelegate>>>;

        /// Setter for [`dragDelegate`][Self::dragDelegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDragDelegate:))]
        #[unsafe(method_family = none)]
        pub fn setDragDelegate(
            &self,
            drag_delegate: Option<&ProtocolObject<dyn UITableViewDragDelegate>>,
        );

        #[unsafe(method(dropDelegate))]
        #[unsafe(method_family = none)]
        pub fn dropDelegate(&self)
            -> Option<Retained<ProtocolObject<dyn UITableViewDropDelegate>>>;

        /// Setter for [`dropDelegate`][Self::dropDelegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDropDelegate:))]
        #[unsafe(method_family = none)]
        pub fn setDropDelegate(
            &self,
            drop_delegate: Option<&ProtocolObject<dyn UITableViewDropDelegate>>,
        );

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(rowHeight))]
        #[unsafe(method_family = none)]
        pub fn rowHeight(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`rowHeight`][Self::rowHeight].
        #[unsafe(method(setRowHeight:))]
        #[unsafe(method_family = none)]
        pub fn setRowHeight(&self, row_height: CGFloat);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(sectionHeaderHeight))]
        #[unsafe(method_family = none)]
        pub fn sectionHeaderHeight(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`sectionHeaderHeight`][Self::sectionHeaderHeight].
        #[unsafe(method(setSectionHeaderHeight:))]
        #[unsafe(method_family = none)]
        pub fn setSectionHeaderHeight(&self, section_header_height: CGFloat);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(sectionFooterHeight))]
        #[unsafe(method_family = none)]
        pub fn sectionFooterHeight(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`sectionFooterHeight`][Self::sectionFooterHeight].
        #[unsafe(method(setSectionFooterHeight:))]
        #[unsafe(method_family = none)]
        pub fn setSectionFooterHeight(&self, section_footer_height: CGFloat);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(estimatedRowHeight))]
        #[unsafe(method_family = none)]
        pub fn estimatedRowHeight(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`estimatedRowHeight`][Self::estimatedRowHeight].
        #[unsafe(method(setEstimatedRowHeight:))]
        #[unsafe(method_family = none)]
        pub fn setEstimatedRowHeight(&self, estimated_row_height: CGFloat);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(estimatedSectionHeaderHeight))]
        #[unsafe(method_family = none)]
        pub fn estimatedSectionHeaderHeight(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`estimatedSectionHeaderHeight`][Self::estimatedSectionHeaderHeight].
        #[unsafe(method(setEstimatedSectionHeaderHeight:))]
        #[unsafe(method_family = none)]
        pub fn setEstimatedSectionHeaderHeight(&self, estimated_section_header_height: CGFloat);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(estimatedSectionFooterHeight))]
        #[unsafe(method_family = none)]
        pub fn estimatedSectionFooterHeight(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`estimatedSectionFooterHeight`][Self::estimatedSectionFooterHeight].
        #[unsafe(method(setEstimatedSectionFooterHeight:))]
        #[unsafe(method_family = none)]
        pub fn setEstimatedSectionFooterHeight(&self, estimated_section_footer_height: CGFloat);

        #[cfg(feature = "objc2-core-foundation")]
        /// The height for filler rows added below the last row when there aren't enough rows to fill a plain style table view.
        /// Set 0 to disable filler rows entirely, use `UITableViewAutomaticDimension` for the default height.
        #[unsafe(method(fillerRowHeight))]
        #[unsafe(method_family = none)]
        pub fn fillerRowHeight(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`fillerRowHeight`][Self::fillerRowHeight].
        #[unsafe(method(setFillerRowHeight:))]
        #[unsafe(method_family = none)]
        pub fn setFillerRowHeight(&self, filler_row_height: CGFloat);

        #[cfg(feature = "objc2-core-foundation")]
        /// Padding above each section header. The default value is `UITableViewAutomaticDimension`.
        #[unsafe(method(sectionHeaderTopPadding))]
        #[unsafe(method_family = none)]
        pub fn sectionHeaderTopPadding(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`sectionHeaderTopPadding`][Self::sectionHeaderTopPadding].
        #[unsafe(method(setSectionHeaderTopPadding:))]
        #[unsafe(method_family = none)]
        pub fn setSectionHeaderTopPadding(&self, section_header_top_padding: CGFloat);

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(separatorInset))]
        #[unsafe(method_family = none)]
        pub fn separatorInset(&self) -> UIEdgeInsets;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// Setter for [`separatorInset`][Self::separatorInset].
        #[unsafe(method(setSeparatorInset:))]
        #[unsafe(method_family = none)]
        pub fn setSeparatorInset(&self, separator_inset: UIEdgeInsets);

        #[unsafe(method(separatorInsetReference))]
        #[unsafe(method_family = none)]
        pub fn separatorInsetReference(&self) -> UITableViewSeparatorInsetReference;

        /// Setter for [`separatorInsetReference`][Self::separatorInsetReference].
        #[unsafe(method(setSeparatorInsetReference:))]
        #[unsafe(method_family = none)]
        pub fn setSeparatorInsetReference(
            &self,
            separator_inset_reference: UITableViewSeparatorInsetReference,
        );

        #[unsafe(method(selfSizingInvalidation))]
        #[unsafe(method_family = none)]
        pub fn selfSizingInvalidation(&self) -> UITableViewSelfSizingInvalidation;

        /// Setter for [`selfSizingInvalidation`][Self::selfSizingInvalidation].
        #[unsafe(method(setSelfSizingInvalidation:))]
        #[unsafe(method_family = none)]
        pub fn setSelfSizingInvalidation(
            &self,
            self_sizing_invalidation: UITableViewSelfSizingInvalidation,
        );

        #[unsafe(method(backgroundView))]
        #[unsafe(method_family = none)]
        pub fn backgroundView(&self) -> Option<Retained<UIView>>;

        /// Setter for [`backgroundView`][Self::backgroundView].
        #[unsafe(method(setBackgroundView:))]
        #[unsafe(method_family = none)]
        pub fn setBackgroundView(&self, background_view: Option<&UIView>);

        #[cfg(feature = "UIContextMenuInteraction")]
        #[unsafe(method(contextMenuInteraction))]
        #[unsafe(method_family = none)]
        pub fn contextMenuInteraction(&self) -> Option<Retained<UIContextMenuInteraction>>;

        #[unsafe(method(numberOfSections))]
        #[unsafe(method_family = none)]
        pub fn numberOfSections(&self) -> NSInteger;

        #[unsafe(method(numberOfRowsInSection:))]
        #[unsafe(method_family = none)]
        pub fn numberOfRowsInSection(&self, section: NSInteger) -> NSInteger;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(rectForSection:))]
        #[unsafe(method_family = none)]
        pub fn rectForSection(&self, section: NSInteger) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(rectForHeaderInSection:))]
        #[unsafe(method_family = none)]
        pub fn rectForHeaderInSection(&self, section: NSInteger) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(rectForFooterInSection:))]
        #[unsafe(method_family = none)]
        pub fn rectForFooterInSection(&self, section: NSInteger) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(rectForRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        pub fn rectForRowAtIndexPath(&self, index_path: &NSIndexPath) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(indexPathForRowAtPoint:))]
        #[unsafe(method_family = none)]
        pub fn indexPathForRowAtPoint(&self, point: CGPoint) -> Option<Retained<NSIndexPath>>;

        #[cfg(feature = "UITableViewCell")]
        #[unsafe(method(indexPathForCell:))]
        #[unsafe(method_family = none)]
        pub fn indexPathForCell(&self, cell: &UITableViewCell) -> Option<Retained<NSIndexPath>>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(indexPathsForRowsInRect:))]
        #[unsafe(method_family = none)]
        pub fn indexPathsForRowsInRect(
            &self,
            rect: CGRect,
        ) -> Option<Retained<NSArray<NSIndexPath>>>;

        #[cfg(feature = "UITableViewCell")]
        #[unsafe(method(cellForRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        pub fn cellForRowAtIndexPath(
            &self,
            index_path: &NSIndexPath,
        ) -> Option<Retained<UITableViewCell>>;

        #[cfg(feature = "UITableViewCell")]
        #[unsafe(method(visibleCells))]
        #[unsafe(method_family = none)]
        pub fn visibleCells(&self) -> Retained<NSArray<UITableViewCell>>;

        #[unsafe(method(indexPathsForVisibleRows))]
        #[unsafe(method_family = none)]
        pub fn indexPathsForVisibleRows(&self) -> Option<Retained<NSArray<NSIndexPath>>>;

        #[cfg(feature = "UITableViewHeaderFooterView")]
        #[unsafe(method(headerViewForSection:))]
        #[unsafe(method_family = none)]
        pub fn headerViewForSection(
            &self,
            section: NSInteger,
        ) -> Option<Retained<UITableViewHeaderFooterView>>;

        #[cfg(feature = "UITableViewHeaderFooterView")]
        #[unsafe(method(footerViewForSection:))]
        #[unsafe(method_family = none)]
        pub fn footerViewForSection(
            &self,
            section: NSInteger,
        ) -> Option<Retained<UITableViewHeaderFooterView>>;

        #[unsafe(method(scrollToRowAtIndexPath:atScrollPosition:animated:))]
        #[unsafe(method_family = none)]
        pub fn scrollToRowAtIndexPath_atScrollPosition_animated(
            &self,
            index_path: &NSIndexPath,
            scroll_position: UITableViewScrollPosition,
            animated: bool,
        );

        #[unsafe(method(scrollToNearestSelectedRowAtScrollPosition:animated:))]
        #[unsafe(method_family = none)]
        pub fn scrollToNearestSelectedRowAtScrollPosition_animated(
            &self,
            scroll_position: UITableViewScrollPosition,
            animated: bool,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(performBatchUpdates:completion:))]
        #[unsafe(method_family = none)]
        pub fn performBatchUpdates_completion(
            &self,
            updates: Option<&block2::DynBlock<dyn Fn() + '_>>,
            completion: Option<&block2::DynBlock<dyn Fn(Bool)>>,
        );

        #[unsafe(method(beginUpdates))]
        #[unsafe(method_family = none)]
        pub fn beginUpdates(&self);

        #[unsafe(method(endUpdates))]
        #[unsafe(method_family = none)]
        pub fn endUpdates(&self);

        #[unsafe(method(insertSections:withRowAnimation:))]
        #[unsafe(method_family = none)]
        pub fn insertSections_withRowAnimation(
            &self,
            sections: &NSIndexSet,
            animation: UITableViewRowAnimation,
        );

        #[unsafe(method(deleteSections:withRowAnimation:))]
        #[unsafe(method_family = none)]
        pub fn deleteSections_withRowAnimation(
            &self,
            sections: &NSIndexSet,
            animation: UITableViewRowAnimation,
        );

        #[unsafe(method(moveSection:toSection:))]
        #[unsafe(method_family = none)]
        pub fn moveSection_toSection(&self, section: NSInteger, new_section: NSInteger);

        #[unsafe(method(reloadSections:withRowAnimation:))]
        #[unsafe(method_family = none)]
        pub fn reloadSections_withRowAnimation(
            &self,
            sections: &NSIndexSet,
            animation: UITableViewRowAnimation,
        );

        #[unsafe(method(insertRowsAtIndexPaths:withRowAnimation:))]
        #[unsafe(method_family = none)]
        pub fn insertRowsAtIndexPaths_withRowAnimation(
            &self,
            index_paths: &NSArray<NSIndexPath>,
            animation: UITableViewRowAnimation,
        );

        #[unsafe(method(deleteRowsAtIndexPaths:withRowAnimation:))]
        #[unsafe(method_family = none)]
        pub fn deleteRowsAtIndexPaths_withRowAnimation(
            &self,
            index_paths: &NSArray<NSIndexPath>,
            animation: UITableViewRowAnimation,
        );

        #[unsafe(method(moveRowAtIndexPath:toIndexPath:))]
        #[unsafe(method_family = none)]
        pub fn moveRowAtIndexPath_toIndexPath(
            &self,
            index_path: &NSIndexPath,
            new_index_path: &NSIndexPath,
        );

        #[unsafe(method(reloadRowsAtIndexPaths:withRowAnimation:))]
        #[unsafe(method_family = none)]
        pub fn reloadRowsAtIndexPaths_withRowAnimation(
            &self,
            index_paths: &NSArray<NSIndexPath>,
            animation: UITableViewRowAnimation,
        );

        #[unsafe(method(reconfigureRowsAtIndexPaths:))]
        #[unsafe(method_family = none)]
        pub fn reconfigureRowsAtIndexPaths(&self, index_paths: &NSArray<NSIndexPath>);

        #[unsafe(method(hasUncommittedUpdates))]
        #[unsafe(method_family = none)]
        pub fn hasUncommittedUpdates(&self) -> bool;

        #[unsafe(method(reloadData))]
        #[unsafe(method_family = none)]
        pub fn reloadData(&self);

        #[unsafe(method(reloadSectionIndexTitles))]
        #[unsafe(method_family = none)]
        pub fn reloadSectionIndexTitles(&self);

        #[unsafe(method(isEditing))]
        #[unsafe(method_family = none)]
        pub fn isEditing(&self) -> bool;

        /// Setter for [`isEditing`][Self::isEditing].
        #[unsafe(method(setEditing:))]
        #[unsafe(method_family = none)]
        pub fn setEditing(&self, editing: bool);

        #[unsafe(method(setEditing:animated:))]
        #[unsafe(method_family = none)]
        pub fn setEditing_animated(&self, editing: bool, animated: bool);

        #[unsafe(method(allowsSelection))]
        #[unsafe(method_family = none)]
        pub fn allowsSelection(&self) -> bool;

        /// Setter for [`allowsSelection`][Self::allowsSelection].
        #[unsafe(method(setAllowsSelection:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsSelection(&self, allows_selection: bool);

        #[unsafe(method(allowsSelectionDuringEditing))]
        #[unsafe(method_family = none)]
        pub fn allowsSelectionDuringEditing(&self) -> bool;

        /// Setter for [`allowsSelectionDuringEditing`][Self::allowsSelectionDuringEditing].
        #[unsafe(method(setAllowsSelectionDuringEditing:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsSelectionDuringEditing(&self, allows_selection_during_editing: bool);

        #[unsafe(method(allowsMultipleSelection))]
        #[unsafe(method_family = none)]
        pub fn allowsMultipleSelection(&self) -> bool;

        /// Setter for [`allowsMultipleSelection`][Self::allowsMultipleSelection].
        #[unsafe(method(setAllowsMultipleSelection:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsMultipleSelection(&self, allows_multiple_selection: bool);

        #[unsafe(method(allowsMultipleSelectionDuringEditing))]
        #[unsafe(method_family = none)]
        pub fn allowsMultipleSelectionDuringEditing(&self) -> bool;

        /// Setter for [`allowsMultipleSelectionDuringEditing`][Self::allowsMultipleSelectionDuringEditing].
        #[unsafe(method(setAllowsMultipleSelectionDuringEditing:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsMultipleSelectionDuringEditing(
            &self,
            allows_multiple_selection_during_editing: bool,
        );

        #[unsafe(method(indexPathForSelectedRow))]
        #[unsafe(method_family = none)]
        pub fn indexPathForSelectedRow(&self) -> Option<Retained<NSIndexPath>>;

        #[unsafe(method(indexPathsForSelectedRows))]
        #[unsafe(method_family = none)]
        pub fn indexPathsForSelectedRows(&self) -> Option<Retained<NSArray<NSIndexPath>>>;

        #[unsafe(method(selectRowAtIndexPath:animated:scrollPosition:))]
        #[unsafe(method_family = none)]
        pub fn selectRowAtIndexPath_animated_scrollPosition(
            &self,
            index_path: Option<&NSIndexPath>,
            animated: bool,
            scroll_position: UITableViewScrollPosition,
        );

        #[unsafe(method(deselectRowAtIndexPath:animated:))]
        #[unsafe(method_family = none)]
        pub fn deselectRowAtIndexPath_animated(&self, index_path: &NSIndexPath, animated: bool);

        #[unsafe(method(sectionIndexMinimumDisplayRowCount))]
        #[unsafe(method_family = none)]
        pub fn sectionIndexMinimumDisplayRowCount(&self) -> NSInteger;

        /// Setter for [`sectionIndexMinimumDisplayRowCount`][Self::sectionIndexMinimumDisplayRowCount].
        #[unsafe(method(setSectionIndexMinimumDisplayRowCount:))]
        #[unsafe(method_family = none)]
        pub fn setSectionIndexMinimumDisplayRowCount(
            &self,
            section_index_minimum_display_row_count: NSInteger,
        );

        #[cfg(feature = "UIColor")]
        #[unsafe(method(sectionIndexColor))]
        #[unsafe(method_family = none)]
        pub fn sectionIndexColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`sectionIndexColor`][Self::sectionIndexColor].
        #[unsafe(method(setSectionIndexColor:))]
        #[unsafe(method_family = none)]
        pub fn setSectionIndexColor(&self, section_index_color: Option<&UIColor>);

        #[cfg(feature = "UIColor")]
        #[unsafe(method(sectionIndexBackgroundColor))]
        #[unsafe(method_family = none)]
        pub fn sectionIndexBackgroundColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`sectionIndexBackgroundColor`][Self::sectionIndexBackgroundColor].
        #[unsafe(method(setSectionIndexBackgroundColor:))]
        #[unsafe(method_family = none)]
        pub fn setSectionIndexBackgroundColor(
            &self,
            section_index_background_color: Option<&UIColor>,
        );

        #[cfg(feature = "UIColor")]
        #[unsafe(method(sectionIndexTrackingBackgroundColor))]
        #[unsafe(method_family = none)]
        pub fn sectionIndexTrackingBackgroundColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`sectionIndexTrackingBackgroundColor`][Self::sectionIndexTrackingBackgroundColor].
        #[unsafe(method(setSectionIndexTrackingBackgroundColor:))]
        #[unsafe(method_family = none)]
        pub fn setSectionIndexTrackingBackgroundColor(
            &self,
            section_index_tracking_background_color: Option<&UIColor>,
        );

        #[cfg(feature = "UITableViewCell")]
        #[unsafe(method(separatorStyle))]
        #[unsafe(method_family = none)]
        pub fn separatorStyle(&self) -> UITableViewCellSeparatorStyle;

        #[cfg(feature = "UITableViewCell")]
        /// Setter for [`separatorStyle`][Self::separatorStyle].
        #[unsafe(method(setSeparatorStyle:))]
        #[unsafe(method_family = none)]
        pub fn setSeparatorStyle(&self, separator_style: UITableViewCellSeparatorStyle);

        #[cfg(feature = "UIColor")]
        #[unsafe(method(separatorColor))]
        #[unsafe(method_family = none)]
        pub fn separatorColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`separatorColor`][Self::separatorColor].
        #[unsafe(method(setSeparatorColor:))]
        #[unsafe(method_family = none)]
        pub fn setSeparatorColor(&self, separator_color: Option<&UIColor>);

        #[cfg(feature = "UIVisualEffect")]
        #[unsafe(method(separatorEffect))]
        #[unsafe(method_family = none)]
        pub fn separatorEffect(&self) -> Option<Retained<UIVisualEffect>>;

        #[cfg(feature = "UIVisualEffect")]
        /// Setter for [`separatorEffect`][Self::separatorEffect].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setSeparatorEffect:))]
        #[unsafe(method_family = none)]
        pub fn setSeparatorEffect(&self, separator_effect: Option<&UIVisualEffect>);

        #[unsafe(method(cellLayoutMarginsFollowReadableWidth))]
        #[unsafe(method_family = none)]
        pub fn cellLayoutMarginsFollowReadableWidth(&self) -> bool;

        /// Setter for [`cellLayoutMarginsFollowReadableWidth`][Self::cellLayoutMarginsFollowReadableWidth].
        #[unsafe(method(setCellLayoutMarginsFollowReadableWidth:))]
        #[unsafe(method_family = none)]
        pub fn setCellLayoutMarginsFollowReadableWidth(
            &self,
            cell_layout_margins_follow_readable_width: bool,
        );

        #[unsafe(method(insetsContentViewsToSafeArea))]
        #[unsafe(method_family = none)]
        pub fn insetsContentViewsToSafeArea(&self) -> bool;

        /// Setter for [`insetsContentViewsToSafeArea`][Self::insetsContentViewsToSafeArea].
        #[unsafe(method(setInsetsContentViewsToSafeArea:))]
        #[unsafe(method_family = none)]
        pub fn setInsetsContentViewsToSafeArea(&self, insets_content_views_to_safe_area: bool);

        #[unsafe(method(tableHeaderView))]
        #[unsafe(method_family = none)]
        pub fn tableHeaderView(&self) -> Option<Retained<UIView>>;

        /// Setter for [`tableHeaderView`][Self::tableHeaderView].
        #[unsafe(method(setTableHeaderView:))]
        #[unsafe(method_family = none)]
        pub fn setTableHeaderView(&self, table_header_view: Option<&UIView>);

        #[unsafe(method(tableFooterView))]
        #[unsafe(method_family = none)]
        pub fn tableFooterView(&self) -> Option<Retained<UIView>>;

        /// Setter for [`tableFooterView`][Self::tableFooterView].
        #[unsafe(method(setTableFooterView:))]
        #[unsafe(method_family = none)]
        pub fn setTableFooterView(&self, table_footer_view: Option<&UIView>);

        #[cfg(feature = "UITableViewCell")]
        #[unsafe(method(dequeueReusableCellWithIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn dequeueReusableCellWithIdentifier(
            &self,
            identifier: &NSString,
        ) -> Option<Retained<UITableViewCell>>;

        #[cfg(feature = "UITableViewCell")]
        #[unsafe(method(dequeueReusableCellWithIdentifier:forIndexPath:))]
        #[unsafe(method_family = none)]
        pub fn dequeueReusableCellWithIdentifier_forIndexPath(
            &self,
            identifier: &NSString,
            index_path: &NSIndexPath,
        ) -> Retained<UITableViewCell>;

        #[cfg(feature = "UITableViewHeaderFooterView")]
        #[unsafe(method(dequeueReusableHeaderFooterViewWithIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn dequeueReusableHeaderFooterViewWithIdentifier(
            &self,
            identifier: &NSString,
        ) -> Option<Retained<UITableViewHeaderFooterView>>;

        #[cfg(feature = "UINib")]
        #[deprecated = "Loading Interface Builder products will not be supported in a future version of visionOS."]
        #[unsafe(method(registerNib:forCellReuseIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn registerNib_forCellReuseIdentifier(
            &self,
            nib: Option<&UINib>,
            identifier: &NSString,
        );

        /// # Safety
        ///
        /// `cell_class` probably has further requirements.
        #[unsafe(method(registerClass:forCellReuseIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn registerClass_forCellReuseIdentifier(
            &self,
            cell_class: Option<&AnyClass>,
            identifier: &NSString,
        );

        #[cfg(feature = "UINib")]
        #[deprecated = "Loading Interface Builder products will not be supported in a future version of visionOS."]
        #[unsafe(method(registerNib:forHeaderFooterViewReuseIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn registerNib_forHeaderFooterViewReuseIdentifier(
            &self,
            nib: Option<&UINib>,
            identifier: &NSString,
        );

        /// # Safety
        ///
        /// `a_class` probably has further requirements.
        #[unsafe(method(registerClass:forHeaderFooterViewReuseIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn registerClass_forHeaderFooterViewReuseIdentifier(
            &self,
            a_class: Option<&AnyClass>,
            identifier: &NSString,
        );

        #[unsafe(method(remembersLastFocusedIndexPath))]
        #[unsafe(method_family = none)]
        pub fn remembersLastFocusedIndexPath(&self) -> bool;

        /// Setter for [`remembersLastFocusedIndexPath`][Self::remembersLastFocusedIndexPath].
        #[unsafe(method(setRemembersLastFocusedIndexPath:))]
        #[unsafe(method_family = none)]
        pub fn setRemembersLastFocusedIndexPath(&self, remembers_last_focused_index_path: bool);

        /// When enabled, the table view ensures that selection is automatically triggered when focus moves to a cell.
        /// Defaults to a system derived value based on platform and other properties of the table view.
        #[unsafe(method(selectionFollowsFocus))]
        #[unsafe(method_family = none)]
        pub fn selectionFollowsFocus(&self) -> bool;

        /// Setter for [`selectionFollowsFocus`][Self::selectionFollowsFocus].
        #[unsafe(method(setSelectionFollowsFocus:))]
        #[unsafe(method_family = none)]
        pub fn setSelectionFollowsFocus(&self, selection_follows_focus: bool);

        /// Determines if the table view allows its cells to become focused.
        /// When tableView:canFocusRowAtIndexPath: is implemented, its return value takes precedence over this method.
        /// Defaults to a system derived value based on platform and other properties of the table view.
        #[unsafe(method(allowsFocus))]
        #[unsafe(method_family = none)]
        pub fn allowsFocus(&self) -> bool;

        /// Setter for [`allowsFocus`][Self::allowsFocus].
        #[unsafe(method(setAllowsFocus:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsFocus(&self, allows_focus: bool);

        /// Determines if the table view allows its cells to become focused while editing.
        /// When tableView:canFocusRowAtIndexPath: is implemented, its return value takes precedence over this method.
        /// Defaults to a system derived value based on platform and other properties of the table view.
        #[unsafe(method(allowsFocusDuringEditing))]
        #[unsafe(method_family = none)]
        pub fn allowsFocusDuringEditing(&self) -> bool;

        /// Setter for [`allowsFocusDuringEditing`][Self::allowsFocusDuringEditing].
        #[unsafe(method(setAllowsFocusDuringEditing:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsFocusDuringEditing(&self, allows_focus_during_editing: bool);

        #[unsafe(method(dragInteractionEnabled))]
        #[unsafe(method_family = none)]
        pub fn dragInteractionEnabled(&self) -> bool;

        /// Setter for [`dragInteractionEnabled`][Self::dragInteractionEnabled].
        #[unsafe(method(setDragInteractionEnabled:))]
        #[unsafe(method_family = none)]
        pub fn setDragInteractionEnabled(&self, drag_interaction_enabled: bool);

        #[unsafe(method(hasActiveDrag))]
        #[unsafe(method_family = none)]
        pub fn hasActiveDrag(&self) -> bool;

        #[unsafe(method(hasActiveDrop))]
        #[unsafe(method_family = none)]
        pub fn hasActiveDrop(&self) -> bool;

        /// Determines the type of items that will tightly hug their content.
        ///
        /// The default value for this property is `UITableViewContentHuggingElementsSectionHeaders` on visionOS for plain style table views and `UITableViewContentHuggingElementsNone` on all other platforms.
        /// When the value of this property is `UITableViewContentHuggingElementsSectionHeaders`, any header view will not stretch the width of the table view if their content's intrinsic content size is less than the table view's width.
        #[unsafe(method(contentHuggingElements))]
        #[unsafe(method_family = none)]
        pub fn contentHuggingElements(&self) -> UITableViewContentHuggingElements;

        /// Setter for [`contentHuggingElements`][Self::contentHuggingElements].
        #[unsafe(method(setContentHuggingElements:))]
        #[unsafe(method_family = none)]
        pub fn setContentHuggingElements(
            &self,
            content_hugging_elements: UITableViewContentHuggingElements,
        );
    );
}

/// Methods declared on superclass `UIView`.
#[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
impl UITableView {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub fn initWithFrame(this: Allocated<Self>, frame: CGRect) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
impl UITableView {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// UIDragAndDrop.
#[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
impl UITableView {
    extern_methods!();
}

#[cfg(all(
    feature = "UIResponder",
    feature = "UIScrollView",
    feature = "UISpringLoadedInteractionSupporting",
    feature = "UIView"
))]
extern_conformance!(
    unsafe impl UISpringLoadedInteractionSupporting for UITableView {}
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewdatasource?language=objc)
    pub unsafe trait UITableViewDataSource: NSObjectProtocol + MainThreadOnly {
        #[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
        #[unsafe(method(tableView:numberOfRowsInSection:))]
        #[unsafe(method_family = none)]
        fn tableView_numberOfRowsInSection(
            &self,
            table_view: &UITableView,
            section: NSInteger,
        ) -> NSInteger;

        #[cfg(all(
            feature = "UIResponder",
            feature = "UIScrollView",
            feature = "UITableViewCell",
            feature = "UIView"
        ))]
        #[unsafe(method(tableView:cellForRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_cellForRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> Retained<UITableViewCell>;

        #[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
        #[optional]
        #[unsafe(method(numberOfSectionsInTableView:))]
        #[unsafe(method_family = none)]
        fn numberOfSectionsInTableView(&self, table_view: &UITableView) -> NSInteger;

        #[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:titleForHeaderInSection:))]
        #[unsafe(method_family = none)]
        fn tableView_titleForHeaderInSection(
            &self,
            table_view: &UITableView,
            section: NSInteger,
        ) -> Option<Retained<NSString>>;

        #[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:titleForFooterInSection:))]
        #[unsafe(method_family = none)]
        fn tableView_titleForFooterInSection(
            &self,
            table_view: &UITableView,
            section: NSInteger,
        ) -> Option<Retained<NSString>>;

        #[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:canEditRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_canEditRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> bool;

        #[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:canMoveRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_canMoveRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> bool;

        #[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
        #[optional]
        #[unsafe(method(sectionIndexTitlesForTableView:))]
        #[unsafe(method_family = none)]
        fn sectionIndexTitlesForTableView(
            &self,
            table_view: &UITableView,
        ) -> Option<Retained<NSArray<NSString>>>;

        #[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:sectionForSectionIndexTitle:atIndex:))]
        #[unsafe(method_family = none)]
        fn tableView_sectionForSectionIndexTitle_atIndex(
            &self,
            table_view: &UITableView,
            title: &NSString,
            index: NSInteger,
        ) -> NSInteger;

        #[cfg(all(
            feature = "UIResponder",
            feature = "UIScrollView",
            feature = "UITableViewCell",
            feature = "UIView"
        ))]
        #[optional]
        #[unsafe(method(tableView:commitEditingStyle:forRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_commitEditingStyle_forRowAtIndexPath(
            &self,
            table_view: &UITableView,
            editing_style: UITableViewCellEditingStyle,
            index_path: &NSIndexPath,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:moveRowAtIndexPath:toIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_moveRowAtIndexPath_toIndexPath(
            &self,
            table_view: &UITableView,
            source_index_path: &NSIndexPath,
            destination_index_path: &NSIndexPath,
        );
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewdatasourceprefetching?language=objc)
    pub unsafe trait UITableViewDataSourcePrefetching:
        NSObjectProtocol + MainThreadOnly
    {
        #[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
        #[unsafe(method(tableView:prefetchRowsAtIndexPaths:))]
        #[unsafe(method_family = none)]
        fn tableView_prefetchRowsAtIndexPaths(
            &self,
            table_view: &UITableView,
            index_paths: &NSArray<NSIndexPath>,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
        #[optional]
        #[unsafe(method(tableView:cancelPrefetchingForRowsAtIndexPaths:))]
        #[unsafe(method_family = none)]
        fn tableView_cancelPrefetchingForRowsAtIndexPaths(
            &self,
            table_view: &UITableView,
            index_paths: &NSArray<NSIndexPath>,
        );
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewdragdelegate?language=objc)
    pub unsafe trait UITableViewDragDelegate: NSObjectProtocol + MainThreadOnly {
        #[cfg(all(
            feature = "UIDragItem",
            feature = "UIDragSession",
            feature = "UIResponder",
            feature = "UIScrollView",
            feature = "UIView"
        ))]
        #[unsafe(method(tableView:itemsForBeginningDragSession:atIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_itemsForBeginningDragSession_atIndexPath(
            &self,
            table_view: &UITableView,
            session: &ProtocolObject<dyn UIDragSession>,
            index_path: &NSIndexPath,
        ) -> Retained<NSArray<UIDragItem>>;

        #[cfg(all(
            feature = "UIDragItem",
            feature = "UIDragSession",
            feature = "UIResponder",
            feature = "UIScrollView",
            feature = "UIView",
            feature = "objc2-core-foundation"
        ))]
        #[optional]
        #[unsafe(method(tableView:itemsForAddingToDragSession:atIndexPath:point:))]
        #[unsafe(method_family = none)]
        fn tableView_itemsForAddingToDragSession_atIndexPath_point(
            &self,
            table_view: &UITableView,
            session: &ProtocolObject<dyn UIDragSession>,
            index_path: &NSIndexPath,
            point: CGPoint,
        ) -> Retained<NSArray<UIDragItem>>;

        #[cfg(all(
            feature = "UIDragPreviewParameters",
            feature = "UIPreviewParameters",
            feature = "UIResponder",
            feature = "UIScrollView",
            feature = "UIView"
        ))]
        #[optional]
        #[unsafe(method(tableView:dragPreviewParametersForRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_dragPreviewParametersForRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> Option<Retained<UIDragPreviewParameters>>;

        #[cfg(all(
            feature = "UIDragSession",
            feature = "UIResponder",
            feature = "UIScrollView",
            feature = "UIView"
        ))]
        #[optional]
        #[unsafe(method(tableView:dragSessionWillBegin:))]
        #[unsafe(method_family = none)]
        fn tableView_dragSessionWillBegin(
            &self,
            table_view: &UITableView,
            session: &ProtocolObject<dyn UIDragSession>,
        );

        #[cfg(all(
            feature = "UIDragSession",
            feature = "UIResponder",
            feature = "UIScrollView",
            feature = "UIView"
        ))]
        #[optional]
        #[unsafe(method(tableView:dragSessionDidEnd:))]
        #[unsafe(method_family = none)]
        fn tableView_dragSessionDidEnd(
            &self,
            table_view: &UITableView,
            session: &ProtocolObject<dyn UIDragSession>,
        );

        #[cfg(all(
            feature = "UIDragSession",
            feature = "UIResponder",
            feature = "UIScrollView",
            feature = "UIView"
        ))]
        #[optional]
        #[unsafe(method(tableView:dragSessionAllowsMoveOperation:))]
        #[unsafe(method_family = none)]
        fn tableView_dragSessionAllowsMoveOperation(
            &self,
            table_view: &UITableView,
            session: &ProtocolObject<dyn UIDragSession>,
        ) -> bool;

        #[cfg(all(
            feature = "UIDragSession",
            feature = "UIResponder",
            feature = "UIScrollView",
            feature = "UIView"
        ))]
        #[optional]
        #[unsafe(method(tableView:dragSessionIsRestrictedToDraggingApplication:))]
        #[unsafe(method_family = none)]
        fn tableView_dragSessionIsRestrictedToDraggingApplication(
            &self,
            table_view: &UITableView,
            session: &ProtocolObject<dyn UIDragSession>,
        ) -> bool;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewdropdelegate?language=objc)
    pub unsafe trait UITableViewDropDelegate: NSObjectProtocol + MainThreadOnly {
        #[cfg(all(feature = "UIResponder", feature = "UIScrollView", feature = "UIView"))]
        #[unsafe(method(tableView:performDropWithCoordinator:))]
        #[unsafe(method_family = none)]
        fn tableView_performDropWithCoordinator(
            &self,
            table_view: &UITableView,
            coordinator: &ProtocolObject<dyn UITableViewDropCoordinator>,
        );

        #[cfg(all(
            feature = "UIDragSession",
            feature = "UIResponder",
            feature = "UIScrollView",
            feature = "UIView"
        ))]
        #[optional]
        #[unsafe(method(tableView:canHandleDropSession:))]
        #[unsafe(method_family = none)]
        fn tableView_canHandleDropSession(
            &self,
            table_view: &UITableView,
            session: &ProtocolObject<dyn UIDropSession>,
        ) -> bool;

        #[cfg(all(
            feature = "UIDragSession",
            feature = "UIResponder",
            feature = "UIScrollView",
            feature = "UIView"
        ))]
        #[optional]
        #[unsafe(method(tableView:dropSessionDidEnter:))]
        #[unsafe(method_family = none)]
        fn tableView_dropSessionDidEnter(
            &self,
            table_view: &UITableView,
            session: &ProtocolObject<dyn UIDropSession>,
        );

        #[cfg(all(
            feature = "UIDragSession",
            feature = "UIDropInteraction",
            feature = "UIResponder",
            feature = "UIScrollView",
            feature = "UIView"
        ))]
        #[optional]
        #[unsafe(method(tableView:dropSessionDidUpdate:withDestinationIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_dropSessionDidUpdate_withDestinationIndexPath(
            &self,
            table_view: &UITableView,
            session: &ProtocolObject<dyn UIDropSession>,
            destination_index_path: Option<&NSIndexPath>,
        ) -> Retained<UITableViewDropProposal>;

        #[cfg(all(
            feature = "UIDragSession",
            feature = "UIResponder",
            feature = "UIScrollView",
            feature = "UIView"
        ))]
        #[optional]
        #[unsafe(method(tableView:dropSessionDidExit:))]
        #[unsafe(method_family = none)]
        fn tableView_dropSessionDidExit(
            &self,
            table_view: &UITableView,
            session: &ProtocolObject<dyn UIDropSession>,
        );

        #[cfg(all(
            feature = "UIDragSession",
            feature = "UIResponder",
            feature = "UIScrollView",
            feature = "UIView"
        ))]
        #[optional]
        #[unsafe(method(tableView:dropSessionDidEnd:))]
        #[unsafe(method_family = none)]
        fn tableView_dropSessionDidEnd(
            &self,
            table_view: &UITableView,
            session: &ProtocolObject<dyn UIDropSession>,
        );

        #[cfg(all(
            feature = "UIDragPreviewParameters",
            feature = "UIPreviewParameters",
            feature = "UIResponder",
            feature = "UIScrollView",
            feature = "UIView"
        ))]
        #[optional]
        #[unsafe(method(tableView:dropPreviewParametersForRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn tableView_dropPreviewParametersForRowAtIndexPath(
            &self,
            table_view: &UITableView,
            index_path: &NSIndexPath,
        ) -> Option<Retained<UIDragPreviewParameters>>;
    }
);

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewdropintent?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UITableViewDropIntent(pub NSInteger);
impl UITableViewDropIntent {
    #[doc(alias = "UITableViewDropIntentUnspecified")]
    pub const Unspecified: Self = Self(0);
    #[doc(alias = "UITableViewDropIntentInsertAtDestinationIndexPath")]
    pub const InsertAtDestinationIndexPath: Self = Self(1);
    #[doc(alias = "UITableViewDropIntentInsertIntoDestinationIndexPath")]
    pub const InsertIntoDestinationIndexPath: Self = Self(2);
    #[doc(alias = "UITableViewDropIntentAutomatic")]
    pub const Automatic: Self = Self(3);
}

unsafe impl Encode for UITableViewDropIntent {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UITableViewDropIntent {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewdropproposal?language=objc)
    #[unsafe(super(UIDropProposal, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "UIDropInteraction")]
    pub struct UITableViewDropProposal;
);

#[cfg(feature = "UIDropInteraction")]
extern_conformance!(
    unsafe impl NSCopying for UITableViewDropProposal {}
);

#[cfg(feature = "UIDropInteraction")]
unsafe impl CopyingHelper for UITableViewDropProposal {
    type Result = Self;
}

#[cfg(feature = "UIDropInteraction")]
extern_conformance!(
    unsafe impl NSObjectProtocol for UITableViewDropProposal {}
);

#[cfg(feature = "UIDropInteraction")]
impl UITableViewDropProposal {
    extern_methods!(
        #[unsafe(method(initWithDropOperation:intent:))]
        #[unsafe(method_family = init)]
        pub fn initWithDropOperation_intent(
            this: Allocated<Self>,
            operation: UIDropOperation,
            intent: UITableViewDropIntent,
        ) -> Retained<Self>;

        #[unsafe(method(intent))]
        #[unsafe(method_family = none)]
        pub fn intent(&self) -> UITableViewDropIntent;
    );
}

/// Methods declared on superclass `UIDropProposal`.
#[cfg(feature = "UIDropInteraction")]
impl UITableViewDropProposal {
    extern_methods!(
        #[unsafe(method(initWithDropOperation:))]
        #[unsafe(method_family = init)]
        pub fn initWithDropOperation(
            this: Allocated<Self>,
            operation: UIDropOperation,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewdropcoordinator?language=objc)
    pub unsafe trait UITableViewDropCoordinator: NSObjectProtocol + MainThreadOnly {
        #[unsafe(method(items))]
        #[unsafe(method_family = none)]
        fn items(&self) -> Retained<NSArray<ProtocolObject<dyn UITableViewDropItem>>>;

        #[unsafe(method(destinationIndexPath))]
        #[unsafe(method_family = none)]
        fn destinationIndexPath(&self) -> Option<Retained<NSIndexPath>>;

        #[cfg(feature = "UIDropInteraction")]
        #[unsafe(method(proposal))]
        #[unsafe(method_family = none)]
        fn proposal(&self) -> Retained<UITableViewDropProposal>;

        #[cfg(feature = "UIDragSession")]
        #[unsafe(method(session))]
        #[unsafe(method_family = none)]
        fn session(&self) -> Retained<ProtocolObject<dyn UIDropSession>>;

        #[cfg(all(feature = "UIDragInteraction", feature = "UIDragItem"))]
        #[unsafe(method(dropItem:toPlaceholder:))]
        #[unsafe(method_family = none)]
        fn dropItem_toPlaceholder(
            &self,
            drag_item: &UIDragItem,
            placeholder: &UITableViewDropPlaceholder,
        ) -> Retained<ProtocolObject<dyn UITableViewDropPlaceholderContext>>;

        #[cfg(all(feature = "UIDragInteraction", feature = "UIDragItem"))]
        #[unsafe(method(dropItem:toRowAtIndexPath:))]
        #[unsafe(method_family = none)]
        fn dropItem_toRowAtIndexPath(
            &self,
            drag_item: &UIDragItem,
            index_path: &NSIndexPath,
        ) -> Retained<ProtocolObject<dyn UIDragAnimating>>;

        #[cfg(all(
            feature = "UIDragInteraction",
            feature = "UIDragItem",
            feature = "objc2-core-foundation"
        ))]
        #[unsafe(method(dropItem:intoRowAtIndexPath:rect:))]
        #[unsafe(method_family = none)]
        fn dropItem_intoRowAtIndexPath_rect(
            &self,
            drag_item: &UIDragItem,
            index_path: &NSIndexPath,
            rect: CGRect,
        ) -> Retained<ProtocolObject<dyn UIDragAnimating>>;

        #[cfg(all(
            feature = "UIDragInteraction",
            feature = "UIDragItem",
            feature = "UITargetedDragPreview",
            feature = "UITargetedPreview"
        ))]
        #[unsafe(method(dropItem:toTarget:))]
        #[unsafe(method_family = none)]
        fn dropItem_toTarget(
            &self,
            drag_item: &UIDragItem,
            target: &UIDragPreviewTarget,
        ) -> Retained<ProtocolObject<dyn UIDragAnimating>>;
    }
);

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewplaceholder?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UITableViewPlaceholder;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UITableViewPlaceholder {}
);

impl UITableViewPlaceholder {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(initWithInsertionIndexPath:reuseIdentifier:rowHeight:))]
        #[unsafe(method_family = init)]
        pub fn initWithInsertionIndexPath_reuseIdentifier_rowHeight(
            this: Allocated<Self>,
            insertion_index_path: &NSIndexPath,
            reuse_identifier: &NSString,
            row_height: CGFloat,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[cfg(all(
            feature = "UIResponder",
            feature = "UITableViewCell",
            feature = "UIView",
            feature = "block2"
        ))]
        /// # Safety
        ///
        /// The returned block's argument must be a valid pointer.
        #[unsafe(method(cellUpdateHandler))]
        #[unsafe(method_family = none)]
        pub unsafe fn cellUpdateHandler(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn(NonNull<UITableViewCell>)>;

        #[cfg(all(
            feature = "UIResponder",
            feature = "UITableViewCell",
            feature = "UIView",
            feature = "block2"
        ))]
        /// Setter for [`cellUpdateHandler`][Self::cellUpdateHandler].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setCellUpdateHandler:))]
        #[unsafe(method_family = none)]
        pub fn setCellUpdateHandler(
            &self,
            cell_update_handler: Option<&block2::DynBlock<dyn Fn(NonNull<UITableViewCell>)>>,
        );
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewdropplaceholder?language=objc)
    #[unsafe(super(UITableViewPlaceholder, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UITableViewDropPlaceholder;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UITableViewDropPlaceholder {}
);

impl UITableViewDropPlaceholder {
    extern_methods!(
        #[cfg(all(
            feature = "UIDragPreviewParameters",
            feature = "UIPreviewParameters",
            feature = "UIResponder",
            feature = "UITableViewCell",
            feature = "UIView",
            feature = "block2"
        ))]
        /// # Safety
        ///
        /// The returned block's argument must be a valid pointer.
        #[unsafe(method(previewParametersProvider))]
        #[unsafe(method_family = none)]
        pub unsafe fn previewParametersProvider(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn(NonNull<UITableViewCell>) -> *mut UIDragPreviewParameters>;

        #[cfg(all(
            feature = "UIDragPreviewParameters",
            feature = "UIPreviewParameters",
            feature = "UIResponder",
            feature = "UITableViewCell",
            feature = "UIView",
            feature = "block2"
        ))]
        /// Setter for [`previewParametersProvider`][Self::previewParametersProvider].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `preview_parameters_provider` block's return must be a valid pointer or null.
        #[unsafe(method(setPreviewParametersProvider:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPreviewParametersProvider(
            &self,
            preview_parameters_provider: Option<
                &block2::DynBlock<dyn Fn(NonNull<UITableViewCell>) -> *mut UIDragPreviewParameters>,
            >,
        );
    );
}

/// Methods declared on superclass `UITableViewPlaceholder`.
impl UITableViewDropPlaceholder {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(initWithInsertionIndexPath:reuseIdentifier:rowHeight:))]
        #[unsafe(method_family = init)]
        pub fn initWithInsertionIndexPath_reuseIdentifier_rowHeight(
            this: Allocated<Self>,
            insertion_index_path: &NSIndexPath,
            reuse_identifier: &NSString,
            row_height: CGFloat,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewdropitem?language=objc)
    pub unsafe trait UITableViewDropItem: NSObjectProtocol + MainThreadOnly {
        #[cfg(feature = "UIDragItem")]
        #[unsafe(method(dragItem))]
        #[unsafe(method_family = none)]
        fn dragItem(&self) -> Retained<UIDragItem>;

        #[unsafe(method(sourceIndexPath))]
        #[unsafe(method_family = none)]
        fn sourceIndexPath(&self) -> Option<Retained<NSIndexPath>>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(previewSize))]
        #[unsafe(method_family = none)]
        fn previewSize(&self) -> CGSize;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitableviewdropplaceholdercontext?language=objc)
    #[cfg(feature = "UIDragInteraction")]
    pub unsafe trait UITableViewDropPlaceholderContext:
        UIDragAnimating + MainThreadOnly
    {
        #[cfg(feature = "UIDragItem")]
        #[unsafe(method(dragItem))]
        #[unsafe(method_family = none)]
        fn dragItem(&self) -> Retained<UIDragItem>;

        #[cfg(feature = "block2")]
        #[unsafe(method(commitInsertionWithDataSourceUpdates:))]
        #[unsafe(method_family = none)]
        fn commitInsertionWithDataSourceUpdates(
            &self,
            data_source_updates: &block2::DynBlock<dyn Fn(NonNull<NSIndexPath>) + '_>,
        ) -> bool;

        #[unsafe(method(deletePlaceholder))]
        #[unsafe(method_family = none)]
        fn deletePlaceholder(&self) -> bool;
    }
);
