//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiactionidentifier?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
pub type UIActionIdentifier = NSString;

extern "C" {
    /// Default action identifiers for paste variants
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiactionpaste?language=objc)
    pub static UIActionPaste: &'static UIActionIdentifier;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiactionpasteandmatchstyle?language=objc)
    pub static UIActionPasteAndMatchStyle: &'static UIActionIdentifier;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiactionpasteandgo?language=objc)
    pub static UIActionPasteAndGo: &'static UIActionIdentifier;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiactionpasteandsearch?language=objc)
    pub static UIActionPasteAndSearch: &'static UIActionIdentifier;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiactionnewfrompasteboard?language=objc)
    pub static UIActionNewFromPasteboard: &'static UIActionIdentifier;
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiactionhandler?language=objc)
#[cfg(all(feature = "UIMenuElement", feature = "block2"))]
pub type UIActionHandler = *mut block2::DynBlock<dyn Fn(NonNull<UIAction>)>;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiaction?language=objc)
    #[unsafe(super(UIMenuElement, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "UIMenuElement")]
    pub struct UIAction;
);

#[cfg(feature = "UIMenuElement")]
extern_conformance!(
    unsafe impl NSCoding for UIAction {}
);

#[cfg(feature = "UIMenuElement")]
extern_conformance!(
    unsafe impl NSCopying for UIAction {}
);

#[cfg(feature = "UIMenuElement")]
unsafe impl CopyingHelper for UIAction {
    type Result = Self;
}

#[cfg(feature = "UIMenuElement")]
extern_conformance!(
    unsafe impl NSObjectProtocol for UIAction {}
);

#[cfg(feature = "UIMenuElement")]
extern_conformance!(
    unsafe impl NSSecureCoding for UIAction {}
);

#[cfg(all(feature = "UIMenuElement", feature = "UIMenuLeaf"))]
extern_conformance!(
    unsafe impl UIMenuLeaf for UIAction {}
);

#[cfg(feature = "UIMenuElement")]
impl UIAction {
    extern_methods!(
        /// Short display title.
        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        pub fn title(&self) -> Retained<NSString>;

        /// Setter for [`title`][Self::title].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setTitle:))]
        #[unsafe(method_family = none)]
        pub fn setTitle(&self, title: &NSString);

        #[cfg(feature = "UIImage")]
        /// Image that can appear next to this action.
        #[unsafe(method(image))]
        #[unsafe(method_family = none)]
        pub fn image(&self) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UIImage")]
        /// Setter for [`image`][Self::image].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setImage:))]
        #[unsafe(method_family = none)]
        pub fn setImage(&self, image: Option<&UIImage>);

        /// Elaborated title used in keyboard shortcut overlay.
        #[unsafe(method(discoverabilityTitle))]
        #[unsafe(method_family = none)]
        pub fn discoverabilityTitle(&self) -> Option<Retained<NSString>>;

        /// Setter for [`discoverabilityTitle`][Self::discoverabilityTitle].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setDiscoverabilityTitle:))]
        #[unsafe(method_family = none)]
        pub fn setDiscoverabilityTitle(&self, discoverability_title: Option<&NSString>);

        /// This action's identifier.
        #[unsafe(method(identifier))]
        #[unsafe(method_family = none)]
        pub fn identifier(&self) -> Retained<UIActionIdentifier>;

        /// This action's style.
        #[unsafe(method(attributes))]
        #[unsafe(method_family = none)]
        pub fn attributes(&self) -> UIMenuElementAttributes;

        /// Setter for [`attributes`][Self::attributes].
        #[unsafe(method(setAttributes:))]
        #[unsafe(method_family = none)]
        pub fn setAttributes(&self, attributes: UIMenuElementAttributes);

        /// State that can appear next to this action.
        #[unsafe(method(state))]
        #[unsafe(method_family = none)]
        pub fn state(&self) -> UIMenuElementState;

        /// Setter for [`state`][Self::state].
        #[unsafe(method(setState:))]
        #[unsafe(method_family = none)]
        pub fn setState(&self, state: UIMenuElementState);

        /// If available, the object on behalf of which the actionHandler is called.
        #[unsafe(method(sender))]
        #[unsafe(method_family = none)]
        pub fn sender(&self) -> Option<Retained<AnyObject>>;

        #[cfg(feature = "block2")]
        /// Creates a UIAction with an empty title, nil image, and automatically generated identifier
        ///
        ///
        /// Parameter `handler`: Handler block. Called when the user selects the action.
        ///
        ///
        /// Returns: A new UIAction.
        ///
        /// # Safety
        ///
        /// `handler` must be a valid pointer.
        #[unsafe(method(actionWithHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn actionWithHandler(
            handler: UIActionHandler,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(all(feature = "UIImage", feature = "block2"))]
        /// Creates a UIAction with the given arguments.
        ///
        ///
        /// Parameter `title`: The action's title.
        ///
        /// Parameter `image`: Image that can appear next to this action, if needed.
        ///
        /// Parameter `identifier`: The action's identifier. Pass nil to use an auto-generated identifier.
        ///
        /// Parameter `handler`: Handler block. Called when the user selects the action.
        ///
        ///
        /// Returns: A new UIAction.
        ///
        /// # Safety
        ///
        /// `handler` must be a valid pointer.
        #[unsafe(method(actionWithTitle:image:identifier:handler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn actionWithTitle_image_identifier_handler(
            title: &NSString,
            image: Option<&UIImage>,
            identifier: Option<&UIActionIdentifier>,
            handler: UIActionHandler,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// Methods declared on superclass `UIMenuElement`.
#[cfg(feature = "UIMenuElement")]
impl UIAction {
    extern_methods!(
        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// UICaptureTextFromCameraSupporting.
#[cfg(feature = "UIMenuElement")]
impl UIAction {
    extern_methods!(
        #[cfg(all(
            feature = "UIResponder",
            feature = "UITextInput",
            feature = "UITextInputTraits"
        ))]
        /// Creates a new UIAction for the captureTextFromCamera: standard edit action.
        ///
        ///
        /// Parameter `responder`: The UIKeyInput responder to send captureTextFromCamera: to.
        ///
        /// Parameter `identifier`: The action's identifier. Pass nil to use an auto-generated identifier.
        ///
        ///
        /// Returns: A new UIAction.
        ///
        /// # Safety
        ///
        /// `responder` must implement UIKeyInput.
        #[unsafe(method(captureTextFromCameraActionForResponder:identifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn captureTextFromCameraActionForResponder_identifier(
            responder: &UIResponder,
            identifier: Option<&UIActionIdentifier>,
        ) -> Retained<Self>;
    );
}
