/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone;

import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.cli.ApplicationInstanceController;
import org.jkiss.dbeaver.model.cli.CLIProcessResult;
import org.jkiss.dbeaver.model.cli.CLIRunMeta;
import org.jkiss.dbeaver.model.cli.CommandLineContext;
import org.jkiss.dbeaver.model.cli.command.AbstractTopLevelCommand;
import org.jkiss.dbeaver.ui.app.standalone.rpc.IInstanceController;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.CommonUtils;
import picocli.CommandLine;

@CommandLine.Command(name="dbeaver", description={"DBeaver commands"}, mixinStandardHelpOptions=true)
public class DBeaverTopLevelCommand
extends AbstractTopLevelCommand {
    private static final Log log = Log.getLog(DBeaverTopLevelCommand.class);
    @CommandLine.Option(names={"-vars", "-variablesFile"}, description={"Uses a specified configuration file for variable resolving"})
    private String variablesFile;
    @CommandLine.Option(names={"-newInstance"}, description={"Force creating new application instance (do not try to activate already running)"})
    private boolean newInstance;
    @CommandLine.Option(names={"-reuseWorkspace"}, description={"Force workspace reuse (do not show warnings)"})
    private boolean reuseWorkspace;
    @CommandLine.Option(names={"-stop", "-quit"}, description={"Stop DBeaver running instance"})
    private boolean stop;
    @CommandLine.Option(names={"-f", "-file"}, arity="1", split=",", description={"Open a file"})
    private List<String> filesToOpen;
    @CommandLine.Option(names={"-con", "-connect"}, arity="1", split=",", description={"Connects to a specified database"})
    private List<String> connectionSpecs;
    @CommandLine.Option(names={"-disconnectAll"}, description={"Disconnect from all databases"})
    private boolean disconnectAll;
    @CommandLine.Option(names={"-closeTabs"}, description={"Close all open editors"})
    private boolean closeTabs;
    @CommandLine.Option(names={"-bringToFront"}, description={"Bring DBeaver window on top of other applications"})
    private boolean bringToFront;
    @CommandLine.Option(names={"-q"}, description={"Run quietly (do not print logs)"})
    private boolean quiet;
    @Nullable
    private final IInstanceController instanceController;

    protected DBeaverTopLevelCommand(@Nullable IInstanceController controller, @NotNull CommandLineContext context, @NotNull CLIRunMeta meta) {
        super((ApplicationInstanceController)controller, context, meta);
        this.instanceController = controller;
    }

    public void run() {
        super.run();
        if (this.context.getPostAction() != null) {
            return;
        }
        if (this.newInstance) {
            this.context.setPostAction(CLIProcessResult.PostAction.START_INSTANCE);
            return;
        }
        if (!CommonUtils.isEmpty((String)this.variablesFile)) {
            try {
                Throwable throwable = null;
                Object var2_5 = null;
                try (FileInputStream stream = new FileInputStream(this.variablesFile);){
                    Properties properties = new Properties();
                    properties.load(stream);
                    SystemVariablesResolver.setConfiguration((Properties)properties);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error parsing command line ", (Throwable)e);
                this.context.setPostAction(CLIProcessResult.PostAction.START_INSTANCE);
            }
        }
        if (this.instanceController == null) {
            log.debug((Object)"Can't process commands because no running instance is present");
            this.context.setPostAction(CLIProcessResult.PostAction.START_INSTANCE);
            return;
        }
        boolean exitAfterExecute = false;
        if (this.stop) {
            this.instanceController.quit();
            exitAfterExecute = true;
        }
        if (!CommonUtils.isEmpty(this.filesToOpen)) {
            this.instanceController.openExternalFiles(this.filesToOpen.toArray(new String[0]));
            exitAfterExecute = true;
        }
        if (!CommonUtils.isEmpty(this.connectionSpecs)) {
            for (String con : this.connectionSpecs) {
                this.instanceController.openDatabaseConnection(con);
            }
            exitAfterExecute = true;
        }
        if (this.closeTabs) {
            this.instanceController.closeAllEditors();
            exitAfterExecute = true;
        }
        if (this.disconnectAll) {
            this.instanceController.executeWorkbenchCommand("org.jkiss.dbeaver.core.disconnectAll");
            exitAfterExecute = true;
        }
        if (this.bringToFront) {
            this.instanceController.bringToFront();
            exitAfterExecute = true;
        }
        this.context.setPostAction(exitAfterExecute ? CLIProcessResult.PostAction.SHUTDOWN : CLIProcessResult.PostAction.START_INSTANCE);
    }
}

