/*******************************************************************************
 *
 * MIT License
 *
 * Copyright (c) 2020-2021 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *******************************************************************************/
; generated by igemm_codegen.py (b306bdceabec59034a2fdc1ecc4b24f037834b95)
;
.macro .v_u32_div v_q, v_n, v_d, v_tmp4, s_tmp4
    v_cvt_f32_u32     v[\v_tmp4+0],   v[\v_d]
    v_rcp_f32         v[\v_tmp4+0],   v[\v_tmp4+0]
    v_mul_f32         v[\v_tmp4+0],   0x4f800000, v[\v_tmp4+0]
    v_cvt_u32_f32     v[\v_tmp4+0],   v[\v_tmp4+0]
    v_mul_lo_u32      v[\v_tmp4+1],   v[\v_d],      v[\v_tmp4+0]
    v_mul_hi_u32      v[\v_tmp4+2],   v[\v_d],      v[\v_tmp4+0]
    v_sub_co_u32      v[\v_tmp4+3],   vcc, 0,     v[\v_tmp4+1]
    v_cmp_ne_i32      s[\s_tmp4:\s_tmp4+1], 0,          v[\v_tmp4+2]
    v_cndmask_b32     v[\v_tmp4+1],   v[\v_tmp4+3],   v[\v_tmp4+1],   s[\s_tmp4:\s_tmp4+1]
    v_mul_hi_u32      v[\v_tmp4+1],   v[\v_tmp4+1],   v[\v_tmp4+0]
    v_sub_co_u32      v[\v_tmp4+2],   vcc,        v[\v_tmp4+0],   v[\v_tmp4+1]
    v_add_co_u32      v[\v_tmp4+0],   vcc,        v[\v_tmp4+0],   v[\v_tmp4+1]
    v_cndmask_b32     v[\v_tmp4+0],   v[\v_tmp4+0],   v[\v_tmp4+2],   s[\s_tmp4:\s_tmp4+1]
    v_mul_hi_u32      v[\v_tmp4+0],   v[\v_tmp4+0],   v[\v_n]
    v_mul_lo_u32      v[\v_tmp4+1],   v[\v_tmp4+0],   v[\v_d]
    v_sub_co_u32      v[\v_tmp4+2],   vcc,        v[\v_n],      v[\v_tmp4+1]
    v_cmp_ge_u32      s[\s_tmp4:\s_tmp4+1], v[\v_n],      v[\v_tmp4+1]
    v_cmp_ge_u32      s[\s_tmp4+2:\s_tmp4+3], v[\v_tmp4+2],   v[\v_d]
    v_add_co_u32      v[\v_tmp4+2],   vcc, 1, v[\v_tmp4+0]
    s_and_b64         s[\s_tmp4+2:\s_tmp4+3], s[\s_tmp4:\s_tmp4+1], s[\s_tmp4+2:\s_tmp4+3]
    v_add_co_u32      v[\v_tmp4+1],   vcc, -1,    v[\v_tmp4+0]
    v_cndmask_b32     v[\v_tmp4+2],   v[\v_tmp4+0],   v[\v_tmp4+2],      s[\s_tmp4+2:\s_tmp4+3]
    v_cndmask_b32     v[\v_tmp4+2],   v[\v_tmp4+1],   v[\v_tmp4+2],      s[\s_tmp4:\s_tmp4+1]
    v_cmp_ne_i32      vcc,          0,          v[\v_d]
    v_cndmask_b32     v[\v_q],      -1,         v[\v_tmp4+2],      vcc
.endm

.macro .v_u32_div_vs v_q, v_n, s_d, v_tmp4, s_tmp4
    v_cvt_f32_u32     v[\v_tmp4+0],   s[\s_d]
    v_rcp_f32         v[\v_tmp4+0],   v[\v_tmp4+0]
    v_mul_f32         v[\v_tmp4+0],   0x4f800000, v[\v_tmp4+0]
    v_cvt_u32_f32     v[\v_tmp4+0],   v[\v_tmp4+0]
    v_mul_lo_u32      v[\v_tmp4+1],   s[\s_d],      v[\v_tmp4+0]
    v_mul_hi_u32      v[\v_tmp4+2],   s[\s_d],      v[\v_tmp4+0]
    v_sub_co_u32      v[\v_tmp4+3],   vcc, 0,     v[\v_tmp4+1]
    v_cmp_ne_i32      s[\s_tmp4:\s_tmp4+1], 0,          v[\v_tmp4+2]
    v_cndmask_b32     v[\v_tmp4+1],   v[\v_tmp4+3],   v[\v_tmp4+1],   s[\s_tmp4:\s_tmp4+1]
    v_mul_hi_u32      v[\v_tmp4+1],   v[\v_tmp4+1],   v[\v_tmp4+0]
    v_sub_co_u32      v[\v_tmp4+2],   vcc,        v[\v_tmp4+0],   v[\v_tmp4+1]
    v_add_co_u32      v[\v_tmp4+0],   vcc,        v[\v_tmp4+0],   v[\v_tmp4+1]
    v_cndmask_b32     v[\v_tmp4+0],   v[\v_tmp4+0],   v[\v_tmp4+2],   s[\s_tmp4:\s_tmp4+1]
    v_mul_hi_u32      v[\v_tmp4+0],   v[\v_tmp4+0],   v[\v_n]
    v_mul_lo_u32      v[\v_tmp4+1],   s[\s_d],     v[\v_tmp4+0]
    v_sub_co_u32      v[\v_tmp4+2],   vcc,        v[\v_n],      v[\v_tmp4+1]
    v_cmp_ge_u32      s[\s_tmp4:\s_tmp4+1], v[\v_n],      v[\v_tmp4+1]
    v_cmp_le_u32      s[\s_tmp4+2:\s_tmp4+3],  s[\s_d],    v[\v_tmp4+2]
    v_add_co_u32      v[\v_tmp4+2],   vcc, 1, v[\v_tmp4+0]
    s_and_b64         s[\s_tmp4+2:\s_tmp4+3], s[\s_tmp4:\s_tmp4+1], s[\s_tmp4+2:\s_tmp4+3]
    v_add_co_u32      v[\v_tmp4+1],   vcc, -1,    v[\v_tmp4+0]
    v_cndmask_b32     v[\v_tmp4+2],   v[\v_tmp4+0],   v[\v_tmp4+2],      s[\s_tmp4+2:\s_tmp4+3]
    v_cndmask_b32     v[\v_tmp4+2],   v[\v_tmp4+1],   v[\v_tmp4+2],      s[\s_tmp4:\s_tmp4+1]
    v_cmp_ne_i32      vcc,          s[\s_d],   0
    v_cndmask_b32     v[\v_q],      -1,         v[\v_tmp4+2],      vcc
.endm

.macro .v_u32_div_ss v_q, s_n, s_d, v_tmp4, s_tmp4
    v_cvt_f32_u32     v[\v_tmp4+0],   s[\s_d]
    v_rcp_f32         v[\v_tmp4+0],   v[\v_tmp4+0]
    v_mul_f32         v[\v_tmp4+0],   0x4f800000, v[\v_tmp4+0]
    v_cvt_u32_f32     v[\v_tmp4+0],   v[\v_tmp4+0]
    v_mul_lo_u32      v[\v_tmp4+1],   s[\s_d],      v[\v_tmp4+0]
    v_mul_hi_u32      v[\v_tmp4+2],   s[\s_d],      v[\v_tmp4+0]
    v_sub_co_u32      v[\v_tmp4+3],   vcc, 0,     v[\v_tmp4+1]
    v_cmp_ne_i32      s[\s_tmp4:\s_tmp4+1], 0,          v[\v_tmp4+2]
    v_cndmask_b32     v[\v_tmp4+1],   v[\v_tmp4+3],   v[\v_tmp4+1],   s[\s_tmp4:\s_tmp4+1]
    v_mul_hi_u32      v[\v_tmp4+1],   v[\v_tmp4+1],   v[\v_tmp4+0]
    v_sub_co_u32      v[\v_tmp4+2],   vcc,        v[\v_tmp4+0],   v[\v_tmp4+1]
    v_add_co_u32      v[\v_tmp4+0],   vcc,        v[\v_tmp4+0],   v[\v_tmp4+1]
    v_cndmask_b32     v[\v_tmp4+0],   v[\v_tmp4+0],   v[\v_tmp4+2],   s[\s_tmp4:\s_tmp4+1]
    v_mul_hi_u32      v[\v_tmp4+0],   s[\s_n],   v[\v_tmp4+0]
    v_mul_lo_u32      v[\v_tmp4+1],   s[\s_d],     v[\v_tmp4+0]
    v_sub_co_u32      v[\v_tmp4+2],   vcc,        s[\s_n],      v[\v_tmp4+1]
    v_cmp_ge_u32      s[\s_tmp4:\s_tmp4+1], s[\s_n],      v[\v_tmp4+1]
    v_cmp_le_u32      s[\s_tmp4+2:\s_tmp4+3],  s[\s_d],    v[\v_tmp4+2]
    v_add_co_u32      v[\v_tmp4+2],   vcc, 1, v[\v_tmp4+0]
    s_and_b64         s[\s_tmp4+2:\s_tmp4+3], s[\s_tmp4:\s_tmp4+1], s[\s_tmp4+2:\s_tmp4+3]
    v_add_co_u32      v[\v_tmp4+1],   vcc, -1,    v[\v_tmp4+0]
    v_cndmask_b32     v[\v_tmp4+2],   v[\v_tmp4+0],   v[\v_tmp4+2],      s[\s_tmp4+2:\s_tmp4+3]
    v_cndmask_b32     v[\v_tmp4+2],   v[\v_tmp4+1],   v[\v_tmp4+2],      s[\s_tmp4:\s_tmp4+1]
    v_cmp_ne_i32      vcc,          s[\s_d],   0
    v_cndmask_b32     v[\v_q],      -1,         v[\v_tmp4+2],      vcc
.endm

.macro .v_u32_div_rem v_r, v_q, v_n, v_d, v_tmp4, s_tmp4
    .v_u32_div \v_q, \v_n, \v_d, \v_tmp4, \s_tmp4
    v_mul_lo_u32 v[\v_tmp4], v[\v_d], v[\v_q]
    v_sub_u32 v[\v_r], v[\v_n], v[\v_tmp4]
.endm

.macro .v_u32_div_rem_vs v_r, v_q, v_n, s_d, v_tmp4, s_tmp4
    .v_u32_div_vs \v_q, \v_n, \s_d, \v_tmp4, \s_tmp4
    v_mul_lo_u32 v[\v_tmp4], s[\s_d], v[\v_q]
    v_sub_u32 v[\v_r], v[\v_n], v[\v_tmp4]
.endm

.macro .v_u32_div_rem_ss s_r, s_q, s_n, s_d, v_q, v_tmp4, s_tmp4
    .v_u32_div_ss \v_q, \s_n, \s_d, \v_tmp4, \s_tmp4
    v_readfirstlane_b32 s[\s_q], v[\v_q]
    s_mul_i32 s[\s_tmp4], s[\s_d], s[\s_q]
    s_sub_i32 s[\s_r], s[\s_n], s[\s_tmp4]
.endm

.macro .mdiv_u32_ss s_quot s_numer s_magic s_shift s_tmp
    s_mul_hi_u32 s[\s_tmp], s[\s_magic], s[\s_numer]
    s_add_u32 s[\s_tmp], s[\s_tmp], s[\s_numer]
    s_lshr_b32 s[\s_quot], s[\s_tmp], s[\s_shift]
.endm

.macro .mdiv_u32_rem_ss s_rem s_quot s_numer s_magic s_shift s_denom s_tmp
    .mdiv_u32_ss \s_quot,\s_numer,\s_magic,\s_shift,\s_tmp
    s_mul_i32 s[\s_tmp], s[\s_denom], s[\s_quot]
    s_sub_u32 s[\s_rem], s[\s_numer], s[\s_tmp]
.endm

.macro .mdiv_u32_vs v_quot v_numer s_magic s_shift v_tmp
    v_mul_hi_u32 v[\v_tmp], s[\s_magic], v[\v_numer]
    v_add_u32 v[\v_tmp], v[\v_tmp], v[\v_numer]
    v_lshrrev_b32 v[\v_quot], s[\s_shift], v[\v_tmp]
.endm

.macro .mdiv_u32_rem_vs v_rem v_quot v_numer s_magic s_shift s_denom v_tmp
    .mdiv_u32_vs \v_quot,\v_numer,\s_magic,\s_shift,\v_tmp
    v_mul_lo_u32 v[\v_tmp], s[\s_denom], v[\v_quot]
    v_sub_u32 v[\v_rem], v[\v_numer], v[\v_tmp]
.endm

.macro .v_clear_acc_c a, num
    _a = \a
    .rept \num
        v_accvgpr_write_b32 a[_a], 0
        _a = _a + 1
    .endr
.endm

.macro .v_clear_nc vid, num
    _v = \vid
    .rept \num
        v_mov_b32 v[_v], 0
        _v = _v + 1
    .endr
.endm

;----------------------------------------------------------
; starting of kernel igemm_wrw_gtcx_nchw_fp32_bx16_ex1_bt4x64x16_wt4x64x1_ws1x1_wr1x1_ta1x1x1x1_1x16x1x4_tb1x1x16x1_1x16x1x4
; tensor_layout              : 'nchw'
; gemm_m_per_block           : 4
; gemm_n_per_block           : 64
; gemm_k_per_block           : 16
; wave_tile_m                : 4
; wave_step_m                : 1
; wave_repeat_m              : 1
; wave_tile_n                : 64
; wave_step_n                : 1
; wave_repeat_n              : 1
; wave_tile_k                : 1
; tensor_a_thread_lengths    : [1, 1, 1, 1]
; tensor_a_cluster_lengths   : [1, 16, 1, 4]
; tensor_b_thread_lengths    : [1, 1, 16, 1]
; tensor_b_cluster_lengths   : [1, 16, 1, 4]
; direction                  : 'wrw'
; precision                  : 'fp32'
; nxb                        : 16
; nxe                        : 1
; 
; block_size                 : 64
; lds_total                  : 16384
; 
.set k_p_in, 0
.set k_p_wei, 8
.set k_p_out, 16
.set k_hi, 24
.set k_wi, 28
.set k_n, 32
.set k_k, 36
.set k_c, 40
.set k_ho, 44
.set k_wo, 48
.set k_stride_h, 52
.set k_stride_w, 56
.set k_dilation_h, 60
.set k_dilation_w, 64
.set k_pad_h, 68
.set k_pad_w, 72
.set k_y, 76
.set k_x, 80
.set k_gemm_k_global_split, 84
.set k_group, 88
.set k_pack_0, 92
.set k_end, 96

.set s_ka, 0
.set s_bx, 2
.set s_p_in, 4
.set s_p_wei, 8
.set s_p_out, 12
.set s_hi, 16
.set s_wi, 17
.set s_n, 18
.set s_k, 19
.set s_c, 20
.set s_ho, 21
.set s_wo, 22
.set s_stride_h, 23
.set s_stride_w, 24
.set s_dilation_h, 25
.set s_dilation_w, 26
.set s_pad_h, 27
.set s_pad_w, 28
.set s_y, 29
.set s_x, 30
.set s_gemmk_split, 31
.set s_group, 32
.set s_ho_padded, 33
.set s_out_stride_k, 34
.set s_hoxwo, 31
.set s_out_stride_n, 35
.set s_in_stride_c0, 36
.set s_in_stride_c, 37
.set s_in_stride_n, 38
.set s_wei_stride_c, 39
.set s_wei_stride_k, 40
.set s_out_stride_n_n1, 41
.set s_in_stride_n_n1, 42
.set s_move_slice_n_n1, 43
.set s_move_slice_n_dsho, 44
.set s_move_slice_n_dswo, 45
.set s_dim_b, 46
.set s_block_gtc_ik, 47
.set s_block_gtc_ic0, 48
.set s_block_gtc_ic1e, 49
.set s_block_gtc_in, 50
.set s_block_gtc_ig, 51
.set s_knum, 1
.set s_gemm_k_num_n1, 0
.set s_kitr, 3
.set s_in_offset, 52
.set s_out_offset, 66
.set s_sub_n, 66
.set s_k_padded, 67
.set s_tmp, 68
.set s_end, 74

.set v_c, 0  ; coalescing:4, needed:0, resuable:33
.set v_a, 0
.set v_b, 2
.set v_gld_a, 4
.set v_gld_b, 5
.set v_sst_a_os, 21
.set v_sst_b_os, 22
.set v_sld_a_os, 23
.set v_sld_b_os, 24
.set v_in_ihi, 25
.set v_in_iwi, 26
.set v_in_os, 27
.set v_in_os_base, 28
.set v_out_iho, 29
.set v_out_iwo, 30
.set v_out_os, 31
.set v_out_os_base, 32
.set v_in_flag, 33
.set v_out_flag, 34
.set v_co_sst, 35
.set v_co_sld, 36
.set v_wei_flag, 37
.set v_wei_os, 38
.set v_gtc_ik1, 39
.set v_move_slice_n_in0, 40
.set v_in_flag_prev, 40
.set v_flag_n, 41
.set v_flag_k, 42
.set v_move_slice_n_in1, 43
.set v_move_slice_n_idsho, 44
.set v_move_slice_n_idswo, 45
.set v_wei_iy, 46
.set v_wei_ix, 47
.set v_gtc_ic0, 48
.set v_gtc_ic1e, 49
.set v_gtc_ik0, 50
.set v_gtc_ic1, 51
.set v_gtc_in0, 52
.set v_out_flag_prev, 52
.set v_gtc_in1b, 53
.set v_gtc_in1, 54
.set v_gemm_in, 55
.set v_gemm_im, 56
.set v_wei_ic0, 57
.set v_wei_ic1e, 58
.set v_wei_ic1, 59
.set v_co_sub_m_index, 60
.set v_co_sub_n_index, 61
.set v_cur_k, 62
.set v_cur_c, 63
.set v_in_flag_with_wi, 64
.set v_tmp, 66
.set v_end, 72

.set a_c, 0
.set a_end, 4

.text
.globl igemm_wrw_gtcx_nchw_fp32_bx16_ex1_bt4x64x16_wt4x64x1_ws1x1_wr1x1_ta1x1x1x1_1x16x1x4_tb1x1x16x1_1x16x1x4
.p2align 8
.type igemm_wrw_gtcx_nchw_fp32_bx16_ex1_bt4x64x16_wt4x64x1_ws1x1_wr1x1_ta1x1x1x1_1x16x1x4_tb1x1x16x1_1x16x1x4,@function
igemm_wrw_gtcx_nchw_fp32_bx16_ex1_bt4x64x16_wt4x64x1_ws1x1_wr1x1_ta1x1x1x1_1x16x1x4_tb1x1x16x1_1x16x1x4:
    ; unmerge_sub_n:1, unmerge_sub_n1:1, unmerge_sub_c:64, unmerge_sub_c1:4
    ; gemm_m_unmerge_cluster:0, gemm_n_unmerge_cluster:0, gemm_k_unmerge_cluster:0
    s_load_dwordx2  s[s_p_in+0:s_p_in+1],       s[s_ka+0:s_ka+1],    0+k_p_in
    s_load_dwordx2  s[s_p_wei+0:s_p_wei+1],      s[s_ka+0:s_ka+1],    0+k_p_wei
    s_load_dwordx2  s[s_p_out+0:s_p_out+1],      s[s_ka+0:s_ka+1],    0+k_p_out
    s_load_dwordx16 s[s_hi+0:s_hi+15],        s[s_ka+0:s_ka+1],    0+k_hi
    s_load_dwordx2  s[s_group+0:s_group+1],      s[s_ka+0:s_ka+1],    0+k_group

    ; input, thread(n0,n1b,c0,c1e): 1x1x16x1, cluster(n0,n1b,c0,c1e): 1x16x1x4
    v_mov_b32 v[v_tmp], v0
    v_and_b32 v[v_gtc_in1b], 15, v[v_tmp]
    v_lshrrev_b32 v[v_tmp], 4, v[v_tmp]
    v_mov_b32 v[v_gtc_in0], 0
    v_and_b32 v[v_gtc_ic1e], 3, v[v_tmp]
    v_lshrrev_b32 v[v_tmp], 2, v[v_tmp]
    v_mov_b32 v[v_gtc_ic0], 0

    ; output, thread(n0,n1b,k0,k1): 1x1x1x1, cluster(n0,n1b,k0,k1) 1x16x1x4
    v_lshrrev_b32 v[v_tmp], 4, v0
    v_and_b32 v[v_gtc_ik1], 3, v[v_tmp]
    v_lshrrev_b32 v[v_tmp], 2, v[v_tmp]
    v_mov_b32 v[v_gtc_ik0], 0

    s_mov_b32 s[s_p_in+3], 0x27000
    s_mov_b32 s[s_p_wei+2], 0xffffffff
    s_mov_b32 s[s_p_wei+3], 0x27000
    s_mov_b32 s[s_p_out+3], 0x27000
    s_waitcnt lgkmcnt(0)

    ; calculate index
    s_mul_i32 s[s_in_stride_c],      s[s_hi],       s[s_wi]
    s_mul_i32 s[s_tmp],  s[s_in_stride_c], s[s_c]
    s_mul_i32 s[s_in_stride_n],      s[s_group],        s[s_tmp]
    s_mul_i32 s[s_wei_stride_c],       s[s_y],       s[s_x]
    s_mul_i32 s[s_wei_stride_k],       s[s_c],        s[s_wei_stride_c]
    s_mul_i32 s[s_out_stride_k],      s[s_ho],        s[s_wo]
    s_mul_i32 s[s_tmp],  s[s_out_stride_k],  s[s_k]
    s_mul_i32 s[s_out_stride_n],      s[s_group],        s[s_tmp]
    ; config for weight range
    s_mul_i32 s[s_p_out+2], s[s_out_stride_n], s[s_n]
    s_lshl_b32 s[s_p_out+2], s[s_p_out+2], 2
    s_lshl_b32 s[s_in_stride_c0], s[s_in_stride_c], 2
    s_add_u32 s[s_tmp], 15, s[s_out_stride_k]
    s_lshr_b32 s[s_tmp+1], s[s_tmp], 4
    s_lshl_b32 s[s_dim_b], s[s_tmp+1], 4
    ; n1b transform
    .v_u32_div_rem_vs v_tmp+4, v_move_slice_n_in1, v_gtc_in1b, s_dim_b, v_tmp, s_tmp
    .v_u32_div_rem_vs v_move_slice_n_idswo, v_move_slice_n_idsho, v_tmp+4, s_wo, v_tmp, s_tmp
    v_mov_b32 v[v_move_slice_n_in0], v[v_gtc_in0]

    ; pad gemm_m if needed
    s_add_u32 s[s_tmp], 3, s[s_k]
    s_lshr_b32 s[s_tmp], s[s_tmp], 2
    s_lshl_b32 s[s_k_padded], s[s_tmp], 2

    ; add block i_n
    ; gemm_m_per_block:4, gemm_n_per_block:64
    s_lshr_b32 s[0], s[s_wei_stride_k], 6

    ; padding k
    s_add_u32 s[s_tmp], s[s_k], 3
    s_lshr_b32 s[s_tmp], s[s_tmp], 2
    s_mul_i32 s[1], s[0], s[s_tmp]
    s_lshl_b32 s[3], s[1], s[s_gemmk_split]
    .v_u32_div_rem_ss s_tmp+4, s_block_gtc_ig, s_bx, 3, v_tmp+5, v_tmp, s_tmp
    .v_u32_div_rem_ss s_bx, s_block_gtc_in, s_tmp+4, 1, v_tmp+5, v_tmp, s_tmp
    ; config input and output n offset
    s_lshr_b32 s[s_sub_n], s[s_n], s[s_gemmk_split]
    s_mul_i32 s[s_block_gtc_in], s[s_block_gtc_in], s[s_sub_n]
    .v_u32_div_rem_ss s_tmp+4, s_tmp+5, s_bx, 0, v_tmp+5, v_tmp, s_tmp
    ; s_tmp+4:block_gtc_in, s_tmp+5:block_gtc_im
    s_lshl_b32 s[s_block_gtc_ik], s[s_tmp+5], 2
    s_mov_b32 s[0], s[s_wei_stride_c] ; total number of c1e
    .v_u32_div_rem_ss s_block_gtc_ic1e, s_block_gtc_ic0, s_tmp+4, 0, v_tmp+5, v_tmp, s_tmp
    s_lshl_b32 s[s_block_gtc_ic1e], s[s_block_gtc_ic1e], 2
    s_lshl_b32 s[s_block_gtc_ic0], s[s_block_gtc_ic0], 4

    ; c1e transform
    v_add_u32 v[v_tmp+5], s[s_block_gtc_ic1e], v[v_gtc_ic1e]
    .v_u32_div_rem_vs v_tmp+4, v_gtc_ic1, v_tmp+5, s_wei_stride_c, v_tmp, s_tmp
    .v_u32_div_rem_vs v_wei_ix, v_wei_iy, v_tmp+4, s_x, v_tmp, s_tmp

    v_mul_u32_u24 v[v_tmp], s[s_dilation_h], v[v_wei_iy]
    v_mul_u32_u24 v[v_tmp+1], s[s_dilation_w], v[v_wei_ix]
    v_sub_i32 v[v_wei_iy], v[v_tmp], s[s_pad_h]
    v_sub_i32 v[v_wei_ix], v[v_tmp+1], s[s_pad_w]
    ; ihi = iho * s_stride_h + iy * s_dilation_h - s_pad_h,   here make sure iy <- iy * s_dilation_h - s_pad_h before hand
    ; iwi = iwo * s_stride_w + ix * s_dilation_w - s_pad_w,   here make sure ix <- ix * s_dilation_w - s_pad_w before hand
    v_mul_lo_u32 v[v_tmp], s[s_stride_h], v[v_move_slice_n_idsho]
    v_add_i32 v[v_in_ihi], v[v_tmp], v[v_wei_iy]
    v_mul_lo_u32 v[v_tmp+1], s[s_stride_w], v[v_move_slice_n_idswo]
    v_add_i32 v[v_in_iwi], v[v_tmp+1], v[v_wei_ix]
    ; calculate input offset
    ; set input range
    s_mul_i32 s[s_p_in+2], s[s_in_stride_n], s[s_n]
    s_lshl_b32 s[s_p_in+2], s[s_p_in+2], 2
    s_mul_i32 s[s_tmp+5], s[s_c], s[s_in_stride_c]
    s_lshl_b32 s[s_block_gtc_ig], s[s_block_gtc_ig], 2
    s_mul_i32 s[s_tmp], s[s_block_gtc_ig], s[s_tmp+5]
    s_mul_hi_u32 s[s_tmp+1], s[s_block_gtc_ig], s[s_tmp+5]
    s_sub_u32 s[s_p_in+2], s[s_p_in+2], s[s_tmp]
    s_add_u32 s[s_p_in], s[s_p_in], s[s_tmp]
    s_addc_u32 s[s_p_in+1], s[s_p_in+1], s[s_tmp+1]
    s_lshl_b32 s[s_tmp+3], s[s_block_gtc_ic0], 4
    s_mul_i32 s[s_tmp], s[s_in_stride_c], s[s_tmp+3]
    s_mul_hi_u32 s[s_tmp+1], s[s_in_stride_c], s[s_tmp+3]
    s_sub_u32 s[s_p_in+2], s[s_p_in+2], s[s_tmp]
    s_add_u32 s[s_p_in], s[s_p_in], s[s_tmp]
    s_addc_u32 s[s_p_in+1], s[s_p_in+1], s[s_tmp+1]

    v_mov_b32 v[v_tmp], v[v_move_slice_n_in1]
    v_cmp_gt_u32 vcc, s[s_n], v[v_tmp]
    v_cndmask_b32 v[v_flag_n], 0, 1, vcc
    v_add_u32 v[v_tmp], v[v_tmp], s[s_block_gtc_in]
    v_mul_lo_u32 v[v_tmp], s[s_in_stride_n], v[v_tmp]
    v_mov_b32 v[v_tmp+1], v[v_gtc_ic1]
    v_mul_lo_u32 v[v_tmp+1], s[s_in_stride_c], v[v_tmp+1]
    v_add_lshl_u32 v[v_in_os_base], v[v_tmp], v[v_tmp+1], 2
    ; from hi, wi, os_base, compute final offset
    v_mad_u32_u24 v[v_tmp], s[s_wi], v[v_in_ihi], v[v_in_iwi]
    v_lshl_add_u32 v[v_in_os], v[v_tmp], 2, v[v_in_os_base]
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, 1, vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag], vcc
    v_and_b32 v[v_in_flag], v[v_in_flag], v[v_flag_n]

    s_lshl_b32 s[s_in_stride_c0], s[s_in_stride_c0], 2

    s_mul_i32 s[s_in_offset+0], 2, s[s_in_stride_c0]
    s_mul_i32 s[s_in_offset+1], 3, s[s_in_stride_c0]
    s_mul_i32 s[s_in_offset+2], 4, s[s_in_stride_c0]
    s_mul_i32 s[s_in_offset+3], 5, s[s_in_stride_c0]
    s_mul_i32 s[s_in_offset+4], 6, s[s_in_stride_c0]
    s_mul_i32 s[s_in_offset+5], 7, s[s_in_stride_c0]
    s_mul_i32 s[s_in_offset+6], 8, s[s_in_stride_c0]
    s_mul_i32 s[s_in_offset+7], 9, s[s_in_stride_c0]
    s_mul_i32 s[s_in_offset+8], 10, s[s_in_stride_c0]
    s_mul_i32 s[s_in_offset+9], 11, s[s_in_stride_c0]
    s_mul_i32 s[s_in_offset+10], 12, s[s_in_stride_c0]
    s_mul_i32 s[s_in_offset+11], 13, s[s_in_stride_c0]
    s_mul_i32 s[s_in_offset+12], 14, s[s_in_stride_c0]
    s_mul_i32 s[s_in_offset+13], 15, s[s_in_stride_c0]
    ; load input
    .v_clear_nc v_gld_b, 16
    v_cmpx_eq_u32 vcc, 1, v[v_in_flag]
    buffer_load_dword v[v_gld_b+0], v[v_in_os], s[s_p_in:s_p_in+3], 0 offen offset:0
    buffer_load_dword v[v_gld_b+1], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_stride_c0] offen offset:0
    buffer_load_dword v[v_gld_b+2], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+0] offen offset:0
    buffer_load_dword v[v_gld_b+3], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+1] offen offset:0
    buffer_load_dword v[v_gld_b+4], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+2] offen offset:0
    buffer_load_dword v[v_gld_b+5], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+3] offen offset:0
    buffer_load_dword v[v_gld_b+6], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+4] offen offset:0
    buffer_load_dword v[v_gld_b+7], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+5] offen offset:0
    buffer_load_dword v[v_gld_b+8], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+6] offen offset:0
    buffer_load_dword v[v_gld_b+9], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+7] offen offset:0
    buffer_load_dword v[v_gld_b+10], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+8] offen offset:0
    buffer_load_dword v[v_gld_b+11], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+9] offen offset:0
    buffer_load_dword v[v_gld_b+12], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+10] offen offset:0
    buffer_load_dword v[v_gld_b+13], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+11] offen offset:0
    buffer_load_dword v[v_gld_b+14], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+12] offen offset:0
    buffer_load_dword v[v_gld_b+15], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+13] offen offset:0
    s_mov_b64 exec, -1

    ; calculate out offset
    ; set output range
    s_mul_i32 s[s_p_out+2], s[s_out_stride_n], s[s_n]
    s_lshl_b32 s[s_p_out+2], s[s_p_out+2], 2
    s_mul_i32 s[s_tmp+2], s[s_k], s[s_out_stride_k]
    s_mul_i32 s[s_tmp], s[s_block_gtc_ig], s[s_tmp+2]
    s_mul_hi_u32 s[s_tmp+1], s[s_block_gtc_ig], s[s_tmp+2]
    s_sub_u32 s[s_p_out+2], s[s_p_out+2], s[s_tmp]
    s_add_u32 s[s_p_out], s[s_p_out], s[s_tmp]
    s_addc_u32 s[s_p_out+1], s[s_p_out+1], s[s_tmp+1]

    v_mov_b32 v[v_tmp], v[v_gtc_ik1]
    v_add_u32 v[v_tmp+5], s[s_block_gtc_ik], v[v_tmp]
    v_cmp_gt_u32 vcc, s[s_k], v[v_tmp+5]
    v_cndmask_b32 v[v_flag_k], 0, 1, vcc
    v_mul_lo_u32 v[v_tmp], s[s_out_stride_k], v[v_tmp+5]
    v_mov_b32 v[v_tmp+1], v[v_move_slice_n_in1]
    v_add_u32 v[v_tmp+1], v[v_tmp+1], s[s_block_gtc_in]
    v_mul_lo_u32 v[v_tmp+1], s[s_out_stride_n], v[v_tmp+1]
    v_add_lshl_u32 v[v_out_os_base], v[v_tmp], v[v_tmp+1], 2
    ; from ho, wo, os_base, compute final offset
    v_mad_u32_u24 v[v_tmp], s[s_wo], v[v_move_slice_n_idsho], v[v_move_slice_n_idswo]
    v_lshl_add_u32 v[v_out_os], v[v_tmp], 2, v[v_out_os_base]
    v_cmp_gt_u32 vcc, s[s_ho], v[v_move_slice_n_idsho]
    v_cndmask_b32 v[v_out_flag], 0, 1, vcc
    v_cmp_gt_u32 vcc, s[s_wo], v[v_move_slice_n_idswo]
    v_cndmask_b32 v[v_out_flag], 0, v[v_out_flag], vcc
    v_and_b32 v[v_out_flag], v[v_out_flag], v[v_flag_n]
    v_and_b32 v[v_out_flag], v[v_out_flag], v[v_flag_k]


    
    ; load output
    .v_clear_nc v_gld_a, 1
    v_cmpx_eq_u32 vcc, 1, v[v_out_flag]
    buffer_load_dword v[v_gld_a+0], v[v_out_os], s[s_p_out:s_p_out+3], 0 offen offset:0
    s_mov_b64 exec, -1

    v_mov_b32 v[v_tmp+5], v0
    ; xdlops mapping, get source matrix gemm index
    v_and_b32 v[v_gemm_in], 3, v[v_tmp+5]           ; block_n index 
    v_and_b32 v[v_gemm_im], 3, v[v_tmp+5]           ; block_m index 
    v_lshrrev_b32 v[v_tmp+5], 2, v[v_tmp+5]
    v_and_b32 v[v_tmp + 0], 15, v[v_tmp+5]          ; block_n_per_wave index
    v_lshl_or_b32 v[v_gemm_in], v[v_tmp + 0], 2, v[v_gemm_in]
    v_lshrrev_b32 v[v_tmp+5], 4, v[v_tmp+5]

    v_mov_b32 v[v_tmp+5], v0
    ; xdlops mapping, get dst matrix gemm index
    v_and_b32 v[v_tmp+0], 3, v[v_tmp+5]
    v_lshrrev_b32 v[v_tmp+5], 2, v[v_tmp+5]
    v_and_b32 v[v_tmp+2], 15, v[v_tmp+5]
    v_lshrrev_b32 v[v_tmp+5], 4, v[v_tmp+5]
    v_mov_b32 v[v_co_sst], v[v_tmp+0]
    v_lshl_or_b32 v[v_co_sst], v[v_tmp+2], 2, v[v_co_sst]
    v_mov_b32 v[v_co_sld], 0

    ; LDS store, in: n0,n1b,c0,c1e: 1x1x16x1, 1x16x1x4, order:4
    v_lshlrev_b32 v[v_tmp], 0, v[v_gtc_ic1e]
    v_lshl_or_b32 v[v_tmp], v[v_gtc_in1b], 6, v[v_tmp]
    v_lshlrev_b32 v[v_sst_b_os], 2, v[v_tmp]
    v_add_u32 v[v_sst_b_os], 256, v[v_sst_b_os]

    ; LDS store, out: n0,n1b,k0,k1: 1x1x1x1, 1x16x1x4, order:0
    v_lshlrev_b32 v[v_tmp], 0, v[v_gtc_ik1]
    v_lshl_or_b32 v[v_tmp], v[v_gtc_in1b], 2, v[v_tmp]
    v_lshlrev_b32 v[v_sst_a_os], 2, v[v_tmp]

    ; LDS load
    v_lshlrev_b32 v[v_sld_b_os], 2, v[v_gemm_in]
    v_lshlrev_b32 v[v_sld_a_os], 2, v[v_gemm_im]
    v_add_u32 v[v_sld_b_os], 256, v[v_sld_b_os]

    v_mov_b32 v[v_gemm_in], v[v_co_sst]
    v_mov_b32 v[v_gemm_im], v[v_co_sld]
    ; init_co_lds_offset for xdlops
    v_lshrrev_b32 v[v_tmp], 2, v[v_gemm_im]
    v_and_b32 v[v_tmp], 0, v[v_tmp]   ; thread id of lanegroup_m_per_cluster
    v_lshlrev_b32 v[v_co_sst], 2, v[v_tmp]
    v_lshrrev_b32 v[v_tmp], 2, v[v_co_sst]
    v_lshlrev_b32 v[v_tmp+1], 2, v[v_gemm_in]   ; implicit transpose with m granularity:4 while store
    v_lshl_or_b32 v[v_co_sst], v[v_tmp], 8, v[v_tmp+1]
    v_lshlrev_b32 v[v_co_sst], 2, v[v_co_sst]
    v_lshlrev_b32 v[v_co_sld], 4, v[0]
    ; init_co_sub_m_index xdlops, block_size:64, macro-tile:4x64 sub_m_index:[0]
    ; g_mr:1, g_ms:1, g_mw:1, g_mb:1, g_mt:1 | l_mr:1, l_ms:1, l_mw:1, l_mb:1, l_mt:4 | n_mc:1, n_ml:1, n_mv:1
    ; nd_stride:[1, 1, 1, 1, 1, 1, 1]
    v_mov_b32 v[v_co_sub_m_index], 0
    ; init_co_sub_n_index xdlops
    v_and_b32 v[v_co_sub_n_index], 63, v[0]

    ; weight offset
    s_mul_i32 s[s_tmp+2], s[s_k], s[s_wei_stride_k]
    s_mul_i32 s[s_tmp], s[s_block_gtc_ig], s[s_tmp+2]
    s_mul_hi_u32 s[s_tmp+1], s[s_block_gtc_ig], s[s_tmp+2]
    s_add_u32 s[s_p_wei], s[s_p_wei], s[s_tmp]
    s_addc_u32 s[s_p_wei+1], s[s_p_wei+1], s[s_tmp+1]
    s_lshl_b32 s[s_tmp+3], s[s_block_gtc_ic0], 4
    s_mul_i32 s[s_tmp], s[s_wei_stride_c], s[s_tmp+3]
    s_mul_hi_u32 s[s_tmp+1], s[s_wei_stride_c], s[s_tmp+3]
    s_add_u32 s[s_p_wei], s[s_p_wei], s[s_tmp]
    s_addc_u32 s[s_p_wei+1], s[s_p_wei+1], s[s_tmp+1]

    s_lshl_b32 s[s_tmp+3], s[s_block_gtc_ik], 2
    s_mul_i32 s[s_tmp], s[s_wei_stride_k], s[s_tmp+3]
    s_mul_hi_u32 s[s_tmp+1], s[s_wei_stride_k], s[s_tmp+3]
    s_add_u32 s[s_p_wei], s[s_p_wei], s[s_tmp]
    s_addc_u32 s[s_p_wei+1], s[s_p_wei+1], s[s_tmp+1]

    ; compute v_co_sub_n_index along c0 x c1e : 16x4
    v_and_b32 v[v_wei_ic1e], 3, v[v_co_sub_n_index]     ; => C1E
    v_lshrrev_b32 v[v_wei_ic0], 2, v[v_co_sub_n_index]  ; => C0
    ;   compute from n1b
    v_add_u32 v[v_tmp+5], s[s_block_gtc_ic1e], v[v_wei_ic1e]
    .v_u32_div_rem_vs v_tmp+4, v_wei_ic1, v_tmp+5, s_wei_stride_c, v_tmp, s_tmp

    ; add wei_ic0, wei_ic1
    v_lshl_or_b32 v[v_tmp+1], v[v_wei_ic0], 2, v[v_wei_ic1]
    v_mul_lo_u32 v[v_wei_os], s[s_wei_stride_c], v[v_tmp+1]
    ; add i_k
    v_mul_lo_u32 v[v_tmp], s[s_wei_stride_k], v[v_co_sub_m_index]
    v_add_u32 v[v_wei_os], v[v_wei_os], v[v_tmp]
    ; add y, x
    v_add_u32 v[v_wei_os], v[v_wei_os], v[v_tmp+4]
    v_lshlrev_b32 v[v_wei_os], 2, v[v_wei_os]
    ; move slice stride
    s_mul_i32 s[s_hoxwo], s[s_ho], s[s_wo]
    s_mov_b32 s[0], 16
    .v_u32_div_rem_ss s_tmp+4, s_move_slice_n_n1, 0, s_dim_b, v_tmp+4, v_tmp, s_tmp
    .v_u32_div_rem_ss s_move_slice_n_dswo, s_move_slice_n_dsho, s_tmp+4, s_wo, v_tmp+4, v_tmp, s_tmp

    s_mul_i32 s[s_in_stride_n_n1], s[s_move_slice_n_n1], s[s_in_stride_n]  ; might be 0 or larger
    s_mul_i32 s[s_out_stride_n_n1], s[s_move_slice_n_n1], s[s_out_stride_n]  ; might be 0 or larger
    s_lshl_b32 s[s_in_stride_n_n1], s[s_in_stride_n_n1], 2
    s_lshl_b32 s[s_out_stride_n_n1], s[s_out_stride_n_n1], 2
    s_lshl_b32 s[s_in_stride_n], s[s_in_stride_n], 2
    s_lshl_b32 s[s_out_stride_n], s[s_out_stride_n], 2
    s_lshl_b32 s[s_wei_stride_k], s[s_wei_stride_k], 2
    s_mov_b32 s[s_gemm_k_num_n1], 1
    s_mul_i32 s[s_knum], s[s_dim_b], s[s_sub_n]

    ; start MFMA loop, 4x64 wave tile with 1x1 repeat, 1x1 step
    s_waitcnt vmcnt(1)
    ds_write2_b32 v[v_sst_b_os], v[v_gld_b+0], v[v_gld_b+0+1], offset0:0, offset1:4
    ds_write2_b32 v[v_sst_b_os], v[v_gld_b+2], v[v_gld_b+2+1], offset0:8, offset1:12
    ds_write2_b32 v[v_sst_b_os], v[v_gld_b+4], v[v_gld_b+4+1], offset0:16, offset1:20
    ds_write2_b32 v[v_sst_b_os], v[v_gld_b+6], v[v_gld_b+6+1], offset0:24, offset1:28
    ds_write2_b32 v[v_sst_b_os], v[v_gld_b+8], v[v_gld_b+8+1], offset0:32, offset1:36
    ds_write2_b32 v[v_sst_b_os], v[v_gld_b+10], v[v_gld_b+10+1], offset0:40, offset1:44
    ds_write2_b32 v[v_sst_b_os], v[v_gld_b+12], v[v_gld_b+12+1], offset0:48, offset1:52
    ds_write2_b32 v[v_sst_b_os], v[v_gld_b+14], v[v_gld_b+14+1], offset0:56, offset1:60

    s_waitcnt vmcnt(0)
    ds_write_b32 v[v_sst_a_os], v[v_gld_a+0] 

    .v_clear_acc_c a_c, 4
    ; make sure acc WAR harzard, at least 1 nop for src_c
    s_sub_i32 s[s_kitr], s[s_knum], 16
    s_cmp_gt_i32 s[s_kitr], 0
    s_cbranch_scc0 L_igemm_wrw_gtcx_nchw_fp32_bx16_ex1_bt4x64x16_wt4x64x1_ws1x1_wr1x1_ta1x1x1x1_1x16x1x4_tb1x1x16x1_1x16x1x4_mfma_end

    v_xor_b32 v[v_sst_b_os], 0x2000, v[v_sst_b_os] ; switch double buffer b store
    v_xor_b32 v[v_sst_a_os], 0x2000, v[v_sst_a_os] ; switch double buffer a store
    v_add_u32 v[v_move_slice_n_idswo], s[s_move_slice_n_dswo], v[v_move_slice_n_idswo]
    v_cmpx_le_u32 vcc, s[s_wo], v[v_move_slice_n_idswo]
    v_subrev_u32 v[v_move_slice_n_idswo], s[s_wo], v[v_move_slice_n_idswo]
    v_add_u32 v[v_move_slice_n_idsho], 1, v[v_move_slice_n_idsho]
    s_mov_b64 exec, -1

    v_add_u32 v[v_move_slice_n_idsho], s[s_move_slice_n_dsho], v[v_move_slice_n_idsho]
    v_cmpx_le_u32 vcc, s[s_ho_padded], v[v_move_slice_n_idsho]
    v_subrev_u32 v[v_move_slice_n_idsho], s[s_ho_padded], v[v_move_slice_n_idsho]
    v_add_u32 v[v_move_slice_n_in1], 1, v[v_move_slice_n_in1]
    v_add_u32 v[v_in_os_base], s[s_in_stride_n], v[v_in_os_base]
    v_add_u32 v[v_out_os_base], s[s_out_stride_n], v[v_out_os_base]
    s_mov_b64 exec, -1

    v_add_u32 v[v_move_slice_n_in1], s[s_move_slice_n_n1], v[v_move_slice_n_in1]
    v_cmpx_gt_u32 vcc, s[s_sub_n], v[v_move_slice_n_in1]
    v_add_u32 v[v_in_os_base], s[s_in_stride_n_n1], v[v_in_os_base]
    v_add_u32 v[v_out_os_base], s[s_out_stride_n_n1], v[v_out_os_base]
    s_mov_b64 exec, -1
    v_cndmask_b32 v[v_flag_n], 0, 1, vcc
    ; ihi = iho * s_stride_h + iy * s_dilation_h - s_pad_h,   here make sure iy <- iy * s_dilation_h - s_pad_h before hand
    ; iwi = iwo * s_stride_w + ix * s_dilation_w - s_pad_w,   here make sure ix <- ix * s_dilation_w - s_pad_w before hand
    v_mul_lo_u32 v[v_tmp], s[s_stride_h], v[v_move_slice_n_idsho]
    v_add_i32 v[v_in_ihi], v[v_tmp], v[v_wei_iy]
    v_mul_lo_u32 v[v_tmp+1], s[s_stride_w], v[v_move_slice_n_idswo]
    v_add_i32 v[v_in_iwi], v[v_tmp+1], v[v_wei_ix]
    ; from hi, wi, os_base, compute final offset
    v_mad_u32_u24 v[v_tmp], s[s_wi], v[v_in_ihi], v[v_in_iwi]
    v_lshl_add_u32 v[v_in_os], v[v_tmp], 2, v[v_in_os_base]
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    v_cndmask_b32 v[v_in_flag], 0, 1, vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag], vcc
    v_and_b32 v[v_in_flag], v[v_in_flag], v[v_flag_n]
    ; from ho, wo, os_base, compute final offset
    v_mad_u32_u24 v[v_tmp], s[s_wo], v[v_move_slice_n_idsho], v[v_move_slice_n_idswo]
    v_lshl_add_u32 v[v_out_os], v[v_tmp], 2, v[v_out_os_base]
    v_cmp_gt_u32 vcc, s[s_ho], v[v_move_slice_n_idsho]
    v_cndmask_b32 v[v_out_flag], 0, 1, vcc
    v_cmp_gt_u32 vcc, s[s_wo], v[v_move_slice_n_idswo]
    v_cndmask_b32 v[v_out_flag], 0, v[v_out_flag], vcc
    v_and_b32 v[v_out_flag], v[v_out_flag], v[v_flag_n]
    v_and_b32 v[v_out_flag], v[v_out_flag], v[v_flag_k]
L_igemm_wrw_gtcx_nchw_fp32_bx16_ex1_bt4x64x16_wt4x64x1_ws1x1_wr1x1_ta1x1x1x1_1x16x1x4_tb1x1x16x1_1x16x1x4_mfma_body:
    ; load input
    .v_clear_nc v_gld_b, 16
    v_cmpx_eq_u32 vcc, 1, v[v_in_flag]
    buffer_load_dword v[v_gld_b+0], v[v_in_os], s[s_p_in:s_p_in+3], 0 offen offset:0
    buffer_load_dword v[v_gld_b+1], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_stride_c0] offen offset:0
    buffer_load_dword v[v_gld_b+2], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+0] offen offset:0
    buffer_load_dword v[v_gld_b+3], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+1] offen offset:0
    buffer_load_dword v[v_gld_b+4], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+2] offen offset:0
    buffer_load_dword v[v_gld_b+5], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+3] offen offset:0
    buffer_load_dword v[v_gld_b+6], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+4] offen offset:0
    buffer_load_dword v[v_gld_b+7], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+5] offen offset:0
    buffer_load_dword v[v_gld_b+8], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+6] offen offset:0
    buffer_load_dword v[v_gld_b+9], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+7] offen offset:0
    buffer_load_dword v[v_gld_b+10], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+8] offen offset:0
    buffer_load_dword v[v_gld_b+11], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+9] offen offset:0
    buffer_load_dword v[v_gld_b+12], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+10] offen offset:0
    buffer_load_dword v[v_gld_b+13], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+11] offen offset:0
    buffer_load_dword v[v_gld_b+14], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+12] offen offset:0
    buffer_load_dword v[v_gld_b+15], v[v_in_os], s[s_p_in:s_p_in+3], s[s_in_offset+13] offen offset:0
    s_mov_b64 exec, -1
    ; load output
    .v_clear_nc v_gld_a, 1
    v_cmpx_eq_u32 vcc, 1, v[v_out_flag]
    buffer_load_dword v[v_gld_a+0], v[v_out_os], s[s_p_out:s_p_out+3], 0 offen offset:0
    s_mov_b64 exec, -1
    ; do fma accumulate with unroll 16
    s_waitcnt lgkmcnt(0)
    s_barrier

    ds_read_b32 v[v_a], v[v_sld_a_os] 
    ds_read_b32 v[v_b], v[v_sld_b_os] 
    ds_read_b32 v[v_a+1], v[v_sld_a_os] offset:16
    ds_read_b32 v[v_b+1], v[v_sld_b_os] offset:256
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a], v[v_b], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    v_add_u32 v[v_move_slice_n_idswo], s[s_move_slice_n_dswo], v[v_move_slice_n_idswo]
    v_cmpx_le_u32 vcc, s[s_wo], v[v_move_slice_n_idswo]
    v_subrev_u32 v[v_move_slice_n_idswo], s[s_wo], v[v_move_slice_n_idswo]
    v_add_u32 v[v_move_slice_n_idsho], 1, v[v_move_slice_n_idsho]
    s_mov_b64 exec, -1
    ds_read_b32 v[v_a], v[v_sld_a_os] offset:32
    ds_read_b32 v[v_b], v[v_sld_b_os] offset:512
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a+1], v[v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    v_add_u32 v[v_move_slice_n_idsho], s[s_move_slice_n_dsho], v[v_move_slice_n_idsho]
    v_cmpx_le_u32 vcc, s[s_ho_padded], v[v_move_slice_n_idsho]
    v_subrev_u32 v[v_move_slice_n_idsho], s[s_ho_padded], v[v_move_slice_n_idsho]
    v_add_u32 v[v_move_slice_n_in1], 1, v[v_move_slice_n_in1]
    v_add_u32 v[v_in_os_base], s[s_in_stride_n], v[v_in_os_base]
    v_add_u32 v[v_out_os_base], s[s_out_stride_n], v[v_out_os_base]
    s_mov_b64 exec, -1
    ds_read_b32 v[v_a+1], v[v_sld_a_os] offset:48
    ds_read_b32 v[v_b+1], v[v_sld_b_os] offset:768
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a], v[v_b], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    v_add_u32 v[v_move_slice_n_in1], s[s_move_slice_n_n1], v[v_move_slice_n_in1]
    v_cmpx_gt_u32 vcc, s[s_sub_n], v[v_move_slice_n_in1]
    v_add_u32 v[v_in_os_base], s[s_in_stride_n_n1], v[v_in_os_base]
    v_add_u32 v[v_out_os_base], s[s_out_stride_n_n1], v[v_out_os_base]
    s_mov_b64 exec, -1
    ds_read_b32 v[v_a], v[v_sld_a_os] offset:64
    ds_read_b32 v[v_b], v[v_sld_b_os] offset:1024
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a+1], v[v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    v_cndmask_b32 v[v_flag_n], 0, 1, vcc
    v_mul_lo_u32 v[v_tmp], s[s_stride_h], v[v_move_slice_n_idsho]
    ds_read_b32 v[v_a+1], v[v_sld_a_os] offset:80
    ds_read_b32 v[v_b+1], v[v_sld_b_os] offset:1280
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a], v[v_b], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    v_add_i32 v[v_in_ihi], v[v_tmp], v[v_wei_iy]
    v_mul_lo_u32 v[v_tmp+1], s[s_stride_w], v[v_move_slice_n_idswo]
    ds_read_b32 v[v_a], v[v_sld_a_os] offset:96
    ds_read_b32 v[v_b], v[v_sld_b_os] offset:1536
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a+1], v[v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    v_add_i32 v[v_in_iwi], v[v_tmp+1], v[v_wei_ix]
    v_mad_u32_u24 v[v_tmp], s[s_wi], v[v_in_ihi], v[v_in_iwi]
    ds_read_b32 v[v_a+1], v[v_sld_a_os] offset:112
    ds_read_b32 v[v_b+1], v[v_sld_b_os] offset:1792
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a], v[v_b], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    v_lshl_add_u32 v[v_in_os], v[v_tmp], 2, v[v_in_os_base]
    v_cmp_gt_u32 vcc, s[s_hi], v[v_in_ihi]
    ds_read_b32 v[v_a], v[v_sld_a_os] offset:128
    ds_read_b32 v[v_b], v[v_sld_b_os] offset:2048
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a+1], v[v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    v_cndmask_b32 v[v_in_flag], 0, 1, vcc
    v_cmp_gt_u32 vcc, s[s_wi], v[v_in_iwi]
    ds_read_b32 v[v_a+1], v[v_sld_a_os] offset:144
    ds_read_b32 v[v_b+1], v[v_sld_b_os] offset:2304
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a], v[v_b], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    v_cndmask_b32 v[v_in_flag], 0, v[v_in_flag], vcc
    v_and_b32 v[v_in_flag], v[v_in_flag], v[v_flag_n]
    ds_read_b32 v[v_a], v[v_sld_a_os] offset:160
    ds_read_b32 v[v_b], v[v_sld_b_os] offset:2560
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a+1], v[v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    v_mad_u32_u24 v[v_tmp], s[s_wo], v[v_move_slice_n_idsho], v[v_move_slice_n_idswo]
    v_lshl_add_u32 v[v_out_os], v[v_tmp], 2, v[v_out_os_base]
    ds_read_b32 v[v_a+1], v[v_sld_a_os] offset:176
    ds_read_b32 v[v_b+1], v[v_sld_b_os] offset:2816
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a], v[v_b], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    v_cmp_gt_u32 vcc, s[s_ho], v[v_move_slice_n_idsho]
    v_cndmask_b32 v[v_out_flag], 0, 1, vcc
    ds_read_b32 v[v_a], v[v_sld_a_os] offset:192
    ds_read_b32 v[v_b], v[v_sld_b_os] offset:3072
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a+1], v[v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    v_cmp_gt_u32 vcc, s[s_wo], v[v_move_slice_n_idswo]
    v_cndmask_b32 v[v_out_flag], 0, v[v_out_flag], vcc
    ds_read_b32 v[v_a+1], v[v_sld_a_os] offset:208
    ds_read_b32 v[v_b+1], v[v_sld_b_os] offset:3328
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a], v[v_b], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    v_and_b32 v[v_out_flag], v[v_out_flag], v[v_flag_n]
    v_and_b32 v[v_out_flag], v[v_out_flag], v[v_flag_k]
    ds_read_b32 v[v_a], v[v_sld_a_os] offset:224
    ds_read_b32 v[v_b], v[v_sld_b_os] offset:3584
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a+1], v[v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b32 v[v_a+1], v[v_sld_a_os] offset:240
    ds_read_b32 v[v_b+1], v[v_sld_b_os] offset:3840
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a], v[v_b], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    s_waitcnt lgkmcnt(0)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a+1], v[v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ; k iteration : 14
    s_waitcnt lgkmcnt(0)
    s_waitcnt vmcnt(1)
    ds_write2_b32 v[v_sst_b_os], v[v_gld_b+0], v[v_gld_b+0+1], offset0:0, offset1:4
    ds_write2_b32 v[v_sst_b_os], v[v_gld_b+2], v[v_gld_b+2+1], offset0:8, offset1:12
    ds_write2_b32 v[v_sst_b_os], v[v_gld_b+4], v[v_gld_b+4+1], offset0:16, offset1:20
    ds_write2_b32 v[v_sst_b_os], v[v_gld_b+6], v[v_gld_b+6+1], offset0:24, offset1:28
    ds_write2_b32 v[v_sst_b_os], v[v_gld_b+8], v[v_gld_b+8+1], offset0:32, offset1:36
    ds_write2_b32 v[v_sst_b_os], v[v_gld_b+10], v[v_gld_b+10+1], offset0:40, offset1:44
    ds_write2_b32 v[v_sst_b_os], v[v_gld_b+12], v[v_gld_b+12+1], offset0:48, offset1:52
    ds_write2_b32 v[v_sst_b_os], v[v_gld_b+14], v[v_gld_b+14+1], offset0:56, offset1:60
    s_waitcnt vmcnt(0)
    ds_write_b32 v[v_sst_a_os], v[v_gld_a+0] 
    
    v_xor_b32 v[v_sld_b_os], 8192, v[v_sld_b_os] ; switch double buffer b load
    v_xor_b32 v[v_sld_a_os], 8192, v[v_sld_a_os] ; switch double buffer a load
    s_sub_i32 s[s_kitr], s[s_kitr], 16
    s_cmp_gt_i32 s[s_kitr], 0
    s_cbranch_scc0 L_igemm_wrw_gtcx_nchw_fp32_bx16_ex1_bt4x64x16_wt4x64x1_ws1x1_wr1x1_ta1x1x1x1_1x16x1x4_tb1x1x16x1_1x16x1x4_mfma_finishing
    v_xor_b32 v[v_sst_b_os], 8192, v[v_sst_b_os] ; switch double buffer b store
    v_xor_b32 v[v_sst_a_os], 8192, v[v_sst_a_os] ; switch double buffer a store
    s_branch L_igemm_wrw_gtcx_nchw_fp32_bx16_ex1_bt4x64x16_wt4x64x1_ws1x1_wr1x1_ta1x1x1x1_1x16x1x4_tb1x1x16x1_1x16x1x4_mfma_body

L_igemm_wrw_gtcx_nchw_fp32_bx16_ex1_bt4x64x16_wt4x64x1_ws1x1_wr1x1_ta1x1x1x1_1x16x1x4_tb1x1x16x1_1x16x1x4_mfma_finishing:
L_igemm_wrw_gtcx_nchw_fp32_bx16_ex1_bt4x64x16_wt4x64x1_ws1x1_wr1x1_ta1x1x1x1_1x16x1x4_tb1x1x16x1_1x16x1x4_mfma_end:
    s_waitcnt lgkmcnt(0)
    s_barrier
    ds_read_b32 v[v_a], v[v_sld_a_os] 
    ds_read_b32 v[v_b], v[v_sld_b_os] 
    ds_read_b32 v[v_a+1], v[v_sld_a_os] offset:16
    ds_read_b32 v[v_b+1], v[v_sld_b_os] offset:256
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a], v[v_b], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b32 v[v_a], v[v_sld_a_os] offset:32
    ds_read_b32 v[v_b], v[v_sld_b_os] offset:512
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a+1], v[v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b32 v[v_a+1], v[v_sld_a_os] offset:48
    ds_read_b32 v[v_b+1], v[v_sld_b_os] offset:768
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a], v[v_b], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b32 v[v_a], v[v_sld_a_os] offset:64
    ds_read_b32 v[v_b], v[v_sld_b_os] offset:1024
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a+1], v[v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b32 v[v_a+1], v[v_sld_a_os] offset:80
    ds_read_b32 v[v_b+1], v[v_sld_b_os] offset:1280
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a], v[v_b], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b32 v[v_a], v[v_sld_a_os] offset:96
    ds_read_b32 v[v_b], v[v_sld_b_os] offset:1536
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a+1], v[v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b32 v[v_a+1], v[v_sld_a_os] offset:112
    ds_read_b32 v[v_b+1], v[v_sld_b_os] offset:1792
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a], v[v_b], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b32 v[v_a], v[v_sld_a_os] offset:128
    ds_read_b32 v[v_b], v[v_sld_b_os] offset:2048
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a+1], v[v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b32 v[v_a+1], v[v_sld_a_os] offset:144
    ds_read_b32 v[v_b+1], v[v_sld_b_os] offset:2304
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a], v[v_b], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b32 v[v_a], v[v_sld_a_os] offset:160
    ds_read_b32 v[v_b], v[v_sld_b_os] offset:2560
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a+1], v[v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b32 v[v_a+1], v[v_sld_a_os] offset:176
    ds_read_b32 v[v_b+1], v[v_sld_b_os] offset:2816
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a], v[v_b], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b32 v[v_a], v[v_sld_a_os] offset:192
    ds_read_b32 v[v_b], v[v_sld_b_os] offset:3072
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a+1], v[v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b32 v[v_a+1], v[v_sld_a_os] offset:208
    ds_read_b32 v[v_b+1], v[v_sld_b_os] offset:3328
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a], v[v_b], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b32 v[v_a], v[v_sld_a_os] offset:224
    ds_read_b32 v[v_b], v[v_sld_b_os] offset:3584
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a+1], v[v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    ds_read_b32 v[v_a+1], v[v_sld_a_os] offset:240
    ds_read_b32 v[v_b+1], v[v_sld_b_os] offset:3840
    s_waitcnt lgkmcnt(2)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a], v[v_b], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    s_waitcnt lgkmcnt(0)
    v_mfma_f32_4x4x1f32 a[a_c+0:a_c+3], v[v_a+1], v[v_b+1], a[a_c+0:a_c+3]     ; repeat:0x0, step:0x0, num_a_c:4
    s_nop 3
    ; coalescing store, mapping:mt_m:4, mt_n:64, wt_m:4, wt_n:64, ws:1, r_m:1, r_n:1, s_m:1, s_n:1 | 4x4x1, lanegroup_m_tcbw:4x1x1x1, lanegroup_n_tcbw:1x4x1x1
    ; coalescing_groups:1, num_dword_per_group:4
    ; init_co_sub_m_index xdlops, block_size:64, macro-tile:4x64 sub_m_index:[0]
    ; g_mr:1, g_ms:1, g_mw:1, g_mb:1, g_mt:1 | l_mr:1, l_ms:1, l_mw:1, l_mb:1, l_mt:4 | n_mc:1, n_ml:1, n_mv:1
    ; nd_stride:[1, 1, 1, 1, 1, 1, 1]
    ; start group 0, i_g_mr:0, i_g_ms:0, i_g_mw:0, i_g_mb:0, i_g_mt:0, m index start from 0
    s_barrier
    v_accvgpr_read_b32 v[v_c], a[a_c]
    v_accvgpr_read_b32 v[v_c+1], a[a_c+1]
    v_accvgpr_read_b32 v[v_c+2], a[a_c+2]
    v_accvgpr_read_b32 v[v_c+3], a[a_c+3]
    ds_write_b128 v[v_co_sst], v[v_c:v_c+3]    ; idword:0(0,0),  0x0 | /4, i_mr:0, i_ms:0, i_mw:0, i_mb:0  x  i_nr:0, i_ns:0, i_nw:0
    s_waitcnt lgkmcnt(0)
    s_barrier
    ;   load from lds
    ds_read_b128 v[v_c:v_c+3], v[v_co_sld] 
    ;   store to global, m index start from 0, m0:0, m1:0
    s_mov_b32 s[s_tmp], 0   ; i_m:0(i_m0:0,i_m1:0)
    s_waitcnt lgkmcnt(0)
    buffer_store_dword v[v_c], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_tmp] offen offset:0
    s_mov_b32 s[s_tmp], s[s_wei_stride_k]   ; i_m:1(i_m0:0,i_m1:1)
    buffer_store_dword v[v_c+1], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_tmp] offen offset:0
    s_mul_i32 s[s_tmp], 2, s[s_wei_stride_k]   ; i_m:2(i_m0:0,i_m1:2)
    buffer_store_dword v[v_c+2], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_tmp] offen offset:0
    s_mul_i32 s[s_tmp], 3, s[s_wei_stride_k]   ; i_m:3(i_m0:0,i_m1:3)
    buffer_store_dword v[v_c+3], v[v_wei_os], s[s_p_wei:s_p_wei+3], s[s_tmp] offen offset:0

L_igemm_wrw_gtcx_nchw_fp32_bx16_ex1_bt4x64x16_wt4x64x1_ws1x1_wr1x1_ta1x1x1x1_1x16x1x4_tb1x1x16x1_1x16x1x4_out:
    s_endpgm
.rodata
.p2align 6
.amdhsa_kernel igemm_wrw_gtcx_nchw_fp32_bx16_ex1_bt4x64x16_wt4x64x1_ws1x1_wr1x1_ta1x1x1x1_1x16x1x4_tb1x1x16x1_1x16x1x4
    .amdhsa_group_segment_fixed_size 16384
    .amdhsa_user_sgpr_kernarg_segment_ptr 1
    .amdhsa_system_sgpr_workgroup_id_x 1
    .amdhsa_system_vgpr_workitem_id 0
    .amdhsa_next_free_vgpr 72
    .amdhsa_next_free_sgpr 74
    .amdhsa_ieee_mode 0
    .amdhsa_dx10_clamp 0
.end_amdhsa_kernel

.amdgpu_metadata
---
amdhsa.version: [ 1, 0 ]
amdhsa.kernels:
  - .name: igemm_wrw_gtcx_nchw_fp32_bx16_ex1_bt4x64x16_wt4x64x1_ws1x1_wr1x1_ta1x1x1x1_1x16x1x4_tb1x1x16x1_1x16x1x4
    .symbol: igemm_wrw_gtcx_nchw_fp32_bx16_ex1_bt4x64x16_wt4x64x1_ws1x1_wr1x1_ta1x1x1x1_1x16x1x4_tb1x1x16x1_1x16x1x4.kd
    .sgpr_count: 80
    .vgpr_count: 72
    .kernarg_segment_align: 8
    .kernarg_segment_size: 96
    .group_segment_fixed_size: 16384
    .private_segment_fixed_size: 0
    .wavefront_size: 64
    .reqd_workgroup_size : [64, 1, 1]
    .max_flat_workgroup_size: 64
    .args:
    - { .name: p_in      , .size: 8, .offset:   0, .value_kind: global_buffer, .value_type: f32, .address_space: global, .is_const: false}
    - { .name: p_wei     , .size: 8, .offset:   8, .value_kind: global_buffer, .value_type: f32, .address_space: global, .is_const: true}
    - { .name: p_out     , .size: 8, .offset:  16, .value_kind: global_buffer, .value_type: f32, .address_space: global, .is_const: true}
    - { .name: hi        , .size: 4, .offset:  24, .value_kind: by_value, .value_type: i32}
    - { .name: wi        , .size: 4, .offset:  28, .value_kind: by_value, .value_type: i32}
    - { .name: n_         , .size: 4, .offset:  32, .value_kind: by_value, .value_type: i32}
    - { .name: k         , .size: 4, .offset:  36, .value_kind: by_value, .value_type: i32}
    - { .name: c         , .size: 4, .offset:  40, .value_kind: by_value, .value_type: i32}
    - { .name: ho        , .size: 4, .offset:  44, .value_kind: by_value, .value_type: i32}
    - { .name: wo        , .size: 4, .offset:  48, .value_kind: by_value, .value_type: i32}
    - { .name: stride_h  , .size: 4, .offset:  52, .value_kind: by_value, .value_type: i32}
    - { .name: stride_w  , .size: 4, .offset:  56, .value_kind: by_value, .value_type: i32}
    - { .name: dilation_h, .size: 4, .offset:  60, .value_kind: by_value, .value_type: i32}
    - { .name: dilation_w, .size: 4, .offset:  64, .value_kind: by_value, .value_type: i32}
    - { .name: pad_h     , .size: 4, .offset:  68, .value_kind: by_value, .value_type: i32}
    - { .name: pad_w     , .size: 4, .offset:  72, .value_kind: by_value, .value_type: i32}
    - { .name: y_         , .size: 4, .offset:  76, .value_kind: by_value, .value_type: i32}
    - { .name: x         , .size: 4, .offset:  80, .value_kind: by_value, .value_type: i32}
    - { .name: gemm_k_global_split, .size: 4, .offset:  84, .value_kind: by_value, .value_type: i32}
    - { .name: group     , .size: 4, .offset:  88, .value_kind: by_value, .value_type: i32}
    - { .name: __pack_0  , .size: 4, .offset:  92, .value_kind: by_value, .value_type: i32}
...
.end_amdgpu_metadata
