/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class PostgreJobClass
implements PostgreObject {
    private final PostgreDatabase database;
    private final long id;
    private final String name;

    public PostgreJobClass(@NotNull PostgreDatabase database, @NotNull ResultSet dbResult) {
        this.database = database;
        this.id = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"jclid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"jclname");
    }

    public long getObjectId() {
        return this.id;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return this.database.getDataSource();
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this.database;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.database;
    }
}

