/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.terminal;

import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.console.MessageConsole;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.plaintext.PlainTextFormatter;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorOutputConsoleViewer;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class SQLTerminalView
extends SQLEditorOutputConsoleViewer {
    public SQLTerminalView(@NotNull IWorkbenchPartSite site, @NotNull CTabFolder tabsContainer, int styles) {
        super(site, (Composite)tabsContainer, new MessageConsole("sql-data-log-output", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_CONSOLE)));
    }

    public void printQueryData(@NotNull DBPPreferenceStore prefs, @NotNull ResultSetModel model, @Nullable String name) {
        PlainTextFormatter formatter = new PlainTextFormatter(prefs);
        StringBuilder grid = new StringBuilder();
        if (prefs.getBoolean("SQLEditor.SQLTerminal.showQueryText")) {
            formatter.printQueryName(grid, name);
            grid.append("\n");
        }
        int totalRows = formatter.printGrid(grid, model);
        this.getOutputWriter().append("\n");
        this.getOutputWriter().append(grid.toString()).append("\n\n");
        this.getOutputWriter().append(String.valueOf(totalRows)).append(" row(s) fetched.\n\n");
        this.getOutputWriter().flush();
        this.scrollToEnd();
    }

    public void printQueryResult(@NotNull DBPPreferenceStore prefs, @NotNull SQLQueryResult result) {
        boolean hasUpdateCount = result.getExecuteResults().stream().anyMatch(r -> r.getUpdateCount() != null);
        Throwable error = result.getError();
        if (hasUpdateCount || error != null) {
            PlainTextFormatter formatter = new PlainTextFormatter(prefs);
            StringBuilder grid = new StringBuilder();
            if (prefs.getBoolean("SQLEditor.SQLTerminal.showQueryText")) {
                formatter.printQueryName(grid, result.getStatement().getText());
                grid.append("\n");
            }
            if (hasUpdateCount) {
                long updateCount = result.getExecuteResults().stream().mapToLong(r -> (Long)CommonUtils.notNull((Object)r.getUpdateCount(), (Object)0L)).sum();
                grid.append(updateCount).append(" row(s) modified.\n\n");
            }
            if (error != null) {
                grid.append(GeneralUtils.getFirstMessage((Throwable)error)).append("\n\n");
            }
            this.getOutputWriter().append(grid.toString());
            this.getOutputWriter().flush();
            this.scrollToEnd();
        }
    }
}

