//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uidragitem?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIDragItem;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UIDragItem {}
);

impl UIDragItem {
    extern_methods!(
        #[unsafe(method(initWithItemProvider:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithItemProvider(
            this: Allocated<Self>,
            item_provider: &NSItemProvider,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(itemProvider))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemProvider(&self) -> Retained<NSItemProvider>;

        /// Use `localObject` to attach additional information to
        /// this drag item, visible only inside the app that started the drag.
        #[unsafe(method(localObject))]
        #[unsafe(method_family = none)]
        pub unsafe fn localObject(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`localObject`][Self::localObject].
        #[unsafe(method(setLocalObject:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setLocalObject(&self, local_object: Option<&AnyObject>);

        #[cfg(all(feature = "UIDragPreview", feature = "block2"))]
        /// Use `previewProvider` to change the preview for an item.
        ///
        /// Each item is usually given a preview when the drag begins,
        /// either by the UIDragInteractionDelegate's `-dragInteraction:previewForLiftingItem:session:`
        /// method, or by creating a preview from the dragging view.
        ///
        /// During the drag, applications may attempt to change the item's preview,
        /// by setting `previewProvider` to a block that returns a preview.
        /// It will be called when and if the system requests it.
        ///
        /// To use the default preview, set `previewProvider` to nil.
        /// To hide the preview, set `previewProvider` to a block that returns nil.
        #[unsafe(method(previewProvider))]
        #[unsafe(method_family = none)]
        pub unsafe fn previewProvider(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn() -> *mut UIDragPreview>;

        #[cfg(all(feature = "UIDragPreview", feature = "block2"))]
        /// Setter for [`previewProvider`][Self::previewProvider].
        #[unsafe(method(setPreviewProvider:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPreviewProvider(
            &self,
            preview_provider: Option<&block2::DynBlock<dyn Fn() -> *mut UIDragPreview>>,
        );

        /// Requests for the drop preview to be updated if an active drop animation is in progress, and can handle updates.
        /// If no active drop animation is in progress for the specified item, then nothing happens.
        #[unsafe(method(setNeedsDropPreviewUpdate))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNeedsDropPreviewUpdate(&self);
    );
}
