// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`EnableEnhancedMonitoring`](crate::operation::enable_enhanced_monitoring::builders::EnableEnhancedMonitoringFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stream_name(impl Into<String>)`](crate::operation::enable_enhanced_monitoring::builders::EnableEnhancedMonitoringFluentBuilder::stream_name) / [`set_stream_name(Option<String>)`](crate::operation::enable_enhanced_monitoring::builders::EnableEnhancedMonitoringFluentBuilder::set_stream_name):<br>required: **false**<br><p>The name of the stream for which to enable enhanced monitoring.</p><br>
    ///   - [`shard_level_metrics(MetricsName)`](crate::operation::enable_enhanced_monitoring::builders::EnableEnhancedMonitoringFluentBuilder::shard_level_metrics) / [`set_shard_level_metrics(Option<Vec::<MetricsName>>)`](crate::operation::enable_enhanced_monitoring::builders::EnableEnhancedMonitoringFluentBuilder::set_shard_level_metrics):<br>required: **true**<br><p>List of shard-level metrics to enable.</p> <p>The following are the valid shard-level metrics. The value "<code>ALL</code>" enables every metric.</p> <ul>  <li>   <p><code>IncomingBytes</code></p></li>  <li>   <p><code>IncomingRecords</code></p></li>  <li>   <p><code>OutgoingBytes</code></p></li>  <li>   <p><code>OutgoingRecords</code></p></li>  <li>   <p><code>WriteProvisionedThroughputExceeded</code></p></li>  <li>   <p><code>ReadProvisionedThroughputExceeded</code></p></li>  <li>   <p><code>IteratorAgeMilliseconds</code></p></li>  <li>   <p><code>ALL</code></p></li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.</p><br>
    ///   - [`stream_arn(impl Into<String>)`](crate::operation::enable_enhanced_monitoring::builders::EnableEnhancedMonitoringFluentBuilder::stream_arn) / [`set_stream_arn(Option<String>)`](crate::operation::enable_enhanced_monitoring::builders::EnableEnhancedMonitoringFluentBuilder::set_stream_arn):<br>required: **false**<br><p>The ARN of the stream.</p><br>
    /// - On success, responds with [`EnableEnhancedMonitoringOutput`](crate::operation::enable_enhanced_monitoring::EnableEnhancedMonitoringOutput) with field(s):
    ///   - [`stream_name(Option<String>)`](crate::operation::enable_enhanced_monitoring::EnableEnhancedMonitoringOutput::stream_name): <p>The name of the Kinesis data stream.</p>
    ///   - [`current_shard_level_metrics(Option<Vec::<MetricsName>>)`](crate::operation::enable_enhanced_monitoring::EnableEnhancedMonitoringOutput::current_shard_level_metrics): <p>Represents the current state of the metrics that are in the enhanced state before the operation.</p>
    ///   - [`desired_shard_level_metrics(Option<Vec::<MetricsName>>)`](crate::operation::enable_enhanced_monitoring::EnableEnhancedMonitoringOutput::desired_shard_level_metrics): <p>Represents the list of all the metrics that would be in the enhanced state after the operation.</p>
    ///   - [`stream_arn(Option<String>)`](crate::operation::enable_enhanced_monitoring::EnableEnhancedMonitoringOutput::stream_arn): <p>The ARN of the stream.</p>
    /// - On failure, responds with [`SdkError<EnableEnhancedMonitoringError>`](crate::operation::enable_enhanced_monitoring::EnableEnhancedMonitoringError)
    pub fn enable_enhanced_monitoring(&self) -> crate::operation::enable_enhanced_monitoring::builders::EnableEnhancedMonitoringFluentBuilder {
        crate::operation::enable_enhanced_monitoring::builders::EnableEnhancedMonitoringFluentBuilder::new(self.handle.clone())
    }
}
