/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.WorkbenchMessages;

public class ListSelectionDialog
extends SelectionDialog {
    private Object inputElement;
    private ILabelProvider labelProvider;
    private IStructuredContentProvider contentProvider;
    CheckboxTableViewer listViewer;
    private final String optionalCheckboxText;
    private boolean optionalCheckboxValue;
    private Button optionalCheckbox;
    private final String okButtonText;
    private final String okButtonTextWhenNoSelection;
    private final boolean canCancel;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;

    public ListSelectionDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String message) {
        this(parentShell, input, contentProvider, labelProvider, message, null, null, true, null);
    }

    private ListSelectionDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String message, String okButtonText, String okButtonTextWhenNoSelection, boolean canCancel, String optionalCheckboxText) {
        super(parentShell);
        this.inputElement = input;
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        this.setMessage(message == null ? WorkbenchMessages.ListSelection_message : message);
        this.okButtonText = okButtonText;
        this.okButtonTextWhenNoSelection = okButtonTextWhenNoSelection;
        this.canCancel = canCancel;
        this.optionalCheckboxText = optionalCheckboxText;
    }

    public static Builder of(Object input) {
        return new Builder(input);
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        Button selectAllButton = this.createButton(buttonComposite, 18, WorkbenchMessages.SelectionDialog_selectLabel, false);
        selectAllButton.setToolTipText(WorkbenchMessages.SelectionDialog_selectLabel);
        selectAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.setAllChecked(true)));
        Button deselectAllButton = this.createButton(buttonComposite, 19, WorkbenchMessages.SelectionDialog_deselectLabel, false);
        deselectAllButton.setToolTipText(WorkbenchMessages.SelectionDialog_deselectLabel);
        deselectAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.setAllChecked(false)));
    }

    private void setAllChecked(boolean state) {
        this.listViewer.setAllChecked(state);
        this.updateButtonsOnSelection();
    }

    private void updateButtonsOnSelection() {
        long selectedCount = Arrays.stream(this.getViewer().getTable().getItems()).filter(TableItem::getChecked).count();
        int totalCount = this.getViewer().getTable().getItemCount();
        this.getButton(18).setEnabled(selectedCount < (long)totalCount);
        this.getButton(19).setEnabled(selectedCount > 0L);
        if (this.okButtonText != null) {
            this.getButton(0).setText(NLS.bind((String)(selectedCount == 0L && this.okButtonTextWhenNoSelection != null ? this.okButtonTextWhenNoSelection : this.okButtonText), (Object)selectedCount, (Object)totalCount));
        }
    }

    private void checkInitialSelections() {
        Iterator itemsToCheck = this.getInitialElementSelections().iterator();
        while (itemsToCheck.hasNext()) {
            this.listViewer.setChecked(itemsToCheck.next(), true);
        }
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.list_selection_dialog_context");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.updateButtonsOnSelection();
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.createMessageArea(composite);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.listViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.listViewer.addCheckStateListener(e -> this.updateButtonsOnSelection());
        this.addSelectionButtons(composite);
        this.initializeViewer();
        if (!this.getInitialElementSelections().isEmpty()) {
            this.checkInitialSelections();
        }
        if (this.optionalCheckboxText != null) {
            this.optionalCheckbox = (Button)((ButtonFactory)WidgetFactory.button((int)32).text(this.optionalCheckboxText).layoutData((Object)new GridData())).onSelect(e -> {
                boolean bl = this.optionalCheckboxValue = this.optionalCheckbox.getSelection();
            }).create((Widget)composite);
            this.optionalCheckbox.setSelection(this.optionalCheckboxValue);
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.canCancel) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    protected CheckboxTableViewer getViewer() {
        return this.listViewer;
    }

    public boolean getCheckboxValue() {
        return this.optionalCheckboxValue;
    }

    private void initializeViewer() {
        this.listViewer.setInput(this.inputElement);
    }

    protected void okPressed() {
        Object[] children = this.contentProvider.getElements(this.inputElement);
        if (children != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (this.listViewer.getChecked(element)) {
                    list.add(element);
                }
                ++n2;
            }
            this.setResult(list);
        }
        super.okPressed();
    }

    public static final class Builder {
        private final Object input;
        private IStructuredContentProvider contentProvider;
        private ILabelProvider labelProvider;
        private Object[] initialSelections;
        private String title;
        private String message;
        private String okButtonText;
        private String okButtonTextWhenNoSelection;
        private boolean canCancel = true;
        private boolean asSheet = false;
        private String checkboxText;
        boolean checkboxValue = false;

        private Builder(Object input) {
            this.input = input;
        }

        public Builder contentProvider(IStructuredContentProvider contentProvider) {
            this.contentProvider = contentProvider;
            return this;
        }

        public Builder labelProvider(ILabelProvider labelProvider) {
            this.labelProvider = labelProvider;
            return this;
        }

        public Builder preselect(Object ... initialSelections) {
            this.initialSelections = initialSelections;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder okButtonText(String text) {
            this.okButtonText = text;
            return this;
        }

        public Builder okButtonTextWhenNoSelection(String text) {
            this.okButtonTextWhenNoSelection = text;
            return this;
        }

        public Builder canCancel(boolean canCancel) {
            this.canCancel = canCancel;
            return this;
        }

        public Builder asSheet(boolean asSheet) {
            this.asSheet = asSheet;
            return this;
        }

        public Builder checkboxText(String checkboxText) {
            this.checkboxText = checkboxText;
            return this;
        }

        public Builder checkboxValue(boolean checkboxValue) {
            this.checkboxValue = checkboxValue;
            return this;
        }

        public ListSelectionDialog create(Shell parentShell) {
            ListSelectionDialog dialog = new ListSelectionDialog(parentShell, this.input, (IStructuredContentProvider)(this.contentProvider == null ? ArrayContentProvider.getInstance() : this.contentProvider), (ILabelProvider)(this.labelProvider == null ? new LabelProvider() : this.labelProvider), this.message, this.okButtonText, this.okButtonTextWhenNoSelection, this.canCancel, this.checkboxText);
            int shellStyle = dialog.getShellStyle();
            if (!this.canCancel) {
                shellStyle &= 0xFFFFFFBF;
            }
            if (this.asSheet) {
                shellStyle |= 0x10000000;
            }
            dialog.setShellStyle(shellStyle);
            dialog.setTitle(this.title == null ? WorkbenchMessages.ListSelection_title : this.title);
            if (this.initialSelections != null) {
                dialog.setInitialSelections(this.initialSelections);
            }
            dialog.optionalCheckboxValue = this.checkboxValue;
            return dialog;
        }
    }
}

