// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>References a specific automated reasoning policy rule that was applied during evaluation.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct GuardrailAutomatedReasoningRule {
    /// <p>The unique identifier of the automated reasoning rule.</p>
    pub identifier: ::std::option::Option<::std::string::String>,
    /// <p>The ARN of the automated reasoning policy version that contains this rule.</p>
    pub policy_version_arn: ::std::option::Option<::std::string::String>,
}
impl GuardrailAutomatedReasoningRule {
    /// <p>The unique identifier of the automated reasoning rule.</p>
    pub fn identifier(&self) -> ::std::option::Option<&str> {
        self.identifier.as_deref()
    }
    /// <p>The ARN of the automated reasoning policy version that contains this rule.</p>
    pub fn policy_version_arn(&self) -> ::std::option::Option<&str> {
        self.policy_version_arn.as_deref()
    }
}
impl GuardrailAutomatedReasoningRule {
    /// Creates a new builder-style object to manufacture [`GuardrailAutomatedReasoningRule`](crate::types::GuardrailAutomatedReasoningRule).
    pub fn builder() -> crate::types::builders::GuardrailAutomatedReasoningRuleBuilder {
        crate::types::builders::GuardrailAutomatedReasoningRuleBuilder::default()
    }
}

/// A builder for [`GuardrailAutomatedReasoningRule`](crate::types::GuardrailAutomatedReasoningRule).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct GuardrailAutomatedReasoningRuleBuilder {
    pub(crate) identifier: ::std::option::Option<::std::string::String>,
    pub(crate) policy_version_arn: ::std::option::Option<::std::string::String>,
}
impl GuardrailAutomatedReasoningRuleBuilder {
    /// <p>The unique identifier of the automated reasoning rule.</p>
    pub fn identifier(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.identifier = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The unique identifier of the automated reasoning rule.</p>
    pub fn set_identifier(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.identifier = input;
        self
    }
    /// <p>The unique identifier of the automated reasoning rule.</p>
    pub fn get_identifier(&self) -> &::std::option::Option<::std::string::String> {
        &self.identifier
    }
    /// <p>The ARN of the automated reasoning policy version that contains this rule.</p>
    pub fn policy_version_arn(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.policy_version_arn = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The ARN of the automated reasoning policy version that contains this rule.</p>
    pub fn set_policy_version_arn(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.policy_version_arn = input;
        self
    }
    /// <p>The ARN of the automated reasoning policy version that contains this rule.</p>
    pub fn get_policy_version_arn(&self) -> &::std::option::Option<::std::string::String> {
        &self.policy_version_arn
    }
    /// Consumes the builder and constructs a [`GuardrailAutomatedReasoningRule`](crate::types::GuardrailAutomatedReasoningRule).
    pub fn build(self) -> crate::types::GuardrailAutomatedReasoningRule {
        crate::types::GuardrailAutomatedReasoningRule {
            identifier: self.identifier,
            policy_version_arn: self.policy_version_arn,
        }
    }
}
