## RabbitMQ 3.13.5

RabbitMQ `3.13.5` is a maintenance release in the `3.13.x` [release series](https://www.rabbitmq.com/release-information).

**Please skip this release and upgrade straight to `3.13.6`** or a later version (if available).

Starting June 1st, 2024, community support for this series will only be provided to [regularly contributing users](https://github.com/rabbitmq/rabbitmq-server/blob/main/COMMUNITY_SUPPORT.md) and those
who hold a valid [commercial support license](https://tanzu.vmware.com/rabbitmq/oss).

Please refer to the upgrade section from the [3.13.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.13.0)
if upgrading from a version prior to 3.13.0.

This release requires Erlang 26 and supports Erlang versions up to `26.2.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/docs/which-erlang) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.13.0, RabbitMQ requires Erlang 26. Nodes **will fail to start** on older Erlang releases.

Users upgrading from 3.12.x (or older releases) on Erlang 25 to 3.13.x on Erlang 26
(both RabbitMQ *and* Erlang are upgraded at the same time) **must** consult
the [v3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0) and [v3.13.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.13.0) first.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.13.x/release-notes).


### Core Broker

#### Bug Fixes

 * Quorum queue replicas could fail to recover in certain scenarios.

   GitHub issue: [#11769](https://github.com/rabbitmq/rabbitmq-server/pull/11769)

 * Safer AMQP 0-9-1 to AMQP 1.0 (the internal message format) conversion for longer string values.

   GitHub issue: [#11737](https://github.com/rabbitmq/rabbitmq-server/pull/11737)

 * When a message that contained an `x-deaths` [dead-lettering](https://www.rabbitmq.com/docs/dlx) header was republished "as is" by a client,
   the `time` field in the dead lettering events was not correctly converted for AMQP 0-9-1 clients.

   GitHub issue: [#11608](https://github.com/rabbitmq/rabbitmq-server/pull/11608)

 * [Direct Reply-to](https://www.rabbitmq.com/docs/direct-reply-to) failed with an exception when firehose tracing was enabled.

   GitHub issue: [#11666](https://github.com/rabbitmq/rabbitmq-server/pull/11666)


### CLI Tools

#### Bug Fixes

 * `rabbitmqctl export_definitions` failed if cluster contained custom federation upstream set definitions.

   GitHub issue: [#11612](https://github.com/rabbitmq/rabbitmq-server/issues/11612)


### MQTT Plugin

#### Bug Fixes

 * An abrupt client TCP connection closure could result in a spike in that connection's memory footprint.

   GitHub issue: [#11683](https://github.com/rabbitmq/rabbitmq-server/pull/11683)


### Shovel Plugin

#### Enhancements

 * Improved AMQP 1.0 to AMQP 0-9-1 conversion for shovels.

   Contributed by @luos.

   GitHub issue: [#10037](https://github.com/rabbitmq/rabbitmq-server/pull/10037)


### etcd Peer Discovery Plugin

#### Bug Fixes

 * Nodes now register themselves before running peer discovery, reducing the probability of
   first (usually) two nodes to boot potentially forming two initial clusters.

   GitHub issues: [#11647](https://github.com/rabbitmq/rabbitmq-server/pull/11647), [#11646](https://github.com/rabbitmq/rabbitmq-server/pull/11646)


### Consul Peer Discovery Plugin

#### Bug Fixes

 * Nodes now register themselves before running peer discovery, reducing the probability of
   first (usually) two nodes to boot potentially forming two initial clusters.

   GitHub issues: [#11647](https://github.com/rabbitmq/rabbitmq-server/pull/11647), [#11646](https://github.com/rabbitmq/rabbitmq-server/pull/11646)


### AWS Peer Discovery Plugin

#### Enhancements

 * Forward compatibility: handle AWS API responses that use empty HTTP response bodies.

   Contributed by @SimonUnge.

   GitHub issue: [#11722](https://github.com/rabbitmq/rabbitmq-server/pull/11722)



### Dependency Changes

 * Ra was [upgraded to `2.13.3`](https://github.com/rabbitmq/ra/releases)

## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.13.5.tar.xz`
instead of the source tarball produced by GitHub.
